import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudJavaDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#cpu SpringCloudJavaDeployment#cpu}
    */
    readonly cpu?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#environment_variables SpringCloudJavaDeployment#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#instance_count SpringCloudJavaDeployment#instance_count}
    */
    readonly instanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#jvm_options SpringCloudJavaDeployment#jvm_options}
    */
    readonly jvmOptions?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#memory_in_gb SpringCloudJavaDeployment#memory_in_gb}
    */
    readonly memoryInGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#name SpringCloudJavaDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#runtime_version SpringCloudJavaDeployment#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#spring_cloud_app_id SpringCloudJavaDeployment#spring_cloud_app_id}
    */
    readonly springCloudAppId: string;
    /**
    * quota block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#quota SpringCloudJavaDeployment#quota}
    */
    readonly quota?: SpringCloudJavaDeploymentQuota;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#timeouts SpringCloudJavaDeployment#timeouts}
    */
    readonly timeouts?: SpringCloudJavaDeploymentTimeouts;
}
export interface SpringCloudJavaDeploymentQuota {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#cpu SpringCloudJavaDeployment#cpu}
    */
    readonly cpu?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#memory SpringCloudJavaDeployment#memory}
    */
    readonly memory?: string;
}
export declare function springCloudJavaDeploymentQuotaToTerraform(struct?: SpringCloudJavaDeploymentQuotaOutputReference | SpringCloudJavaDeploymentQuota): any;
export declare class SpringCloudJavaDeploymentQuotaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudJavaDeploymentQuota | undefined;
    set internalValue(value: SpringCloudJavaDeploymentQuota | undefined);
    private _cpu?;
    get cpu(): string;
    set cpu(value: string);
    resetCpu(): void;
    get cpuInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface SpringCloudJavaDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#create SpringCloudJavaDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#delete SpringCloudJavaDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#read SpringCloudJavaDeployment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment#update SpringCloudJavaDeployment#update}
    */
    readonly update?: string;
}
export declare function springCloudJavaDeploymentTimeoutsToTerraform(struct?: SpringCloudJavaDeploymentTimeoutsOutputReference | SpringCloudJavaDeploymentTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudJavaDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudJavaDeploymentTimeouts | undefined;
    set internalValue(value: SpringCloudJavaDeploymentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment azurerm_spring_cloud_java_deployment}
*/
export declare class SpringCloudJavaDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_java_deployment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/spring_cloud_java_deployment azurerm_spring_cloud_java_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudJavaDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudJavaDeploymentConfig);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _instanceCount?;
    get instanceCount(): number;
    set instanceCount(value: number);
    resetInstanceCount(): void;
    get instanceCountInput(): number | undefined;
    private _jvmOptions?;
    get jvmOptions(): string;
    set jvmOptions(value: string);
    resetJvmOptions(): void;
    get jvmOptionsInput(): string | undefined;
    private _memoryInGb?;
    get memoryInGb(): number;
    set memoryInGb(value: number);
    resetMemoryInGb(): void;
    get memoryInGbInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _springCloudAppId?;
    get springCloudAppId(): string;
    set springCloudAppId(value: string);
    get springCloudAppIdInput(): string | undefined;
    private _quota;
    get quota(): SpringCloudJavaDeploymentQuotaOutputReference;
    putQuota(value: SpringCloudJavaDeploymentQuota): void;
    resetQuota(): void;
    get quotaInput(): SpringCloudJavaDeploymentQuota | undefined;
    private _timeouts;
    get timeouts(): SpringCloudJavaDeploymentTimeoutsOutputReference;
    putTimeouts(value: SpringCloudJavaDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SpringCloudJavaDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
