import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SynapseWorkspaceAadAdminAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#login SynapseWorkspaceAadAdminA#login}
    */
    readonly login: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#object_id SynapseWorkspaceAadAdminA#object_id}
    */
    readonly objectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#synapse_workspace_id SynapseWorkspaceAadAdminA#synapse_workspace_id}
    */
    readonly synapseWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#tenant_id SynapseWorkspaceAadAdminA#tenant_id}
    */
    readonly tenantId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#timeouts SynapseWorkspaceAadAdminA#timeouts}
    */
    readonly timeouts?: SynapseWorkspaceAadAdminTimeouts;
}
export interface SynapseWorkspaceAadAdminTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#create SynapseWorkspaceAadAdminA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#delete SynapseWorkspaceAadAdminA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#read SynapseWorkspaceAadAdminA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin#update SynapseWorkspaceAadAdminA#update}
    */
    readonly update?: string;
}
export declare function synapseWorkspaceAadAdminTimeoutsToTerraform(struct?: SynapseWorkspaceAadAdminTimeoutsOutputReference | SynapseWorkspaceAadAdminTimeouts | cdktf.IResolvable): any;
export declare class SynapseWorkspaceAadAdminTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SynapseWorkspaceAadAdminTimeouts | undefined;
    set internalValue(value: SynapseWorkspaceAadAdminTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin azurerm_synapse_workspace_aad_admin}
*/
export declare class SynapseWorkspaceAadAdminA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_synapse_workspace_aad_admin";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace_aad_admin azurerm_synapse_workspace_aad_admin} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SynapseWorkspaceAadAdminAConfig
    */
    constructor(scope: Construct, id: string, config: SynapseWorkspaceAadAdminAConfig);
    get id(): string;
    private _login?;
    get login(): string;
    set login(value: string);
    get loginInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    private _synapseWorkspaceId?;
    get synapseWorkspaceId(): string;
    set synapseWorkspaceId(value: string);
    get synapseWorkspaceIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SynapseWorkspaceAadAdminTimeoutsOutputReference;
    putTimeouts(value: SynapseWorkspaceAadAdminTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SynapseWorkspaceAadAdminTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
