import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TrafficManagerNestedEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#enabled TrafficManagerNestedEndpoint#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#endpoint_location TrafficManagerNestedEndpoint#endpoint_location}
    */
    readonly endpointLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#geo_mappings TrafficManagerNestedEndpoint#geo_mappings}
    */
    readonly geoMappings?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#minimum_child_endpoints TrafficManagerNestedEndpoint#minimum_child_endpoints}
    */
    readonly minimumChildEndpoints: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#minimum_required_child_endpoints_ipv4 TrafficManagerNestedEndpoint#minimum_required_child_endpoints_ipv4}
    */
    readonly minimumRequiredChildEndpointsIpv4?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#minimum_required_child_endpoints_ipv6 TrafficManagerNestedEndpoint#minimum_required_child_endpoints_ipv6}
    */
    readonly minimumRequiredChildEndpointsIpv6?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#name TrafficManagerNestedEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#priority TrafficManagerNestedEndpoint#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#profile_id TrafficManagerNestedEndpoint#profile_id}
    */
    readonly profileId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#target_resource_id TrafficManagerNestedEndpoint#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#weight TrafficManagerNestedEndpoint#weight}
    */
    readonly weight: number;
    /**
    * custom_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#custom_header TrafficManagerNestedEndpoint#custom_header}
    */
    readonly customHeader?: TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable;
    /**
    * subnet block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#subnet TrafficManagerNestedEndpoint#subnet}
    */
    readonly subnet?: TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#timeouts TrafficManagerNestedEndpoint#timeouts}
    */
    readonly timeouts?: TrafficManagerNestedEndpointTimeouts;
}
export interface TrafficManagerNestedEndpointCustomHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#name TrafficManagerNestedEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#value TrafficManagerNestedEndpoint#value}
    */
    readonly value: string;
}
export declare function trafficManagerNestedEndpointCustomHeaderToTerraform(struct?: TrafficManagerNestedEndpointCustomHeader | cdktf.IResolvable): any;
export interface TrafficManagerNestedEndpointSubnet {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#first TrafficManagerNestedEndpoint#first}
    */
    readonly first: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#last TrafficManagerNestedEndpoint#last}
    */
    readonly last?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#scope TrafficManagerNestedEndpoint#scope}
    */
    readonly scope?: number;
}
export declare function trafficManagerNestedEndpointSubnetToTerraform(struct?: TrafficManagerNestedEndpointSubnet | cdktf.IResolvable): any;
export interface TrafficManagerNestedEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#create TrafficManagerNestedEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#delete TrafficManagerNestedEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#read TrafficManagerNestedEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#update TrafficManagerNestedEndpoint#update}
    */
    readonly update?: string;
}
export declare function trafficManagerNestedEndpointTimeoutsToTerraform(struct?: TrafficManagerNestedEndpointTimeoutsOutputReference | TrafficManagerNestedEndpointTimeouts | cdktf.IResolvable): any;
export declare class TrafficManagerNestedEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): TrafficManagerNestedEndpointTimeouts | undefined;
    set internalValue(value: TrafficManagerNestedEndpointTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint azurerm_traffic_manager_nested_endpoint}
*/
export declare class TrafficManagerNestedEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_traffic_manager_nested_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint azurerm_traffic_manager_nested_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TrafficManagerNestedEndpointConfig
    */
    constructor(scope: Construct, id: string, config: TrafficManagerNestedEndpointConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointLocation?;
    get endpointLocation(): string;
    set endpointLocation(value: string);
    resetEndpointLocation(): void;
    get endpointLocationInput(): string | undefined;
    private _geoMappings?;
    get geoMappings(): string[];
    set geoMappings(value: string[]);
    resetGeoMappings(): void;
    get geoMappingsInput(): string[] | undefined;
    get id(): string;
    private _minimumChildEndpoints?;
    get minimumChildEndpoints(): number;
    set minimumChildEndpoints(value: number);
    get minimumChildEndpointsInput(): number | undefined;
    private _minimumRequiredChildEndpointsIpv4?;
    get minimumRequiredChildEndpointsIpv4(): number;
    set minimumRequiredChildEndpointsIpv4(value: number);
    resetMinimumRequiredChildEndpointsIpv4(): void;
    get minimumRequiredChildEndpointsIpv4Input(): number | undefined;
    private _minimumRequiredChildEndpointsIpv6?;
    get minimumRequiredChildEndpointsIpv6(): number;
    set minimumRequiredChildEndpointsIpv6(value: number);
    resetMinimumRequiredChildEndpointsIpv6(): void;
    get minimumRequiredChildEndpointsIpv6Input(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _profileId?;
    get profileId(): string;
    set profileId(value: string);
    get profileIdInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
    private _customHeader?;
    get customHeader(): TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable;
    set customHeader(value: TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable);
    resetCustomHeader(): void;
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerNestedEndpointCustomHeader[] | undefined;
    private _subnet?;
    get subnet(): TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable;
    set subnet(value: TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable);
    resetSubnet(): void;
    get subnetInput(): cdktf.IResolvable | TrafficManagerNestedEndpointSubnet[] | undefined;
    private _timeouts;
    get timeouts(): TrafficManagerNestedEndpointTimeoutsOutputReference;
    putTimeouts(value: TrafficManagerNestedEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): TrafficManagerNestedEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
