import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VpnServerConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#location VpnServerConfiguration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#resource_group_name VpnServerConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#tags VpnServerConfiguration#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#vpn_authentication_types VpnServerConfiguration#vpn_authentication_types}
    */
    readonly vpnAuthenticationTypes: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#vpn_protocols VpnServerConfiguration#vpn_protocols}
    */
    readonly vpnProtocols?: string[];
    /**
    * azure_active_directory_authentication block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#azure_active_directory_authentication VpnServerConfiguration#azure_active_directory_authentication}
    */
    readonly azureActiveDirectoryAuthentication?: VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable;
    /**
    * client_revoked_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#client_revoked_certificate VpnServerConfiguration#client_revoked_certificate}
    */
    readonly clientRevokedCertificate?: VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable;
    /**
    * client_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#client_root_certificate VpnServerConfiguration#client_root_certificate}
    */
    readonly clientRootCertificate?: VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable;
    /**
    * ipsec_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ipsec_policy VpnServerConfiguration#ipsec_policy}
    */
    readonly ipsecPolicy?: VpnServerConfigurationIpsecPolicy;
    /**
    * radius block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#radius VpnServerConfiguration#radius}
    */
    readonly radius?: VpnServerConfigurationRadius;
    /**
    * radius_server block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#radius_server VpnServerConfiguration#radius_server}
    */
    readonly radiusServer?: VpnServerConfigurationRadiusServerA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#timeouts VpnServerConfiguration#timeouts}
    */
    readonly timeouts?: VpnServerConfigurationTimeouts;
}
export interface VpnServerConfigurationAzureActiveDirectoryAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#audience VpnServerConfiguration#audience}
    */
    readonly audience: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#issuer VpnServerConfiguration#issuer}
    */
    readonly issuer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#tenant VpnServerConfiguration#tenant}
    */
    readonly tenant: string;
}
export declare function vpnServerConfigurationAzureActiveDirectoryAuthenticationToTerraform(struct?: VpnServerConfigurationAzureActiveDirectoryAuthentication | cdktf.IResolvable): any;
export interface VpnServerConfigurationClientRevokedCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#thumbprint VpnServerConfiguration#thumbprint}
    */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationClientRevokedCertificateToTerraform(struct?: VpnServerConfigurationClientRevokedCertificate | cdktf.IResolvable): any;
export interface VpnServerConfigurationClientRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#public_cert_data VpnServerConfiguration#public_cert_data}
    */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationClientRootCertificateToTerraform(struct?: VpnServerConfigurationClientRootCertificate | cdktf.IResolvable): any;
export interface VpnServerConfigurationIpsecPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#dh_group VpnServerConfiguration#dh_group}
    */
    readonly dhGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ike_encryption VpnServerConfiguration#ike_encryption}
    */
    readonly ikeEncryption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ike_integrity VpnServerConfiguration#ike_integrity}
    */
    readonly ikeIntegrity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ipsec_encryption VpnServerConfiguration#ipsec_encryption}
    */
    readonly ipsecEncryption: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#ipsec_integrity VpnServerConfiguration#ipsec_integrity}
    */
    readonly ipsecIntegrity: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#pfs_group VpnServerConfiguration#pfs_group}
    */
    readonly pfsGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#sa_data_size_kilobytes VpnServerConfiguration#sa_data_size_kilobytes}
    */
    readonly saDataSizeKilobytes: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#sa_lifetime_seconds VpnServerConfiguration#sa_lifetime_seconds}
    */
    readonly saLifetimeSeconds: number;
}
export declare function vpnServerConfigurationIpsecPolicyToTerraform(struct?: VpnServerConfigurationIpsecPolicyOutputReference | VpnServerConfigurationIpsecPolicy): any;
export declare class VpnServerConfigurationIpsecPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnServerConfigurationIpsecPolicy | undefined;
    set internalValue(value: VpnServerConfigurationIpsecPolicy | undefined);
    private _dhGroup?;
    get dhGroup(): string;
    set dhGroup(value: string);
    get dhGroupInput(): string | undefined;
    private _ikeEncryption?;
    get ikeEncryption(): string;
    set ikeEncryption(value: string);
    get ikeEncryptionInput(): string | undefined;
    private _ikeIntegrity?;
    get ikeIntegrity(): string;
    set ikeIntegrity(value: string);
    get ikeIntegrityInput(): string | undefined;
    private _ipsecEncryption?;
    get ipsecEncryption(): string;
    set ipsecEncryption(value: string);
    get ipsecEncryptionInput(): string | undefined;
    private _ipsecIntegrity?;
    get ipsecIntegrity(): string;
    set ipsecIntegrity(value: string);
    get ipsecIntegrityInput(): string | undefined;
    private _pfsGroup?;
    get pfsGroup(): string;
    set pfsGroup(value: string);
    get pfsGroupInput(): string | undefined;
    private _saDataSizeKilobytes?;
    get saDataSizeKilobytes(): number;
    set saDataSizeKilobytes(value: number);
    get saDataSizeKilobytesInput(): number | undefined;
    private _saLifetimeSeconds?;
    get saLifetimeSeconds(): number;
    set saLifetimeSeconds(value: number);
    get saLifetimeSecondsInput(): number | undefined;
}
export interface VpnServerConfigurationRadiusClientRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#thumbprint VpnServerConfiguration#thumbprint}
    */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationRadiusClientRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusClientRootCertificate | cdktf.IResolvable): any;
export interface VpnServerConfigurationRadiusServer {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#address VpnServerConfiguration#address}
    */
    readonly address: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#score VpnServerConfiguration#score}
    */
    readonly score: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#secret VpnServerConfiguration#secret}
    */
    readonly secret: string;
}
export declare function vpnServerConfigurationRadiusServerToTerraform(struct?: VpnServerConfigurationRadiusServer | cdktf.IResolvable): any;
export interface VpnServerConfigurationRadiusServerRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#public_cert_data VpnServerConfiguration#public_cert_data}
    */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationRadiusServerRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerRootCertificate | cdktf.IResolvable): any;
export interface VpnServerConfigurationRadius {
    /**
    * client_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#client_root_certificate VpnServerConfiguration#client_root_certificate}
    */
    readonly clientRootCertificate?: VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable;
    /**
    * server block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#server VpnServerConfiguration#server}
    */
    readonly server?: VpnServerConfigurationRadiusServer[] | cdktf.IResolvable;
    /**
    * server_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#server_root_certificate VpnServerConfiguration#server_root_certificate}
    */
    readonly serverRootCertificate: VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable;
}
export declare function vpnServerConfigurationRadiusToTerraform(struct?: VpnServerConfigurationRadiusOutputReference | VpnServerConfigurationRadius): any;
export declare class VpnServerConfigurationRadiusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnServerConfigurationRadius | undefined;
    set internalValue(value: VpnServerConfigurationRadius | undefined);
    private _clientRootCertificate?;
    get clientRootCertificate(): VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable;
    set clientRootCertificate(value: VpnServerConfigurationRadiusClientRootCertificate[] | cdktf.IResolvable);
    resetClientRootCertificate(): void;
    get clientRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusClientRootCertificate[] | undefined;
    private _server?;
    get server(): VpnServerConfigurationRadiusServer[] | cdktf.IResolvable;
    set server(value: VpnServerConfigurationRadiusServer[] | cdktf.IResolvable);
    resetServer(): void;
    get serverInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServer[] | undefined;
    private _serverRootCertificate?;
    get serverRootCertificate(): VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable;
    set serverRootCertificate(value: VpnServerConfigurationRadiusServerRootCertificate[] | cdktf.IResolvable);
    get serverRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServerRootCertificate[] | undefined;
}
export interface VpnServerConfigurationRadiusServerClientRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#thumbprint VpnServerConfiguration#thumbprint}
    */
    readonly thumbprint: string;
}
export declare function vpnServerConfigurationRadiusServerClientRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerClientRootCertificate | cdktf.IResolvable): any;
export interface VpnServerConfigurationRadiusServerServerRootCertificate {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#name VpnServerConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#public_cert_data VpnServerConfiguration#public_cert_data}
    */
    readonly publicCertData: string;
}
export declare function vpnServerConfigurationRadiusServerServerRootCertificateToTerraform(struct?: VpnServerConfigurationRadiusServerServerRootCertificate | cdktf.IResolvable): any;
export interface VpnServerConfigurationRadiusServerA {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#address VpnServerConfiguration#address}
    */
    readonly address: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#secret VpnServerConfiguration#secret}
    */
    readonly secret: string;
    /**
    * client_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#client_root_certificate VpnServerConfiguration#client_root_certificate}
    */
    readonly clientRootCertificate?: VpnServerConfigurationRadiusServerClientRootCertificate[] | cdktf.IResolvable;
    /**
    * server_root_certificate block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#server_root_certificate VpnServerConfiguration#server_root_certificate}
    */
    readonly serverRootCertificate: VpnServerConfigurationRadiusServerServerRootCertificate[] | cdktf.IResolvable;
}
export declare function vpnServerConfigurationRadiusServerAToTerraform(struct?: VpnServerConfigurationRadiusServerAOutputReference | VpnServerConfigurationRadiusServerA): any;
export declare class VpnServerConfigurationRadiusServerAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnServerConfigurationRadiusServerA | undefined;
    set internalValue(value: VpnServerConfigurationRadiusServerA | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    private _clientRootCertificate?;
    get clientRootCertificate(): VpnServerConfigurationRadiusServerClientRootCertificate[] | cdktf.IResolvable;
    set clientRootCertificate(value: VpnServerConfigurationRadiusServerClientRootCertificate[] | cdktf.IResolvable);
    resetClientRootCertificate(): void;
    get clientRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServerClientRootCertificate[] | undefined;
    private _serverRootCertificate?;
    get serverRootCertificate(): VpnServerConfigurationRadiusServerServerRootCertificate[] | cdktf.IResolvable;
    set serverRootCertificate(value: VpnServerConfigurationRadiusServerServerRootCertificate[] | cdktf.IResolvable);
    get serverRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationRadiusServerServerRootCertificate[] | undefined;
}
export interface VpnServerConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#create VpnServerConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#delete VpnServerConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#read VpnServerConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration#update VpnServerConfiguration#update}
    */
    readonly update?: string;
}
export declare function vpnServerConfigurationTimeoutsToTerraform(struct?: VpnServerConfigurationTimeoutsOutputReference | VpnServerConfigurationTimeouts | cdktf.IResolvable): any;
export declare class VpnServerConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VpnServerConfigurationTimeouts | undefined;
    set internalValue(value: VpnServerConfigurationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration azurerm_vpn_server_configuration}
*/
export declare class VpnServerConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vpn_server_configuration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vpn_server_configuration azurerm_vpn_server_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpnServerConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: VpnServerConfigurationConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpnAuthenticationTypes?;
    get vpnAuthenticationTypes(): string[];
    set vpnAuthenticationTypes(value: string[]);
    get vpnAuthenticationTypesInput(): string[] | undefined;
    private _vpnProtocols?;
    get vpnProtocols(): string[];
    set vpnProtocols(value: string[]);
    resetVpnProtocols(): void;
    get vpnProtocolsInput(): string[] | undefined;
    private _azureActiveDirectoryAuthentication?;
    get azureActiveDirectoryAuthentication(): VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable;
    set azureActiveDirectoryAuthentication(value: VpnServerConfigurationAzureActiveDirectoryAuthentication[] | cdktf.IResolvable);
    resetAzureActiveDirectoryAuthentication(): void;
    get azureActiveDirectoryAuthenticationInput(): cdktf.IResolvable | VpnServerConfigurationAzureActiveDirectoryAuthentication[] | undefined;
    private _clientRevokedCertificate?;
    get clientRevokedCertificate(): VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable;
    set clientRevokedCertificate(value: VpnServerConfigurationClientRevokedCertificate[] | cdktf.IResolvable);
    resetClientRevokedCertificate(): void;
    get clientRevokedCertificateInput(): cdktf.IResolvable | VpnServerConfigurationClientRevokedCertificate[] | undefined;
    private _clientRootCertificate?;
    get clientRootCertificate(): VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable;
    set clientRootCertificate(value: VpnServerConfigurationClientRootCertificate[] | cdktf.IResolvable);
    resetClientRootCertificate(): void;
    get clientRootCertificateInput(): cdktf.IResolvable | VpnServerConfigurationClientRootCertificate[] | undefined;
    private _ipsecPolicy;
    get ipsecPolicy(): VpnServerConfigurationIpsecPolicyOutputReference;
    putIpsecPolicy(value: VpnServerConfigurationIpsecPolicy): void;
    resetIpsecPolicy(): void;
    get ipsecPolicyInput(): VpnServerConfigurationIpsecPolicy | undefined;
    private _radius;
    get radius(): VpnServerConfigurationRadiusOutputReference;
    putRadius(value: VpnServerConfigurationRadius): void;
    resetRadius(): void;
    get radiusInput(): VpnServerConfigurationRadius | undefined;
    private _radiusServer;
    get radiusServer(): VpnServerConfigurationRadiusServerAOutputReference;
    putRadiusServer(value: VpnServerConfigurationRadiusServerA): void;
    resetRadiusServer(): void;
    get radiusServerInput(): VpnServerConfigurationRadiusServerA | undefined;
    private _timeouts;
    get timeouts(): VpnServerConfigurationTimeoutsOutputReference;
    putTimeouts(value: VpnServerConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): VpnServerConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
