import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebPubsubNetworkAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#default_action WebPubsubNetworkAcl#default_action}
    */
    readonly defaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#web_pubsub_id WebPubsubNetworkAcl#web_pubsub_id}
    */
    readonly webPubsubId: string;
    /**
    * private_endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#private_endpoint WebPubsubNetworkAcl#private_endpoint}
    */
    readonly privateEndpoint?: WebPubsubNetworkAclPrivateEndpoint[] | cdktf.IResolvable;
    /**
    * public_network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#public_network WebPubsubNetworkAcl#public_network}
    */
    readonly publicNetwork: WebPubsubNetworkAclPublicNetwork;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#timeouts WebPubsubNetworkAcl#timeouts}
    */
    readonly timeouts?: WebPubsubNetworkAclTimeouts;
}
export interface WebPubsubNetworkAclPrivateEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#allowed_request_types WebPubsubNetworkAcl#allowed_request_types}
    */
    readonly allowedRequestTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#denied_request_types WebPubsubNetworkAcl#denied_request_types}
    */
    readonly deniedRequestTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#id WebPubsubNetworkAcl#id}
    */
    readonly id: string;
}
export declare function webPubsubNetworkAclPrivateEndpointToTerraform(struct?: WebPubsubNetworkAclPrivateEndpoint | cdktf.IResolvable): any;
export interface WebPubsubNetworkAclPublicNetwork {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#allowed_request_types WebPubsubNetworkAcl#allowed_request_types}
    */
    readonly allowedRequestTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#denied_request_types WebPubsubNetworkAcl#denied_request_types}
    */
    readonly deniedRequestTypes?: string[];
}
export declare function webPubsubNetworkAclPublicNetworkToTerraform(struct?: WebPubsubNetworkAclPublicNetworkOutputReference | WebPubsubNetworkAclPublicNetwork): any;
export declare class WebPubsubNetworkAclPublicNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubNetworkAclPublicNetwork | undefined;
    set internalValue(value: WebPubsubNetworkAclPublicNetwork | undefined);
    private _allowedRequestTypes?;
    get allowedRequestTypes(): string[];
    set allowedRequestTypes(value: string[]);
    resetAllowedRequestTypes(): void;
    get allowedRequestTypesInput(): string[] | undefined;
    private _deniedRequestTypes?;
    get deniedRequestTypes(): string[];
    set deniedRequestTypes(value: string[]);
    resetDeniedRequestTypes(): void;
    get deniedRequestTypesInput(): string[] | undefined;
}
export interface WebPubsubNetworkAclTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#create WebPubsubNetworkAcl#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#delete WebPubsubNetworkAcl#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#read WebPubsubNetworkAcl#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl#update WebPubsubNetworkAcl#update}
    */
    readonly update?: string;
}
export declare function webPubsubNetworkAclTimeoutsToTerraform(struct?: WebPubsubNetworkAclTimeoutsOutputReference | WebPubsubNetworkAclTimeouts | cdktf.IResolvable): any;
export declare class WebPubsubNetworkAclTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubNetworkAclTimeouts | undefined;
    set internalValue(value: WebPubsubNetworkAclTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl azurerm_web_pubsub_network_acl}
*/
export declare class WebPubsubNetworkAcl extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_web_pubsub_network_acl";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/web_pubsub_network_acl azurerm_web_pubsub_network_acl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebPubsubNetworkAclConfig
    */
    constructor(scope: Construct, id: string, config: WebPubsubNetworkAclConfig);
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    resetDefaultAction(): void;
    get defaultActionInput(): string | undefined;
    get id(): string;
    private _webPubsubId?;
    get webPubsubId(): string;
    set webPubsubId(value: string);
    get webPubsubIdInput(): string | undefined;
    private _privateEndpoint?;
    get privateEndpoint(): WebPubsubNetworkAclPrivateEndpoint[] | cdktf.IResolvable;
    set privateEndpoint(value: WebPubsubNetworkAclPrivateEndpoint[] | cdktf.IResolvable);
    resetPrivateEndpoint(): void;
    get privateEndpointInput(): cdktf.IResolvable | WebPubsubNetworkAclPrivateEndpoint[] | undefined;
    private _publicNetwork;
    get publicNetwork(): WebPubsubNetworkAclPublicNetworkOutputReference;
    putPublicNetwork(value: WebPubsubNetworkAclPublicNetwork): void;
    get publicNetworkInput(): WebPubsubNetworkAclPublicNetwork | undefined;
    private _timeouts;
    get timeouts(): WebPubsubNetworkAclTimeoutsOutputReference;
    putTimeouts(value: WebPubsubNetworkAclTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): WebPubsubNetworkAclTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
