"""
Python module generated from Java source file com.google.common.reflect.ImmutableTypeToInstanceMap

Java source file obtained from artifact guava version 32.1.2-jre

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from com.google.common.collect import ForwardingMap
from com.google.common.collect import ImmutableMap
from com.google.common.reflect import *
from com.google.errorprone.annotations import CanIgnoreReturnValue
from com.google.errorprone.annotations import DoNotCall
from javax.annotation import CheckForNull
from typing import Any, Callable, Iterable, Tuple


class ImmutableTypeToInstanceMap(ForwardingMap, TypeToInstanceMap):
    """
    A type-to-instance map backed by an ImmutableMap. See also MutableTypeToInstanceMap.

    Author(s)
    - Ben Yu

    Since
    - 13.0
    """

    @staticmethod
    def of() -> "ImmutableTypeToInstanceMap"["B"]:
        """
        Returns an empty type to instance map.
        """
        ...


    @staticmethod
    def builder() -> "Builder"["B"]:
        """
        Returns a new builder.
        """
        ...


    def getInstance(self, type: "TypeToken"["T"]) -> "T":
        ...


    def getInstance(self, type: type["T"]) -> "T":
        ...


    def putInstance(self, type: "TypeToken"["T"], value: "T") -> "T":
        """
        Guaranteed to throw an exception and leave the map unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - unsupported operation
        """
        ...


    def putInstance(self, type: type["T"], value: "T") -> "T":
        """
        Guaranteed to throw an exception and leave the map unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - unsupported operation
        """
        ...


    def put(self, key: "TypeToken"["B"], value: "B") -> "B":
        """
        Guaranteed to throw an exception and leave the map unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - unsupported operation
        """
        ...


    def putAll(self, map: dict["TypeToken"["B"], "B"]) -> None:
        """
        Guaranteed to throw an exception and leave the map unmodified.

        Raises
        - UnsupportedOperationException: always

        Deprecated
        - unsupported operation
        """
        ...


    class Builder:
        """
        A builder for creating immutable type-to-instance maps. Example:
        
        ````static final ImmutableTypeToInstanceMap<Handler<?>> HANDLERS =
            ImmutableTypeToInstanceMap.<Handler<?>>builder()
                .put(new TypeToken<Handler<Foo>>() {`, new FooHandler())
                .put(new TypeToken<Handler<Bar>>() {}, new SubBarHandler())
                .build();
        }```
        
        After invoking .build() it is still possible to add more entries and build again.
        Thus each map generated by this builder will be a superset of any map generated before it.

        Since
        - 13.0
        """

        def put(self, key: type["T"], value: "T") -> "Builder"["B"]:
            """
            Associates `key` with `value` in the built map. Duplicate keys are not allowed,
            and will cause .build to fail.
            """
            ...


        def put(self, key: "TypeToken"["T"], value: "T") -> "Builder"["B"]:
            """
            Associates `key` with `value` in the built map. Duplicate keys are not allowed,
            and will cause .build to fail.
            """
            ...


        def build(self) -> "ImmutableTypeToInstanceMap"["B"]:
            """
            Returns a new immutable type-to-instance map containing the entries provided to this builder.

            Raises
            - IllegalArgumentException: if duplicate keys were added
            """
            ...
