"""
Python module generated from Java source file java.lang.reflect.Proxy

Java source file obtained from artifact jdk version jdk

Because this Python module is automatically generated, it may contain errors
and/or code that cannot be parsed. Please report these issues at
https://github.com/magicmq/docs-translator/issues
"""
from java.lang.invoke import MethodHandle
from java.lang.invoke import MethodHandles
from java.lang.invoke import MethodType
from java.lang.invoke import WrongMethodTypeException
from java.lang.module import ModuleDescriptor
from java.lang.reflect import *
from java.security import AccessController
from java.security import PrivilegedAction
from java.util import ArrayDeque
from java.util import Arrays
from java.util import Collections
from java.util import Deque
from java.util import IdentityHashMap
from java.util import Objects
from java.util.concurrent import ConcurrentHashMap
from java.util.concurrent.atomic import AtomicInteger
from java.util.concurrent.atomic import AtomicLong
from java.util.function import BooleanSupplier
from jdk.internal.access import JavaLangAccess
from jdk.internal.access import SharedSecrets
from jdk.internal.loader import ClassLoaderValue
from jdk.internal.misc import VM
from jdk.internal.module import Modules
from jdk.internal.reflect import CallerSensitive
from jdk.internal.reflect import Reflection
from jdk.internal.vm.annotation import Stable
from sun.reflect.misc import ReflectUtil
from sun.security.action import GetPropertyAction
from sun.security.util import SecurityConstants
from typing import Any, Callable, Iterable, Tuple


class Proxy(Serializable):
    """
    `Proxy` provides static methods for creating objects that act like instances
    of interfaces but allow for customized method invocation.
    To create a proxy instance for some interface `Foo`:
    ````InvocationHandler handler = new MyInvocationHandler(...);
        Foo f = (Foo) Proxy.newProxyInstance(Foo.class.getClassLoader(),
                                             new Class<?>[] { Foo.class`,
                                             handler);
    }```
    
    
    A *proxy class* is a class created at runtime that implements a specified
    list of interfaces, known as *proxy interfaces*. A *proxy instance*
    is an instance of a proxy class.
    
    Each proxy instance has an associated *invocation handler*
    object, which implements the interface InvocationHandler.
    A method invocation on a proxy instance through one of its proxy
    interfaces will be dispatched to the InvocationHandler.invoke
    invoke method of the instance's invocation handler, passing the proxy
    instance, a `java.lang.reflect.Method` object identifying
    the method that was invoked, and an array of type `Object`
    containing the arguments.  The invocation handler processes the
    encoded method invocation as appropriate and the result that it
    returns will be returned as the result of the method invocation on
    the proxy instance.
    
    A proxy class has the following properties:
    
    
    - The unqualified name of a proxy class is unspecified.  The space
    of class names that begin with the string `"$Proxy"`
    should be, however, reserved for proxy classes.
    
    - The package and module in which a proxy class is defined is specified
    <a href="#membership">below</a>.
    
    - A proxy class is *final and non-abstract*.
    
    - A proxy class extends `java.lang.reflect.Proxy`.
    
    - A proxy class implements exactly the interfaces specified at its
    creation, in the same order. Invoking Class.getInterfaces() getInterfaces
    on its `Class` object will return an array containing the same
    list of interfaces (in the order specified at its creation), invoking
    Class.getMethods getMethods on its `Class` object will return
    an array of `Method` objects that include all of the
    methods in those interfaces, and invoking `getMethod` will
    find methods in the proxy interfaces as would be expected.
    
    - The java.security.ProtectionDomain of a proxy class
    is the same as that of system classes loaded by the bootstrap class
    loader, such as `java.lang.Object`, because the code for a
    proxy class is generated by trusted system code.  This protection
    domain will typically be granted `java.security.AllPermission`.
    
    - The Proxy.isProxyClass Proxy.isProxyClass method can be used
    to determine if a given class is a proxy class.
    
    
    A proxy instance has the following properties:
    
    
    - Given a proxy instance `proxy` and one of the
    interfaces, `Foo`, implemented by its proxy class, the
    following expression will return True:
    ```
        `proxy instanceof Foo`
    ```
    and the following cast operation will succeed (rather than throwing
    a `ClassCastException`):
    ```
        `(Foo) proxy`
    ```
    
    - Each proxy instance has an associated invocation handler, the one
    that was passed to its constructor.  The static
    Proxy.getInvocationHandler Proxy.getInvocationHandler method
    will return the invocation handler associated with the proxy instance
    passed as its argument.
    
    - An interface method invocation on a proxy instance will be
    encoded and dispatched to the invocation handler's InvocationHandler.invoke invoke method as described in the
    documentation for that method.
    
    - A proxy interface may define a default method or inherit
    a default method from its superinterface directly or indirectly.
    An invocation handler can invoke a default method of a proxy interface
    by calling InvocationHandler.invokeDefault(Object, Method, Object...)
    InvocationHandler::invokeDefault.
    
    - An invocation of the `hashCode`,
    `equals`, or `toString` methods declared in
    `java.lang.Object` on a proxy instance will be encoded and
    dispatched to the invocation handler's `invoke` method in
    the same manner as interface method invocations are encoded and
    dispatched, as described above.  The declaring class of the
    `Method` object passed to `invoke` will be
    `java.lang.Object`.  Other public methods of a proxy
    instance inherited from `java.lang.Object` are not
    overridden by a proxy class, so invocations of those methods behave
    like they do for instances of `java.lang.Object`.
    
    
    <h2><a id="membership">Package and Module Membership of Proxy Class</a></h2>
    
    The package and module to which a proxy class belongs are chosen such that
    the accessibility of the proxy class is in line with the accessibility of
    the proxy interfaces. Specifically, the package and the module membership
    of a proxy class defined via the
    Proxy.getProxyClass(ClassLoader, Class[]) or
    Proxy.newProxyInstance(ClassLoader, Class[], InvocationHandler)
    methods is specified as follows:
    
    <ol>
    - If all the proxy interfaces are in *exported* or *open*
        packages:
    <ol type="a">
    - if all the proxy interfaces are *public*, then the proxy class is
        *public* in an unconditionally exported but non-open package.
        The name of the package and the module are unspecified.
    
    - if at least one of all the proxy interfaces is *non-public*, then
        the proxy class is *non-public* in the package and module of the
        non-public interfaces. All the non-public interfaces must be in the same
        package and module; otherwise, proxying them is
        <a href="#restrictions">not possible</a>.
    </ol>
    
    - If at least one proxy interface is in a package that is
        *non-exported* and *non-open*:
    <ol type="a">
    - if all the proxy interfaces are *public*, then the proxy class is
        *public* in a *non-exported*, *non-open* package of
        <a href="#dynamicmodule">*dynamic module*.</a>
        The names of the package and the module are unspecified.
    
    - if at least one of all the proxy interfaces is *non-public*, then
        the proxy class is *non-public* in the package and module of the
        non-public interfaces. All the non-public interfaces must be in the same
        package and module; otherwise, proxying them is
        <a href="#restrictions">not possible</a>.
    </ol>
    
    </ol>
    
    
    Note that if proxy interfaces with a mix of accessibilities -- for example,
    an exported public interface and a non-exported non-public interface -- are
    proxied by the same instance, then the proxy class's accessibility is
    governed by the least accessible proxy interface.
    
    Note that it is possible for arbitrary code to obtain access to a proxy class
    in an open package with AccessibleObject.setAccessible setAccessible,
    whereas a proxy class in a non-open package is never accessible to
    code outside the module of the proxy class.
    
    
    Throughout this specification, a "non-exported package" refers to a package
    that is not exported to all modules, and a "non-open package" refers to
    a package that is not open to all modules.  Specifically, these terms refer to
    a package that either is not exported/open by its containing module or is
    exported/open in a qualified fashion by its containing module.
    
    <h3><a id="dynamicmodule">Dynamic Modules</a></h3>
    
    A dynamic module is a named module generated at runtime. A proxy class
    defined in a dynamic module is encapsulated and not accessible to any module.
    Calling Constructor.newInstance(Object...) on a proxy class in
    a dynamic module will throw `IllegalAccessException`;
    `Proxy.newProxyInstance` method should be used instead.
    
    
    A dynamic module can read the modules of all of the superinterfaces of a proxy
    class and the modules of the classes and interfaces referenced by
    all public method signatures of a proxy class.  If a superinterface or
    a referenced class or interface, say `T`, is in a non-exported package,
    the Module module of `T` is updated to export the
    package of `T` to the dynamic module.
    
    <h3>Methods Duplicated in Multiple Proxy Interfaces</h3>
    
    When two or more proxy interfaces contain a method with
    the same name and parameter signature, the order of the proxy class's
    interfaces becomes significant.  When such a *duplicate method*
    is invoked on a proxy instance, the `Method` object passed
    to the invocation handler will not necessarily be the one whose
    declaring class is assignable from the reference type of the interface
    that the proxy's method was invoked through.  This limitation exists
    because the corresponding method implementation in the generated proxy
    class cannot determine which interface it was invoked through.
    Therefore, when a duplicate method is invoked on a proxy instance,
    the `Method` object for the method in the foremost interface
    that contains the method (either directly or inherited through a
    superinterface) in the proxy class's list of interfaces is passed to
    the invocation handler's `invoke` method, regardless of the
    reference type through which the method invocation occurred.
    
    If a proxy interface contains a method with the same name and
    parameter signature as the `hashCode`, `equals`,
    or `toString` methods of `java.lang.Object`,
    when such a method is invoked on a proxy instance, the
    `Method` object passed to the invocation handler will have
    `java.lang.Object` as its declaring class.  In other words,
    the public, non-final methods of `java.lang.Object`
    logically precede all of the proxy interfaces for the determination of
    which `Method` object to pass to the invocation handler.
    
    Note also that when a duplicate method is dispatched to an
    invocation handler, the `invoke` method may only throw
    checked exception types that are assignable to one of the exception
    types in the `throws` clause of the method in *all* of
    the proxy interfaces that it can be invoked through.  If the
    `invoke` method throws a checked exception that is not
    assignable to any of the exception types declared by the method in one
    of the proxy interfaces that it can be invoked through, then an
    unchecked `UndeclaredThrowableException` will be thrown by
    the invocation on the proxy instance.  This restriction means that not
    all of the exception types returned by invoking
    `getExceptionTypes` on the `Method` object
    passed to the `invoke` method can necessarily be thrown
    successfully by the `invoke` method.

    Author(s)
    - Peter Jones

    See
    - InvocationHandler

    Since
    - 1.3

    Unknown Tags
    - 9
    """

    @staticmethod
    def getProxyClass(loader: "ClassLoader", *interfaces: Tuple[type[Any], ...]) -> type[Any]:
        """
        Returns the `java.lang.Class` object for a proxy class
        given a class loader and an array of interfaces.  The proxy class
        will be defined by the specified class loader and will implement
        all of the supplied interfaces.  If any of the given interfaces
        is non-public, the proxy class will be non-public. If a proxy class
        for the same permutation of interfaces has already been defined by the
        class loader, then the existing proxy class will be returned; otherwise,
        a proxy class for those interfaces will be generated dynamically
        and defined by the class loader.

        Arguments
        - loader: the class loader to define the proxy class
        - interfaces: the list of interfaces for the proxy class
                 to implement

        Returns
        - a proxy class that is defined in the specified class loader
                 and that implements the specified interfaces

        Raises
        - IllegalArgumentException: if any of the <a href="#restrictions">
                 restrictions</a> on the parameters are violated
        - SecurityException: if a security manager, *s*, is present
                 and any of the following conditions is met:
                 
                    -  the given `loader` is `null` and
                    the caller's class loader is not `null` and the
                    invocation of SecurityManager.checkPermission
                    s.checkPermission with
                    `RuntimePermission("getClassLoader")` permission
                    denies access.
                    -  for each proxy interface, `intf`,
                    the caller's class loader is not the same as or an
                    ancestor of the class loader for `intf` and
                    invocation of SecurityManager.checkPackageAccess
                    s.checkPackageAccess() denies access to `intf`.
                 
        - NullPointerException: if the `interfaces` array
                 argument or any of its elements are `null`

        See
        - <a href=".membership">Package and Module Membership of Proxy Class</a>

        Deprecated
        - Proxy classes generated in a named module are encapsulated
             and not accessible to code outside its module.
             Constructor.newInstance(Object...) Constructor.newInstance
             will throw `IllegalAccessException` when it is called on
             an inaccessible proxy class.
             Use .newProxyInstance(ClassLoader, Class[], InvocationHandler)
             to create a proxy instance instead.

        Unknown Tags
        - 9
        """
        ...


    @staticmethod
    def newProxyInstance(loader: "ClassLoader", interfaces: list[type[Any]], h: "InvocationHandler") -> "Object":
        """
        Returns a proxy instance for the specified interfaces
        that dispatches method invocations to the specified invocation
        handler.
        
        <a id="restrictions">`IllegalArgumentException` will be thrown
        if any of the following restrictions is violated:</a>
        
        - All of `Class` objects in the given `interfaces` array
        must represent Class.isHidden() non-hidden and
        Class.isSealed() non-sealed interfaces,
        not classes or primitive types.
        
        - No two elements in the `interfaces` array may
        refer to identical `Class` objects.
        
        - All of the interface types must be visible by name through the
        specified class loader. In other words, for class loader
        `cl` and every interface `i`, the following
        expression must be True:
        `Class.forName(i.getName(), False, cl) == i`
        
        - All of the types referenced by all
        public method signatures of the specified interfaces
        and those inherited by their superinterfaces
        must be visible by name through the specified class loader.
        
        - All non-public interfaces must be in the same package
        and module, defined by the specified class loader and
        the module of the non-public interfaces can access all of
        the interface types; otherwise, it would not be possible for
        the proxy class to implement all of the interfaces,
        regardless of what package it is defined in.
        
        - For any set of member methods of the specified interfaces
        that have the same signature:
        
        - If the return type of any of the methods is a primitive
        type or void, then all of the methods must have that same
        return type.
        - Otherwise, one of the methods must have a return type that
        is assignable to all of the return types of the rest of the
        methods.
        
        
        - The resulting proxy class must not exceed any limits imposed
        on classes by the virtual machine.  For example, the VM may limit
        the number of interfaces that a class may implement to 65535; in
        that case, the size of the `interfaces` array must not
        exceed 65535.
        
        
        Note that the order of the specified proxy interfaces is
        significant: two requests for a proxy class with the same combination
        of interfaces but in a different order will result in two distinct
        proxy classes.

        Arguments
        - loader: the class loader to define the proxy class
        - interfaces: the list of interfaces for the proxy class
                 to implement
        - h: the invocation handler to dispatch method invocations to

        Returns
        - a proxy instance with the specified invocation handler of a
                 proxy class that is defined by the specified class loader
                 and that implements the specified interfaces

        Raises
        - IllegalArgumentException: if any of the <a href="#restrictions">
                 restrictions</a> on the parameters are violated
        - SecurityException: if a security manager, *s*, is present
                 and any of the following conditions is met:
                 
                 -  the given `loader` is `null` and
                      the caller's class loader is not `null` and the
                      invocation of SecurityManager.checkPermission
                      s.checkPermission with
                      `RuntimePermission("getClassLoader")` permission
                      denies access;
                 -  for each proxy interface, `intf`,
                      the caller's class loader is not the same as or an
                      ancestor of the class loader for `intf` and
                      invocation of SecurityManager.checkPackageAccess
                      s.checkPackageAccess() denies access to `intf`;
                 -  any of the given proxy interfaces is non-public and the
                      caller class is not in the same Package runtime package
                      as the non-public interface and the invocation of
                      SecurityManager.checkPermission s.checkPermission with
                      `ReflectPermission("newProxyInPackage.{package name`")}
                      permission denies access.
                 
        - NullPointerException: if the `interfaces` array
                 argument or any of its elements are `null`, or
                 if the invocation handler, `h`, is
                 `null`

        See
        - <a href=".membership">Package and Module Membership of Proxy Class</a>

        Unknown Tags
        - 9
        """
        ...


    @staticmethod
    def isProxyClass(cl: type[Any]) -> bool:
        """
        Returns True if the given class is a proxy class.

        Arguments
        - cl: the class to test

        Returns
        - `True` if the class is a proxy class and
                 `False` otherwise

        Raises
        - NullPointerException: if `cl` is `null`

        Unknown Tags
        - The reliability of this method is important for the ability
        to use it to make security decisions, so its implementation should
        not just test if the class in question extends `Proxy`.
        - 9
        """
        ...


    @staticmethod
    def getInvocationHandler(proxy: "Object") -> "InvocationHandler":
        """
        Returns the invocation handler for the specified proxy instance.

        Arguments
        - proxy: the proxy instance to return the invocation handler for

        Returns
        - the invocation handler for the proxy instance

        Raises
        - IllegalArgumentException: if the argument is not a
                 proxy instance
        - SecurityException: if a security manager, *s*, is present
                 and the caller's class loader is not the same as or an
                 ancestor of the class loader for the invocation handler
                 and invocation of SecurityManager.checkPackageAccess
                 s.checkPackageAccess() denies access to the invocation
                 handler's class.
        """
        ...
