"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-lambda-kendra';
const testBucket = defaults.CreateScrapBucket(stack);
const existingIamRole = new iam.Role(stack, 'existingRole', {
    assumedBy: new iam.ServicePrincipal('kendra.amazonaws.com')
});
const sourceProps = {
    urls: {
        seedUrlConfiguration: {
            seedUrls: ["https://aws.amazon.com"]
        }
    },
    crawlDepth: 1,
};
const webCrawlerSource = {
    name: "web-source",
    roleArn: existingIamRole.roleArn,
    type: "WEBCRAWLER",
    dataSourceConfiguration: {
        webCrawlerConfiguration: sourceProps
    }
};
new lib_1.LambdaToKendra(stack, 'minimal-arguments', {
    lambdaFunctionProps: {
        code: lambda.Code.fromAsset(`lambda`),
        runtime: lambda.Runtime.NODEJS_18_X,
        handler: 'index.handler',
    },
    kendraDataSourcesProps: [{
            type: 'S3',
            dataSourceConfiguration: {
                s3Configuration: {
                    bucketName: testBucket.bucketName,
                }
            }
        },
        webCrawlerSource],
});
core_1.suppressAutoDeleteHandlerWarnings(stack);
//# sourceMappingURL=data:application/json;base64,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