/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnEndpointCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#cdn_endpoint_id CdnEndpointCustomDomain#cdn_endpoint_id}
    */
    readonly cdnEndpointId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#host_name CdnEndpointCustomDomain#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#id CdnEndpointCustomDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#name CdnEndpointCustomDomain#name}
    */
    readonly name: string;
    /**
    * cdn_managed_https block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#cdn_managed_https CdnEndpointCustomDomain#cdn_managed_https}
    */
    readonly cdnManagedHttps?: CdnEndpointCustomDomainCdnManagedHttps;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#timeouts CdnEndpointCustomDomain#timeouts}
    */
    readonly timeouts?: CdnEndpointCustomDomainTimeouts;
    /**
    * user_managed_https block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#user_managed_https CdnEndpointCustomDomain#user_managed_https}
    */
    readonly userManagedHttps?: CdnEndpointCustomDomainUserManagedHttps;
}
export interface CdnEndpointCustomDomainCdnManagedHttps {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#certificate_type CdnEndpointCustomDomain#certificate_type}
    */
    readonly certificateType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#protocol_type CdnEndpointCustomDomain#protocol_type}
    */
    readonly protocolType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#tls_version CdnEndpointCustomDomain#tls_version}
    */
    readonly tlsVersion?: string;
}
export declare function cdnEndpointCustomDomainCdnManagedHttpsToTerraform(struct?: CdnEndpointCustomDomainCdnManagedHttpsOutputReference | CdnEndpointCustomDomainCdnManagedHttps): any;
export declare function cdnEndpointCustomDomainCdnManagedHttpsToHclTerraform(struct?: CdnEndpointCustomDomainCdnManagedHttpsOutputReference | CdnEndpointCustomDomainCdnManagedHttps): any;
export declare class CdnEndpointCustomDomainCdnManagedHttpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointCustomDomainCdnManagedHttps | undefined;
    set internalValue(value: CdnEndpointCustomDomainCdnManagedHttps | undefined);
    private _certificateType?;
    get certificateType(): string;
    set certificateType(value: string);
    get certificateTypeInput(): string | undefined;
    private _protocolType?;
    get protocolType(): string;
    set protocolType(value: string);
    get protocolTypeInput(): string | undefined;
    private _tlsVersion?;
    get tlsVersion(): string;
    set tlsVersion(value: string);
    resetTlsVersion(): void;
    get tlsVersionInput(): string | undefined;
}
export interface CdnEndpointCustomDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#create CdnEndpointCustomDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#delete CdnEndpointCustomDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#read CdnEndpointCustomDomain#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#update CdnEndpointCustomDomain#update}
    */
    readonly update?: string;
}
export declare function cdnEndpointCustomDomainTimeoutsToTerraform(struct?: CdnEndpointCustomDomainTimeouts | cdktf.IResolvable): any;
export declare function cdnEndpointCustomDomainTimeoutsToHclTerraform(struct?: CdnEndpointCustomDomainTimeouts | cdktf.IResolvable): any;
export declare class CdnEndpointCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointCustomDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnEndpointCustomDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CdnEndpointCustomDomainUserManagedHttps {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#key_vault_secret_id CdnEndpointCustomDomain#key_vault_secret_id}
    */
    readonly keyVaultSecretId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#tls_version CdnEndpointCustomDomain#tls_version}
    */
    readonly tlsVersion?: string;
}
export declare function cdnEndpointCustomDomainUserManagedHttpsToTerraform(struct?: CdnEndpointCustomDomainUserManagedHttpsOutputReference | CdnEndpointCustomDomainUserManagedHttps): any;
export declare function cdnEndpointCustomDomainUserManagedHttpsToHclTerraform(struct?: CdnEndpointCustomDomainUserManagedHttpsOutputReference | CdnEndpointCustomDomainUserManagedHttps): any;
export declare class CdnEndpointCustomDomainUserManagedHttpsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnEndpointCustomDomainUserManagedHttps | undefined;
    set internalValue(value: CdnEndpointCustomDomainUserManagedHttps | undefined);
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    get keyVaultSecretIdInput(): string | undefined;
    private _tlsVersion?;
    get tlsVersion(): string;
    set tlsVersion(value: string);
    resetTlsVersion(): void;
    get tlsVersionInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain azurerm_cdn_endpoint_custom_domain}
*/
export declare class CdnEndpointCustomDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_endpoint_custom_domain";
    /**
    * Generates CDKTF code for importing a CdnEndpointCustomDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnEndpointCustomDomain to import
    * @param importFromId The id of the existing CdnEndpointCustomDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnEndpointCustomDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_endpoint_custom_domain azurerm_cdn_endpoint_custom_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnEndpointCustomDomainConfig
    */
    constructor(scope: Construct, id: string, config: CdnEndpointCustomDomainConfig);
    private _cdnEndpointId?;
    get cdnEndpointId(): string;
    set cdnEndpointId(value: string);
    get cdnEndpointIdInput(): string | undefined;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _cdnManagedHttps;
    get cdnManagedHttps(): CdnEndpointCustomDomainCdnManagedHttpsOutputReference;
    putCdnManagedHttps(value: CdnEndpointCustomDomainCdnManagedHttps): void;
    resetCdnManagedHttps(): void;
    get cdnManagedHttpsInput(): CdnEndpointCustomDomainCdnManagedHttps | undefined;
    private _timeouts;
    get timeouts(): CdnEndpointCustomDomainTimeoutsOutputReference;
    putTimeouts(value: CdnEndpointCustomDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnEndpointCustomDomainTimeouts | undefined;
    private _userManagedHttps;
    get userManagedHttps(): CdnEndpointCustomDomainUserManagedHttpsOutputReference;
    putUserManagedHttps(value: CdnEndpointCustomDomainUserManagedHttps): void;
    resetUserManagedHttps(): void;
    get userManagedHttpsInput(): CdnEndpointCustomDomainUserManagedHttps | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
