/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorRouteConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#cdn_frontdoor_custom_domain_ids CdnFrontdoorRoute#cdn_frontdoor_custom_domain_ids}
    */
    readonly cdnFrontdoorCustomDomainIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#cdn_frontdoor_endpoint_id CdnFrontdoorRoute#cdn_frontdoor_endpoint_id}
    */
    readonly cdnFrontdoorEndpointId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#cdn_frontdoor_origin_group_id CdnFrontdoorRoute#cdn_frontdoor_origin_group_id}
    */
    readonly cdnFrontdoorOriginGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#cdn_frontdoor_origin_ids CdnFrontdoorRoute#cdn_frontdoor_origin_ids}
    */
    readonly cdnFrontdoorOriginIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#cdn_frontdoor_origin_path CdnFrontdoorRoute#cdn_frontdoor_origin_path}
    */
    readonly cdnFrontdoorOriginPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#cdn_frontdoor_rule_set_ids CdnFrontdoorRoute#cdn_frontdoor_rule_set_ids}
    */
    readonly cdnFrontdoorRuleSetIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#enabled CdnFrontdoorRoute#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#forwarding_protocol CdnFrontdoorRoute#forwarding_protocol}
    */
    readonly forwardingProtocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#https_redirect_enabled CdnFrontdoorRoute#https_redirect_enabled}
    */
    readonly httpsRedirectEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#id CdnFrontdoorRoute#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#link_to_default_domain CdnFrontdoorRoute#link_to_default_domain}
    */
    readonly linkToDefaultDomain?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#name CdnFrontdoorRoute#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#patterns_to_match CdnFrontdoorRoute#patterns_to_match}
    */
    readonly patternsToMatch: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#supported_protocols CdnFrontdoorRoute#supported_protocols}
    */
    readonly supportedProtocols: string[];
    /**
    * cache block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#cache CdnFrontdoorRoute#cache}
    */
    readonly cache?: CdnFrontdoorRouteCache;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#timeouts CdnFrontdoorRoute#timeouts}
    */
    readonly timeouts?: CdnFrontdoorRouteTimeouts;
}
export interface CdnFrontdoorRouteCache {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#compression_enabled CdnFrontdoorRoute#compression_enabled}
    */
    readonly compressionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#content_types_to_compress CdnFrontdoorRoute#content_types_to_compress}
    */
    readonly contentTypesToCompress?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#query_string_caching_behavior CdnFrontdoorRoute#query_string_caching_behavior}
    */
    readonly queryStringCachingBehavior?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#query_strings CdnFrontdoorRoute#query_strings}
    */
    readonly queryStrings?: string[];
}
export declare function cdnFrontdoorRouteCacheToTerraform(struct?: CdnFrontdoorRouteCacheOutputReference | CdnFrontdoorRouteCache): any;
export declare function cdnFrontdoorRouteCacheToHclTerraform(struct?: CdnFrontdoorRouteCacheOutputReference | CdnFrontdoorRouteCache): any;
export declare class CdnFrontdoorRouteCacheOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRouteCache | undefined;
    set internalValue(value: CdnFrontdoorRouteCache | undefined);
    private _compressionEnabled?;
    get compressionEnabled(): boolean | cdktf.IResolvable;
    set compressionEnabled(value: boolean | cdktf.IResolvable);
    resetCompressionEnabled(): void;
    get compressionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _contentTypesToCompress?;
    get contentTypesToCompress(): string[];
    set contentTypesToCompress(value: string[]);
    resetContentTypesToCompress(): void;
    get contentTypesToCompressInput(): string[] | undefined;
    private _queryStringCachingBehavior?;
    get queryStringCachingBehavior(): string;
    set queryStringCachingBehavior(value: string);
    resetQueryStringCachingBehavior(): void;
    get queryStringCachingBehaviorInput(): string | undefined;
    private _queryStrings?;
    get queryStrings(): string[];
    set queryStrings(value: string[]);
    resetQueryStrings(): void;
    get queryStringsInput(): string[] | undefined;
}
export interface CdnFrontdoorRouteTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#create CdnFrontdoorRoute#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#delete CdnFrontdoorRoute#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#read CdnFrontdoorRoute#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#update CdnFrontdoorRoute#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorRouteTimeoutsToTerraform(struct?: CdnFrontdoorRouteTimeouts | cdktf.IResolvable): any;
export declare function cdnFrontdoorRouteTimeoutsToHclTerraform(struct?: CdnFrontdoorRouteTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorRouteTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorRouteTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorRouteTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route azurerm_cdn_frontdoor_route}
*/
export declare class CdnFrontdoorRoute extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_route";
    /**
    * Generates CDKTF code for importing a CdnFrontdoorRoute resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnFrontdoorRoute to import
    * @param importFromId The id of the existing CdnFrontdoorRoute that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnFrontdoorRoute to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cdn_frontdoor_route azurerm_cdn_frontdoor_route} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorRouteConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorRouteConfig);
    private _cdnFrontdoorCustomDomainIds?;
    get cdnFrontdoorCustomDomainIds(): string[];
    set cdnFrontdoorCustomDomainIds(value: string[]);
    resetCdnFrontdoorCustomDomainIds(): void;
    get cdnFrontdoorCustomDomainIdsInput(): string[] | undefined;
    private _cdnFrontdoorEndpointId?;
    get cdnFrontdoorEndpointId(): string;
    set cdnFrontdoorEndpointId(value: string);
    get cdnFrontdoorEndpointIdInput(): string | undefined;
    private _cdnFrontdoorOriginGroupId?;
    get cdnFrontdoorOriginGroupId(): string;
    set cdnFrontdoorOriginGroupId(value: string);
    get cdnFrontdoorOriginGroupIdInput(): string | undefined;
    private _cdnFrontdoorOriginIds?;
    get cdnFrontdoorOriginIds(): string[];
    set cdnFrontdoorOriginIds(value: string[]);
    get cdnFrontdoorOriginIdsInput(): string[] | undefined;
    private _cdnFrontdoorOriginPath?;
    get cdnFrontdoorOriginPath(): string;
    set cdnFrontdoorOriginPath(value: string);
    resetCdnFrontdoorOriginPath(): void;
    get cdnFrontdoorOriginPathInput(): string | undefined;
    private _cdnFrontdoorRuleSetIds?;
    get cdnFrontdoorRuleSetIds(): string[];
    set cdnFrontdoorRuleSetIds(value: string[]);
    resetCdnFrontdoorRuleSetIds(): void;
    get cdnFrontdoorRuleSetIdsInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardingProtocol?;
    get forwardingProtocol(): string;
    set forwardingProtocol(value: string);
    resetForwardingProtocol(): void;
    get forwardingProtocolInput(): string | undefined;
    private _httpsRedirectEnabled?;
    get httpsRedirectEnabled(): boolean | cdktf.IResolvable;
    set httpsRedirectEnabled(value: boolean | cdktf.IResolvable);
    resetHttpsRedirectEnabled(): void;
    get httpsRedirectEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkToDefaultDomain?;
    get linkToDefaultDomain(): boolean | cdktf.IResolvable;
    set linkToDefaultDomain(value: boolean | cdktf.IResolvable);
    resetLinkToDefaultDomain(): void;
    get linkToDefaultDomainInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _patternsToMatch?;
    get patternsToMatch(): string[];
    set patternsToMatch(value: string[]);
    get patternsToMatchInput(): string[] | undefined;
    private _supportedProtocols?;
    get supportedProtocols(): string[];
    set supportedProtocols(value: string[]);
    get supportedProtocolsInput(): string[] | undefined;
    private _cache;
    get cache(): CdnFrontdoorRouteCacheOutputReference;
    putCache(value: CdnFrontdoorRouteCache): void;
    resetCache(): void;
    get cacheInput(): CdnFrontdoorRouteCache | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorRouteTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorRouteTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorRouteTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
