/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbPostgresqlClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#administrator_login_password CosmosdbPostgresqlCluster#administrator_login_password}
    */
    readonly administratorLoginPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#citus_version CosmosdbPostgresqlCluster#citus_version}
    */
    readonly citusVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#coordinator_public_ip_access_enabled CosmosdbPostgresqlCluster#coordinator_public_ip_access_enabled}
    */
    readonly coordinatorPublicIpAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#coordinator_server_edition CosmosdbPostgresqlCluster#coordinator_server_edition}
    */
    readonly coordinatorServerEdition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#coordinator_storage_quota_in_mb CosmosdbPostgresqlCluster#coordinator_storage_quota_in_mb}
    */
    readonly coordinatorStorageQuotaInMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#coordinator_vcore_count CosmosdbPostgresqlCluster#coordinator_vcore_count}
    */
    readonly coordinatorVcoreCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#ha_enabled CosmosdbPostgresqlCluster#ha_enabled}
    */
    readonly haEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#id CosmosdbPostgresqlCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#location CosmosdbPostgresqlCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#name CosmosdbPostgresqlCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#node_count CosmosdbPostgresqlCluster#node_count}
    */
    readonly nodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#node_public_ip_access_enabled CosmosdbPostgresqlCluster#node_public_ip_access_enabled}
    */
    readonly nodePublicIpAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#node_server_edition CosmosdbPostgresqlCluster#node_server_edition}
    */
    readonly nodeServerEdition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#node_storage_quota_in_mb CosmosdbPostgresqlCluster#node_storage_quota_in_mb}
    */
    readonly nodeStorageQuotaInMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#node_vcores CosmosdbPostgresqlCluster#node_vcores}
    */
    readonly nodeVcores?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#point_in_time_in_utc CosmosdbPostgresqlCluster#point_in_time_in_utc}
    */
    readonly pointInTimeInUtc?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#preferred_primary_zone CosmosdbPostgresqlCluster#preferred_primary_zone}
    */
    readonly preferredPrimaryZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#resource_group_name CosmosdbPostgresqlCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#shards_on_coordinator_enabled CosmosdbPostgresqlCluster#shards_on_coordinator_enabled}
    */
    readonly shardsOnCoordinatorEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#source_location CosmosdbPostgresqlCluster#source_location}
    */
    readonly sourceLocation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#source_resource_id CosmosdbPostgresqlCluster#source_resource_id}
    */
    readonly sourceResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#sql_version CosmosdbPostgresqlCluster#sql_version}
    */
    readonly sqlVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#tags CosmosdbPostgresqlCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#maintenance_window CosmosdbPostgresqlCluster#maintenance_window}
    */
    readonly maintenanceWindow?: CosmosdbPostgresqlClusterMaintenanceWindow;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#timeouts CosmosdbPostgresqlCluster#timeouts}
    */
    readonly timeouts?: CosmosdbPostgresqlClusterTimeouts;
}
export interface CosmosdbPostgresqlClusterServers {
}
export declare function cosmosdbPostgresqlClusterServersToTerraform(struct?: CosmosdbPostgresqlClusterServers): any;
export declare function cosmosdbPostgresqlClusterServersToHclTerraform(struct?: CosmosdbPostgresqlClusterServers): any;
export declare class CosmosdbPostgresqlClusterServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbPostgresqlClusterServers | undefined;
    set internalValue(value: CosmosdbPostgresqlClusterServers | undefined);
    get fqdn(): string;
    get name(): string;
}
export declare class CosmosdbPostgresqlClusterServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbPostgresqlClusterServersOutputReference;
}
export interface CosmosdbPostgresqlClusterMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#day_of_week CosmosdbPostgresqlCluster#day_of_week}
    */
    readonly dayOfWeek?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#start_hour CosmosdbPostgresqlCluster#start_hour}
    */
    readonly startHour?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#start_minute CosmosdbPostgresqlCluster#start_minute}
    */
    readonly startMinute?: number;
}
export declare function cosmosdbPostgresqlClusterMaintenanceWindowToTerraform(struct?: CosmosdbPostgresqlClusterMaintenanceWindowOutputReference | CosmosdbPostgresqlClusterMaintenanceWindow): any;
export declare function cosmosdbPostgresqlClusterMaintenanceWindowToHclTerraform(struct?: CosmosdbPostgresqlClusterMaintenanceWindowOutputReference | CosmosdbPostgresqlClusterMaintenanceWindow): any;
export declare class CosmosdbPostgresqlClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbPostgresqlClusterMaintenanceWindow | undefined;
    set internalValue(value: CosmosdbPostgresqlClusterMaintenanceWindow | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): number;
    set dayOfWeek(value: number);
    resetDayOfWeek(): void;
    get dayOfWeekInput(): number | undefined;
    private _startHour?;
    get startHour(): number;
    set startHour(value: number);
    resetStartHour(): void;
    get startHourInput(): number | undefined;
    private _startMinute?;
    get startMinute(): number;
    set startMinute(value: number);
    resetStartMinute(): void;
    get startMinuteInput(): number | undefined;
}
export interface CosmosdbPostgresqlClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#create CosmosdbPostgresqlCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#delete CosmosdbPostgresqlCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#read CosmosdbPostgresqlCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#update CosmosdbPostgresqlCluster#update}
    */
    readonly update?: string;
}
export declare function cosmosdbPostgresqlClusterTimeoutsToTerraform(struct?: CosmosdbPostgresqlClusterTimeouts | cdktf.IResolvable): any;
export declare function cosmosdbPostgresqlClusterTimeoutsToHclTerraform(struct?: CosmosdbPostgresqlClusterTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbPostgresqlClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbPostgresqlClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbPostgresqlClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster azurerm_cosmosdb_postgresql_cluster}
*/
export declare class CosmosdbPostgresqlCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cosmosdb_postgresql_cluster";
    /**
    * Generates CDKTF code for importing a CosmosdbPostgresqlCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CosmosdbPostgresqlCluster to import
    * @param importFromId The id of the existing CosmosdbPostgresqlCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CosmosdbPostgresqlCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/cosmosdb_postgresql_cluster azurerm_cosmosdb_postgresql_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbPostgresqlClusterConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbPostgresqlClusterConfig);
    private _administratorLoginPassword?;
    get administratorLoginPassword(): string;
    set administratorLoginPassword(value: string);
    resetAdministratorLoginPassword(): void;
    get administratorLoginPasswordInput(): string | undefined;
    private _citusVersion?;
    get citusVersion(): string;
    set citusVersion(value: string);
    resetCitusVersion(): void;
    get citusVersionInput(): string | undefined;
    private _coordinatorPublicIpAccessEnabled?;
    get coordinatorPublicIpAccessEnabled(): boolean | cdktf.IResolvable;
    set coordinatorPublicIpAccessEnabled(value: boolean | cdktf.IResolvable);
    resetCoordinatorPublicIpAccessEnabled(): void;
    get coordinatorPublicIpAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _coordinatorServerEdition?;
    get coordinatorServerEdition(): string;
    set coordinatorServerEdition(value: string);
    resetCoordinatorServerEdition(): void;
    get coordinatorServerEditionInput(): string | undefined;
    private _coordinatorStorageQuotaInMb?;
    get coordinatorStorageQuotaInMb(): number;
    set coordinatorStorageQuotaInMb(value: number);
    resetCoordinatorStorageQuotaInMb(): void;
    get coordinatorStorageQuotaInMbInput(): number | undefined;
    private _coordinatorVcoreCount?;
    get coordinatorVcoreCount(): number;
    set coordinatorVcoreCount(value: number);
    resetCoordinatorVcoreCount(): void;
    get coordinatorVcoreCountInput(): number | undefined;
    get earliestRestoreTime(): string;
    private _haEnabled?;
    get haEnabled(): boolean | cdktf.IResolvable;
    set haEnabled(value: boolean | cdktf.IResolvable);
    resetHaEnabled(): void;
    get haEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _nodePublicIpAccessEnabled?;
    get nodePublicIpAccessEnabled(): boolean | cdktf.IResolvable;
    set nodePublicIpAccessEnabled(value: boolean | cdktf.IResolvable);
    resetNodePublicIpAccessEnabled(): void;
    get nodePublicIpAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeServerEdition?;
    get nodeServerEdition(): string;
    set nodeServerEdition(value: string);
    resetNodeServerEdition(): void;
    get nodeServerEditionInput(): string | undefined;
    private _nodeStorageQuotaInMb?;
    get nodeStorageQuotaInMb(): number;
    set nodeStorageQuotaInMb(value: number);
    resetNodeStorageQuotaInMb(): void;
    get nodeStorageQuotaInMbInput(): number | undefined;
    private _nodeVcores?;
    get nodeVcores(): number;
    set nodeVcores(value: number);
    resetNodeVcores(): void;
    get nodeVcoresInput(): number | undefined;
    private _pointInTimeInUtc?;
    get pointInTimeInUtc(): string;
    set pointInTimeInUtc(value: string);
    resetPointInTimeInUtc(): void;
    get pointInTimeInUtcInput(): string | undefined;
    private _preferredPrimaryZone?;
    get preferredPrimaryZone(): string;
    set preferredPrimaryZone(value: string);
    resetPreferredPrimaryZone(): void;
    get preferredPrimaryZoneInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _servers;
    get servers(): CosmosdbPostgresqlClusterServersList;
    private _shardsOnCoordinatorEnabled?;
    get shardsOnCoordinatorEnabled(): boolean | cdktf.IResolvable;
    set shardsOnCoordinatorEnabled(value: boolean | cdktf.IResolvable);
    resetShardsOnCoordinatorEnabled(): void;
    get shardsOnCoordinatorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceLocation?;
    get sourceLocation(): string;
    set sourceLocation(value: string);
    resetSourceLocation(): void;
    get sourceLocationInput(): string | undefined;
    private _sourceResourceId?;
    get sourceResourceId(): string;
    set sourceResourceId(value: string);
    resetSourceResourceId(): void;
    get sourceResourceIdInput(): string | undefined;
    private _sqlVersion?;
    get sqlVersion(): string;
    set sqlVersion(value: string);
    resetSqlVersion(): void;
    get sqlVersionInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): CosmosdbPostgresqlClusterMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: CosmosdbPostgresqlClusterMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): CosmosdbPostgresqlClusterMaintenanceWindow | undefined;
    private _timeouts;
    get timeouts(): CosmosdbPostgresqlClusterTimeoutsOutputReference;
    putTimeouts(value: CosmosdbPostgresqlClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CosmosdbPostgresqlClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
