/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CustomIpPrefixConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#cidr CustomIpPrefix#cidr}
    */
    readonly cidr: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#commissioning_enabled CustomIpPrefix#commissioning_enabled}
    */
    readonly commissioningEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#id CustomIpPrefix#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#internet_advertising_disabled CustomIpPrefix#internet_advertising_disabled}
    */
    readonly internetAdvertisingDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#location CustomIpPrefix#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#name CustomIpPrefix#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#parent_custom_ip_prefix_id CustomIpPrefix#parent_custom_ip_prefix_id}
    */
    readonly parentCustomIpPrefixId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#resource_group_name CustomIpPrefix#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#roa_validity_end_date CustomIpPrefix#roa_validity_end_date}
    */
    readonly roaValidityEndDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#tags CustomIpPrefix#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#wan_validation_signed_message CustomIpPrefix#wan_validation_signed_message}
    */
    readonly wanValidationSignedMessage?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#zones CustomIpPrefix#zones}
    */
    readonly zones?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#timeouts CustomIpPrefix#timeouts}
    */
    readonly timeouts?: CustomIpPrefixTimeouts;
}
export interface CustomIpPrefixTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#create CustomIpPrefix#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#delete CustomIpPrefix#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#read CustomIpPrefix#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#update CustomIpPrefix#update}
    */
    readonly update?: string;
}
export declare function customIpPrefixTimeoutsToTerraform(struct?: CustomIpPrefixTimeouts | cdktf.IResolvable): any;
export declare function customIpPrefixTimeoutsToHclTerraform(struct?: CustomIpPrefixTimeouts | cdktf.IResolvable): any;
export declare class CustomIpPrefixTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CustomIpPrefixTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CustomIpPrefixTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix azurerm_custom_ip_prefix}
*/
export declare class CustomIpPrefix extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_custom_ip_prefix";
    /**
    * Generates CDKTF code for importing a CustomIpPrefix resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CustomIpPrefix to import
    * @param importFromId The id of the existing CustomIpPrefix that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CustomIpPrefix to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/custom_ip_prefix azurerm_custom_ip_prefix} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CustomIpPrefixConfig
    */
    constructor(scope: Construct, id: string, config: CustomIpPrefixConfig);
    private _cidr?;
    get cidr(): string;
    set cidr(value: string);
    get cidrInput(): string | undefined;
    private _commissioningEnabled?;
    get commissioningEnabled(): boolean | cdktf.IResolvable;
    set commissioningEnabled(value: boolean | cdktf.IResolvable);
    resetCommissioningEnabled(): void;
    get commissioningEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internetAdvertisingDisabled?;
    get internetAdvertisingDisabled(): boolean | cdktf.IResolvable;
    set internetAdvertisingDisabled(value: boolean | cdktf.IResolvable);
    resetInternetAdvertisingDisabled(): void;
    get internetAdvertisingDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentCustomIpPrefixId?;
    get parentCustomIpPrefixId(): string;
    set parentCustomIpPrefixId(value: string);
    resetParentCustomIpPrefixId(): void;
    get parentCustomIpPrefixIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _roaValidityEndDate?;
    get roaValidityEndDate(): string;
    set roaValidityEndDate(value: string);
    resetRoaValidityEndDate(): void;
    get roaValidityEndDateInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _wanValidationSignedMessage?;
    get wanValidationSignedMessage(): string;
    set wanValidationSignedMessage(value: string);
    resetWanValidationSignedMessage(): void;
    get wanValidationSignedMessageInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): CustomIpPrefixTimeoutsOutputReference;
    putTimeouts(value: CustomIpPrefixTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CustomIpPrefixTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
