/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataFactoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/data_factory#id DataAzurermDataFactory#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/data_factory#name DataAzurermDataFactory#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/data_factory#resource_group_name DataAzurermDataFactory#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/data_factory#timeouts DataAzurermDataFactory#timeouts}
    */
    readonly timeouts?: DataAzurermDataFactoryTimeouts;
}
export interface DataAzurermDataFactoryGithubConfiguration {
}
export declare function dataAzurermDataFactoryGithubConfigurationToTerraform(struct?: DataAzurermDataFactoryGithubConfiguration): any;
export declare function dataAzurermDataFactoryGithubConfigurationToHclTerraform(struct?: DataAzurermDataFactoryGithubConfiguration): any;
export declare class DataAzurermDataFactoryGithubConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataFactoryGithubConfiguration | undefined;
    set internalValue(value: DataAzurermDataFactoryGithubConfiguration | undefined);
    get accountName(): string;
    get branchName(): string;
    get gitUrl(): string;
    get repositoryName(): string;
    get rootFolder(): string;
}
export declare class DataAzurermDataFactoryGithubConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataFactoryGithubConfigurationOutputReference;
}
export interface DataAzurermDataFactoryIdentity {
}
export declare function dataAzurermDataFactoryIdentityToTerraform(struct?: DataAzurermDataFactoryIdentity): any;
export declare function dataAzurermDataFactoryIdentityToHclTerraform(struct?: DataAzurermDataFactoryIdentity): any;
export declare class DataAzurermDataFactoryIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataFactoryIdentity | undefined;
    set internalValue(value: DataAzurermDataFactoryIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermDataFactoryIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataFactoryIdentityOutputReference;
}
export interface DataAzurermDataFactoryVstsConfiguration {
}
export declare function dataAzurermDataFactoryVstsConfigurationToTerraform(struct?: DataAzurermDataFactoryVstsConfiguration): any;
export declare function dataAzurermDataFactoryVstsConfigurationToHclTerraform(struct?: DataAzurermDataFactoryVstsConfiguration): any;
export declare class DataAzurermDataFactoryVstsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataFactoryVstsConfiguration | undefined;
    set internalValue(value: DataAzurermDataFactoryVstsConfiguration | undefined);
    get accountName(): string;
    get branchName(): string;
    get projectName(): string;
    get repositoryName(): string;
    get rootFolder(): string;
    get tenantId(): string;
}
export declare class DataAzurermDataFactoryVstsConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataFactoryVstsConfigurationOutputReference;
}
export interface DataAzurermDataFactoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/data_factory#read DataAzurermDataFactory#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataFactoryTimeoutsToTerraform(struct?: DataAzurermDataFactoryTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDataFactoryTimeoutsToHclTerraform(struct?: DataAzurermDataFactoryTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataFactoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataFactoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDataFactoryTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/data_factory azurerm_data_factory}
*/
export declare class DataAzurermDataFactory extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_data_factory";
    /**
    * Generates CDKTF code for importing a DataAzurermDataFactory resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDataFactory to import
    * @param importFromId The id of the existing DataAzurermDataFactory that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/data_factory#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDataFactory to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/data_factory azurerm_data_factory} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataFactoryConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataFactoryConfig);
    private _githubConfiguration;
    get githubConfiguration(): DataAzurermDataFactoryGithubConfigurationList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermDataFactoryIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _vstsConfiguration;
    get vstsConfiguration(): DataAzurermDataFactoryVstsConfigurationList;
    private _timeouts;
    get timeouts(): DataAzurermDataFactoryTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataFactoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDataFactoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
