/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermHealthcareServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service#id DataAzurermHealthcareService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service#location DataAzurermHealthcareService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service#name DataAzurermHealthcareService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service#resource_group_name DataAzurermHealthcareService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service#timeouts DataAzurermHealthcareService#timeouts}
    */
    readonly timeouts?: DataAzurermHealthcareServiceTimeouts;
}
export interface DataAzurermHealthcareServiceAuthenticationConfiguration {
}
export declare function dataAzurermHealthcareServiceAuthenticationConfigurationToTerraform(struct?: DataAzurermHealthcareServiceAuthenticationConfiguration): any;
export declare function dataAzurermHealthcareServiceAuthenticationConfigurationToHclTerraform(struct?: DataAzurermHealthcareServiceAuthenticationConfiguration): any;
export declare class DataAzurermHealthcareServiceAuthenticationConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareServiceAuthenticationConfiguration | undefined;
    set internalValue(value: DataAzurermHealthcareServiceAuthenticationConfiguration | undefined);
    get audience(): string;
    get authority(): string;
    get smartProxyEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermHealthcareServiceAuthenticationConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareServiceAuthenticationConfigurationOutputReference;
}
export interface DataAzurermHealthcareServiceCorsConfiguration {
}
export declare function dataAzurermHealthcareServiceCorsConfigurationToTerraform(struct?: DataAzurermHealthcareServiceCorsConfiguration): any;
export declare function dataAzurermHealthcareServiceCorsConfigurationToHclTerraform(struct?: DataAzurermHealthcareServiceCorsConfiguration): any;
export declare class DataAzurermHealthcareServiceCorsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareServiceCorsConfiguration | undefined;
    set internalValue(value: DataAzurermHealthcareServiceCorsConfiguration | undefined);
    get allowCredentials(): cdktf.IResolvable;
    get allowedHeaders(): string[];
    get allowedMethods(): string[];
    get allowedOrigins(): string[];
    get maxAgeInSeconds(): number;
}
export declare class DataAzurermHealthcareServiceCorsConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareServiceCorsConfigurationOutputReference;
}
export interface DataAzurermHealthcareServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service#read DataAzurermHealthcareService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermHealthcareServiceTimeoutsToTerraform(struct?: DataAzurermHealthcareServiceTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermHealthcareServiceTimeoutsToHclTerraform(struct?: DataAzurermHealthcareServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermHealthcareServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermHealthcareServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermHealthcareServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service azurerm_healthcare_service}
*/
export declare class DataAzurermHealthcareService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_healthcare_service";
    /**
    * Generates CDKTF code for importing a DataAzurermHealthcareService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermHealthcareService to import
    * @param importFromId The id of the existing DataAzurermHealthcareService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermHealthcareService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/healthcare_service azurerm_healthcare_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermHealthcareServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermHealthcareServiceConfig);
    get accessPolicyObjectIds(): string[];
    private _authenticationConfiguration;
    get authenticationConfiguration(): DataAzurermHealthcareServiceAuthenticationConfigurationList;
    private _corsConfiguration;
    get corsConfiguration(): DataAzurermHealthcareServiceCorsConfigurationList;
    get cosmosdbKeyVaultKeyVersionlessId(): string;
    get cosmosdbThroughput(): number;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermHealthcareServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermHealthcareServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermHealthcareServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
