/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMssqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/mssql_database#id DataAzurermMssqlDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/mssql_database#name DataAzurermMssqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/mssql_database#server_id DataAzurermMssqlDatabase#server_id}
    */
    readonly serverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/mssql_database#timeouts DataAzurermMssqlDatabase#timeouts}
    */
    readonly timeouts?: DataAzurermMssqlDatabaseTimeouts;
}
export interface DataAzurermMssqlDatabaseIdentity {
}
export declare function dataAzurermMssqlDatabaseIdentityToTerraform(struct?: DataAzurermMssqlDatabaseIdentity): any;
export declare function dataAzurermMssqlDatabaseIdentityToHclTerraform(struct?: DataAzurermMssqlDatabaseIdentity): any;
export declare class DataAzurermMssqlDatabaseIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMssqlDatabaseIdentity | undefined;
    set internalValue(value: DataAzurermMssqlDatabaseIdentity | undefined);
    get identityIds(): string[];
    get type(): string;
}
export declare class DataAzurermMssqlDatabaseIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMssqlDatabaseIdentityOutputReference;
}
export interface DataAzurermMssqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/mssql_database#read DataAzurermMssqlDatabase#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMssqlDatabaseTimeoutsToTerraform(struct?: DataAzurermMssqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMssqlDatabaseTimeoutsToHclTerraform(struct?: DataAzurermMssqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMssqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMssqlDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMssqlDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/mssql_database azurerm_mssql_database}
*/
export declare class DataAzurermMssqlDatabase extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mssql_database";
    /**
    * Generates CDKTF code for importing a DataAzurermMssqlDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMssqlDatabase to import
    * @param importFromId The id of the existing DataAzurermMssqlDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/mssql_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMssqlDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/mssql_database azurerm_mssql_database} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMssqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlDatabaseConfig);
    get collation(): string;
    get elasticPoolId(): string;
    get enclaveType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermMssqlDatabaseIdentityList;
    get licenseType(): string;
    get maxSizeGb(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get readReplicaCount(): number;
    get readScale(): cdktf.IResolvable;
    private _serverId?;
    get serverId(): string;
    set serverId(value: string);
    get serverIdInput(): string | undefined;
    get skuName(): string;
    get storageAccountType(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get transparentDataEncryptionEnabled(): cdktf.IResolvable;
    get transparentDataEncryptionKeyAutomaticRotationEnabled(): cdktf.IResolvable;
    get transparentDataEncryptionKeyVaultKeyId(): string;
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermMssqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMssqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMssqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
