/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSiteRecoveryReplicationRecoveryPlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/site_recovery_replication_recovery_plan#id DataAzurermSiteRecoveryReplicationRecoveryPlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/site_recovery_replication_recovery_plan#name DataAzurermSiteRecoveryReplicationRecoveryPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/site_recovery_replication_recovery_plan#recovery_vault_id DataAzurermSiteRecoveryReplicationRecoveryPlan#recovery_vault_id}
    */
    readonly recoveryVaultId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/site_recovery_replication_recovery_plan#timeouts DataAzurermSiteRecoveryReplicationRecoveryPlan#timeouts}
    */
    readonly timeouts?: DataAzurermSiteRecoveryReplicationRecoveryPlanTimeouts;
}
export interface DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettings {
}
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsToTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettings): any;
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsToHclTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettings): any;
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettings | undefined;
    set internalValue(value: DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettings | undefined);
    get primaryEdgeZone(): string;
    get primaryZone(): string;
    get recoveryEdgeZone(): string;
    get recoveryZone(): string;
}
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsOutputReference;
}
export interface DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction {
}
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionToTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction): any;
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionToHclTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction): any;
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction | undefined;
    set internalValue(value: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostAction | undefined);
    get fabricLocation(): string;
    get failOverDirections(): string[];
    get failOverTypes(): string[];
    get manualActionInstruction(): string;
    get name(): string;
    get runbookId(): string;
    get scriptPath(): string;
    get type(): string;
}
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionListList extends cdktf.MapList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList;
}
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionOutputReference;
}
export interface DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction {
}
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionToTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction): any;
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionToHclTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction): any;
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction | undefined;
    set internalValue(value: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreAction | undefined);
    get fabricLocation(): string;
    get failOverDirections(): string[];
    get failOverTypes(): string[];
    get manualActionInstruction(): string;
    get name(): string;
    get runbookId(): string;
    get scriptPath(): string;
    get type(): string;
}
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionListList extends cdktf.MapList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList;
}
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionOutputReference;
}
export interface DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroup {
}
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupToTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroup): any;
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupToHclTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroup): any;
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroup | undefined;
    set internalValue(value: DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroup | undefined);
    private _postAction;
    get postAction(): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPostActionListList;
    private _preAction;
    get preAction(): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupPreActionListList;
    get replicatedProtectedItems(): string[];
    get type(): string;
}
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupOutputReference;
}
export interface DataAzurermSiteRecoveryReplicationRecoveryPlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/site_recovery_replication_recovery_plan#read DataAzurermSiteRecoveryReplicationRecoveryPlan#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanTimeoutsToTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSiteRecoveryReplicationRecoveryPlanTimeoutsToHclTerraform(struct?: DataAzurermSiteRecoveryReplicationRecoveryPlanTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSiteRecoveryReplicationRecoveryPlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSiteRecoveryReplicationRecoveryPlanTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/site_recovery_replication_recovery_plan azurerm_site_recovery_replication_recovery_plan}
*/
export declare class DataAzurermSiteRecoveryReplicationRecoveryPlan extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_site_recovery_replication_recovery_plan";
    /**
    * Generates CDKTF code for importing a DataAzurermSiteRecoveryReplicationRecoveryPlan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSiteRecoveryReplicationRecoveryPlan to import
    * @param importFromId The id of the existing DataAzurermSiteRecoveryReplicationRecoveryPlan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/site_recovery_replication_recovery_plan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSiteRecoveryReplicationRecoveryPlan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/site_recovery_replication_recovery_plan azurerm_site_recovery_replication_recovery_plan} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSiteRecoveryReplicationRecoveryPlanConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSiteRecoveryReplicationRecoveryPlanConfig);
    private _azureToAzureSettings;
    get azureToAzureSettings(): DataAzurermSiteRecoveryReplicationRecoveryPlanAzureToAzureSettingsList;
    get failoverDeploymentModel(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recoveryGroup;
    get recoveryGroup(): DataAzurermSiteRecoveryReplicationRecoveryPlanRecoveryGroupList;
    private _recoveryVaultId?;
    get recoveryVaultId(): string;
    set recoveryVaultId(value: string);
    get recoveryVaultIdInput(): string | undefined;
    get sourceRecoveryFabricId(): string;
    get targetRecoveryFabricId(): string;
    private _timeouts;
    get timeouts(): DataAzurermSiteRecoveryReplicationRecoveryPlanTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSiteRecoveryReplicationRecoveryPlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSiteRecoveryReplicationRecoveryPlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
