/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStackHciClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/stack_hci_cluster#id DataAzurermStackHciCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/stack_hci_cluster#name DataAzurermStackHciCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/stack_hci_cluster#resource_group_name DataAzurermStackHciCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/stack_hci_cluster#timeouts DataAzurermStackHciCluster#timeouts}
    */
    readonly timeouts?: DataAzurermStackHciClusterTimeouts;
}
export interface DataAzurermStackHciClusterIdentity {
}
export declare function dataAzurermStackHciClusterIdentityToTerraform(struct?: DataAzurermStackHciClusterIdentity): any;
export declare function dataAzurermStackHciClusterIdentityToHclTerraform(struct?: DataAzurermStackHciClusterIdentity): any;
export declare class DataAzurermStackHciClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStackHciClusterIdentity | undefined;
    set internalValue(value: DataAzurermStackHciClusterIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermStackHciClusterIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStackHciClusterIdentityOutputReference;
}
export interface DataAzurermStackHciClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/stack_hci_cluster#read DataAzurermStackHciCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStackHciClusterTimeoutsToTerraform(struct?: DataAzurermStackHciClusterTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStackHciClusterTimeoutsToHclTerraform(struct?: DataAzurermStackHciClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStackHciClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStackHciClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStackHciClusterTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/stack_hci_cluster azurerm_stack_hci_cluster}
*/
export declare class DataAzurermStackHciCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_stack_hci_cluster";
    /**
    * Generates CDKTF code for importing a DataAzurermStackHciCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStackHciCluster to import
    * @param importFromId The id of the existing DataAzurermStackHciCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/stack_hci_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStackHciCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/stack_hci_cluster azurerm_stack_hci_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStackHciClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStackHciClusterConfig);
    get automanageConfigurationId(): string;
    get clientId(): string;
    get cloudId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermStackHciClusterIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceProviderObjectId(): string;
    get serviceEndpoint(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurermStackHciClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStackHciClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStackHciClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
