/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageTableEntitiesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities#filter DataAzurermStorageTableEntities#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities#id DataAzurermStorageTableEntities#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities#select DataAzurermStorageTableEntities#select}
    */
    readonly select?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities#storage_table_id DataAzurermStorageTableEntities#storage_table_id}
    */
    readonly storageTableId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities#timeouts DataAzurermStorageTableEntities#timeouts}
    */
    readonly timeouts?: DataAzurermStorageTableEntitiesTimeouts;
}
export interface DataAzurermStorageTableEntitiesItems {
}
export declare function dataAzurermStorageTableEntitiesItemsToTerraform(struct?: DataAzurermStorageTableEntitiesItems): any;
export declare function dataAzurermStorageTableEntitiesItemsToHclTerraform(struct?: DataAzurermStorageTableEntitiesItems): any;
export declare class DataAzurermStorageTableEntitiesItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageTableEntitiesItems | undefined;
    set internalValue(value: DataAzurermStorageTableEntitiesItems | undefined);
    get partitionKey(): string;
    private _properties;
    get properties(): cdktf.StringMap;
    get rowKey(): string;
}
export declare class DataAzurermStorageTableEntitiesItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageTableEntitiesItemsOutputReference;
}
export interface DataAzurermStorageTableEntitiesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities#read DataAzurermStorageTableEntities#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageTableEntitiesTimeoutsToTerraform(struct?: DataAzurermStorageTableEntitiesTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStorageTableEntitiesTimeoutsToHclTerraform(struct?: DataAzurermStorageTableEntitiesTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageTableEntitiesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageTableEntitiesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStorageTableEntitiesTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities azurerm_storage_table_entities}
*/
export declare class DataAzurermStorageTableEntities extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_table_entities";
    /**
    * Generates CDKTF code for importing a DataAzurermStorageTableEntities resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStorageTableEntities to import
    * @param importFromId The id of the existing DataAzurermStorageTableEntities that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStorageTableEntities to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table_entities azurerm_storage_table_entities} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageTableEntitiesConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageTableEntitiesConfig);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _items;
    get items(): DataAzurermStorageTableEntitiesItemsList;
    private _select?;
    get select(): string[];
    set select(value: string[]);
    resetSelect(): void;
    get selectInput(): string[] | undefined;
    private _storageTableId?;
    get storageTableId(): string;
    set storageTableId(value: string);
    get storageTableIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageTableEntitiesTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageTableEntitiesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStorageTableEntitiesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
