/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table#name DataAzurermStorageTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table#storage_account_name DataAzurermStorageTable#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table#timeouts DataAzurermStorageTable#timeouts}
    */
    readonly timeouts?: DataAzurermStorageTableTimeouts;
}
export interface DataAzurermStorageTableAclAccessPolicy {
}
export declare function dataAzurermStorageTableAclAccessPolicyToTerraform(struct?: DataAzurermStorageTableAclAccessPolicy): any;
export declare function dataAzurermStorageTableAclAccessPolicyToHclTerraform(struct?: DataAzurermStorageTableAclAccessPolicy): any;
export declare class DataAzurermStorageTableAclAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageTableAclAccessPolicy | undefined;
    set internalValue(value: DataAzurermStorageTableAclAccessPolicy | undefined);
    get expiry(): string;
    get permissions(): string;
    get start(): string;
}
export declare class DataAzurermStorageTableAclAccessPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageTableAclAccessPolicyOutputReference;
}
export interface DataAzurermStorageTableAcl {
}
export declare function dataAzurermStorageTableAclToTerraform(struct?: DataAzurermStorageTableAcl): any;
export declare function dataAzurermStorageTableAclToHclTerraform(struct?: DataAzurermStorageTableAcl): any;
export declare class DataAzurermStorageTableAclOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageTableAcl | undefined;
    set internalValue(value: DataAzurermStorageTableAcl | undefined);
    private _accessPolicy;
    get accessPolicy(): DataAzurermStorageTableAclAccessPolicyList;
    get id(): string;
}
export declare class DataAzurermStorageTableAclList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageTableAclOutputReference;
}
export interface DataAzurermStorageTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table#read DataAzurermStorageTable#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageTableTimeoutsToTerraform(struct?: DataAzurermStorageTableTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStorageTableTimeoutsToHclTerraform(struct?: DataAzurermStorageTableTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageTableTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStorageTableTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table azurerm_storage_table}
*/
export declare class DataAzurermStorageTable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_table";
    /**
    * Generates CDKTF code for importing a DataAzurermStorageTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStorageTable to import
    * @param importFromId The id of the existing DataAzurermStorageTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStorageTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/data-sources/storage_table azurerm_storage_table} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageTableConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageTableConfig);
    private _acl;
    get acl(): DataAzurermStorageTableAclList;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get resourceManagerId(): string;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageTableTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStorageTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
