/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataProtectionBackupPolicyBlobStorageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#backup_repeating_time_intervals DataProtectionBackupPolicyBlobStorage#backup_repeating_time_intervals}
    */
    readonly backupRepeatingTimeIntervals?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#id DataProtectionBackupPolicyBlobStorage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#name DataProtectionBackupPolicyBlobStorage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#operational_default_retention_duration DataProtectionBackupPolicyBlobStorage#operational_default_retention_duration}
    */
    readonly operationalDefaultRetentionDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#time_zone DataProtectionBackupPolicyBlobStorage#time_zone}
    */
    readonly timeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#vault_default_retention_duration DataProtectionBackupPolicyBlobStorage#vault_default_retention_duration}
    */
    readonly vaultDefaultRetentionDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#vault_id DataProtectionBackupPolicyBlobStorage#vault_id}
    */
    readonly vaultId: string;
    /**
    * retention_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#retention_rule DataProtectionBackupPolicyBlobStorage#retention_rule}
    */
    readonly retentionRule?: DataProtectionBackupPolicyBlobStorageRetentionRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#timeouts DataProtectionBackupPolicyBlobStorage#timeouts}
    */
    readonly timeouts?: DataProtectionBackupPolicyBlobStorageTimeouts;
}
export interface DataProtectionBackupPolicyBlobStorageRetentionRuleCriteria {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#absolute_criteria DataProtectionBackupPolicyBlobStorage#absolute_criteria}
    */
    readonly absoluteCriteria?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#days_of_month DataProtectionBackupPolicyBlobStorage#days_of_month}
    */
    readonly daysOfMonth?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#days_of_week DataProtectionBackupPolicyBlobStorage#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#months_of_year DataProtectionBackupPolicyBlobStorage#months_of_year}
    */
    readonly monthsOfYear?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#scheduled_backup_times DataProtectionBackupPolicyBlobStorage#scheduled_backup_times}
    */
    readonly scheduledBackupTimes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#weeks_of_month DataProtectionBackupPolicyBlobStorage#weeks_of_month}
    */
    readonly weeksOfMonth?: string[];
}
export declare function dataProtectionBackupPolicyBlobStorageRetentionRuleCriteriaToTerraform(struct?: DataProtectionBackupPolicyBlobStorageRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyBlobStorageRetentionRuleCriteria): any;
export declare function dataProtectionBackupPolicyBlobStorageRetentionRuleCriteriaToHclTerraform(struct?: DataProtectionBackupPolicyBlobStorageRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyBlobStorageRetentionRuleCriteria): any;
export declare class DataProtectionBackupPolicyBlobStorageRetentionRuleCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyBlobStorageRetentionRuleCriteria | undefined;
    set internalValue(value: DataProtectionBackupPolicyBlobStorageRetentionRuleCriteria | undefined);
    private _absoluteCriteria?;
    get absoluteCriteria(): string;
    set absoluteCriteria(value: string);
    resetAbsoluteCriteria(): void;
    get absoluteCriteriaInput(): string | undefined;
    private _daysOfMonth?;
    get daysOfMonth(): number[];
    set daysOfMonth(value: number[]);
    resetDaysOfMonth(): void;
    get daysOfMonthInput(): number[] | undefined;
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _monthsOfYear?;
    get monthsOfYear(): string[];
    set monthsOfYear(value: string[]);
    resetMonthsOfYear(): void;
    get monthsOfYearInput(): string[] | undefined;
    private _scheduledBackupTimes?;
    get scheduledBackupTimes(): string[];
    set scheduledBackupTimes(value: string[]);
    resetScheduledBackupTimes(): void;
    get scheduledBackupTimesInput(): string[] | undefined;
    private _weeksOfMonth?;
    get weeksOfMonth(): string[];
    set weeksOfMonth(value: string[]);
    resetWeeksOfMonth(): void;
    get weeksOfMonthInput(): string[] | undefined;
}
export interface DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#data_store_type DataProtectionBackupPolicyBlobStorage#data_store_type}
    */
    readonly dataStoreType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#duration DataProtectionBackupPolicyBlobStorage#duration}
    */
    readonly duration: string;
}
export declare function dataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycleToTerraform(struct?: DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycleOutputReference | DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycle): any;
export declare function dataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycleToHclTerraform(struct?: DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycleOutputReference | DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycle): any;
export declare class DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycle | undefined;
    set internalValue(value: DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycle | undefined);
    private _dataStoreType?;
    get dataStoreType(): string;
    set dataStoreType(value: string);
    get dataStoreTypeInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
}
export interface DataProtectionBackupPolicyBlobStorageRetentionRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#name DataProtectionBackupPolicyBlobStorage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#priority DataProtectionBackupPolicyBlobStorage#priority}
    */
    readonly priority: number;
    /**
    * criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#criteria DataProtectionBackupPolicyBlobStorage#criteria}
    */
    readonly criteria: DataProtectionBackupPolicyBlobStorageRetentionRuleCriteria;
    /**
    * life_cycle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#life_cycle DataProtectionBackupPolicyBlobStorage#life_cycle}
    */
    readonly lifeCycle: DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycle;
}
export declare function dataProtectionBackupPolicyBlobStorageRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyBlobStorageRetentionRule | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyBlobStorageRetentionRuleToHclTerraform(struct?: DataProtectionBackupPolicyBlobStorageRetentionRule | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyBlobStorageRetentionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyBlobStorageRetentionRule | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyBlobStorageRetentionRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _criteria;
    get criteria(): DataProtectionBackupPolicyBlobStorageRetentionRuleCriteriaOutputReference;
    putCriteria(value: DataProtectionBackupPolicyBlobStorageRetentionRuleCriteria): void;
    get criteriaInput(): DataProtectionBackupPolicyBlobStorageRetentionRuleCriteria | undefined;
    private _lifeCycle;
    get lifeCycle(): DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycleOutputReference;
    putLifeCycle(value: DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycle): void;
    get lifeCycleInput(): DataProtectionBackupPolicyBlobStorageRetentionRuleLifeCycle | undefined;
}
export declare class DataProtectionBackupPolicyBlobStorageRetentionRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyBlobStorageRetentionRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyBlobStorageRetentionRuleOutputReference;
}
export interface DataProtectionBackupPolicyBlobStorageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#create DataProtectionBackupPolicyBlobStorage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#delete DataProtectionBackupPolicyBlobStorage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#read DataProtectionBackupPolicyBlobStorage#read}
    */
    readonly read?: string;
}
export declare function dataProtectionBackupPolicyBlobStorageTimeoutsToTerraform(struct?: DataProtectionBackupPolicyBlobStorageTimeouts | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyBlobStorageTimeoutsToHclTerraform(struct?: DataProtectionBackupPolicyBlobStorageTimeouts | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyBlobStorageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyBlobStorageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyBlobStorageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage azurerm_data_protection_backup_policy_blob_storage}
*/
export declare class DataProtectionBackupPolicyBlobStorage extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_protection_backup_policy_blob_storage";
    /**
    * Generates CDKTF code for importing a DataProtectionBackupPolicyBlobStorage resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataProtectionBackupPolicyBlobStorage to import
    * @param importFromId The id of the existing DataProtectionBackupPolicyBlobStorage that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataProtectionBackupPolicyBlobStorage to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_protection_backup_policy_blob_storage azurerm_data_protection_backup_policy_blob_storage} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataProtectionBackupPolicyBlobStorageConfig
    */
    constructor(scope: Construct, id: string, config: DataProtectionBackupPolicyBlobStorageConfig);
    private _backupRepeatingTimeIntervals?;
    get backupRepeatingTimeIntervals(): string[];
    set backupRepeatingTimeIntervals(value: string[]);
    resetBackupRepeatingTimeIntervals(): void;
    get backupRepeatingTimeIntervalsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operationalDefaultRetentionDuration?;
    get operationalDefaultRetentionDuration(): string;
    set operationalDefaultRetentionDuration(value: string);
    resetOperationalDefaultRetentionDuration(): void;
    get operationalDefaultRetentionDurationInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _vaultDefaultRetentionDuration?;
    get vaultDefaultRetentionDuration(): string;
    set vaultDefaultRetentionDuration(value: string);
    resetVaultDefaultRetentionDuration(): void;
    get vaultDefaultRetentionDurationInput(): string | undefined;
    private _vaultId?;
    get vaultId(): string;
    set vaultId(value: string);
    get vaultIdInput(): string | undefined;
    private _retentionRule;
    get retentionRule(): DataProtectionBackupPolicyBlobStorageRetentionRuleList;
    putRetentionRule(value: DataProtectionBackupPolicyBlobStorageRetentionRule[] | cdktf.IResolvable): void;
    resetRetentionRule(): void;
    get retentionRuleInput(): cdktf.IResolvable | DataProtectionBackupPolicyBlobStorageRetentionRule[] | undefined;
    private _timeouts;
    get timeouts(): DataProtectionBackupPolicyBlobStorageTimeoutsOutputReference;
    putTimeouts(value: DataProtectionBackupPolicyBlobStorageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataProtectionBackupPolicyBlobStorageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
