/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataShareDatasetKustoDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#id DataShareDatasetKustoDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#kusto_database_id DataShareDatasetKustoDatabase#kusto_database_id}
    */
    readonly kustoDatabaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#name DataShareDatasetKustoDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#share_id DataShareDatasetKustoDatabase#share_id}
    */
    readonly shareId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#timeouts DataShareDatasetKustoDatabase#timeouts}
    */
    readonly timeouts?: DataShareDatasetKustoDatabaseTimeouts;
}
export interface DataShareDatasetKustoDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#create DataShareDatasetKustoDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#delete DataShareDatasetKustoDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#read DataShareDatasetKustoDatabase#read}
    */
    readonly read?: string;
}
export declare function dataShareDatasetKustoDatabaseTimeoutsToTerraform(struct?: DataShareDatasetKustoDatabaseTimeouts | cdktf.IResolvable): any;
export declare function dataShareDatasetKustoDatabaseTimeoutsToHclTerraform(struct?: DataShareDatasetKustoDatabaseTimeouts | cdktf.IResolvable): any;
export declare class DataShareDatasetKustoDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataShareDatasetKustoDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataShareDatasetKustoDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database azurerm_data_share_dataset_kusto_database}
*/
export declare class DataShareDatasetKustoDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_share_dataset_kusto_database";
    /**
    * Generates CDKTF code for importing a DataShareDatasetKustoDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataShareDatasetKustoDatabase to import
    * @param importFromId The id of the existing DataShareDatasetKustoDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataShareDatasetKustoDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/data_share_dataset_kusto_database azurerm_data_share_dataset_kusto_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataShareDatasetKustoDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: DataShareDatasetKustoDatabaseConfig);
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kustoClusterLocation(): string;
    private _kustoDatabaseId?;
    get kustoDatabaseId(): string;
    set kustoDatabaseId(value: string);
    get kustoDatabaseIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareId?;
    get shareId(): string;
    set shareId(value: string);
    get shareIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataShareDatasetKustoDatabaseTimeoutsOutputReference;
    putTimeouts(value: DataShareDatasetKustoDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataShareDatasetKustoDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
