/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DedicatedHardwareSecurityModuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#id DedicatedHardwareSecurityModule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#location DedicatedHardwareSecurityModule#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#name DedicatedHardwareSecurityModule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#resource_group_name DedicatedHardwareSecurityModule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#sku_name DedicatedHardwareSecurityModule#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#stamp_id DedicatedHardwareSecurityModule#stamp_id}
    */
    readonly stampId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#tags DedicatedHardwareSecurityModule#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#zones DedicatedHardwareSecurityModule#zones}
    */
    readonly zones?: string[];
    /**
    * management_network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#management_network_profile DedicatedHardwareSecurityModule#management_network_profile}
    */
    readonly managementNetworkProfile?: DedicatedHardwareSecurityModuleManagementNetworkProfile;
    /**
    * network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#network_profile DedicatedHardwareSecurityModule#network_profile}
    */
    readonly networkProfile: DedicatedHardwareSecurityModuleNetworkProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#timeouts DedicatedHardwareSecurityModule#timeouts}
    */
    readonly timeouts?: DedicatedHardwareSecurityModuleTimeouts;
}
export interface DedicatedHardwareSecurityModuleManagementNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#network_interface_private_ip_addresses DedicatedHardwareSecurityModule#network_interface_private_ip_addresses}
    */
    readonly networkInterfacePrivateIpAddresses: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#subnet_id DedicatedHardwareSecurityModule#subnet_id}
    */
    readonly subnetId: string;
}
export declare function dedicatedHardwareSecurityModuleManagementNetworkProfileToTerraform(struct?: DedicatedHardwareSecurityModuleManagementNetworkProfileOutputReference | DedicatedHardwareSecurityModuleManagementNetworkProfile): any;
export declare function dedicatedHardwareSecurityModuleManagementNetworkProfileToHclTerraform(struct?: DedicatedHardwareSecurityModuleManagementNetworkProfileOutputReference | DedicatedHardwareSecurityModuleManagementNetworkProfile): any;
export declare class DedicatedHardwareSecurityModuleManagementNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DedicatedHardwareSecurityModuleManagementNetworkProfile | undefined;
    set internalValue(value: DedicatedHardwareSecurityModuleManagementNetworkProfile | undefined);
    private _networkInterfacePrivateIpAddresses?;
    get networkInterfacePrivateIpAddresses(): string[];
    set networkInterfacePrivateIpAddresses(value: string[]);
    get networkInterfacePrivateIpAddressesInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface DedicatedHardwareSecurityModuleNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#network_interface_private_ip_addresses DedicatedHardwareSecurityModule#network_interface_private_ip_addresses}
    */
    readonly networkInterfacePrivateIpAddresses: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#subnet_id DedicatedHardwareSecurityModule#subnet_id}
    */
    readonly subnetId: string;
}
export declare function dedicatedHardwareSecurityModuleNetworkProfileToTerraform(struct?: DedicatedHardwareSecurityModuleNetworkProfileOutputReference | DedicatedHardwareSecurityModuleNetworkProfile): any;
export declare function dedicatedHardwareSecurityModuleNetworkProfileToHclTerraform(struct?: DedicatedHardwareSecurityModuleNetworkProfileOutputReference | DedicatedHardwareSecurityModuleNetworkProfile): any;
export declare class DedicatedHardwareSecurityModuleNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DedicatedHardwareSecurityModuleNetworkProfile | undefined;
    set internalValue(value: DedicatedHardwareSecurityModuleNetworkProfile | undefined);
    private _networkInterfacePrivateIpAddresses?;
    get networkInterfacePrivateIpAddresses(): string[];
    set networkInterfacePrivateIpAddresses(value: string[]);
    get networkInterfacePrivateIpAddressesInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface DedicatedHardwareSecurityModuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#create DedicatedHardwareSecurityModule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#delete DedicatedHardwareSecurityModule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#read DedicatedHardwareSecurityModule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#update DedicatedHardwareSecurityModule#update}
    */
    readonly update?: string;
}
export declare function dedicatedHardwareSecurityModuleTimeoutsToTerraform(struct?: DedicatedHardwareSecurityModuleTimeouts | cdktf.IResolvable): any;
export declare function dedicatedHardwareSecurityModuleTimeoutsToHclTerraform(struct?: DedicatedHardwareSecurityModuleTimeouts | cdktf.IResolvable): any;
export declare class DedicatedHardwareSecurityModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DedicatedHardwareSecurityModuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DedicatedHardwareSecurityModuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module azurerm_dedicated_hardware_security_module}
*/
export declare class DedicatedHardwareSecurityModule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dedicated_hardware_security_module";
    /**
    * Generates CDKTF code for importing a DedicatedHardwareSecurityModule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DedicatedHardwareSecurityModule to import
    * @param importFromId The id of the existing DedicatedHardwareSecurityModule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DedicatedHardwareSecurityModule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/dedicated_hardware_security_module azurerm_dedicated_hardware_security_module} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DedicatedHardwareSecurityModuleConfig
    */
    constructor(scope: Construct, id: string, config: DedicatedHardwareSecurityModuleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _stampId?;
    get stampId(): string;
    set stampId(value: string);
    resetStampId(): void;
    get stampIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _managementNetworkProfile;
    get managementNetworkProfile(): DedicatedHardwareSecurityModuleManagementNetworkProfileOutputReference;
    putManagementNetworkProfile(value: DedicatedHardwareSecurityModuleManagementNetworkProfile): void;
    resetManagementNetworkProfile(): void;
    get managementNetworkProfileInput(): DedicatedHardwareSecurityModuleManagementNetworkProfile | undefined;
    private _networkProfile;
    get networkProfile(): DedicatedHardwareSecurityModuleNetworkProfileOutputReference;
    putNetworkProfile(value: DedicatedHardwareSecurityModuleNetworkProfile): void;
    get networkProfileInput(): DedicatedHardwareSecurityModuleNetworkProfile | undefined;
    private _timeouts;
    get timeouts(): DedicatedHardwareSecurityModuleTimeoutsOutputReference;
    putTimeouts(value: DedicatedHardwareSecurityModuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DedicatedHardwareSecurityModuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
