/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FrontdoorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#friendly_name Frontdoor#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#id Frontdoor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#load_balancer_enabled Frontdoor#load_balancer_enabled}
    */
    readonly loadBalancerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#resource_group_name Frontdoor#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#tags Frontdoor#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * backend_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#backend_pool Frontdoor#backend_pool}
    */
    readonly backendPool: FrontdoorBackendPool[] | cdktf.IResolvable;
    /**
    * backend_pool_health_probe block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#backend_pool_health_probe Frontdoor#backend_pool_health_probe}
    */
    readonly backendPoolHealthProbe: FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable;
    /**
    * backend_pool_load_balancing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#backend_pool_load_balancing Frontdoor#backend_pool_load_balancing}
    */
    readonly backendPoolLoadBalancing: FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable;
    /**
    * backend_pool_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#backend_pool_settings Frontdoor#backend_pool_settings}
    */
    readonly backendPoolSettings?: FrontdoorBackendPoolSettings[] | cdktf.IResolvable;
    /**
    * frontend_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#frontend_endpoint Frontdoor#frontend_endpoint}
    */
    readonly frontendEndpoint: FrontdoorFrontendEndpoint[] | cdktf.IResolvable;
    /**
    * routing_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#routing_rule Frontdoor#routing_rule}
    */
    readonly routingRule: FrontdoorRoutingRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#timeouts Frontdoor#timeouts}
    */
    readonly timeouts?: FrontdoorTimeouts;
}
export interface FrontdoorExplicitResourceOrder {
}
export declare function frontdoorExplicitResourceOrderToTerraform(struct?: FrontdoorExplicitResourceOrder): any;
export declare function frontdoorExplicitResourceOrderToHclTerraform(struct?: FrontdoorExplicitResourceOrder): any;
export declare class FrontdoorExplicitResourceOrderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorExplicitResourceOrder | undefined;
    set internalValue(value: FrontdoorExplicitResourceOrder | undefined);
    get backendPoolHealthProbeIds(): string[];
    get backendPoolIds(): string[];
    get backendPoolLoadBalancingIds(): string[];
    get frontendEndpointIds(): string[];
    get routingRuleIds(): string[];
}
export declare class FrontdoorExplicitResourceOrderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorExplicitResourceOrderOutputReference;
}
export interface FrontdoorBackendPoolBackend {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#address Frontdoor#address}
    */
    readonly address: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#enabled Frontdoor#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#host_header Frontdoor#host_header}
    */
    readonly hostHeader: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#http_port Frontdoor#http_port}
    */
    readonly httpPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#https_port Frontdoor#https_port}
    */
    readonly httpsPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#priority Frontdoor#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#weight Frontdoor#weight}
    */
    readonly weight?: number;
}
export declare function frontdoorBackendPoolBackendToTerraform(struct?: FrontdoorBackendPoolBackend | cdktf.IResolvable): any;
export declare function frontdoorBackendPoolBackendToHclTerraform(struct?: FrontdoorBackendPoolBackend | cdktf.IResolvable): any;
export declare class FrontdoorBackendPoolBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorBackendPoolBackend | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorBackendPoolBackend | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    get addressInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostHeader?;
    get hostHeader(): string;
    set hostHeader(value: string);
    get hostHeaderInput(): string | undefined;
    private _httpPort?;
    get httpPort(): number;
    set httpPort(value: number);
    get httpPortInput(): number | undefined;
    private _httpsPort?;
    get httpsPort(): number;
    set httpsPort(value: number);
    get httpsPortInput(): number | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
}
export declare class FrontdoorBackendPoolBackendList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorBackendPoolBackend[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorBackendPoolBackendOutputReference;
}
export interface FrontdoorBackendPool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#health_probe_name Frontdoor#health_probe_name}
    */
    readonly healthProbeName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#load_balancing_name Frontdoor#load_balancing_name}
    */
    readonly loadBalancingName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * backend block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#backend Frontdoor#backend}
    */
    readonly backend: FrontdoorBackendPoolBackend[] | cdktf.IResolvable;
}
export declare function frontdoorBackendPoolToTerraform(struct?: FrontdoorBackendPool | cdktf.IResolvable): any;
export declare function frontdoorBackendPoolToHclTerraform(struct?: FrontdoorBackendPool | cdktf.IResolvable): any;
export declare class FrontdoorBackendPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorBackendPool | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorBackendPool | cdktf.IResolvable | undefined);
    private _healthProbeName?;
    get healthProbeName(): string;
    set healthProbeName(value: string);
    get healthProbeNameInput(): string | undefined;
    get id(): string;
    private _loadBalancingName?;
    get loadBalancingName(): string;
    set loadBalancingName(value: string);
    get loadBalancingNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _backend;
    get backend(): FrontdoorBackendPoolBackendList;
    putBackend(value: FrontdoorBackendPoolBackend[] | cdktf.IResolvable): void;
    get backendInput(): cdktf.IResolvable | FrontdoorBackendPoolBackend[] | undefined;
}
export declare class FrontdoorBackendPoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorBackendPool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorBackendPoolOutputReference;
}
export interface FrontdoorBackendPoolHealthProbe {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#enabled Frontdoor#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#interval_in_seconds Frontdoor#interval_in_seconds}
    */
    readonly intervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#path Frontdoor#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#probe_method Frontdoor#probe_method}
    */
    readonly probeMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#protocol Frontdoor#protocol}
    */
    readonly protocol?: string;
}
export declare function frontdoorBackendPoolHealthProbeToTerraform(struct?: FrontdoorBackendPoolHealthProbe | cdktf.IResolvable): any;
export declare function frontdoorBackendPoolHealthProbeToHclTerraform(struct?: FrontdoorBackendPoolHealthProbe | cdktf.IResolvable): any;
export declare class FrontdoorBackendPoolHealthProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorBackendPoolHealthProbe | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorBackendPoolHealthProbe | cdktf.IResolvable | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _intervalInSeconds?;
    get intervalInSeconds(): number;
    set intervalInSeconds(value: number);
    resetIntervalInSeconds(): void;
    get intervalInSecondsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _probeMethod?;
    get probeMethod(): string;
    set probeMethod(value: string);
    resetProbeMethod(): void;
    get probeMethodInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class FrontdoorBackendPoolHealthProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorBackendPoolHealthProbeOutputReference;
}
export interface FrontdoorBackendPoolLoadBalancing {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#additional_latency_milliseconds Frontdoor#additional_latency_milliseconds}
    */
    readonly additionalLatencyMilliseconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#sample_size Frontdoor#sample_size}
    */
    readonly sampleSize?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#successful_samples_required Frontdoor#successful_samples_required}
    */
    readonly successfulSamplesRequired?: number;
}
export declare function frontdoorBackendPoolLoadBalancingToTerraform(struct?: FrontdoorBackendPoolLoadBalancing | cdktf.IResolvable): any;
export declare function frontdoorBackendPoolLoadBalancingToHclTerraform(struct?: FrontdoorBackendPoolLoadBalancing | cdktf.IResolvable): any;
export declare class FrontdoorBackendPoolLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorBackendPoolLoadBalancing | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorBackendPoolLoadBalancing | cdktf.IResolvable | undefined);
    private _additionalLatencyMilliseconds?;
    get additionalLatencyMilliseconds(): number;
    set additionalLatencyMilliseconds(value: number);
    resetAdditionalLatencyMilliseconds(): void;
    get additionalLatencyMillisecondsInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sampleSize?;
    get sampleSize(): number;
    set sampleSize(value: number);
    resetSampleSize(): void;
    get sampleSizeInput(): number | undefined;
    private _successfulSamplesRequired?;
    get successfulSamplesRequired(): number;
    set successfulSamplesRequired(value: number);
    resetSuccessfulSamplesRequired(): void;
    get successfulSamplesRequiredInput(): number | undefined;
}
export declare class FrontdoorBackendPoolLoadBalancingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorBackendPoolLoadBalancingOutputReference;
}
export interface FrontdoorBackendPoolSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#backend_pools_send_receive_timeout_seconds Frontdoor#backend_pools_send_receive_timeout_seconds}
    */
    readonly backendPoolsSendReceiveTimeoutSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#enforce_backend_pools_certificate_name_check Frontdoor#enforce_backend_pools_certificate_name_check}
    */
    readonly enforceBackendPoolsCertificateNameCheck: boolean | cdktf.IResolvable;
}
export declare function frontdoorBackendPoolSettingsToTerraform(struct?: FrontdoorBackendPoolSettings | cdktf.IResolvable): any;
export declare function frontdoorBackendPoolSettingsToHclTerraform(struct?: FrontdoorBackendPoolSettings | cdktf.IResolvable): any;
export declare class FrontdoorBackendPoolSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorBackendPoolSettings | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorBackendPoolSettings | cdktf.IResolvable | undefined);
    private _backendPoolsSendReceiveTimeoutSeconds?;
    get backendPoolsSendReceiveTimeoutSeconds(): number;
    set backendPoolsSendReceiveTimeoutSeconds(value: number);
    resetBackendPoolsSendReceiveTimeoutSeconds(): void;
    get backendPoolsSendReceiveTimeoutSecondsInput(): number | undefined;
    private _enforceBackendPoolsCertificateNameCheck?;
    get enforceBackendPoolsCertificateNameCheck(): boolean | cdktf.IResolvable;
    set enforceBackendPoolsCertificateNameCheck(value: boolean | cdktf.IResolvable);
    get enforceBackendPoolsCertificateNameCheckInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class FrontdoorBackendPoolSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorBackendPoolSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorBackendPoolSettingsOutputReference;
}
export interface FrontdoorFrontendEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#host_name Frontdoor#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#session_affinity_enabled Frontdoor#session_affinity_enabled}
    */
    readonly sessionAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#session_affinity_ttl_seconds Frontdoor#session_affinity_ttl_seconds}
    */
    readonly sessionAffinityTtlSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#web_application_firewall_policy_link_id Frontdoor#web_application_firewall_policy_link_id}
    */
    readonly webApplicationFirewallPolicyLinkId?: string;
}
export declare function frontdoorFrontendEndpointToTerraform(struct?: FrontdoorFrontendEndpoint | cdktf.IResolvable): any;
export declare function frontdoorFrontendEndpointToHclTerraform(struct?: FrontdoorFrontendEndpoint | cdktf.IResolvable): any;
export declare class FrontdoorFrontendEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorFrontendEndpoint | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorFrontendEndpoint | cdktf.IResolvable | undefined);
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sessionAffinityEnabled?;
    get sessionAffinityEnabled(): boolean | cdktf.IResolvable;
    set sessionAffinityEnabled(value: boolean | cdktf.IResolvable);
    resetSessionAffinityEnabled(): void;
    get sessionAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sessionAffinityTtlSeconds?;
    get sessionAffinityTtlSeconds(): number;
    set sessionAffinityTtlSeconds(value: number);
    resetSessionAffinityTtlSeconds(): void;
    get sessionAffinityTtlSecondsInput(): number | undefined;
    private _webApplicationFirewallPolicyLinkId?;
    get webApplicationFirewallPolicyLinkId(): string;
    set webApplicationFirewallPolicyLinkId(value: string);
    resetWebApplicationFirewallPolicyLinkId(): void;
    get webApplicationFirewallPolicyLinkIdInput(): string | undefined;
}
export declare class FrontdoorFrontendEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorFrontendEndpoint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorFrontendEndpointOutputReference;
}
export interface FrontdoorRoutingRuleForwardingConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#backend_pool_name Frontdoor#backend_pool_name}
    */
    readonly backendPoolName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#cache_duration Frontdoor#cache_duration}
    */
    readonly cacheDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#cache_enabled Frontdoor#cache_enabled}
    */
    readonly cacheEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#cache_query_parameter_strip_directive Frontdoor#cache_query_parameter_strip_directive}
    */
    readonly cacheQueryParameterStripDirective?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#cache_query_parameters Frontdoor#cache_query_parameters}
    */
    readonly cacheQueryParameters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#cache_use_dynamic_compression Frontdoor#cache_use_dynamic_compression}
    */
    readonly cacheUseDynamicCompression?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#custom_forwarding_path Frontdoor#custom_forwarding_path}
    */
    readonly customForwardingPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#forwarding_protocol Frontdoor#forwarding_protocol}
    */
    readonly forwardingProtocol?: string;
}
export declare function frontdoorRoutingRuleForwardingConfigurationToTerraform(struct?: FrontdoorRoutingRuleForwardingConfigurationOutputReference | FrontdoorRoutingRuleForwardingConfiguration): any;
export declare function frontdoorRoutingRuleForwardingConfigurationToHclTerraform(struct?: FrontdoorRoutingRuleForwardingConfigurationOutputReference | FrontdoorRoutingRuleForwardingConfiguration): any;
export declare class FrontdoorRoutingRuleForwardingConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorRoutingRuleForwardingConfiguration | undefined;
    set internalValue(value: FrontdoorRoutingRuleForwardingConfiguration | undefined);
    private _backendPoolName?;
    get backendPoolName(): string;
    set backendPoolName(value: string);
    get backendPoolNameInput(): string | undefined;
    private _cacheDuration?;
    get cacheDuration(): string;
    set cacheDuration(value: string);
    resetCacheDuration(): void;
    get cacheDurationInput(): string | undefined;
    private _cacheEnabled?;
    get cacheEnabled(): boolean | cdktf.IResolvable;
    set cacheEnabled(value: boolean | cdktf.IResolvable);
    resetCacheEnabled(): void;
    get cacheEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cacheQueryParameterStripDirective?;
    get cacheQueryParameterStripDirective(): string;
    set cacheQueryParameterStripDirective(value: string);
    resetCacheQueryParameterStripDirective(): void;
    get cacheQueryParameterStripDirectiveInput(): string | undefined;
    private _cacheQueryParameters?;
    get cacheQueryParameters(): string[];
    set cacheQueryParameters(value: string[]);
    resetCacheQueryParameters(): void;
    get cacheQueryParametersInput(): string[] | undefined;
    private _cacheUseDynamicCompression?;
    get cacheUseDynamicCompression(): boolean | cdktf.IResolvable;
    set cacheUseDynamicCompression(value: boolean | cdktf.IResolvable);
    resetCacheUseDynamicCompression(): void;
    get cacheUseDynamicCompressionInput(): boolean | cdktf.IResolvable | undefined;
    private _customForwardingPath?;
    get customForwardingPath(): string;
    set customForwardingPath(value: string);
    resetCustomForwardingPath(): void;
    get customForwardingPathInput(): string | undefined;
    private _forwardingProtocol?;
    get forwardingProtocol(): string;
    set forwardingProtocol(value: string);
    resetForwardingProtocol(): void;
    get forwardingProtocolInput(): string | undefined;
}
export interface FrontdoorRoutingRuleRedirectConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#custom_fragment Frontdoor#custom_fragment}
    */
    readonly customFragment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#custom_host Frontdoor#custom_host}
    */
    readonly customHost?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#custom_path Frontdoor#custom_path}
    */
    readonly customPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#custom_query_string Frontdoor#custom_query_string}
    */
    readonly customQueryString?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#redirect_protocol Frontdoor#redirect_protocol}
    */
    readonly redirectProtocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#redirect_type Frontdoor#redirect_type}
    */
    readonly redirectType: string;
}
export declare function frontdoorRoutingRuleRedirectConfigurationToTerraform(struct?: FrontdoorRoutingRuleRedirectConfigurationOutputReference | FrontdoorRoutingRuleRedirectConfiguration): any;
export declare function frontdoorRoutingRuleRedirectConfigurationToHclTerraform(struct?: FrontdoorRoutingRuleRedirectConfigurationOutputReference | FrontdoorRoutingRuleRedirectConfiguration): any;
export declare class FrontdoorRoutingRuleRedirectConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorRoutingRuleRedirectConfiguration | undefined;
    set internalValue(value: FrontdoorRoutingRuleRedirectConfiguration | undefined);
    private _customFragment?;
    get customFragment(): string;
    set customFragment(value: string);
    resetCustomFragment(): void;
    get customFragmentInput(): string | undefined;
    private _customHost?;
    get customHost(): string;
    set customHost(value: string);
    resetCustomHost(): void;
    get customHostInput(): string | undefined;
    private _customPath?;
    get customPath(): string;
    set customPath(value: string);
    resetCustomPath(): void;
    get customPathInput(): string | undefined;
    private _customQueryString?;
    get customQueryString(): string;
    set customQueryString(value: string);
    resetCustomQueryString(): void;
    get customQueryStringInput(): string | undefined;
    private _redirectProtocol?;
    get redirectProtocol(): string;
    set redirectProtocol(value: string);
    get redirectProtocolInput(): string | undefined;
    private _redirectType?;
    get redirectType(): string;
    set redirectType(value: string);
    get redirectTypeInput(): string | undefined;
}
export interface FrontdoorRoutingRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#accepted_protocols Frontdoor#accepted_protocols}
    */
    readonly acceptedProtocols: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#enabled Frontdoor#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#frontend_endpoints Frontdoor#frontend_endpoints}
    */
    readonly frontendEndpoints: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#name Frontdoor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#patterns_to_match Frontdoor#patterns_to_match}
    */
    readonly patternsToMatch: string[];
    /**
    * forwarding_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#forwarding_configuration Frontdoor#forwarding_configuration}
    */
    readonly forwardingConfiguration?: FrontdoorRoutingRuleForwardingConfiguration;
    /**
    * redirect_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#redirect_configuration Frontdoor#redirect_configuration}
    */
    readonly redirectConfiguration?: FrontdoorRoutingRuleRedirectConfiguration;
}
export declare function frontdoorRoutingRuleToTerraform(struct?: FrontdoorRoutingRule | cdktf.IResolvable): any;
export declare function frontdoorRoutingRuleToHclTerraform(struct?: FrontdoorRoutingRule | cdktf.IResolvable): any;
export declare class FrontdoorRoutingRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FrontdoorRoutingRule | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorRoutingRule | cdktf.IResolvable | undefined);
    private _acceptedProtocols?;
    get acceptedProtocols(): string[];
    set acceptedProtocols(value: string[]);
    get acceptedProtocolsInput(): string[] | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frontendEndpoints?;
    get frontendEndpoints(): string[];
    set frontendEndpoints(value: string[]);
    get frontendEndpointsInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _patternsToMatch?;
    get patternsToMatch(): string[];
    set patternsToMatch(value: string[]);
    get patternsToMatchInput(): string[] | undefined;
    private _forwardingConfiguration;
    get forwardingConfiguration(): FrontdoorRoutingRuleForwardingConfigurationOutputReference;
    putForwardingConfiguration(value: FrontdoorRoutingRuleForwardingConfiguration): void;
    resetForwardingConfiguration(): void;
    get forwardingConfigurationInput(): FrontdoorRoutingRuleForwardingConfiguration | undefined;
    private _redirectConfiguration;
    get redirectConfiguration(): FrontdoorRoutingRuleRedirectConfigurationOutputReference;
    putRedirectConfiguration(value: FrontdoorRoutingRuleRedirectConfiguration): void;
    resetRedirectConfiguration(): void;
    get redirectConfigurationInput(): FrontdoorRoutingRuleRedirectConfiguration | undefined;
}
export declare class FrontdoorRoutingRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FrontdoorRoutingRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FrontdoorRoutingRuleOutputReference;
}
export interface FrontdoorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#create Frontdoor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#delete Frontdoor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#read Frontdoor#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#update Frontdoor#update}
    */
    readonly update?: string;
}
export declare function frontdoorTimeoutsToTerraform(struct?: FrontdoorTimeouts | cdktf.IResolvable): any;
export declare function frontdoorTimeoutsToHclTerraform(struct?: FrontdoorTimeouts | cdktf.IResolvable): any;
export declare class FrontdoorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FrontdoorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FrontdoorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor azurerm_frontdoor}
*/
export declare class Frontdoor extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_frontdoor";
    /**
    * Generates CDKTF code for importing a Frontdoor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Frontdoor to import
    * @param importFromId The id of the existing Frontdoor that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Frontdoor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/frontdoor azurerm_frontdoor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FrontdoorConfig
    */
    constructor(scope: Construct, id: string, config: FrontdoorConfig);
    private _backendPoolHealthProbes;
    get backendPoolHealthProbes(): cdktf.StringMap;
    private _backendPoolLoadBalancingSettings;
    get backendPoolLoadBalancingSettings(): cdktf.StringMap;
    private _backendPools;
    get backendPools(): cdktf.StringMap;
    get cname(): string;
    private _explicitResourceOrder;
    get explicitResourceOrder(): FrontdoorExplicitResourceOrderList;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _frontendEndpoints;
    get frontendEndpoints(): cdktf.StringMap;
    get headerFrontdoorId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loadBalancerEnabled?;
    get loadBalancerEnabled(): boolean | cdktf.IResolvable;
    set loadBalancerEnabled(value: boolean | cdktf.IResolvable);
    resetLoadBalancerEnabled(): void;
    get loadBalancerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _routingRules;
    get routingRules(): cdktf.StringMap;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _backendPool;
    get backendPool(): FrontdoorBackendPoolList;
    putBackendPool(value: FrontdoorBackendPool[] | cdktf.IResolvable): void;
    get backendPoolInput(): cdktf.IResolvable | FrontdoorBackendPool[] | undefined;
    private _backendPoolHealthProbe;
    get backendPoolHealthProbe(): FrontdoorBackendPoolHealthProbeList;
    putBackendPoolHealthProbe(value: FrontdoorBackendPoolHealthProbe[] | cdktf.IResolvable): void;
    get backendPoolHealthProbeInput(): cdktf.IResolvable | FrontdoorBackendPoolHealthProbe[] | undefined;
    private _backendPoolLoadBalancing;
    get backendPoolLoadBalancing(): FrontdoorBackendPoolLoadBalancingList;
    putBackendPoolLoadBalancing(value: FrontdoorBackendPoolLoadBalancing[] | cdktf.IResolvable): void;
    get backendPoolLoadBalancingInput(): cdktf.IResolvable | FrontdoorBackendPoolLoadBalancing[] | undefined;
    private _backendPoolSettings;
    get backendPoolSettings(): FrontdoorBackendPoolSettingsList;
    putBackendPoolSettings(value: FrontdoorBackendPoolSettings[] | cdktf.IResolvable): void;
    resetBackendPoolSettings(): void;
    get backendPoolSettingsInput(): cdktf.IResolvable | FrontdoorBackendPoolSettings[] | undefined;
    private _frontendEndpoint;
    get frontendEndpoint(): FrontdoorFrontendEndpointList;
    putFrontendEndpoint(value: FrontdoorFrontendEndpoint[] | cdktf.IResolvable): void;
    get frontendEndpointInput(): cdktf.IResolvable | FrontdoorFrontendEndpoint[] | undefined;
    private _routingRule;
    get routingRule(): FrontdoorRoutingRuleList;
    putRoutingRule(value: FrontdoorRoutingRule[] | cdktf.IResolvable): void;
    get routingRuleInput(): cdktf.IResolvable | FrontdoorRoutingRule[] | undefined;
    private _timeouts;
    get timeouts(): FrontdoorTimeoutsOutputReference;
    putTimeouts(value: FrontdoorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FrontdoorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
