/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IotcentralOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#display_name IotcentralOrganization#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#id IotcentralOrganization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#iotcentral_application_id IotcentralOrganization#iotcentral_application_id}
    */
    readonly iotcentralApplicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#organization_id IotcentralOrganization#organization_id}
    */
    readonly organizationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#parent_organization_id IotcentralOrganization#parent_organization_id}
    */
    readonly parentOrganizationId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#timeouts IotcentralOrganization#timeouts}
    */
    readonly timeouts?: IotcentralOrganizationTimeouts;
}
export interface IotcentralOrganizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#create IotcentralOrganization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#delete IotcentralOrganization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#read IotcentralOrganization#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#update IotcentralOrganization#update}
    */
    readonly update?: string;
}
export declare function iotcentralOrganizationTimeoutsToTerraform(struct?: IotcentralOrganizationTimeouts | cdktf.IResolvable): any;
export declare function iotcentralOrganizationTimeoutsToHclTerraform(struct?: IotcentralOrganizationTimeouts | cdktf.IResolvable): any;
export declare class IotcentralOrganizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IotcentralOrganizationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IotcentralOrganizationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization azurerm_iotcentral_organization}
*/
export declare class IotcentralOrganization extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_iotcentral_organization";
    /**
    * Generates CDKTF code for importing a IotcentralOrganization resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the IotcentralOrganization to import
    * @param importFromId The id of the existing IotcentralOrganization that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the IotcentralOrganization to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/iotcentral_organization azurerm_iotcentral_organization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IotcentralOrganizationConfig
    */
    constructor(scope: Construct, id: string, config: IotcentralOrganizationConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iotcentralApplicationId?;
    get iotcentralApplicationId(): string;
    set iotcentralApplicationId(value: string);
    get iotcentralApplicationIdInput(): string | undefined;
    private _organizationId?;
    get organizationId(): string;
    set organizationId(value: string);
    get organizationIdInput(): string | undefined;
    private _parentOrganizationId?;
    get parentOrganizationId(): string;
    set parentOrganizationId(value: string);
    resetParentOrganizationId(): void;
    get parentOrganizationIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): IotcentralOrganizationTimeoutsOutputReference;
    putTimeouts(value: IotcentralOrganizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IotcentralOrganizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
