/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesClusterNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#auto_scaling_enabled KubernetesClusterNodePool#auto_scaling_enabled}
    */
    readonly autoScalingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#capacity_reservation_group_id KubernetesClusterNodePool#capacity_reservation_group_id}
    */
    readonly capacityReservationGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#eviction_policy KubernetesClusterNodePool#eviction_policy}
    */
    readonly evictionPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#fips_enabled KubernetesClusterNodePool#fips_enabled}
    */
    readonly fipsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#gpu_instance KubernetesClusterNodePool#gpu_instance}
    */
    readonly gpuInstance?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#host_encryption_enabled KubernetesClusterNodePool#host_encryption_enabled}
    */
    readonly hostEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#host_group_id KubernetesClusterNodePool#host_group_id}
    */
    readonly hostGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#id KubernetesClusterNodePool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#kubelet_disk_type KubernetesClusterNodePool#kubelet_disk_type}
    */
    readonly kubeletDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#kubernetes_cluster_id KubernetesClusterNodePool#kubernetes_cluster_id}
    */
    readonly kubernetesClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#max_count KubernetesClusterNodePool#max_count}
    */
    readonly maxCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#max_pods KubernetesClusterNodePool#max_pods}
    */
    readonly maxPods?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#min_count KubernetesClusterNodePool#min_count}
    */
    readonly minCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#mode KubernetesClusterNodePool#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#name KubernetesClusterNodePool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#node_count KubernetesClusterNodePool#node_count}
    */
    readonly nodeCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#node_labels KubernetesClusterNodePool#node_labels}
    */
    readonly nodeLabels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#node_public_ip_enabled KubernetesClusterNodePool#node_public_ip_enabled}
    */
    readonly nodePublicIpEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#node_public_ip_prefix_id KubernetesClusterNodePool#node_public_ip_prefix_id}
    */
    readonly nodePublicIpPrefixId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#node_taints KubernetesClusterNodePool#node_taints}
    */
    readonly nodeTaints?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#orchestrator_version KubernetesClusterNodePool#orchestrator_version}
    */
    readonly orchestratorVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#os_disk_size_gb KubernetesClusterNodePool#os_disk_size_gb}
    */
    readonly osDiskSizeGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#os_disk_type KubernetesClusterNodePool#os_disk_type}
    */
    readonly osDiskType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#os_sku KubernetesClusterNodePool#os_sku}
    */
    readonly osSku?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#os_type KubernetesClusterNodePool#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#pod_subnet_id KubernetesClusterNodePool#pod_subnet_id}
    */
    readonly podSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#priority KubernetesClusterNodePool#priority}
    */
    readonly priority?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#proximity_placement_group_id KubernetesClusterNodePool#proximity_placement_group_id}
    */
    readonly proximityPlacementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#scale_down_mode KubernetesClusterNodePool#scale_down_mode}
    */
    readonly scaleDownMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#snapshot_id KubernetesClusterNodePool#snapshot_id}
    */
    readonly snapshotId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#spot_max_price KubernetesClusterNodePool#spot_max_price}
    */
    readonly spotMaxPrice?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#tags KubernetesClusterNodePool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#ultra_ssd_enabled KubernetesClusterNodePool#ultra_ssd_enabled}
    */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#vm_size KubernetesClusterNodePool#vm_size}
    */
    readonly vmSize: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#vnet_subnet_id KubernetesClusterNodePool#vnet_subnet_id}
    */
    readonly vnetSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#workload_runtime KubernetesClusterNodePool#workload_runtime}
    */
    readonly workloadRuntime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#zones KubernetesClusterNodePool#zones}
    */
    readonly zones?: string[];
    /**
    * kubelet_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#kubelet_config KubernetesClusterNodePool#kubelet_config}
    */
    readonly kubeletConfig?: KubernetesClusterNodePoolKubeletConfig;
    /**
    * linux_os_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#linux_os_config KubernetesClusterNodePool#linux_os_config}
    */
    readonly linuxOsConfig?: KubernetesClusterNodePoolLinuxOsConfig;
    /**
    * node_network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#node_network_profile KubernetesClusterNodePool#node_network_profile}
    */
    readonly nodeNetworkProfile?: KubernetesClusterNodePoolNodeNetworkProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#timeouts KubernetesClusterNodePool#timeouts}
    */
    readonly timeouts?: KubernetesClusterNodePoolTimeouts;
    /**
    * upgrade_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#upgrade_settings KubernetesClusterNodePool#upgrade_settings}
    */
    readonly upgradeSettings?: KubernetesClusterNodePoolUpgradeSettings;
    /**
    * windows_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#windows_profile KubernetesClusterNodePool#windows_profile}
    */
    readonly windowsProfile?: KubernetesClusterNodePoolWindowsProfile;
}
export interface KubernetesClusterNodePoolKubeletConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#allowed_unsafe_sysctls KubernetesClusterNodePool#allowed_unsafe_sysctls}
    */
    readonly allowedUnsafeSysctls?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#container_log_max_line KubernetesClusterNodePool#container_log_max_line}
    */
    readonly containerLogMaxLine?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#container_log_max_size_mb KubernetesClusterNodePool#container_log_max_size_mb}
    */
    readonly containerLogMaxSizeMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#cpu_cfs_quota_enabled KubernetesClusterNodePool#cpu_cfs_quota_enabled}
    */
    readonly cpuCfsQuotaEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#cpu_cfs_quota_period KubernetesClusterNodePool#cpu_cfs_quota_period}
    */
    readonly cpuCfsQuotaPeriod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#cpu_manager_policy KubernetesClusterNodePool#cpu_manager_policy}
    */
    readonly cpuManagerPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#image_gc_high_threshold KubernetesClusterNodePool#image_gc_high_threshold}
    */
    readonly imageGcHighThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#image_gc_low_threshold KubernetesClusterNodePool#image_gc_low_threshold}
    */
    readonly imageGcLowThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#pod_max_pid KubernetesClusterNodePool#pod_max_pid}
    */
    readonly podMaxPid?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#topology_manager_policy KubernetesClusterNodePool#topology_manager_policy}
    */
    readonly topologyManagerPolicy?: string;
}
export declare function kubernetesClusterNodePoolKubeletConfigToTerraform(struct?: KubernetesClusterNodePoolKubeletConfigOutputReference | KubernetesClusterNodePoolKubeletConfig): any;
export declare function kubernetesClusterNodePoolKubeletConfigToHclTerraform(struct?: KubernetesClusterNodePoolKubeletConfigOutputReference | KubernetesClusterNodePoolKubeletConfig): any;
export declare class KubernetesClusterNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNodePoolKubeletConfig | undefined;
    set internalValue(value: KubernetesClusterNodePoolKubeletConfig | undefined);
    private _allowedUnsafeSysctls?;
    get allowedUnsafeSysctls(): string[];
    set allowedUnsafeSysctls(value: string[]);
    resetAllowedUnsafeSysctls(): void;
    get allowedUnsafeSysctlsInput(): string[] | undefined;
    private _containerLogMaxLine?;
    get containerLogMaxLine(): number;
    set containerLogMaxLine(value: number);
    resetContainerLogMaxLine(): void;
    get containerLogMaxLineInput(): number | undefined;
    private _containerLogMaxSizeMb?;
    get containerLogMaxSizeMb(): number;
    set containerLogMaxSizeMb(value: number);
    resetContainerLogMaxSizeMb(): void;
    get containerLogMaxSizeMbInput(): number | undefined;
    private _cpuCfsQuotaEnabled?;
    get cpuCfsQuotaEnabled(): boolean | cdktf.IResolvable;
    set cpuCfsQuotaEnabled(value: boolean | cdktf.IResolvable);
    resetCpuCfsQuotaEnabled(): void;
    get cpuCfsQuotaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    get cpuCfsQuotaPeriod(): string;
    set cpuCfsQuotaPeriod(value: string);
    resetCpuCfsQuotaPeriod(): void;
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    get cpuManagerPolicy(): string;
    set cpuManagerPolicy(value: string);
    resetCpuManagerPolicy(): void;
    get cpuManagerPolicyInput(): string | undefined;
    private _imageGcHighThreshold?;
    get imageGcHighThreshold(): number;
    set imageGcHighThreshold(value: number);
    resetImageGcHighThreshold(): void;
    get imageGcHighThresholdInput(): number | undefined;
    private _imageGcLowThreshold?;
    get imageGcLowThreshold(): number;
    set imageGcLowThreshold(value: number);
    resetImageGcLowThreshold(): void;
    get imageGcLowThresholdInput(): number | undefined;
    private _podMaxPid?;
    get podMaxPid(): number;
    set podMaxPid(value: number);
    resetPodMaxPid(): void;
    get podMaxPidInput(): number | undefined;
    private _topologyManagerPolicy?;
    get topologyManagerPolicy(): string;
    set topologyManagerPolicy(value: string);
    resetTopologyManagerPolicy(): void;
    get topologyManagerPolicyInput(): string | undefined;
}
export interface KubernetesClusterNodePoolLinuxOsConfigSysctlConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#fs_aio_max_nr KubernetesClusterNodePool#fs_aio_max_nr}
    */
    readonly fsAioMaxNr?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#fs_file_max KubernetesClusterNodePool#fs_file_max}
    */
    readonly fsFileMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#fs_inotify_max_user_watches KubernetesClusterNodePool#fs_inotify_max_user_watches}
    */
    readonly fsInotifyMaxUserWatches?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#fs_nr_open KubernetesClusterNodePool#fs_nr_open}
    */
    readonly fsNrOpen?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#kernel_threads_max KubernetesClusterNodePool#kernel_threads_max}
    */
    readonly kernelThreadsMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_core_netdev_max_backlog KubernetesClusterNodePool#net_core_netdev_max_backlog}
    */
    readonly netCoreNetdevMaxBacklog?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_core_optmem_max KubernetesClusterNodePool#net_core_optmem_max}
    */
    readonly netCoreOptmemMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_core_rmem_default KubernetesClusterNodePool#net_core_rmem_default}
    */
    readonly netCoreRmemDefault?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_core_rmem_max KubernetesClusterNodePool#net_core_rmem_max}
    */
    readonly netCoreRmemMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_core_somaxconn KubernetesClusterNodePool#net_core_somaxconn}
    */
    readonly netCoreSomaxconn?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_core_wmem_default KubernetesClusterNodePool#net_core_wmem_default}
    */
    readonly netCoreWmemDefault?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_core_wmem_max KubernetesClusterNodePool#net_core_wmem_max}
    */
    readonly netCoreWmemMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_ip_local_port_range_max KubernetesClusterNodePool#net_ipv4_ip_local_port_range_max}
    */
    readonly netIpv4IpLocalPortRangeMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_ip_local_port_range_min KubernetesClusterNodePool#net_ipv4_ip_local_port_range_min}
    */
    readonly netIpv4IpLocalPortRangeMin?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_neigh_default_gc_thresh1 KubernetesClusterNodePool#net_ipv4_neigh_default_gc_thresh1}
    */
    readonly netIpv4NeighDefaultGcThresh1?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_neigh_default_gc_thresh2 KubernetesClusterNodePool#net_ipv4_neigh_default_gc_thresh2}
    */
    readonly netIpv4NeighDefaultGcThresh2?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_neigh_default_gc_thresh3 KubernetesClusterNodePool#net_ipv4_neigh_default_gc_thresh3}
    */
    readonly netIpv4NeighDefaultGcThresh3?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_tcp_fin_timeout KubernetesClusterNodePool#net_ipv4_tcp_fin_timeout}
    */
    readonly netIpv4TcpFinTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_tcp_keepalive_intvl KubernetesClusterNodePool#net_ipv4_tcp_keepalive_intvl}
    */
    readonly netIpv4TcpKeepaliveIntvl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_tcp_keepalive_probes KubernetesClusterNodePool#net_ipv4_tcp_keepalive_probes}
    */
    readonly netIpv4TcpKeepaliveProbes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_tcp_keepalive_time KubernetesClusterNodePool#net_ipv4_tcp_keepalive_time}
    */
    readonly netIpv4TcpKeepaliveTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_tcp_max_syn_backlog KubernetesClusterNodePool#net_ipv4_tcp_max_syn_backlog}
    */
    readonly netIpv4TcpMaxSynBacklog?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_tcp_max_tw_buckets KubernetesClusterNodePool#net_ipv4_tcp_max_tw_buckets}
    */
    readonly netIpv4TcpMaxTwBuckets?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_ipv4_tcp_tw_reuse KubernetesClusterNodePool#net_ipv4_tcp_tw_reuse}
    */
    readonly netIpv4TcpTwReuse?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_netfilter_nf_conntrack_buckets KubernetesClusterNodePool#net_netfilter_nf_conntrack_buckets}
    */
    readonly netNetfilterNfConntrackBuckets?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#net_netfilter_nf_conntrack_max KubernetesClusterNodePool#net_netfilter_nf_conntrack_max}
    */
    readonly netNetfilterNfConntrackMax?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#vm_max_map_count KubernetesClusterNodePool#vm_max_map_count}
    */
    readonly vmMaxMapCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#vm_swappiness KubernetesClusterNodePool#vm_swappiness}
    */
    readonly vmSwappiness?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#vm_vfs_cache_pressure KubernetesClusterNodePool#vm_vfs_cache_pressure}
    */
    readonly vmVfsCachePressure?: number;
}
export declare function kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToTerraform(struct?: KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference | KubernetesClusterNodePoolLinuxOsConfigSysctlConfig): any;
export declare function kubernetesClusterNodePoolLinuxOsConfigSysctlConfigToHclTerraform(struct?: KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference | KubernetesClusterNodePoolLinuxOsConfigSysctlConfig): any;
export declare class KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNodePoolLinuxOsConfigSysctlConfig | undefined;
    set internalValue(value: KubernetesClusterNodePoolLinuxOsConfigSysctlConfig | undefined);
    private _fsAioMaxNr?;
    get fsAioMaxNr(): number;
    set fsAioMaxNr(value: number);
    resetFsAioMaxNr(): void;
    get fsAioMaxNrInput(): number | undefined;
    private _fsFileMax?;
    get fsFileMax(): number;
    set fsFileMax(value: number);
    resetFsFileMax(): void;
    get fsFileMaxInput(): number | undefined;
    private _fsInotifyMaxUserWatches?;
    get fsInotifyMaxUserWatches(): number;
    set fsInotifyMaxUserWatches(value: number);
    resetFsInotifyMaxUserWatches(): void;
    get fsInotifyMaxUserWatchesInput(): number | undefined;
    private _fsNrOpen?;
    get fsNrOpen(): number;
    set fsNrOpen(value: number);
    resetFsNrOpen(): void;
    get fsNrOpenInput(): number | undefined;
    private _kernelThreadsMax?;
    get kernelThreadsMax(): number;
    set kernelThreadsMax(value: number);
    resetKernelThreadsMax(): void;
    get kernelThreadsMaxInput(): number | undefined;
    private _netCoreNetdevMaxBacklog?;
    get netCoreNetdevMaxBacklog(): number;
    set netCoreNetdevMaxBacklog(value: number);
    resetNetCoreNetdevMaxBacklog(): void;
    get netCoreNetdevMaxBacklogInput(): number | undefined;
    private _netCoreOptmemMax?;
    get netCoreOptmemMax(): number;
    set netCoreOptmemMax(value: number);
    resetNetCoreOptmemMax(): void;
    get netCoreOptmemMaxInput(): number | undefined;
    private _netCoreRmemDefault?;
    get netCoreRmemDefault(): number;
    set netCoreRmemDefault(value: number);
    resetNetCoreRmemDefault(): void;
    get netCoreRmemDefaultInput(): number | undefined;
    private _netCoreRmemMax?;
    get netCoreRmemMax(): number;
    set netCoreRmemMax(value: number);
    resetNetCoreRmemMax(): void;
    get netCoreRmemMaxInput(): number | undefined;
    private _netCoreSomaxconn?;
    get netCoreSomaxconn(): number;
    set netCoreSomaxconn(value: number);
    resetNetCoreSomaxconn(): void;
    get netCoreSomaxconnInput(): number | undefined;
    private _netCoreWmemDefault?;
    get netCoreWmemDefault(): number;
    set netCoreWmemDefault(value: number);
    resetNetCoreWmemDefault(): void;
    get netCoreWmemDefaultInput(): number | undefined;
    private _netCoreWmemMax?;
    get netCoreWmemMax(): number;
    set netCoreWmemMax(value: number);
    resetNetCoreWmemMax(): void;
    get netCoreWmemMaxInput(): number | undefined;
    private _netIpv4IpLocalPortRangeMax?;
    get netIpv4IpLocalPortRangeMax(): number;
    set netIpv4IpLocalPortRangeMax(value: number);
    resetNetIpv4IpLocalPortRangeMax(): void;
    get netIpv4IpLocalPortRangeMaxInput(): number | undefined;
    private _netIpv4IpLocalPortRangeMin?;
    get netIpv4IpLocalPortRangeMin(): number;
    set netIpv4IpLocalPortRangeMin(value: number);
    resetNetIpv4IpLocalPortRangeMin(): void;
    get netIpv4IpLocalPortRangeMinInput(): number | undefined;
    private _netIpv4NeighDefaultGcThresh1?;
    get netIpv4NeighDefaultGcThresh1(): number;
    set netIpv4NeighDefaultGcThresh1(value: number);
    resetNetIpv4NeighDefaultGcThresh1(): void;
    get netIpv4NeighDefaultGcThresh1Input(): number | undefined;
    private _netIpv4NeighDefaultGcThresh2?;
    get netIpv4NeighDefaultGcThresh2(): number;
    set netIpv4NeighDefaultGcThresh2(value: number);
    resetNetIpv4NeighDefaultGcThresh2(): void;
    get netIpv4NeighDefaultGcThresh2Input(): number | undefined;
    private _netIpv4NeighDefaultGcThresh3?;
    get netIpv4NeighDefaultGcThresh3(): number;
    set netIpv4NeighDefaultGcThresh3(value: number);
    resetNetIpv4NeighDefaultGcThresh3(): void;
    get netIpv4NeighDefaultGcThresh3Input(): number | undefined;
    private _netIpv4TcpFinTimeout?;
    get netIpv4TcpFinTimeout(): number;
    set netIpv4TcpFinTimeout(value: number);
    resetNetIpv4TcpFinTimeout(): void;
    get netIpv4TcpFinTimeoutInput(): number | undefined;
    private _netIpv4TcpKeepaliveIntvl?;
    get netIpv4TcpKeepaliveIntvl(): number;
    set netIpv4TcpKeepaliveIntvl(value: number);
    resetNetIpv4TcpKeepaliveIntvl(): void;
    get netIpv4TcpKeepaliveIntvlInput(): number | undefined;
    private _netIpv4TcpKeepaliveProbes?;
    get netIpv4TcpKeepaliveProbes(): number;
    set netIpv4TcpKeepaliveProbes(value: number);
    resetNetIpv4TcpKeepaliveProbes(): void;
    get netIpv4TcpKeepaliveProbesInput(): number | undefined;
    private _netIpv4TcpKeepaliveTime?;
    get netIpv4TcpKeepaliveTime(): number;
    set netIpv4TcpKeepaliveTime(value: number);
    resetNetIpv4TcpKeepaliveTime(): void;
    get netIpv4TcpKeepaliveTimeInput(): number | undefined;
    private _netIpv4TcpMaxSynBacklog?;
    get netIpv4TcpMaxSynBacklog(): number;
    set netIpv4TcpMaxSynBacklog(value: number);
    resetNetIpv4TcpMaxSynBacklog(): void;
    get netIpv4TcpMaxSynBacklogInput(): number | undefined;
    private _netIpv4TcpMaxTwBuckets?;
    get netIpv4TcpMaxTwBuckets(): number;
    set netIpv4TcpMaxTwBuckets(value: number);
    resetNetIpv4TcpMaxTwBuckets(): void;
    get netIpv4TcpMaxTwBucketsInput(): number | undefined;
    private _netIpv4TcpTwReuse?;
    get netIpv4TcpTwReuse(): boolean | cdktf.IResolvable;
    set netIpv4TcpTwReuse(value: boolean | cdktf.IResolvable);
    resetNetIpv4TcpTwReuse(): void;
    get netIpv4TcpTwReuseInput(): boolean | cdktf.IResolvable | undefined;
    private _netNetfilterNfConntrackBuckets?;
    get netNetfilterNfConntrackBuckets(): number;
    set netNetfilterNfConntrackBuckets(value: number);
    resetNetNetfilterNfConntrackBuckets(): void;
    get netNetfilterNfConntrackBucketsInput(): number | undefined;
    private _netNetfilterNfConntrackMax?;
    get netNetfilterNfConntrackMax(): number;
    set netNetfilterNfConntrackMax(value: number);
    resetNetNetfilterNfConntrackMax(): void;
    get netNetfilterNfConntrackMaxInput(): number | undefined;
    private _vmMaxMapCount?;
    get vmMaxMapCount(): number;
    set vmMaxMapCount(value: number);
    resetVmMaxMapCount(): void;
    get vmMaxMapCountInput(): number | undefined;
    private _vmSwappiness?;
    get vmSwappiness(): number;
    set vmSwappiness(value: number);
    resetVmSwappiness(): void;
    get vmSwappinessInput(): number | undefined;
    private _vmVfsCachePressure?;
    get vmVfsCachePressure(): number;
    set vmVfsCachePressure(value: number);
    resetVmVfsCachePressure(): void;
    get vmVfsCachePressureInput(): number | undefined;
}
export interface KubernetesClusterNodePoolLinuxOsConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#swap_file_size_mb KubernetesClusterNodePool#swap_file_size_mb}
    */
    readonly swapFileSizeMb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#transparent_huge_page_defrag KubernetesClusterNodePool#transparent_huge_page_defrag}
    */
    readonly transparentHugePageDefrag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#transparent_huge_page_enabled KubernetesClusterNodePool#transparent_huge_page_enabled}
    */
    readonly transparentHugePageEnabled?: string;
    /**
    * sysctl_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#sysctl_config KubernetesClusterNodePool#sysctl_config}
    */
    readonly sysctlConfig?: KubernetesClusterNodePoolLinuxOsConfigSysctlConfig;
}
export declare function kubernetesClusterNodePoolLinuxOsConfigToTerraform(struct?: KubernetesClusterNodePoolLinuxOsConfigOutputReference | KubernetesClusterNodePoolLinuxOsConfig): any;
export declare function kubernetesClusterNodePoolLinuxOsConfigToHclTerraform(struct?: KubernetesClusterNodePoolLinuxOsConfigOutputReference | KubernetesClusterNodePoolLinuxOsConfig): any;
export declare class KubernetesClusterNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNodePoolLinuxOsConfig | undefined;
    set internalValue(value: KubernetesClusterNodePoolLinuxOsConfig | undefined);
    private _swapFileSizeMb?;
    get swapFileSizeMb(): number;
    set swapFileSizeMb(value: number);
    resetSwapFileSizeMb(): void;
    get swapFileSizeMbInput(): number | undefined;
    private _transparentHugePageDefrag?;
    get transparentHugePageDefrag(): string;
    set transparentHugePageDefrag(value: string);
    resetTransparentHugePageDefrag(): void;
    get transparentHugePageDefragInput(): string | undefined;
    private _transparentHugePageEnabled?;
    get transparentHugePageEnabled(): string;
    set transparentHugePageEnabled(value: string);
    resetTransparentHugePageEnabled(): void;
    get transparentHugePageEnabledInput(): string | undefined;
    private _sysctlConfig;
    get sysctlConfig(): KubernetesClusterNodePoolLinuxOsConfigSysctlConfigOutputReference;
    putSysctlConfig(value: KubernetesClusterNodePoolLinuxOsConfigSysctlConfig): void;
    resetSysctlConfig(): void;
    get sysctlConfigInput(): KubernetesClusterNodePoolLinuxOsConfigSysctlConfig | undefined;
}
export interface KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#port_end KubernetesClusterNodePool#port_end}
    */
    readonly portEnd?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#port_start KubernetesClusterNodePool#port_start}
    */
    readonly portStart?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#protocol KubernetesClusterNodePool#protocol}
    */
    readonly protocol?: string;
}
export declare function kubernetesClusterNodePoolNodeNetworkProfileAllowedHostPortsToTerraform(struct?: KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts | cdktf.IResolvable): any;
export declare function kubernetesClusterNodePoolNodeNetworkProfileAllowedHostPortsToHclTerraform(struct?: KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts | cdktf.IResolvable): any;
export declare class KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts | cdktf.IResolvable | undefined);
    private _portEnd?;
    get portEnd(): number;
    set portEnd(value: number);
    resetPortEnd(): void;
    get portEndInput(): number | undefined;
    private _portStart?;
    get portStart(): number;
    set portStart(value: number);
    resetPortStart(): void;
    get portStartInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
}
export declare class KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPortsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPortsOutputReference;
}
export interface KubernetesClusterNodePoolNodeNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#application_security_group_ids KubernetesClusterNodePool#application_security_group_ids}
    */
    readonly applicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#node_public_ip_tags KubernetesClusterNodePool#node_public_ip_tags}
    */
    readonly nodePublicIpTags?: {
        [key: string]: string;
    };
    /**
    * allowed_host_ports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#allowed_host_ports KubernetesClusterNodePool#allowed_host_ports}
    */
    readonly allowedHostPorts?: KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts[] | cdktf.IResolvable;
}
export declare function kubernetesClusterNodePoolNodeNetworkProfileToTerraform(struct?: KubernetesClusterNodePoolNodeNetworkProfileOutputReference | KubernetesClusterNodePoolNodeNetworkProfile): any;
export declare function kubernetesClusterNodePoolNodeNetworkProfileToHclTerraform(struct?: KubernetesClusterNodePoolNodeNetworkProfileOutputReference | KubernetesClusterNodePoolNodeNetworkProfile): any;
export declare class KubernetesClusterNodePoolNodeNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNodePoolNodeNetworkProfile | undefined;
    set internalValue(value: KubernetesClusterNodePoolNodeNetworkProfile | undefined);
    private _applicationSecurityGroupIds?;
    get applicationSecurityGroupIds(): string[];
    set applicationSecurityGroupIds(value: string[]);
    resetApplicationSecurityGroupIds(): void;
    get applicationSecurityGroupIdsInput(): string[] | undefined;
    private _nodePublicIpTags?;
    get nodePublicIpTags(): {
        [key: string]: string;
    };
    set nodePublicIpTags(value: {
        [key: string]: string;
    });
    resetNodePublicIpTags(): void;
    get nodePublicIpTagsInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedHostPorts;
    get allowedHostPorts(): KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPortsList;
    putAllowedHostPorts(value: KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts[] | cdktf.IResolvable): void;
    resetAllowedHostPorts(): void;
    get allowedHostPortsInput(): cdktf.IResolvable | KubernetesClusterNodePoolNodeNetworkProfileAllowedHostPorts[] | undefined;
}
export interface KubernetesClusterNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#create KubernetesClusterNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#delete KubernetesClusterNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#read KubernetesClusterNodePool#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#update KubernetesClusterNodePool#update}
    */
    readonly update?: string;
}
export declare function kubernetesClusterNodePoolTimeoutsToTerraform(struct?: KubernetesClusterNodePoolTimeouts | cdktf.IResolvable): any;
export declare function kubernetesClusterNodePoolTimeoutsToHclTerraform(struct?: KubernetesClusterNodePoolTimeouts | cdktf.IResolvable): any;
export declare class KubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNodePoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesClusterNodePoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface KubernetesClusterNodePoolUpgradeSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#drain_timeout_in_minutes KubernetesClusterNodePool#drain_timeout_in_minutes}
    */
    readonly drainTimeoutInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#max_surge KubernetesClusterNodePool#max_surge}
    */
    readonly maxSurge: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#node_soak_duration_in_minutes KubernetesClusterNodePool#node_soak_duration_in_minutes}
    */
    readonly nodeSoakDurationInMinutes?: number;
}
export declare function kubernetesClusterNodePoolUpgradeSettingsToTerraform(struct?: KubernetesClusterNodePoolUpgradeSettingsOutputReference | KubernetesClusterNodePoolUpgradeSettings): any;
export declare function kubernetesClusterNodePoolUpgradeSettingsToHclTerraform(struct?: KubernetesClusterNodePoolUpgradeSettingsOutputReference | KubernetesClusterNodePoolUpgradeSettings): any;
export declare class KubernetesClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNodePoolUpgradeSettings | undefined;
    set internalValue(value: KubernetesClusterNodePoolUpgradeSettings | undefined);
    private _drainTimeoutInMinutes?;
    get drainTimeoutInMinutes(): number;
    set drainTimeoutInMinutes(value: number);
    resetDrainTimeoutInMinutes(): void;
    get drainTimeoutInMinutesInput(): number | undefined;
    private _maxSurge?;
    get maxSurge(): string;
    set maxSurge(value: string);
    get maxSurgeInput(): string | undefined;
    private _nodeSoakDurationInMinutes?;
    get nodeSoakDurationInMinutes(): number;
    set nodeSoakDurationInMinutes(value: number);
    resetNodeSoakDurationInMinutes(): void;
    get nodeSoakDurationInMinutesInput(): number | undefined;
}
export interface KubernetesClusterNodePoolWindowsProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#outbound_nat_enabled KubernetesClusterNodePool#outbound_nat_enabled}
    */
    readonly outboundNatEnabled?: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterNodePoolWindowsProfileToTerraform(struct?: KubernetesClusterNodePoolWindowsProfileOutputReference | KubernetesClusterNodePoolWindowsProfile): any;
export declare function kubernetesClusterNodePoolWindowsProfileToHclTerraform(struct?: KubernetesClusterNodePoolWindowsProfileOutputReference | KubernetesClusterNodePoolWindowsProfile): any;
export declare class KubernetesClusterNodePoolWindowsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesClusterNodePoolWindowsProfile | undefined;
    set internalValue(value: KubernetesClusterNodePoolWindowsProfile | undefined);
    private _outboundNatEnabled?;
    get outboundNatEnabled(): boolean | cdktf.IResolvable;
    set outboundNatEnabled(value: boolean | cdktf.IResolvable);
    resetOutboundNatEnabled(): void;
    get outboundNatEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool}
*/
export declare class KubernetesClusterNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kubernetes_cluster_node_pool";
    /**
    * Generates CDKTF code for importing a KubernetesClusterNodePool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesClusterNodePool to import
    * @param importFromId The id of the existing KubernetesClusterNodePool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesClusterNodePool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesClusterNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesClusterNodePoolConfig);
    private _autoScalingEnabled?;
    get autoScalingEnabled(): boolean | cdktf.IResolvable;
    set autoScalingEnabled(value: boolean | cdktf.IResolvable);
    resetAutoScalingEnabled(): void;
    get autoScalingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _capacityReservationGroupId?;
    get capacityReservationGroupId(): string;
    set capacityReservationGroupId(value: string);
    resetCapacityReservationGroupId(): void;
    get capacityReservationGroupIdInput(): string | undefined;
    private _evictionPolicy?;
    get evictionPolicy(): string;
    set evictionPolicy(value: string);
    resetEvictionPolicy(): void;
    get evictionPolicyInput(): string | undefined;
    private _fipsEnabled?;
    get fipsEnabled(): boolean | cdktf.IResolvable;
    set fipsEnabled(value: boolean | cdktf.IResolvable);
    resetFipsEnabled(): void;
    get fipsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gpuInstance?;
    get gpuInstance(): string;
    set gpuInstance(value: string);
    resetGpuInstance(): void;
    get gpuInstanceInput(): string | undefined;
    private _hostEncryptionEnabled?;
    get hostEncryptionEnabled(): boolean | cdktf.IResolvable;
    set hostEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetHostEncryptionEnabled(): void;
    get hostEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _hostGroupId?;
    get hostGroupId(): string;
    set hostGroupId(value: string);
    resetHostGroupId(): void;
    get hostGroupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubeletDiskType?;
    get kubeletDiskType(): string;
    set kubeletDiskType(value: string);
    resetKubeletDiskType(): void;
    get kubeletDiskTypeInput(): string | undefined;
    private _kubernetesClusterId?;
    get kubernetesClusterId(): string;
    set kubernetesClusterId(value: string);
    get kubernetesClusterIdInput(): string | undefined;
    private _maxCount?;
    get maxCount(): number;
    set maxCount(value: number);
    resetMaxCount(): void;
    get maxCountInput(): number | undefined;
    private _maxPods?;
    get maxPods(): number;
    set maxPods(value: number);
    resetMaxPods(): void;
    get maxPodsInput(): number | undefined;
    private _minCount?;
    get minCount(): number;
    set minCount(value: number);
    resetMinCount(): void;
    get minCountInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    resetNodeCount(): void;
    get nodeCountInput(): number | undefined;
    private _nodeLabels?;
    get nodeLabels(): {
        [key: string]: string;
    };
    set nodeLabels(value: {
        [key: string]: string;
    });
    resetNodeLabels(): void;
    get nodeLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _nodePublicIpEnabled?;
    get nodePublicIpEnabled(): boolean | cdktf.IResolvable;
    set nodePublicIpEnabled(value: boolean | cdktf.IResolvable);
    resetNodePublicIpEnabled(): void;
    get nodePublicIpEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _nodePublicIpPrefixId?;
    get nodePublicIpPrefixId(): string;
    set nodePublicIpPrefixId(value: string);
    resetNodePublicIpPrefixId(): void;
    get nodePublicIpPrefixIdInput(): string | undefined;
    private _nodeTaints?;
    get nodeTaints(): string[];
    set nodeTaints(value: string[]);
    resetNodeTaints(): void;
    get nodeTaintsInput(): string[] | undefined;
    private _orchestratorVersion?;
    get orchestratorVersion(): string;
    set orchestratorVersion(value: string);
    resetOrchestratorVersion(): void;
    get orchestratorVersionInput(): string | undefined;
    private _osDiskSizeGb?;
    get osDiskSizeGb(): number;
    set osDiskSizeGb(value: number);
    resetOsDiskSizeGb(): void;
    get osDiskSizeGbInput(): number | undefined;
    private _osDiskType?;
    get osDiskType(): string;
    set osDiskType(value: string);
    resetOsDiskType(): void;
    get osDiskTypeInput(): string | undefined;
    private _osSku?;
    get osSku(): string;
    set osSku(value: string);
    resetOsSku(): void;
    get osSkuInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _podSubnetId?;
    get podSubnetId(): string;
    set podSubnetId(value: string);
    resetPodSubnetId(): void;
    get podSubnetIdInput(): string | undefined;
    private _priority?;
    get priority(): string;
    set priority(value: string);
    resetPriority(): void;
    get priorityInput(): string | undefined;
    private _proximityPlacementGroupId?;
    get proximityPlacementGroupId(): string;
    set proximityPlacementGroupId(value: string);
    resetProximityPlacementGroupId(): void;
    get proximityPlacementGroupIdInput(): string | undefined;
    private _scaleDownMode?;
    get scaleDownMode(): string;
    set scaleDownMode(value: string);
    resetScaleDownMode(): void;
    get scaleDownModeInput(): string | undefined;
    private _snapshotId?;
    get snapshotId(): string;
    set snapshotId(value: string);
    resetSnapshotId(): void;
    get snapshotIdInput(): string | undefined;
    private _spotMaxPrice?;
    get spotMaxPrice(): number;
    set spotMaxPrice(value: number);
    resetSpotMaxPrice(): void;
    get spotMaxPriceInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ultraSsdEnabled?;
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    resetUltraSsdEnabled(): void;
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
    private _vnetSubnetId?;
    get vnetSubnetId(): string;
    set vnetSubnetId(value: string);
    resetVnetSubnetId(): void;
    get vnetSubnetIdInput(): string | undefined;
    private _workloadRuntime?;
    get workloadRuntime(): string;
    set workloadRuntime(value: string);
    resetWorkloadRuntime(): void;
    get workloadRuntimeInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _kubeletConfig;
    get kubeletConfig(): KubernetesClusterNodePoolKubeletConfigOutputReference;
    putKubeletConfig(value: KubernetesClusterNodePoolKubeletConfig): void;
    resetKubeletConfig(): void;
    get kubeletConfigInput(): KubernetesClusterNodePoolKubeletConfig | undefined;
    private _linuxOsConfig;
    get linuxOsConfig(): KubernetesClusterNodePoolLinuxOsConfigOutputReference;
    putLinuxOsConfig(value: KubernetesClusterNodePoolLinuxOsConfig): void;
    resetLinuxOsConfig(): void;
    get linuxOsConfigInput(): KubernetesClusterNodePoolLinuxOsConfig | undefined;
    private _nodeNetworkProfile;
    get nodeNetworkProfile(): KubernetesClusterNodePoolNodeNetworkProfileOutputReference;
    putNodeNetworkProfile(value: KubernetesClusterNodePoolNodeNetworkProfile): void;
    resetNodeNetworkProfile(): void;
    get nodeNetworkProfileInput(): KubernetesClusterNodePoolNodeNetworkProfile | undefined;
    private _timeouts;
    get timeouts(): KubernetesClusterNodePoolTimeoutsOutputReference;
    putTimeouts(value: KubernetesClusterNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesClusterNodePoolTimeouts | undefined;
    private _upgradeSettings;
    get upgradeSettings(): KubernetesClusterNodePoolUpgradeSettingsOutputReference;
    putUpgradeSettings(value: KubernetesClusterNodePoolUpgradeSettings): void;
    resetUpgradeSettings(): void;
    get upgradeSettingsInput(): KubernetesClusterNodePoolUpgradeSettings | undefined;
    private _windowsProfile;
    get windowsProfile(): KubernetesClusterNodePoolWindowsProfileOutputReference;
    putWindowsProfile(value: KubernetesClusterNodePoolWindowsProfile): void;
    resetWindowsProfile(): void;
    get windowsProfileInput(): KubernetesClusterNodePoolWindowsProfile | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
