/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppIntegrationAccountPartnerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#id LogicAppIntegrationAccountPartner#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#integration_account_name LogicAppIntegrationAccountPartner#integration_account_name}
    */
    readonly integrationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#metadata LogicAppIntegrationAccountPartner#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#name LogicAppIntegrationAccountPartner#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#resource_group_name LogicAppIntegrationAccountPartner#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * business_identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#business_identity LogicAppIntegrationAccountPartner#business_identity}
    */
    readonly businessIdentity: LogicAppIntegrationAccountPartnerBusinessIdentity[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#timeouts LogicAppIntegrationAccountPartner#timeouts}
    */
    readonly timeouts?: LogicAppIntegrationAccountPartnerTimeouts;
}
export interface LogicAppIntegrationAccountPartnerBusinessIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#qualifier LogicAppIntegrationAccountPartner#qualifier}
    */
    readonly qualifier: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#value LogicAppIntegrationAccountPartner#value}
    */
    readonly value: string;
}
export declare function logicAppIntegrationAccountPartnerBusinessIdentityToTerraform(struct?: LogicAppIntegrationAccountPartnerBusinessIdentity | cdktf.IResolvable): any;
export declare function logicAppIntegrationAccountPartnerBusinessIdentityToHclTerraform(struct?: LogicAppIntegrationAccountPartnerBusinessIdentity | cdktf.IResolvable): any;
export declare class LogicAppIntegrationAccountPartnerBusinessIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): LogicAppIntegrationAccountPartnerBusinessIdentity | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppIntegrationAccountPartnerBusinessIdentity | cdktf.IResolvable | undefined);
    private _qualifier?;
    get qualifier(): string;
    set qualifier(value: string);
    get qualifierInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class LogicAppIntegrationAccountPartnerBusinessIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: LogicAppIntegrationAccountPartnerBusinessIdentity[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): LogicAppIntegrationAccountPartnerBusinessIdentityOutputReference;
}
export interface LogicAppIntegrationAccountPartnerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#create LogicAppIntegrationAccountPartner#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#delete LogicAppIntegrationAccountPartner#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#read LogicAppIntegrationAccountPartner#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#update LogicAppIntegrationAccountPartner#update}
    */
    readonly update?: string;
}
export declare function logicAppIntegrationAccountPartnerTimeoutsToTerraform(struct?: LogicAppIntegrationAccountPartnerTimeouts | cdktf.IResolvable): any;
export declare function logicAppIntegrationAccountPartnerTimeoutsToHclTerraform(struct?: LogicAppIntegrationAccountPartnerTimeouts | cdktf.IResolvable): any;
export declare class LogicAppIntegrationAccountPartnerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppIntegrationAccountPartnerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LogicAppIntegrationAccountPartnerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner azurerm_logic_app_integration_account_partner}
*/
export declare class LogicAppIntegrationAccountPartner extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_integration_account_partner";
    /**
    * Generates CDKTF code for importing a LogicAppIntegrationAccountPartner resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LogicAppIntegrationAccountPartner to import
    * @param importFromId The id of the existing LogicAppIntegrationAccountPartner that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LogicAppIntegrationAccountPartner to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/logic_app_integration_account_partner azurerm_logic_app_integration_account_partner} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppIntegrationAccountPartnerConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppIntegrationAccountPartnerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _integrationAccountName?;
    get integrationAccountName(): string;
    set integrationAccountName(value: string);
    get integrationAccountNameInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _businessIdentity;
    get businessIdentity(): LogicAppIntegrationAccountPartnerBusinessIdentityList;
    putBusinessIdentity(value: LogicAppIntegrationAccountPartnerBusinessIdentity[] | cdktf.IResolvable): void;
    get businessIdentityInput(): cdktf.IResolvable | LogicAppIntegrationAccountPartnerBusinessIdentity[] | undefined;
    private _timeouts;
    get timeouts(): LogicAppIntegrationAccountPartnerTimeoutsOutputReference;
    putTimeouts(value: LogicAppIntegrationAccountPartnerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LogicAppIntegrationAccountPartnerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
