/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MobileNetworkAttachedDataNetworkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#dns_addresses MobileNetworkAttachedDataNetwork#dns_addresses}
    */
    readonly dnsAddresses: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#id MobileNetworkAttachedDataNetwork#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#location MobileNetworkAttachedDataNetwork#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#mobile_network_data_network_name MobileNetworkAttachedDataNetwork#mobile_network_data_network_name}
    */
    readonly mobileNetworkDataNetworkName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#mobile_network_packet_core_data_plane_id MobileNetworkAttachedDataNetwork#mobile_network_packet_core_data_plane_id}
    */
    readonly mobileNetworkPacketCoreDataPlaneId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#tags MobileNetworkAttachedDataNetwork#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#user_equipment_address_pool_prefixes MobileNetworkAttachedDataNetwork#user_equipment_address_pool_prefixes}
    */
    readonly userEquipmentAddressPoolPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#user_equipment_static_address_pool_prefixes MobileNetworkAttachedDataNetwork#user_equipment_static_address_pool_prefixes}
    */
    readonly userEquipmentStaticAddressPoolPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#user_plane_access_ipv4_address MobileNetworkAttachedDataNetwork#user_plane_access_ipv4_address}
    */
    readonly userPlaneAccessIpv4Address?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#user_plane_access_ipv4_gateway MobileNetworkAttachedDataNetwork#user_plane_access_ipv4_gateway}
    */
    readonly userPlaneAccessIpv4Gateway?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#user_plane_access_ipv4_subnet MobileNetworkAttachedDataNetwork#user_plane_access_ipv4_subnet}
    */
    readonly userPlaneAccessIpv4Subnet?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#user_plane_access_name MobileNetworkAttachedDataNetwork#user_plane_access_name}
    */
    readonly userPlaneAccessName?: string;
    /**
    * network_address_port_translation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#network_address_port_translation MobileNetworkAttachedDataNetwork#network_address_port_translation}
    */
    readonly networkAddressPortTranslation?: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#timeouts MobileNetworkAttachedDataNetwork#timeouts}
    */
    readonly timeouts?: MobileNetworkAttachedDataNetworkTimeouts;
}
export interface MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#maximum MobileNetworkAttachedDataNetwork#maximum}
    */
    readonly maximum?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#minimum MobileNetworkAttachedDataNetwork#minimum}
    */
    readonly minimum?: number;
}
export declare function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToTerraform(struct?: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference | MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange): any;
export declare function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeToHclTerraform(struct?: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference | MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange): any;
export declare class MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange | undefined;
    set internalValue(value: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange | undefined);
    private _maximum?;
    get maximum(): number;
    set maximum(value: number);
    resetMaximum(): void;
    get maximumInput(): number | undefined;
    private _minimum?;
    get minimum(): number;
    set minimum(value: number);
    resetMinimum(): void;
    get minimumInput(): number | undefined;
}
export interface MobileNetworkAttachedDataNetworkNetworkAddressPortTranslation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#icmp_pinhole_timeout_in_seconds MobileNetworkAttachedDataNetwork#icmp_pinhole_timeout_in_seconds}
    */
    readonly icmpPinholeTimeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#pinhole_maximum_number MobileNetworkAttachedDataNetwork#pinhole_maximum_number}
    */
    readonly pinholeMaximumNumber?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#tcp_pinhole_timeout_in_seconds MobileNetworkAttachedDataNetwork#tcp_pinhole_timeout_in_seconds}
    */
    readonly tcpPinholeTimeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#tcp_port_reuse_minimum_hold_time_in_seconds MobileNetworkAttachedDataNetwork#tcp_port_reuse_minimum_hold_time_in_seconds}
    */
    readonly tcpPortReuseMinimumHoldTimeInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#udp_pinhole_timeout_in_seconds MobileNetworkAttachedDataNetwork#udp_pinhole_timeout_in_seconds}
    */
    readonly udpPinholeTimeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#udp_port_reuse_minimum_hold_time_in_seconds MobileNetworkAttachedDataNetwork#udp_port_reuse_minimum_hold_time_in_seconds}
    */
    readonly udpPortReuseMinimumHoldTimeInSeconds?: number;
    /**
    * port_range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#port_range MobileNetworkAttachedDataNetwork#port_range}
    */
    readonly portRange?: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange;
}
export declare function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToTerraform(struct?: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference | MobileNetworkAttachedDataNetworkNetworkAddressPortTranslation): any;
export declare function mobileNetworkAttachedDataNetworkNetworkAddressPortTranslationToHclTerraform(struct?: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference | MobileNetworkAttachedDataNetworkNetworkAddressPortTranslation): any;
export declare class MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkAttachedDataNetworkNetworkAddressPortTranslation | undefined;
    set internalValue(value: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslation | undefined);
    private _icmpPinholeTimeoutInSeconds?;
    get icmpPinholeTimeoutInSeconds(): number;
    set icmpPinholeTimeoutInSeconds(value: number);
    resetIcmpPinholeTimeoutInSeconds(): void;
    get icmpPinholeTimeoutInSecondsInput(): number | undefined;
    private _pinholeMaximumNumber?;
    get pinholeMaximumNumber(): number;
    set pinholeMaximumNumber(value: number);
    resetPinholeMaximumNumber(): void;
    get pinholeMaximumNumberInput(): number | undefined;
    private _tcpPinholeTimeoutInSeconds?;
    get tcpPinholeTimeoutInSeconds(): number;
    set tcpPinholeTimeoutInSeconds(value: number);
    resetTcpPinholeTimeoutInSeconds(): void;
    get tcpPinholeTimeoutInSecondsInput(): number | undefined;
    private _tcpPortReuseMinimumHoldTimeInSeconds?;
    get tcpPortReuseMinimumHoldTimeInSeconds(): number;
    set tcpPortReuseMinimumHoldTimeInSeconds(value: number);
    resetTcpPortReuseMinimumHoldTimeInSeconds(): void;
    get tcpPortReuseMinimumHoldTimeInSecondsInput(): number | undefined;
    private _udpPinholeTimeoutInSeconds?;
    get udpPinholeTimeoutInSeconds(): number;
    set udpPinholeTimeoutInSeconds(value: number);
    resetUdpPinholeTimeoutInSeconds(): void;
    get udpPinholeTimeoutInSecondsInput(): number | undefined;
    private _udpPortReuseMinimumHoldTimeInSeconds?;
    get udpPortReuseMinimumHoldTimeInSeconds(): number;
    set udpPortReuseMinimumHoldTimeInSeconds(value: number);
    resetUdpPortReuseMinimumHoldTimeInSeconds(): void;
    get udpPortReuseMinimumHoldTimeInSecondsInput(): number | undefined;
    private _portRange;
    get portRange(): MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeOutputReference;
    putPortRange(value: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange): void;
    resetPortRange(): void;
    get portRangeInput(): MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationPortRange | undefined;
}
export interface MobileNetworkAttachedDataNetworkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#create MobileNetworkAttachedDataNetwork#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#delete MobileNetworkAttachedDataNetwork#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#read MobileNetworkAttachedDataNetwork#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#update MobileNetworkAttachedDataNetwork#update}
    */
    readonly update?: string;
}
export declare function mobileNetworkAttachedDataNetworkTimeoutsToTerraform(struct?: MobileNetworkAttachedDataNetworkTimeouts | cdktf.IResolvable): any;
export declare function mobileNetworkAttachedDataNetworkTimeoutsToHclTerraform(struct?: MobileNetworkAttachedDataNetworkTimeouts | cdktf.IResolvable): any;
export declare class MobileNetworkAttachedDataNetworkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkAttachedDataNetworkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkAttachedDataNetworkTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network azurerm_mobile_network_attached_data_network}
*/
export declare class MobileNetworkAttachedDataNetwork extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mobile_network_attached_data_network";
    /**
    * Generates CDKTF code for importing a MobileNetworkAttachedDataNetwork resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MobileNetworkAttachedDataNetwork to import
    * @param importFromId The id of the existing MobileNetworkAttachedDataNetwork that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MobileNetworkAttachedDataNetwork to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_attached_data_network azurerm_mobile_network_attached_data_network} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MobileNetworkAttachedDataNetworkConfig
    */
    constructor(scope: Construct, id: string, config: MobileNetworkAttachedDataNetworkConfig);
    private _dnsAddresses?;
    get dnsAddresses(): string[];
    set dnsAddresses(value: string[]);
    get dnsAddressesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mobileNetworkDataNetworkName?;
    get mobileNetworkDataNetworkName(): string;
    set mobileNetworkDataNetworkName(value: string);
    get mobileNetworkDataNetworkNameInput(): string | undefined;
    private _mobileNetworkPacketCoreDataPlaneId?;
    get mobileNetworkPacketCoreDataPlaneId(): string;
    set mobileNetworkPacketCoreDataPlaneId(value: string);
    get mobileNetworkPacketCoreDataPlaneIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _userEquipmentAddressPoolPrefixes?;
    get userEquipmentAddressPoolPrefixes(): string[];
    set userEquipmentAddressPoolPrefixes(value: string[]);
    resetUserEquipmentAddressPoolPrefixes(): void;
    get userEquipmentAddressPoolPrefixesInput(): string[] | undefined;
    private _userEquipmentStaticAddressPoolPrefixes?;
    get userEquipmentStaticAddressPoolPrefixes(): string[];
    set userEquipmentStaticAddressPoolPrefixes(value: string[]);
    resetUserEquipmentStaticAddressPoolPrefixes(): void;
    get userEquipmentStaticAddressPoolPrefixesInput(): string[] | undefined;
    private _userPlaneAccessIpv4Address?;
    get userPlaneAccessIpv4Address(): string;
    set userPlaneAccessIpv4Address(value: string);
    resetUserPlaneAccessIpv4Address(): void;
    get userPlaneAccessIpv4AddressInput(): string | undefined;
    private _userPlaneAccessIpv4Gateway?;
    get userPlaneAccessIpv4Gateway(): string;
    set userPlaneAccessIpv4Gateway(value: string);
    resetUserPlaneAccessIpv4Gateway(): void;
    get userPlaneAccessIpv4GatewayInput(): string | undefined;
    private _userPlaneAccessIpv4Subnet?;
    get userPlaneAccessIpv4Subnet(): string;
    set userPlaneAccessIpv4Subnet(value: string);
    resetUserPlaneAccessIpv4Subnet(): void;
    get userPlaneAccessIpv4SubnetInput(): string | undefined;
    private _userPlaneAccessName?;
    get userPlaneAccessName(): string;
    set userPlaneAccessName(value: string);
    resetUserPlaneAccessName(): void;
    get userPlaneAccessNameInput(): string | undefined;
    private _networkAddressPortTranslation;
    get networkAddressPortTranslation(): MobileNetworkAttachedDataNetworkNetworkAddressPortTranslationOutputReference;
    putNetworkAddressPortTranslation(value: MobileNetworkAttachedDataNetworkNetworkAddressPortTranslation): void;
    resetNetworkAddressPortTranslation(): void;
    get networkAddressPortTranslationInput(): MobileNetworkAttachedDataNetworkNetworkAddressPortTranslation | undefined;
    private _timeouts;
    get timeouts(): MobileNetworkAttachedDataNetworkTimeoutsOutputReference;
    putTimeouts(value: MobileNetworkAttachedDataNetworkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MobileNetworkAttachedDataNetworkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
