/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MobileNetworkPacketCoreControlPlaneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#control_plane_access_ipv4_address MobileNetworkPacketCoreControlPlane#control_plane_access_ipv4_address}
    */
    readonly controlPlaneAccessIpv4Address?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#control_plane_access_ipv4_gateway MobileNetworkPacketCoreControlPlane#control_plane_access_ipv4_gateway}
    */
    readonly controlPlaneAccessIpv4Gateway?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#control_plane_access_ipv4_subnet MobileNetworkPacketCoreControlPlane#control_plane_access_ipv4_subnet}
    */
    readonly controlPlaneAccessIpv4Subnet?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#control_plane_access_name MobileNetworkPacketCoreControlPlane#control_plane_access_name}
    */
    readonly controlPlaneAccessName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#core_network_technology MobileNetworkPacketCoreControlPlane#core_network_technology}
    */
    readonly coreNetworkTechnology?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#id MobileNetworkPacketCoreControlPlane#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#interoperability_settings_json MobileNetworkPacketCoreControlPlane#interoperability_settings_json}
    */
    readonly interoperabilitySettingsJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#location MobileNetworkPacketCoreControlPlane#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#name MobileNetworkPacketCoreControlPlane#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#resource_group_name MobileNetworkPacketCoreControlPlane#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#site_ids MobileNetworkPacketCoreControlPlane#site_ids}
    */
    readonly siteIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#sku MobileNetworkPacketCoreControlPlane#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#software_version MobileNetworkPacketCoreControlPlane#software_version}
    */
    readonly softwareVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#tags MobileNetworkPacketCoreControlPlane#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#user_equipment_mtu_in_bytes MobileNetworkPacketCoreControlPlane#user_equipment_mtu_in_bytes}
    */
    readonly userEquipmentMtuInBytes?: number;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#identity MobileNetworkPacketCoreControlPlane#identity}
    */
    readonly identity?: MobileNetworkPacketCoreControlPlaneIdentity;
    /**
    * local_diagnostics_access block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#local_diagnostics_access MobileNetworkPacketCoreControlPlane#local_diagnostics_access}
    */
    readonly localDiagnosticsAccess: MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess;
    /**
    * platform block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#platform MobileNetworkPacketCoreControlPlane#platform}
    */
    readonly platform?: MobileNetworkPacketCoreControlPlanePlatform;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#timeouts MobileNetworkPacketCoreControlPlane#timeouts}
    */
    readonly timeouts?: MobileNetworkPacketCoreControlPlaneTimeouts;
}
export interface MobileNetworkPacketCoreControlPlaneIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#identity_ids MobileNetworkPacketCoreControlPlane#identity_ids}
    */
    readonly identityIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#type MobileNetworkPacketCoreControlPlane#type}
    */
    readonly type: string;
}
export declare function mobileNetworkPacketCoreControlPlaneIdentityToTerraform(struct?: MobileNetworkPacketCoreControlPlaneIdentityOutputReference | MobileNetworkPacketCoreControlPlaneIdentity): any;
export declare function mobileNetworkPacketCoreControlPlaneIdentityToHclTerraform(struct?: MobileNetworkPacketCoreControlPlaneIdentityOutputReference | MobileNetworkPacketCoreControlPlaneIdentity): any;
export declare class MobileNetworkPacketCoreControlPlaneIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkPacketCoreControlPlaneIdentity | undefined;
    set internalValue(value: MobileNetworkPacketCoreControlPlaneIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    get identityIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#authentication_type MobileNetworkPacketCoreControlPlane#authentication_type}
    */
    readonly authenticationType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#https_server_certificate_url MobileNetworkPacketCoreControlPlane#https_server_certificate_url}
    */
    readonly httpsServerCertificateUrl?: string;
}
export declare function mobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessToTerraform(struct?: MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessOutputReference | MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess): any;
export declare function mobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessToHclTerraform(struct?: MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessOutputReference | MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess): any;
export declare class MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess | undefined;
    set internalValue(value: MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess | undefined);
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    get authenticationTypeInput(): string | undefined;
    private _httpsServerCertificateUrl?;
    get httpsServerCertificateUrl(): string;
    set httpsServerCertificateUrl(value: string);
    resetHttpsServerCertificateUrl(): void;
    get httpsServerCertificateUrlInput(): string | undefined;
}
export interface MobileNetworkPacketCoreControlPlanePlatform {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#arc_kubernetes_cluster_id MobileNetworkPacketCoreControlPlane#arc_kubernetes_cluster_id}
    */
    readonly arcKubernetesClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#custom_location_id MobileNetworkPacketCoreControlPlane#custom_location_id}
    */
    readonly customLocationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#edge_device_id MobileNetworkPacketCoreControlPlane#edge_device_id}
    */
    readonly edgeDeviceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#stack_hci_cluster_id MobileNetworkPacketCoreControlPlane#stack_hci_cluster_id}
    */
    readonly stackHciClusterId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#type MobileNetworkPacketCoreControlPlane#type}
    */
    readonly type: string;
}
export declare function mobileNetworkPacketCoreControlPlanePlatformToTerraform(struct?: MobileNetworkPacketCoreControlPlanePlatformOutputReference | MobileNetworkPacketCoreControlPlanePlatform): any;
export declare function mobileNetworkPacketCoreControlPlanePlatformToHclTerraform(struct?: MobileNetworkPacketCoreControlPlanePlatformOutputReference | MobileNetworkPacketCoreControlPlanePlatform): any;
export declare class MobileNetworkPacketCoreControlPlanePlatformOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkPacketCoreControlPlanePlatform | undefined;
    set internalValue(value: MobileNetworkPacketCoreControlPlanePlatform | undefined);
    private _arcKubernetesClusterId?;
    get arcKubernetesClusterId(): string;
    set arcKubernetesClusterId(value: string);
    resetArcKubernetesClusterId(): void;
    get arcKubernetesClusterIdInput(): string | undefined;
    private _customLocationId?;
    get customLocationId(): string;
    set customLocationId(value: string);
    resetCustomLocationId(): void;
    get customLocationIdInput(): string | undefined;
    private _edgeDeviceId?;
    get edgeDeviceId(): string;
    set edgeDeviceId(value: string);
    resetEdgeDeviceId(): void;
    get edgeDeviceIdInput(): string | undefined;
    private _stackHciClusterId?;
    get stackHciClusterId(): string;
    set stackHciClusterId(value: string);
    resetStackHciClusterId(): void;
    get stackHciClusterIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MobileNetworkPacketCoreControlPlaneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#create MobileNetworkPacketCoreControlPlane#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#delete MobileNetworkPacketCoreControlPlane#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#read MobileNetworkPacketCoreControlPlane#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#update MobileNetworkPacketCoreControlPlane#update}
    */
    readonly update?: string;
}
export declare function mobileNetworkPacketCoreControlPlaneTimeoutsToTerraform(struct?: MobileNetworkPacketCoreControlPlaneTimeouts | cdktf.IResolvable): any;
export declare function mobileNetworkPacketCoreControlPlaneTimeoutsToHclTerraform(struct?: MobileNetworkPacketCoreControlPlaneTimeouts | cdktf.IResolvable): any;
export declare class MobileNetworkPacketCoreControlPlaneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkPacketCoreControlPlaneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkPacketCoreControlPlaneTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane azurerm_mobile_network_packet_core_control_plane}
*/
export declare class MobileNetworkPacketCoreControlPlane extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mobile_network_packet_core_control_plane";
    /**
    * Generates CDKTF code for importing a MobileNetworkPacketCoreControlPlane resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MobileNetworkPacketCoreControlPlane to import
    * @param importFromId The id of the existing MobileNetworkPacketCoreControlPlane that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MobileNetworkPacketCoreControlPlane to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/mobile_network_packet_core_control_plane azurerm_mobile_network_packet_core_control_plane} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MobileNetworkPacketCoreControlPlaneConfig
    */
    constructor(scope: Construct, id: string, config: MobileNetworkPacketCoreControlPlaneConfig);
    private _controlPlaneAccessIpv4Address?;
    get controlPlaneAccessIpv4Address(): string;
    set controlPlaneAccessIpv4Address(value: string);
    resetControlPlaneAccessIpv4Address(): void;
    get controlPlaneAccessIpv4AddressInput(): string | undefined;
    private _controlPlaneAccessIpv4Gateway?;
    get controlPlaneAccessIpv4Gateway(): string;
    set controlPlaneAccessIpv4Gateway(value: string);
    resetControlPlaneAccessIpv4Gateway(): void;
    get controlPlaneAccessIpv4GatewayInput(): string | undefined;
    private _controlPlaneAccessIpv4Subnet?;
    get controlPlaneAccessIpv4Subnet(): string;
    set controlPlaneAccessIpv4Subnet(value: string);
    resetControlPlaneAccessIpv4Subnet(): void;
    get controlPlaneAccessIpv4SubnetInput(): string | undefined;
    private _controlPlaneAccessName?;
    get controlPlaneAccessName(): string;
    set controlPlaneAccessName(value: string);
    resetControlPlaneAccessName(): void;
    get controlPlaneAccessNameInput(): string | undefined;
    private _coreNetworkTechnology?;
    get coreNetworkTechnology(): string;
    set coreNetworkTechnology(value: string);
    resetCoreNetworkTechnology(): void;
    get coreNetworkTechnologyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _interoperabilitySettingsJson?;
    get interoperabilitySettingsJson(): string;
    set interoperabilitySettingsJson(value: string);
    resetInteroperabilitySettingsJson(): void;
    get interoperabilitySettingsJsonInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _siteIds?;
    get siteIds(): string[];
    set siteIds(value: string[]);
    get siteIdsInput(): string[] | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _softwareVersion?;
    get softwareVersion(): string;
    set softwareVersion(value: string);
    resetSoftwareVersion(): void;
    get softwareVersionInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _userEquipmentMtuInBytes?;
    get userEquipmentMtuInBytes(): number;
    set userEquipmentMtuInBytes(value: number);
    resetUserEquipmentMtuInBytes(): void;
    get userEquipmentMtuInBytesInput(): number | undefined;
    private _identity;
    get identity(): MobileNetworkPacketCoreControlPlaneIdentityOutputReference;
    putIdentity(value: MobileNetworkPacketCoreControlPlaneIdentity): void;
    resetIdentity(): void;
    get identityInput(): MobileNetworkPacketCoreControlPlaneIdentity | undefined;
    private _localDiagnosticsAccess;
    get localDiagnosticsAccess(): MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessOutputReference;
    putLocalDiagnosticsAccess(value: MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess): void;
    get localDiagnosticsAccessInput(): MobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess | undefined;
    private _platform;
    get platform(): MobileNetworkPacketCoreControlPlanePlatformOutputReference;
    putPlatform(value: MobileNetworkPacketCoreControlPlanePlatform): void;
    resetPlatform(): void;
    get platformInput(): MobileNetworkPacketCoreControlPlanePlatform | undefined;
    private _timeouts;
    get timeouts(): MobileNetworkPacketCoreControlPlaneTimeoutsOutputReference;
    putTimeouts(value: MobileNetworkPacketCoreControlPlaneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MobileNetworkPacketCoreControlPlaneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
