/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OracleExadataInfrastructureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#compute_count OracleExadataInfrastructure#compute_count}
    */
    readonly computeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#customer_contacts OracleExadataInfrastructure#customer_contacts}
    */
    readonly customerContacts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#display_name OracleExadataInfrastructure#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#id OracleExadataInfrastructure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#location OracleExadataInfrastructure#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#name OracleExadataInfrastructure#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#resource_group_name OracleExadataInfrastructure#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#shape OracleExadataInfrastructure#shape}
    */
    readonly shape: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#storage_count OracleExadataInfrastructure#storage_count}
    */
    readonly storageCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#tags OracleExadataInfrastructure#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#zones OracleExadataInfrastructure#zones}
    */
    readonly zones: string[];
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#maintenance_window OracleExadataInfrastructure#maintenance_window}
    */
    readonly maintenanceWindow?: OracleExadataInfrastructureMaintenanceWindow[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#timeouts OracleExadataInfrastructure#timeouts}
    */
    readonly timeouts?: OracleExadataInfrastructureTimeouts;
}
export interface OracleExadataInfrastructureMaintenanceWindow {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#days_of_week OracleExadataInfrastructure#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#hours_of_day OracleExadataInfrastructure#hours_of_day}
    */
    readonly hoursOfDay?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#lead_time_in_weeks OracleExadataInfrastructure#lead_time_in_weeks}
    */
    readonly leadTimeInWeeks?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#months OracleExadataInfrastructure#months}
    */
    readonly months?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#patching_mode OracleExadataInfrastructure#patching_mode}
    */
    readonly patchingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#preference OracleExadataInfrastructure#preference}
    */
    readonly preference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#weeks_of_month OracleExadataInfrastructure#weeks_of_month}
    */
    readonly weeksOfMonth?: number[];
}
export declare function oracleExadataInfrastructureMaintenanceWindowToTerraform(struct?: OracleExadataInfrastructureMaintenanceWindow | cdktf.IResolvable): any;
export declare function oracleExadataInfrastructureMaintenanceWindowToHclTerraform(struct?: OracleExadataInfrastructureMaintenanceWindow | cdktf.IResolvable): any;
export declare class OracleExadataInfrastructureMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OracleExadataInfrastructureMaintenanceWindow | cdktf.IResolvable | undefined;
    set internalValue(value: OracleExadataInfrastructureMaintenanceWindow | cdktf.IResolvable | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _hoursOfDay?;
    get hoursOfDay(): number[];
    set hoursOfDay(value: number[]);
    resetHoursOfDay(): void;
    get hoursOfDayInput(): number[] | undefined;
    private _leadTimeInWeeks?;
    get leadTimeInWeeks(): number;
    set leadTimeInWeeks(value: number);
    resetLeadTimeInWeeks(): void;
    get leadTimeInWeeksInput(): number | undefined;
    private _months?;
    get months(): string[];
    set months(value: string[]);
    resetMonths(): void;
    get monthsInput(): string[] | undefined;
    private _patchingMode?;
    get patchingMode(): string;
    set patchingMode(value: string);
    resetPatchingMode(): void;
    get patchingModeInput(): string | undefined;
    private _preference?;
    get preference(): string;
    set preference(value: string);
    resetPreference(): void;
    get preferenceInput(): string | undefined;
    private _weeksOfMonth?;
    get weeksOfMonth(): number[];
    set weeksOfMonth(value: number[]);
    resetWeeksOfMonth(): void;
    get weeksOfMonthInput(): number[] | undefined;
}
export declare class OracleExadataInfrastructureMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OracleExadataInfrastructureMaintenanceWindow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OracleExadataInfrastructureMaintenanceWindowOutputReference;
}
export interface OracleExadataInfrastructureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#create OracleExadataInfrastructure#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#delete OracleExadataInfrastructure#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#read OracleExadataInfrastructure#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#update OracleExadataInfrastructure#update}
    */
    readonly update?: string;
}
export declare function oracleExadataInfrastructureTimeoutsToTerraform(struct?: OracleExadataInfrastructureTimeouts | cdktf.IResolvable): any;
export declare function oracleExadataInfrastructureTimeoutsToHclTerraform(struct?: OracleExadataInfrastructureTimeouts | cdktf.IResolvable): any;
export declare class OracleExadataInfrastructureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OracleExadataInfrastructureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OracleExadataInfrastructureTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure azurerm_oracle_exadata_infrastructure}
*/
export declare class OracleExadataInfrastructure extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_oracle_exadata_infrastructure";
    /**
    * Generates CDKTF code for importing a OracleExadataInfrastructure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OracleExadataInfrastructure to import
    * @param importFromId The id of the existing OracleExadataInfrastructure that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OracleExadataInfrastructure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/oracle_exadata_infrastructure azurerm_oracle_exadata_infrastructure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OracleExadataInfrastructureConfig
    */
    constructor(scope: Construct, id: string, config: OracleExadataInfrastructureConfig);
    private _computeCount?;
    get computeCount(): number;
    set computeCount(value: number);
    get computeCountInput(): number | undefined;
    private _customerContacts?;
    get customerContacts(): string[];
    set customerContacts(value: string[]);
    resetCustomerContacts(): void;
    get customerContactsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _shape?;
    get shape(): string;
    set shape(value: string);
    get shapeInput(): string | undefined;
    private _storageCount?;
    get storageCount(): number;
    set storageCount(value: number);
    get storageCountInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    get zonesInput(): string[] | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): OracleExadataInfrastructureMaintenanceWindowList;
    putMaintenanceWindow(value: OracleExadataInfrastructureMaintenanceWindow[] | cdktf.IResolvable): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): cdktf.IResolvable | OracleExadataInfrastructureMaintenanceWindow[] | undefined;
    private _timeouts;
    get timeouts(): OracleExadataInfrastructureTimeoutsOutputReference;
    putTimeouts(value: OracleExadataInfrastructureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OracleExadataInfrastructureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
