/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PimActiveRoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#id PimActiveRoleAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The justification for this role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#justification PimActiveRoleAssignment#justification}
    */
    readonly justification?: string;
    /**
    * Object ID of the principal for this role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#principal_id PimActiveRoleAssignment#principal_id}
    */
    readonly principalId: string;
    /**
    * Role definition ID for this role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#role_definition_id PimActiveRoleAssignment#role_definition_id}
    */
    readonly roleDefinitionId: string;
    /**
    * Scope for this role assignment, should be a valid resource ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#scope PimActiveRoleAssignment#scope}
    */
    readonly scope: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#schedule PimActiveRoleAssignment#schedule}
    */
    readonly schedule?: PimActiveRoleAssignmentSchedule;
    /**
    * ticket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#ticket PimActiveRoleAssignment#ticket}
    */
    readonly ticket?: PimActiveRoleAssignmentTicket;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#timeouts PimActiveRoleAssignment#timeouts}
    */
    readonly timeouts?: PimActiveRoleAssignmentTimeouts;
}
export interface PimActiveRoleAssignmentScheduleExpiration {
    /**
    * The duration of the role assignment in days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#duration_days PimActiveRoleAssignment#duration_days}
    */
    readonly durationDays?: number;
    /**
    * The duration of the role assignment in hours
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#duration_hours PimActiveRoleAssignment#duration_hours}
    */
    readonly durationHours?: number;
    /**
    * The end date/time of the role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#end_date_time PimActiveRoleAssignment#end_date_time}
    */
    readonly endDateTime?: string;
}
export declare function pimActiveRoleAssignmentScheduleExpirationToTerraform(struct?: PimActiveRoleAssignmentScheduleExpirationOutputReference | PimActiveRoleAssignmentScheduleExpiration): any;
export declare function pimActiveRoleAssignmentScheduleExpirationToHclTerraform(struct?: PimActiveRoleAssignmentScheduleExpirationOutputReference | PimActiveRoleAssignmentScheduleExpiration): any;
export declare class PimActiveRoleAssignmentScheduleExpirationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PimActiveRoleAssignmentScheduleExpiration | undefined;
    set internalValue(value: PimActiveRoleAssignmentScheduleExpiration | undefined);
    private _durationDays?;
    get durationDays(): number;
    set durationDays(value: number);
    resetDurationDays(): void;
    get durationDaysInput(): number | undefined;
    private _durationHours?;
    get durationHours(): number;
    set durationHours(value: number);
    resetDurationHours(): void;
    get durationHoursInput(): number | undefined;
    private _endDateTime?;
    get endDateTime(): string;
    set endDateTime(value: string);
    resetEndDateTime(): void;
    get endDateTimeInput(): string | undefined;
}
export interface PimActiveRoleAssignmentSchedule {
    /**
    * The start date/time of the role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#start_date_time PimActiveRoleAssignment#start_date_time}
    */
    readonly startDateTime?: string;
    /**
    * expiration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#expiration PimActiveRoleAssignment#expiration}
    */
    readonly expiration?: PimActiveRoleAssignmentScheduleExpiration;
}
export declare function pimActiveRoleAssignmentScheduleToTerraform(struct?: PimActiveRoleAssignmentScheduleOutputReference | PimActiveRoleAssignmentSchedule): any;
export declare function pimActiveRoleAssignmentScheduleToHclTerraform(struct?: PimActiveRoleAssignmentScheduleOutputReference | PimActiveRoleAssignmentSchedule): any;
export declare class PimActiveRoleAssignmentScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PimActiveRoleAssignmentSchedule | undefined;
    set internalValue(value: PimActiveRoleAssignmentSchedule | undefined);
    private _startDateTime?;
    get startDateTime(): string;
    set startDateTime(value: string);
    resetStartDateTime(): void;
    get startDateTimeInput(): string | undefined;
    private _expiration;
    get expiration(): PimActiveRoleAssignmentScheduleExpirationOutputReference;
    putExpiration(value: PimActiveRoleAssignmentScheduleExpiration): void;
    resetExpiration(): void;
    get expirationInput(): PimActiveRoleAssignmentScheduleExpiration | undefined;
}
export interface PimActiveRoleAssignmentTicket {
    /**
    * User-supplied ticket number to be included with the request
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#number PimActiveRoleAssignment#number}
    */
    readonly number?: string;
    /**
    * User-supplied ticket system name to be included with the request
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#system PimActiveRoleAssignment#system}
    */
    readonly systemAttribute?: string;
}
export declare function pimActiveRoleAssignmentTicketToTerraform(struct?: PimActiveRoleAssignmentTicketOutputReference | PimActiveRoleAssignmentTicket): any;
export declare function pimActiveRoleAssignmentTicketToHclTerraform(struct?: PimActiveRoleAssignmentTicketOutputReference | PimActiveRoleAssignmentTicket): any;
export declare class PimActiveRoleAssignmentTicketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PimActiveRoleAssignmentTicket | undefined;
    set internalValue(value: PimActiveRoleAssignmentTicket | undefined);
    private _number?;
    get number(): string;
    set number(value: string);
    resetNumber(): void;
    get numberInput(): string | undefined;
    private _system?;
    get systemAttribute(): string;
    set systemAttribute(value: string);
    resetSystemAttribute(): void;
    get systemAttributeInput(): string | undefined;
}
export interface PimActiveRoleAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#create PimActiveRoleAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#delete PimActiveRoleAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#read PimActiveRoleAssignment#read}
    */
    readonly read?: string;
}
export declare function pimActiveRoleAssignmentTimeoutsToTerraform(struct?: PimActiveRoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare function pimActiveRoleAssignmentTimeoutsToHclTerraform(struct?: PimActiveRoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare class PimActiveRoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PimActiveRoleAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PimActiveRoleAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment azurerm_pim_active_role_assignment}
*/
export declare class PimActiveRoleAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_pim_active_role_assignment";
    /**
    * Generates CDKTF code for importing a PimActiveRoleAssignment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PimActiveRoleAssignment to import
    * @param importFromId The id of the existing PimActiveRoleAssignment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PimActiveRoleAssignment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_active_role_assignment azurerm_pim_active_role_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PimActiveRoleAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: PimActiveRoleAssignmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _justification?;
    get justification(): string;
    set justification(value: string);
    resetJustification(): void;
    get justificationInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    get principalIdInput(): string | undefined;
    get principalType(): string;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    get roleDefinitionIdInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _schedule;
    get schedule(): PimActiveRoleAssignmentScheduleOutputReference;
    putSchedule(value: PimActiveRoleAssignmentSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): PimActiveRoleAssignmentSchedule | undefined;
    private _ticket;
    get ticket(): PimActiveRoleAssignmentTicketOutputReference;
    putTicket(value: PimActiveRoleAssignmentTicket): void;
    resetTicket(): void;
    get ticketInput(): PimActiveRoleAssignmentTicket | undefined;
    private _timeouts;
    get timeouts(): PimActiveRoleAssignmentTimeoutsOutputReference;
    putTimeouts(value: PimActiveRoleAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PimActiveRoleAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
