/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PimEligibleRoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#id PimEligibleRoleAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The justification for this eligible role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#justification PimEligibleRoleAssignment#justification}
    */
    readonly justification?: string;
    /**
    * Object ID of the principal for this eligible role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#principal_id PimEligibleRoleAssignment#principal_id}
    */
    readonly principalId: string;
    /**
    * Role definition ID for this eligible role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#role_definition_id PimEligibleRoleAssignment#role_definition_id}
    */
    readonly roleDefinitionId: string;
    /**
    * Scope for this eligible role assignment, should be a valid resource ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#scope PimEligibleRoleAssignment#scope}
    */
    readonly scope: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#schedule PimEligibleRoleAssignment#schedule}
    */
    readonly schedule?: PimEligibleRoleAssignmentSchedule;
    /**
    * ticket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#ticket PimEligibleRoleAssignment#ticket}
    */
    readonly ticket?: PimEligibleRoleAssignmentTicket;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#timeouts PimEligibleRoleAssignment#timeouts}
    */
    readonly timeouts?: PimEligibleRoleAssignmentTimeouts;
}
export interface PimEligibleRoleAssignmentScheduleExpiration {
    /**
    * The duration of the eligible role assignment in days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#duration_days PimEligibleRoleAssignment#duration_days}
    */
    readonly durationDays?: number;
    /**
    * The duration of the eligible role assignment in hours
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#duration_hours PimEligibleRoleAssignment#duration_hours}
    */
    readonly durationHours?: number;
    /**
    * The end date/time of the eligible role assignment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#end_date_time PimEligibleRoleAssignment#end_date_time}
    */
    readonly endDateTime?: string;
}
export declare function pimEligibleRoleAssignmentScheduleExpirationToTerraform(struct?: PimEligibleRoleAssignmentScheduleExpirationOutputReference | PimEligibleRoleAssignmentScheduleExpiration): any;
export declare function pimEligibleRoleAssignmentScheduleExpirationToHclTerraform(struct?: PimEligibleRoleAssignmentScheduleExpirationOutputReference | PimEligibleRoleAssignmentScheduleExpiration): any;
export declare class PimEligibleRoleAssignmentScheduleExpirationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PimEligibleRoleAssignmentScheduleExpiration | undefined;
    set internalValue(value: PimEligibleRoleAssignmentScheduleExpiration | undefined);
    private _durationDays?;
    get durationDays(): number;
    set durationDays(value: number);
    resetDurationDays(): void;
    get durationDaysInput(): number | undefined;
    private _durationHours?;
    get durationHours(): number;
    set durationHours(value: number);
    resetDurationHours(): void;
    get durationHoursInput(): number | undefined;
    private _endDateTime?;
    get endDateTime(): string;
    set endDateTime(value: string);
    resetEndDateTime(): void;
    get endDateTimeInput(): string | undefined;
}
export interface PimEligibleRoleAssignmentSchedule {
    /**
    * The start date/time
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#start_date_time PimEligibleRoleAssignment#start_date_time}
    */
    readonly startDateTime?: string;
    /**
    * expiration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#expiration PimEligibleRoleAssignment#expiration}
    */
    readonly expiration?: PimEligibleRoleAssignmentScheduleExpiration;
}
export declare function pimEligibleRoleAssignmentScheduleToTerraform(struct?: PimEligibleRoleAssignmentScheduleOutputReference | PimEligibleRoleAssignmentSchedule): any;
export declare function pimEligibleRoleAssignmentScheduleToHclTerraform(struct?: PimEligibleRoleAssignmentScheduleOutputReference | PimEligibleRoleAssignmentSchedule): any;
export declare class PimEligibleRoleAssignmentScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PimEligibleRoleAssignmentSchedule | undefined;
    set internalValue(value: PimEligibleRoleAssignmentSchedule | undefined);
    private _startDateTime?;
    get startDateTime(): string;
    set startDateTime(value: string);
    resetStartDateTime(): void;
    get startDateTimeInput(): string | undefined;
    private _expiration;
    get expiration(): PimEligibleRoleAssignmentScheduleExpirationOutputReference;
    putExpiration(value: PimEligibleRoleAssignmentScheduleExpiration): void;
    resetExpiration(): void;
    get expirationInput(): PimEligibleRoleAssignmentScheduleExpiration | undefined;
}
export interface PimEligibleRoleAssignmentTicket {
    /**
    * User-supplied ticket number to be included with the request
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#number PimEligibleRoleAssignment#number}
    */
    readonly number?: string;
    /**
    * User-supplied ticket system name to be included with the request
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#system PimEligibleRoleAssignment#system}
    */
    readonly systemAttribute?: string;
}
export declare function pimEligibleRoleAssignmentTicketToTerraform(struct?: PimEligibleRoleAssignmentTicketOutputReference | PimEligibleRoleAssignmentTicket): any;
export declare function pimEligibleRoleAssignmentTicketToHclTerraform(struct?: PimEligibleRoleAssignmentTicketOutputReference | PimEligibleRoleAssignmentTicket): any;
export declare class PimEligibleRoleAssignmentTicketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PimEligibleRoleAssignmentTicket | undefined;
    set internalValue(value: PimEligibleRoleAssignmentTicket | undefined);
    private _number?;
    get number(): string;
    set number(value: string);
    resetNumber(): void;
    get numberInput(): string | undefined;
    private _system?;
    get systemAttribute(): string;
    set systemAttribute(value: string);
    resetSystemAttribute(): void;
    get systemAttributeInput(): string | undefined;
}
export interface PimEligibleRoleAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#create PimEligibleRoleAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#delete PimEligibleRoleAssignment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#read PimEligibleRoleAssignment#read}
    */
    readonly read?: string;
}
export declare function pimEligibleRoleAssignmentTimeoutsToTerraform(struct?: PimEligibleRoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare function pimEligibleRoleAssignmentTimeoutsToHclTerraform(struct?: PimEligibleRoleAssignmentTimeouts | cdktf.IResolvable): any;
export declare class PimEligibleRoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PimEligibleRoleAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PimEligibleRoleAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment azurerm_pim_eligible_role_assignment}
*/
export declare class PimEligibleRoleAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_pim_eligible_role_assignment";
    /**
    * Generates CDKTF code for importing a PimEligibleRoleAssignment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PimEligibleRoleAssignment to import
    * @param importFromId The id of the existing PimEligibleRoleAssignment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PimEligibleRoleAssignment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/pim_eligible_role_assignment azurerm_pim_eligible_role_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PimEligibleRoleAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: PimEligibleRoleAssignmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _justification?;
    get justification(): string;
    set justification(value: string);
    resetJustification(): void;
    get justificationInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    get principalIdInput(): string | undefined;
    get principalType(): string;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    get roleDefinitionIdInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _schedule;
    get schedule(): PimEligibleRoleAssignmentScheduleOutputReference;
    putSchedule(value: PimEligibleRoleAssignmentSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): PimEligibleRoleAssignmentSchedule | undefined;
    private _ticket;
    get ticket(): PimEligibleRoleAssignmentTicketOutputReference;
    putTicket(value: PimEligibleRoleAssignmentTicket): void;
    resetTicket(): void;
    get ticketInput(): PimEligibleRoleAssignmentTicket | undefined;
    private _timeouts;
    get timeouts(): PimEligibleRoleAssignmentTimeoutsOutputReference;
    putTimeouts(value: PimEligibleRoleAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PimEligibleRoleAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
