/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterServerVulnerabilityAssessmentVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine#id SecurityCenterServerVulnerabilityAssessmentVirtualMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine#virtual_machine_id SecurityCenterServerVulnerabilityAssessmentVirtualMachine#virtual_machine_id}
    */
    readonly virtualMachineId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine#timeouts SecurityCenterServerVulnerabilityAssessmentVirtualMachine#timeouts}
    */
    readonly timeouts?: SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeouts;
}
export interface SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine#create SecurityCenterServerVulnerabilityAssessmentVirtualMachine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine#delete SecurityCenterServerVulnerabilityAssessmentVirtualMachine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine#read SecurityCenterServerVulnerabilityAssessmentVirtualMachine#read}
    */
    readonly read?: string;
}
export declare function securityCenterServerVulnerabilityAssessmentVirtualMachineTimeoutsToTerraform(struct?: SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeouts | cdktf.IResolvable): any;
export declare function securityCenterServerVulnerabilityAssessmentVirtualMachineTimeoutsToHclTerraform(struct?: SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine azurerm_security_center_server_vulnerability_assessment_virtual_machine}
*/
export declare class SecurityCenterServerVulnerabilityAssessmentVirtualMachine extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_server_vulnerability_assessment_virtual_machine";
    /**
    * Generates CDKTF code for importing a SecurityCenterServerVulnerabilityAssessmentVirtualMachine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityCenterServerVulnerabilityAssessmentVirtualMachine to import
    * @param importFromId The id of the existing SecurityCenterServerVulnerabilityAssessmentVirtualMachine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityCenterServerVulnerabilityAssessmentVirtualMachine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/security_center_server_vulnerability_assessment_virtual_machine azurerm_security_center_server_vulnerability_assessment_virtual_machine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterServerVulnerabilityAssessmentVirtualMachineConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterServerVulnerabilityAssessmentVirtualMachineConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    get virtualMachineIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurityCenterServerVulnerabilityAssessmentVirtualMachineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
