/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageAccountNetworkRulesAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#bypass StorageAccountNetworkRulesA#bypass}
    */
    readonly bypass?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#default_action StorageAccountNetworkRulesA#default_action}
    */
    readonly defaultAction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#id StorageAccountNetworkRulesA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#ip_rules StorageAccountNetworkRulesA#ip_rules}
    */
    readonly ipRules?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#storage_account_id StorageAccountNetworkRulesA#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#virtual_network_subnet_ids StorageAccountNetworkRulesA#virtual_network_subnet_ids}
    */
    readonly virtualNetworkSubnetIds?: string[];
    /**
    * private_link_access block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#private_link_access StorageAccountNetworkRulesA#private_link_access}
    */
    readonly privateLinkAccess?: StorageAccountNetworkRulesPrivateLinkAccessA[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#timeouts StorageAccountNetworkRulesA#timeouts}
    */
    readonly timeouts?: StorageAccountNetworkRulesTimeouts;
}
export interface StorageAccountNetworkRulesPrivateLinkAccessA {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#endpoint_resource_id StorageAccountNetworkRulesA#endpoint_resource_id}
    */
    readonly endpointResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#endpoint_tenant_id StorageAccountNetworkRulesA#endpoint_tenant_id}
    */
    readonly endpointTenantId?: string;
}
export declare function storageAccountNetworkRulesPrivateLinkAccessAToTerraform(struct?: StorageAccountNetworkRulesPrivateLinkAccessA | cdktf.IResolvable): any;
export declare function storageAccountNetworkRulesPrivateLinkAccessAToHclTerraform(struct?: StorageAccountNetworkRulesPrivateLinkAccessA | cdktf.IResolvable): any;
export declare class StorageAccountNetworkRulesPrivateLinkAccessAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageAccountNetworkRulesPrivateLinkAccessA | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountNetworkRulesPrivateLinkAccessA | cdktf.IResolvable | undefined);
    private _endpointResourceId?;
    get endpointResourceId(): string;
    set endpointResourceId(value: string);
    get endpointResourceIdInput(): string | undefined;
    private _endpointTenantId?;
    get endpointTenantId(): string;
    set endpointTenantId(value: string);
    resetEndpointTenantId(): void;
    get endpointTenantIdInput(): string | undefined;
}
export declare class StorageAccountNetworkRulesPrivateLinkAccessAList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageAccountNetworkRulesPrivateLinkAccessA[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageAccountNetworkRulesPrivateLinkAccessAOutputReference;
}
export interface StorageAccountNetworkRulesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#create StorageAccountNetworkRulesA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#delete StorageAccountNetworkRulesA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#read StorageAccountNetworkRulesA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#update StorageAccountNetworkRulesA#update}
    */
    readonly update?: string;
}
export declare function storageAccountNetworkRulesTimeoutsToTerraform(struct?: StorageAccountNetworkRulesTimeouts | cdktf.IResolvable): any;
export declare function storageAccountNetworkRulesTimeoutsToHclTerraform(struct?: StorageAccountNetworkRulesTimeouts | cdktf.IResolvable): any;
export declare class StorageAccountNetworkRulesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageAccountNetworkRulesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageAccountNetworkRulesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules azurerm_storage_account_network_rules}
*/
export declare class StorageAccountNetworkRulesA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_account_network_rules";
    /**
    * Generates CDKTF code for importing a StorageAccountNetworkRulesA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageAccountNetworkRulesA to import
    * @param importFromId The id of the existing StorageAccountNetworkRulesA that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageAccountNetworkRulesA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_account_network_rules azurerm_storage_account_network_rules} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageAccountNetworkRulesAConfig
    */
    constructor(scope: Construct, id: string, config: StorageAccountNetworkRulesAConfig);
    private _bypass?;
    get bypass(): string[];
    set bypass(value: string[]);
    resetBypass(): void;
    get bypassInput(): string[] | undefined;
    private _defaultAction?;
    get defaultAction(): string;
    set defaultAction(value: string);
    get defaultActionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipRules?;
    get ipRules(): string[];
    set ipRules(value: string[]);
    resetIpRules(): void;
    get ipRulesInput(): string[] | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _virtualNetworkSubnetIds?;
    get virtualNetworkSubnetIds(): string[];
    set virtualNetworkSubnetIds(value: string[]);
    resetVirtualNetworkSubnetIds(): void;
    get virtualNetworkSubnetIdsInput(): string[] | undefined;
    private _privateLinkAccess;
    get privateLinkAccess(): StorageAccountNetworkRulesPrivateLinkAccessAList;
    putPrivateLinkAccess(value: StorageAccountNetworkRulesPrivateLinkAccessA[] | cdktf.IResolvable): void;
    resetPrivateLinkAccess(): void;
    get privateLinkAccessInput(): cdktf.IResolvable | StorageAccountNetworkRulesPrivateLinkAccessA[] | undefined;
    private _timeouts;
    get timeouts(): StorageAccountNetworkRulesTimeoutsOutputReference;
    putTimeouts(value: StorageAccountNetworkRulesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageAccountNetworkRulesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
