/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageSyncServerEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#cloud_tiering_enabled StorageSyncServerEndpoint#cloud_tiering_enabled}
    */
    readonly cloudTieringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#id StorageSyncServerEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#initial_download_policy StorageSyncServerEndpoint#initial_download_policy}
    */
    readonly initialDownloadPolicy?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#local_cache_mode StorageSyncServerEndpoint#local_cache_mode}
    */
    readonly localCacheMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#name StorageSyncServerEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#registered_server_id StorageSyncServerEndpoint#registered_server_id}
    */
    readonly registeredServerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#server_local_path StorageSyncServerEndpoint#server_local_path}
    */
    readonly serverLocalPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#storage_sync_group_id StorageSyncServerEndpoint#storage_sync_group_id}
    */
    readonly storageSyncGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#tier_files_older_than_days StorageSyncServerEndpoint#tier_files_older_than_days}
    */
    readonly tierFilesOlderThanDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#volume_free_space_percent StorageSyncServerEndpoint#volume_free_space_percent}
    */
    readonly volumeFreeSpacePercent?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#timeouts StorageSyncServerEndpoint#timeouts}
    */
    readonly timeouts?: StorageSyncServerEndpointTimeouts;
}
export interface StorageSyncServerEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#create StorageSyncServerEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#delete StorageSyncServerEndpoint#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#read StorageSyncServerEndpoint#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#update StorageSyncServerEndpoint#update}
    */
    readonly update?: string;
}
export declare function storageSyncServerEndpointTimeoutsToTerraform(struct?: StorageSyncServerEndpointTimeouts | cdktf.IResolvable): any;
export declare function storageSyncServerEndpointTimeoutsToHclTerraform(struct?: StorageSyncServerEndpointTimeouts | cdktf.IResolvable): any;
export declare class StorageSyncServerEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageSyncServerEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageSyncServerEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint azurerm_storage_sync_server_endpoint}
*/
export declare class StorageSyncServerEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_sync_server_endpoint";
    /**
    * Generates CDKTF code for importing a StorageSyncServerEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageSyncServerEndpoint to import
    * @param importFromId The id of the existing StorageSyncServerEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageSyncServerEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/storage_sync_server_endpoint azurerm_storage_sync_server_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageSyncServerEndpointConfig
    */
    constructor(scope: Construct, id: string, config: StorageSyncServerEndpointConfig);
    private _cloudTieringEnabled?;
    get cloudTieringEnabled(): boolean | cdktf.IResolvable;
    set cloudTieringEnabled(value: boolean | cdktf.IResolvable);
    resetCloudTieringEnabled(): void;
    get cloudTieringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialDownloadPolicy?;
    get initialDownloadPolicy(): string;
    set initialDownloadPolicy(value: string);
    resetInitialDownloadPolicy(): void;
    get initialDownloadPolicyInput(): string | undefined;
    private _localCacheMode?;
    get localCacheMode(): string;
    set localCacheMode(value: string);
    resetLocalCacheMode(): void;
    get localCacheModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _registeredServerId?;
    get registeredServerId(): string;
    set registeredServerId(value: string);
    get registeredServerIdInput(): string | undefined;
    private _serverLocalPath?;
    get serverLocalPath(): string;
    set serverLocalPath(value: string);
    get serverLocalPathInput(): string | undefined;
    private _storageSyncGroupId?;
    get storageSyncGroupId(): string;
    set storageSyncGroupId(value: string);
    get storageSyncGroupIdInput(): string | undefined;
    private _tierFilesOlderThanDays?;
    get tierFilesOlderThanDays(): number;
    set tierFilesOlderThanDays(value: number);
    resetTierFilesOlderThanDays(): void;
    get tierFilesOlderThanDaysInput(): number | undefined;
    private _volumeFreeSpacePercent?;
    get volumeFreeSpacePercent(): number;
    set volumeFreeSpacePercent(value: number);
    resetVolumeFreeSpacePercent(): void;
    get volumeFreeSpacePercentInput(): number | undefined;
    private _timeouts;
    get timeouts(): StorageSyncServerEndpointTimeoutsOutputReference;
    putTimeouts(value: StorageSyncServerEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageSyncServerEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
