/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualDesktopApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#application_group_id VirtualDesktopApplication#application_group_id}
    */
    readonly applicationGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#command_line_argument_policy VirtualDesktopApplication#command_line_argument_policy}
    */
    readonly commandLineArgumentPolicy: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#command_line_arguments VirtualDesktopApplication#command_line_arguments}
    */
    readonly commandLineArguments?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#description VirtualDesktopApplication#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#friendly_name VirtualDesktopApplication#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#icon_index VirtualDesktopApplication#icon_index}
    */
    readonly iconIndex?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#icon_path VirtualDesktopApplication#icon_path}
    */
    readonly iconPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#id VirtualDesktopApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#name VirtualDesktopApplication#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#path VirtualDesktopApplication#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#show_in_portal VirtualDesktopApplication#show_in_portal}
    */
    readonly showInPortal?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#timeouts VirtualDesktopApplication#timeouts}
    */
    readonly timeouts?: VirtualDesktopApplicationTimeouts;
}
export interface VirtualDesktopApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#create VirtualDesktopApplication#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#delete VirtualDesktopApplication#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#read VirtualDesktopApplication#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#update VirtualDesktopApplication#update}
    */
    readonly update?: string;
}
export declare function virtualDesktopApplicationTimeoutsToTerraform(struct?: VirtualDesktopApplicationTimeouts | cdktf.IResolvable): any;
export declare function virtualDesktopApplicationTimeoutsToHclTerraform(struct?: VirtualDesktopApplicationTimeouts | cdktf.IResolvable): any;
export declare class VirtualDesktopApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualDesktopApplicationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualDesktopApplicationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application azurerm_virtual_desktop_application}
*/
export declare class VirtualDesktopApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_desktop_application";
    /**
    * Generates CDKTF code for importing a VirtualDesktopApplication resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualDesktopApplication to import
    * @param importFromId The id of the existing VirtualDesktopApplication that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualDesktopApplication to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_desktop_application azurerm_virtual_desktop_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualDesktopApplicationConfig
    */
    constructor(scope: Construct, id: string, config: VirtualDesktopApplicationConfig);
    private _applicationGroupId?;
    get applicationGroupId(): string;
    set applicationGroupId(value: string);
    get applicationGroupIdInput(): string | undefined;
    private _commandLineArgumentPolicy?;
    get commandLineArgumentPolicy(): string;
    set commandLineArgumentPolicy(value: string);
    get commandLineArgumentPolicyInput(): string | undefined;
    private _commandLineArguments?;
    get commandLineArguments(): string;
    set commandLineArguments(value: string);
    resetCommandLineArguments(): void;
    get commandLineArgumentsInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _iconIndex?;
    get iconIndex(): number;
    set iconIndex(value: number);
    resetIconIndex(): void;
    get iconIndexInput(): number | undefined;
    private _iconPath?;
    get iconPath(): string;
    set iconPath(value: string);
    resetIconPath(): void;
    get iconPathInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _showInPortal?;
    get showInPortal(): boolean | cdktf.IResolvable;
    set showInPortal(value: boolean | cdktf.IResolvable);
    resetShowInPortal(): void;
    get showInPortalInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): VirtualDesktopApplicationTimeoutsOutputReference;
    putTimeouts(value: VirtualDesktopApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualDesktopApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
