/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualHubRouteTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#id VirtualHubRouteTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#labels VirtualHubRouteTable#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#name VirtualHubRouteTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#virtual_hub_id VirtualHubRouteTable#virtual_hub_id}
    */
    readonly virtualHubId: string;
    /**
    * route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#route VirtualHubRouteTable#route}
    */
    readonly route?: VirtualHubRouteTableRoute[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#timeouts VirtualHubRouteTable#timeouts}
    */
    readonly timeouts?: VirtualHubRouteTableTimeouts;
}
export interface VirtualHubRouteTableRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#destinations VirtualHubRouteTable#destinations}
    */
    readonly destinations: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#destinations_type VirtualHubRouteTable#destinations_type}
    */
    readonly destinationsType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#name VirtualHubRouteTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#next_hop VirtualHubRouteTable#next_hop}
    */
    readonly nextHop: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#next_hop_type VirtualHubRouteTable#next_hop_type}
    */
    readonly nextHopType?: string;
}
export declare function virtualHubRouteTableRouteToTerraform(struct?: VirtualHubRouteTableRoute | cdktf.IResolvable): any;
export declare function virtualHubRouteTableRouteToHclTerraform(struct?: VirtualHubRouteTableRoute | cdktf.IResolvable): any;
export declare class VirtualHubRouteTableRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualHubRouteTableRoute | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualHubRouteTableRoute | cdktf.IResolvable | undefined);
    private _destinations?;
    get destinations(): string[];
    set destinations(value: string[]);
    get destinationsInput(): string[] | undefined;
    private _destinationsType?;
    get destinationsType(): string;
    set destinationsType(value: string);
    get destinationsTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nextHop?;
    get nextHop(): string;
    set nextHop(value: string);
    get nextHopInput(): string | undefined;
    private _nextHopType?;
    get nextHopType(): string;
    set nextHopType(value: string);
    resetNextHopType(): void;
    get nextHopTypeInput(): string | undefined;
}
export declare class VirtualHubRouteTableRouteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualHubRouteTableRoute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualHubRouteTableRouteOutputReference;
}
export interface VirtualHubRouteTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#create VirtualHubRouteTable#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#delete VirtualHubRouteTable#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#read VirtualHubRouteTable#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#update VirtualHubRouteTable#update}
    */
    readonly update?: string;
}
export declare function virtualHubRouteTableTimeoutsToTerraform(struct?: VirtualHubRouteTableTimeouts | cdktf.IResolvable): any;
export declare function virtualHubRouteTableTimeoutsToHclTerraform(struct?: VirtualHubRouteTableTimeouts | cdktf.IResolvable): any;
export declare class VirtualHubRouteTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubRouteTableTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualHubRouteTableTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table azurerm_virtual_hub_route_table}
*/
export declare class VirtualHubRouteTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_hub_route_table";
    /**
    * Generates CDKTF code for importing a VirtualHubRouteTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualHubRouteTable to import
    * @param importFromId The id of the existing VirtualHubRouteTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualHubRouteTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.6.0/docs/resources/virtual_hub_route_table azurerm_virtual_hub_route_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualHubRouteTableConfig
    */
    constructor(scope: Construct, id: string, config: VirtualHubRouteTableConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
    private _route;
    get route(): VirtualHubRouteTableRouteList;
    putRoute(value: VirtualHubRouteTableRoute[] | cdktf.IResolvable): void;
    resetRoute(): void;
    get routeInput(): cdktf.IResolvable | VirtualHubRouteTableRoute[] | undefined;
    private _timeouts;
    get timeouts(): VirtualHubRouteTableTimeoutsOutputReference;
    putTimeouts(value: VirtualHubRouteTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualHubRouteTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
