"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return construct.node.stack.formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // if we have a string arn, we can extract the bucket name from it.
    if (props.bucketArn) {
        const resolved = construct.node.resolve(props.bucketArn);
        if (typeof (resolved) === 'string') {
            const components = construct.node.stack.parseArn(resolved);
            if (components.service !== 's3') {
                throw new Error('Invalid ARN. Expecting "s3" service:' + resolved);
            }
            if (components.resourceName) {
                throw new Error(`Bucket ARN must not contain a path`);
            }
            return components.resource;
        }
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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