"""
Apply access on a study.
"""

import obiba_mica.core as core
import obiba_mica.access as access

def add_arguments(parser):
    """
    Add command specific options
    """
    access.add_permission_arguments(parser, False)
    parser.add_argument('path', help='File path in Mica file system')

def do_command(args):
    """
    Execute access command
    """
    # Build and send requests
    access.validate_args(args)

    request = core.MicaClient.build(core.MicaClient.LoginInfo.parse(args)).new_request()

    if args.verbose:
        request.verbose()

    # send request
    if args.delete:
        request.delete()
    else:
        request.put()

    try:
        path = args.path
        while path.startswith('/'):
            path = path[1:]
        response = request.resource(access.do_ws(args, ['draft','file-access', path])).send()
    except Exception as e:
        print(Exception, e)

    # format response
    if response.code != 204:
        print(response.content)
