from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkIOXMLParser
import vtkmodules.vtkRenderingCore

class vtkBlueObeliskData(vtkmodules.vtkCommonCore.vtkObject):
    boiling_points:'getset_descriptor'
    covalent_radii:'getset_descriptor'
    default_colors:'getset_descriptor'
    electron_affinities:'getset_descriptor'
    electronic_configurations:'getset_descriptor'
    exact_masses:'getset_descriptor'
    families:'getset_descriptor'
    groups:'getset_descriptor'
    ionization_energies:'getset_descriptor'
    lower_names:'getset_descriptor'
    lower_symbols:'getset_descriptor'
    masses:'getset_descriptor'
    melting_points:'getset_descriptor'
    names:'getset_descriptor'
    number_of_elements:'getset_descriptor'
    pauling_electronegativities:'getset_descriptor'
    periodic_table_blocks:'getset_descriptor'
    periods:'getset_descriptor'
    symbols:'getset_descriptor'
    vdw_radii:'getset_descriptor'
    def GetBoilingPoints(self) -> 'vtkFloatArray': ...
    def GetCovalentRadii(self) -> 'vtkFloatArray': ...
    def GetDefaultColors(self) -> 'vtkFloatArray': ...
    def GetElectronAffinities(self) -> 'vtkFloatArray': ...
    def GetElectronicConfigurations(self) -> 'vtkStringArray': ...
    def GetExactMasses(self) -> 'vtkFloatArray': ...
    def GetFamilies(self) -> 'vtkStringArray': ...
    def GetGroups(self) -> 'vtkUnsignedShortArray': ...
    def GetIonizationEnergies(self) -> 'vtkFloatArray': ...
    def GetLowerNames(self) -> 'vtkStringArray': ...
    def GetLowerSymbols(self) -> 'vtkStringArray': ...
    def GetMasses(self) -> 'vtkFloatArray': ...
    def GetMeltingPoints(self) -> 'vtkFloatArray': ...
    def GetNames(self) -> 'vtkStringArray': ...
    def GetNumberOfElements(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPaulingElectronegativities(self) -> 'vtkFloatArray': ...
    def GetPeriodicTableBlocks(self) -> 'vtkStringArray': ...
    def GetPeriods(self) -> 'vtkUnsignedShortArray': ...
    def GetSymbols(self) -> 'vtkStringArray': ...
    def GetVDWRadii(self) -> 'vtkFloatArray': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsInitialized(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LockWriteMutex(self) -> None: ...
    def NewInstance(self) -> 'vtkBlueObeliskData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBlueObeliskData': ...
    def UnlockWriteMutex(self) -> None: ...

class vtkBlueObeliskDataParser(vtkmodules.vtkIOXMLParser.vtkXMLParser):
    target:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBlueObeliskDataParser': ...
    @overload
    def Parse(self) -> int: ...
    @overload
    def Parse(self, __a:str) -> int: ...
    @overload
    def Parse(self, __a:str, __b:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBlueObeliskDataParser': ...
    def SetTarget(self, bodr:'vtkBlueObeliskData') -> None: ...

class vtkMoleculeMapper(vtkmodules.vtkRenderingCore.vtkMapper):
    CovalentRadius:int
    CustomArrayRadius:int
    DiscreteByAtom:int
    SingleColor:int
    UnitRadius:int
    VDWRadius:int
    atom_color:'getset_descriptor'
    atom_color_mode:'getset_descriptor'
    atomic_radius_array_name:'getset_descriptor'
    atomic_radius_scale_factor:'getset_descriptor'
    atomic_radius_type:'getset_descriptor'
    bond_color:'getset_descriptor'
    bond_color_mode:'getset_descriptor'
    bond_radius:'getset_descriptor'
    bounds:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    lattice_color:'getset_descriptor'
    map_scalars:'getset_descriptor'
    periodic_table:'getset_descriptor'
    render_atoms:'getset_descriptor'
    render_bonds:'getset_descriptor'
    render_lattice:'getset_descriptor'
    supports_selection:'getset_descriptor'
    use_multi_cylinders_for_bonds:'getset_descriptor'
    def FillInputPortInformation(self, port:int, info:'vtkInformation') -> int: ...
    def GetAtomColor(self) -> Tuple[int, int, int]: ...
    def GetAtomColorMode(self) -> int: ...
    def GetAtomColorModeMaxValue(self) -> int: ...
    def GetAtomColorModeMinValue(self) -> int: ...
    def GetAtomicRadiusArrayName(self) -> str: ...
    def GetAtomicRadiusScaleFactor(self) -> float: ...
    def GetAtomicRadiusType(self) -> int: ...
    def GetAtomicRadiusTypeAsString(self) -> str: ...
    def GetBondColor(self) -> Tuple[int, int, int]: ...
    def GetBondColorMode(self) -> int: ...
    def GetBondColorModeAsString(self) -> str: ...
    def GetBondColorModeMaxValue(self) -> int: ...
    def GetBondColorModeMinValue(self) -> int: ...
    def GetBondRadius(self) -> float: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetInput(self) -> 'vtkMolecule': ...
    def GetLatticeColor(self) -> Tuple[int, int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPeriodicTable(self) -> 'vtkPeriodicTable': ...
    def GetRenderAtoms(self) -> bool: ...
    def GetRenderBonds(self) -> bool: ...
    def GetRenderLattice(self) -> bool: ...
    def GetSelectedAtoms(self, selection:'vtkSelection', atomIds:'vtkIdTypeArray') -> None: ...
    def GetSelectedAtomsAndBonds(self, selection:'vtkSelection', atomIds:'vtkIdTypeArray', bondIds:'vtkIdTypeArray') -> None: ...
    def GetSelectedBonds(self, selection:'vtkSelection', bondIds:'vtkIdTypeArray') -> None: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetUseMultiCylindersForBonds(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMoleculeMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkActor') -> None: ...
    def RenderAtomsOff(self) -> None: ...
    def RenderAtomsOn(self) -> None: ...
    def RenderBondsOff(self) -> None: ...
    def RenderBondsOn(self) -> None: ...
    def RenderLatticeOff(self) -> None: ...
    def RenderLatticeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMoleculeMapper': ...
    @overload
    def SetAtomColor(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetAtomColor(self, _arg:Sequence[int]) -> None: ...
    def SetAtomColorMode(self, _arg:int) -> None: ...
    def SetAtomicRadiusArrayName(self, _arg:str) -> None: ...
    def SetAtomicRadiusScaleFactor(self, _arg:float) -> None: ...
    def SetAtomicRadiusType(self, _arg:int) -> None: ...
    def SetAtomicRadiusTypeToCovalentRadius(self) -> None: ...
    def SetAtomicRadiusTypeToCustomArrayRadius(self) -> None: ...
    def SetAtomicRadiusTypeToUnitRadius(self) -> None: ...
    def SetAtomicRadiusTypeToVDWRadius(self) -> None: ...
    @overload
    def SetBondColor(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetBondColor(self, _arg:Sequence[int]) -> None: ...
    def SetBondColorMode(self, _arg:int) -> None: ...
    def SetBondColorModeToDiscreteByAtom(self) -> None: ...
    def SetBondColorModeToSingleColor(self) -> None: ...
    def SetBondRadius(self, _arg:float) -> None: ...
    def SetInputData(self, in_:'vtkMolecule') -> None: ...
    @overload
    def SetLatticeColor(self, _arg1:int, _arg2:int, _arg3:int) -> None: ...
    @overload
    def SetLatticeColor(self, _arg:Sequence[int]) -> None: ...
    def SetMapScalars(self, map:bool) -> None: ...
    def SetRenderAtoms(self, _arg:bool) -> None: ...
    def SetRenderBonds(self, _arg:bool) -> None: ...
    def SetRenderLattice(self, _arg:bool) -> None: ...
    def SetUseMultiCylindersForBonds(self, _arg:bool) -> None: ...
    def UseBallAndStickSettings(self) -> None: ...
    def UseFastSettings(self) -> None: ...
    def UseLiquoriceStickSettings(self) -> None: ...
    def UseMultiCylindersForBondsOff(self) -> None: ...
    def UseMultiCylindersForBondsOn(self) -> None: ...
    def UseVDWSpheresSettings(self) -> None: ...

class vtkMoleculeToPolyDataFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    input:'getset_descriptor'
    def GetInput(self) -> 'vtkMolecule': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMoleculeToPolyDataFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMoleculeToPolyDataFilter': ...

class vtkMoleculeToAtomBallFilter(vtkMoleculeToPolyDataFilter):
    CovalentRadius:int
    UnitRadius:int
    VDWRadius:int
    radius_scale:'getset_descriptor'
    radius_source:'getset_descriptor'
    resolution:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadiusScale(self) -> float: ...
    def GetRadiusSource(self) -> int: ...
    def GetResolution(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMoleculeToAtomBallFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMoleculeToAtomBallFilter': ...
    def SetRadiusScale(self, _arg:float) -> None: ...
    def SetRadiusSource(self, _arg:int) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...

class vtkMoleculeToBondStickFilter(vtkMoleculeToPolyDataFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMoleculeToBondStickFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMoleculeToBondStickFilter': ...

class vtkMoleculeToLinesFilter(vtkMoleculeToPolyDataFilter):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMoleculeToLinesFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMoleculeToLinesFilter': ...

class vtkPeriodicTable(vtkmodules.vtkCommonCore.vtkObject):
    blue_obelisk_data:'getset_descriptor'
    max_vdw_radius:'getset_descriptor'
    number_of_elements:'getset_descriptor'
    def GetAtomicNumber(self, str:str) -> int: ...
    def GetBlueObeliskData(self) -> 'vtkBlueObeliskData': ...
    def GetCovalentRadius(self, atomicNum:int) -> float: ...
    def GetDefaultLUT(self, __a:'vtkLookupTable') -> None: ...
    @overload
    def GetDefaultRGBTuple(self, atomicNum:int, rgb:MutableSequence[float]) -> None: ...
    @overload
    def GetDefaultRGBTuple(self, atomicNum:int) -> 'vtkColor3f': ...
    def GetElementName(self, atomicNum:int) -> str: ...
    def GetMaxVDWRadius(self) -> float: ...
    def GetNumberOfElements(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSymbol(self, atomicNum:int) -> str: ...
    def GetVDWRadius(self, atomicNum:int) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPeriodicTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPeriodicTable': ...

class vtkPointSetToMoleculeFilter(vtkmodules.vtkCommonExecutionModel.vtkMoleculeAlgorithm):
    convert_lines_into_bonds:'getset_descriptor'
    def ConvertLinesIntoBondsOff(self) -> None: ...
    def ConvertLinesIntoBondsOn(self) -> None: ...
    def GetConvertLinesIntoBonds(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointSetToMoleculeFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointSetToMoleculeFilter': ...
    def SetConvertLinesIntoBonds(self, _arg:bool) -> None: ...

class vtkProgrammableElectronicData(vtkmodules.vtkCommonDataModel.vtkAbstractElectronicData):
    electron_density:'getset_descriptor'
    number_of_electrons:'getset_descriptor'
    number_of_m_os:'getset_descriptor'
    padding:'getset_descriptor'
    def DeepCopy(self, obj:'vtkDataObject') -> None: ...
    def GetElectronDensity(self) -> 'vtkImageData': ...
    def GetMO(self, orbitalNumber:int) -> 'vtkImageData': ...
    def GetNumberOfElectrons(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfMOs(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProgrammableElectronicData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProgrammableElectronicData': ...
    def SetElectronDensity(self, __a:'vtkImageData') -> None: ...
    def SetMO(self, orbitalNumber:int, data:'vtkImageData') -> None: ...
    def SetNumberOfElectrons(self, _arg:int) -> None: ...
    def SetNumberOfMOs(self, __a:int) -> None: ...
    def SetPadding(self, _arg:float) -> None: ...

class vtkProteinRibbonFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    coil_width:'getset_descriptor'
    draw_small_molecules_as_spheres:'getset_descriptor'
    helix_width:'getset_descriptor'
    sphere_resolution:'getset_descriptor'
    subdivide_factor:'getset_descriptor'
    def GetCoilWidth(self) -> float: ...
    def GetDrawSmallMoleculesAsSpheres(self) -> bool: ...
    def GetHelixWidth(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSphereResolution(self) -> int: ...
    def GetSubdivideFactor(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProteinRibbonFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProteinRibbonFilter': ...
    def SetCoilWidth(self, _arg:float) -> None: ...
    def SetDrawSmallMoleculesAsSpheres(self, _arg:bool) -> None: ...
    def SetHelixWidth(self, _arg:float) -> None: ...
    def SetSphereResolution(self, _arg:int) -> None: ...
    def SetSubdivideFactor(self, _arg:int) -> None: ...

class vtkSimpleBondPerceiver(vtkmodules.vtkCommonExecutionModel.vtkMoleculeAlgorithm):
    is_tolerance_absolute:'getset_descriptor'
    tolerance:'getset_descriptor'
    def GetIsToleranceAbsolute(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSimpleBondPerceiver': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSimpleBondPerceiver': ...
    def SetIsToleranceAbsolute(self, _arg:bool) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

