from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel

VTKIS_ANIM_OFF:int
VTKIS_ANIM_ON:int
VTKIS_CLIP:int
VTKIS_DOLLY:int
VTKIS_ELEVATION:int
VTKIS_ENV_ROTATE:int
VTKIS_EXIT:int
VTKIS_FORWARDFLY:int
VTKIS_GESTURE:int
VTKIS_GROUNDMOVEMENT:int
VTKIS_LOAD_CAMERA_POSE:int
VTKIS_MENU:int
VTKIS_NONE:int
VTKIS_PAN:int
VTKIS_PICK:int
VTKIS_POSITION_PROP:int
VTKIS_REVERSEFLY:int
VTKIS_ROTATE:int
VTKIS_SPIN:int
VTKIS_START:int
VTKIS_TELEPORTATION:int
VTKIS_TIMER:int
VTKIS_TOGGLE_DRAW_CONTROLS:int
VTKIS_TWO_POINTER:int
VTKIS_USCALE:int
VTKIS_ZOOM:int
VTKI_MAX_POINTERS:int
VTKI_TIMER_FIRST:int
VTKI_TIMER_UPDATE:int
VTK_BACKGROUND_LOCATION:int
VTK_CTF_DIVERGING:int
VTK_CTF_HSV:int
VTK_CTF_LAB:int
VTK_CTF_LAB_CIEDE2000:int
VTK_CTF_LINEAR:int
VTK_CTF_LOG10:int
VTK_CTF_RGB:int
VTK_CTF_STEP:int
VTK_CULLER_SORT_BACK_TO_FRONT:int
VTK_CULLER_SORT_FRONT_TO_BACK:int
VTK_CULLER_SORT_NONE:int
VTK_CURSOR_ARROW:int
VTK_CURSOR_CROSSHAIR:int
VTK_CURSOR_CUSTOM:int
VTK_CURSOR_DEFAULT:int
VTK_CURSOR_HAND:int
VTK_CURSOR_SIZEALL:int
VTK_CURSOR_SIZENE:int
VTK_CURSOR_SIZENS:int
VTK_CURSOR_SIZENW:int
VTK_CURSOR_SIZESE:int
VTK_CURSOR_SIZESW:int
VTK_CURSOR_SIZEWE:int
VTK_DISPLAY:int
VTK_FLAT:int
VTK_FOREGROUND_LOCATION:int
VTK_GET_ARRAY_BY_ID:int
VTK_GET_ARRAY_BY_NAME:int
VTK_GOURAUD:int
VTK_LIGHT_TYPE_CAMERA_LIGHT:int
VTK_LIGHT_TYPE_HEADLIGHT:int
VTK_LIGHT_TYPE_SCENE_LIGHT:int
VTK_MARKER_CIRCLE:int
VTK_MARKER_CROSS:int
VTK_MARKER_DIAMOND:int
VTK_MARKER_NONE:int
VTK_MARKER_PLUS:int
VTK_MARKER_SQUARE:int
VTK_MARKER_UNKNOWN:int
VTK_MATERIALMODE_AMBIENT:int
VTK_MATERIALMODE_AMBIENT_AND_DIFFUSE:int
VTK_MATERIALMODE_DEFAULT:int
VTK_MATERIALMODE_DIFFUSE:int
VTK_NORMALIZED_DISPLAY:int
VTK_NORMALIZED_VIEWPORT:int
VTK_PBR:int
VTK_PHONG:int
VTK_POINTS:int
VTK_POSE:int
VTK_RESOLVE_OFF:int
VTK_RESOLVE_POLYGON_OFFSET:int
VTK_RESOLVE_SHIFT_ZBUFFER:int
VTK_SCALAR_MODE_DEFAULT:int
VTK_SCALAR_MODE_USE_CELL_DATA:int
VTK_SCALAR_MODE_USE_CELL_FIELD_DATA:int
VTK_SCALAR_MODE_USE_FIELD_DATA:int
VTK_SCALAR_MODE_USE_POINT_DATA:int
VTK_SCALAR_MODE_USE_POINT_FIELD_DATA:int
VTK_STEREO_ANAGLYPH:int
VTK_STEREO_CHECKERBOARD:int
VTK_STEREO_CRYSTAL_EYES:int
VTK_STEREO_DRESDEN:int
VTK_STEREO_EMULATE:int
VTK_STEREO_FAKE:int
VTK_STEREO_INTERLACED:int
VTK_STEREO_LEFT:int
VTK_STEREO_RED_BLUE:int
VTK_STEREO_RIGHT:int
VTK_STEREO_SPLITVIEWPORT_HORIZONTAL:int
VTK_STEREO_ZSPACE_INSPIRE:int
VTK_SURFACE:int
VTK_TEXTURE_QUALITY_16BIT:int
VTK_TEXTURE_QUALITY_32BIT:int
VTK_TEXTURE_QUALITY_DEFAULT:int
VTK_USERDEFINED:int
VTK_VIEW:int
VTK_VIEWPORT:int
VTK_WIREFRAME:int
VTK_WORLD:int
VTK_ZBUFFER:int
vtkMaxPythagoreanQuadrupleId:int

class vtkAbstractMapper(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    clipping_planes:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_clipping_planes:'getset_descriptor'
    time_to_draw:'getset_descriptor'
    def AddClippingPlane(self, plane:'vtkPlane') -> None: ...
    @staticmethod
    def GetAbstractScalars(input:'vtkDataSet', scalarMode:int, arrayAccessMode:int, arrayId:int, arrayName:str, cellFlag:int) -> 'vtkAbstractArray': ...
    def GetClippingPlanes(self) -> 'vtkPlaneCollection': ...
    @staticmethod
    def GetGhostArray(input:'vtkDataSet', scalarMode:int, ghostsToSkip:int) -> 'vtkUnsignedCharArray': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfClippingPlanes(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetScalars(input:'vtkDataSet', scalarMode:int, arrayAccessMode:int, arrayId:int, arrayName:str, cellFlag:int) -> 'vtkDataArray': ...
    def GetTimeToDraw(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveAllClippingPlanes(self) -> None: ...
    def RemoveClippingPlane(self, plane:'vtkPlane') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractMapper': ...
    @overload
    def SetClippingPlanes(self, __a:'vtkPlaneCollection') -> None: ...
    @overload
    def SetClippingPlanes(self, planes:'vtkPlanes') -> None: ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...

class vtkAbstractMapper3D(vtkAbstractMapper):
    bounds:'getset_descriptor'
    center:'getset_descriptor'
    length:'getset_descriptor'
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetCenter(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCenter(self, center:MutableSequence[float]) -> None: ...
    def GetClippingPlaneInDataCoords(self, propMatrix:'vtkMatrix4x4', i:int, planeEquation:MutableSequence[float]) -> None: ...
    def GetLength(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsARayCastMapper(self) -> int: ...
    def IsARenderIntoImageMapper(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractMapper3D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractMapper3D': ...

class vtkAbstractVolumeMapper(vtkAbstractMapper3D):
    array_access_mode:'getset_descriptor'
    array_id:'getset_descriptor'
    array_name:'getset_descriptor'
    bounds:'getset_descriptor'
    data_object_input:'getset_descriptor'
    data_set_input:'getset_descriptor'
    gradient_magnitude_bias:'getset_descriptor'
    gradient_magnitude_scale:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    def GetArrayAccessMode(self) -> int: ...
    def GetArrayId(self) -> int: ...
    def GetArrayName(self) -> str: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetDataObjectInput(self) -> 'vtkDataObject': ...
    def GetDataSetInput(self) -> 'vtkDataSet': ...
    @overload
    def GetGradientMagnitudeBias(self) -> float: ...
    @overload
    def GetGradientMagnitudeBias(self, __a:int) -> float: ...
    @overload
    def GetGradientMagnitudeScale(self) -> float: ...
    @overload
    def GetGradientMagnitudeScale(self, __a:int) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarModeAsString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractVolumeMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', vol:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractVolumeMapper': ...
    @overload
    def SelectScalarArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectScalarArray(self, arrayName:str) -> None: ...
    def SetArrayAccessMode(self, _arg:int) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToDefault(self) -> None: ...
    def SetScalarModeToUseCellData(self) -> None: ...
    def SetScalarModeToUseCellFieldData(self) -> None: ...
    def SetScalarModeToUsePointData(self) -> None: ...
    def SetScalarModeToUsePointFieldData(self) -> None: ...

class vtkAbstractHyperTreeGridMapper(vtkAbstractVolumeMapper):
    color_map:'getset_descriptor'
    input:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_data:'getset_descriptor'
    m_time:'getset_descriptor'
    renderer:'getset_descriptor'
    scalar_range:'getset_descriptor'
    scale:'getset_descriptor'
    viewport_size:'getset_descriptor'
    def GetColorMap(self) -> 'vtkScalarsToColors': ...
    def GetInput(self) -> 'vtkUniformHyperTreeGrid': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def GetViewportSize(self) -> Tuple[int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractHyperTreeGridMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkVolume') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractHyperTreeGridMapper': ...
    def SetColorMap(self, __a:'vtkScalarsToColors') -> None: ...
    @overload
    def SetInputConnection(self, __a:int, __b:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetInputConnection(self, input:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, __a:'vtkUniformHyperTreeGrid') -> None: ...
    def SetRenderer(self, __a:'vtkRenderer') -> None: ...
    @overload
    def SetScalarRange(self, __a:float, __b:float) -> None: ...
    @overload
    def SetScalarRange(self, __a:MutableSequence[float]) -> None: ...
    def SetScale(self, _arg:float) -> None: ...

class vtkAbstractInteractionDevice(vtkmodules.vtkCommonCore.vtkObject):
    render_device:'getset_descriptor'
    render_widget:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderDevice(self) -> 'vtkAbstractRenderDevice': ...
    def GetRenderWidget(self) -> 'vtkRenderWidget': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractInteractionDevice': ...
    def ProcessEvents(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractInteractionDevice': ...
    def SetRenderDevice(self, device:'vtkAbstractRenderDevice') -> None: ...
    def SetRenderWidget(self, widget:'vtkRenderWidget') -> None: ...
    def Start(self) -> None: ...

class vtkAbstractPicker(vtkmodules.vtkCommonCore.vtkObject):
    pick_from_list:'getset_descriptor'
    pick_list:'getset_descriptor'
    pick_position:'getset_descriptor'
    renderer:'getset_descriptor'
    selection_point:'getset_descriptor'
    def AddPickList(self, __a:'vtkProp') -> None: ...
    def DeletePickList(self, __a:'vtkProp') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickFromList(self) -> int: ...
    def GetPickList(self) -> 'vtkPropCollection': ...
    def GetPickPosition(self) -> Tuple[float, float, float]: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetSelectionPoint(self) -> Tuple[float, float, float]: ...
    def InitializePickList(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractPicker': ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:'vtkRenderer') -> int: ...
    @overload
    def Pick(self, selectionPt:MutableSequence[float], ren:'vtkRenderer') -> int: ...
    def Pick3DPoint(self, __a:MutableSequence[float], __b:'vtkRenderer') -> int: ...
    def Pick3DRay(self, __a:MutableSequence[float], __b:MutableSequence[float], __c:'vtkRenderer') -> int: ...
    def PickFromListOff(self) -> None: ...
    def PickFromListOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractPicker': ...
    def SetPickFromList(self, _arg:int) -> None: ...

class vtkAbstractPropPicker(vtkAbstractPicker):
    actor:'getset_descriptor'
    actor2d:'getset_descriptor'
    assembly:'getset_descriptor'
    path:'getset_descriptor'
    prop3d:'getset_descriptor'
    prop_assembly:'getset_descriptor'
    view_prop:'getset_descriptor'
    volume:'getset_descriptor'
    def GetActor(self) -> 'vtkActor': ...
    def GetActor2D(self) -> 'vtkActor2D': ...
    def GetAssembly(self) -> 'vtkAssembly': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPath(self) -> 'vtkAssemblyPath': ...
    def GetProp3D(self) -> 'vtkProp3D': ...
    def GetPropAssembly(self) -> 'vtkPropAssembly': ...
    def GetViewProp(self) -> 'vtkProp': ...
    def GetVolume(self) -> 'vtkVolume': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractPropPicker': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractPropPicker': ...
    def SetPath(self, __a:'vtkAssemblyPath') -> None: ...

class vtkAbstractRenderDevice(vtkmodules.vtkCommonCore.vtkObject):
    requested_gl_version:'getset_descriptor'
    def CreateNewWindow(self, geometry:'vtkRecti', name:str) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> 'vtkAbstractRenderDevice': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractRenderDevice': ...
    def SetRequestedGLVersion(self, major:int, minor:int) -> None: ...

class vtkProp(vtkmodules.vtkCommonCore.vtkObject):
    allocated_render_time:'getset_descriptor'
    bounds:'getset_descriptor'
    dragable:'getset_descriptor'
    estimated_render_time:'getset_descriptor'
    matrix:'getset_descriptor'
    next_path:'getset_descriptor'
    number_of_paths:'getset_descriptor'
    pickable:'getset_descriptor'
    property_keys:'getset_descriptor'
    redraw_m_time:'getset_descriptor'
    render_time_multiplier:'getset_descriptor'
    shader_property:'getset_descriptor'
    supports_selection:'getset_descriptor'
    use_bounds:'getset_descriptor'
    visibility:'getset_descriptor'
    def AddConsumer(self, c:'vtkObject') -> None: ...
    def AddEstimatedRenderTime(self, t:float, vp:'vtkViewport') -> None: ...
    def BuildPaths(self, paths:'vtkAssemblyPaths', path:'vtkAssemblyPath') -> None: ...
    def DragableOff(self) -> None: ...
    def DragableOn(self) -> None: ...
    @staticmethod
    def GeneralTextureTransform() -> 'vtkInformationDoubleVectorKey': ...
    @staticmethod
    def GeneralTextureUnit() -> 'vtkInformationIntegerKey': ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetAllocatedRenderTime(self) -> float: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetConsumer(self, i:int) -> 'vtkObject': ...
    def GetDragable(self) -> int: ...
    @overload
    def GetEstimatedRenderTime(self, __a:'vtkViewport') -> float: ...
    @overload
    def GetEstimatedRenderTime(self) -> float: ...
    def GetMatrix(self) -> 'vtkMatrix4x4': ...
    def GetNextPath(self) -> 'vtkAssemblyPath': ...
    def GetNumberOfConsumers(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPaths(self) -> int: ...
    def GetPickable(self) -> int: ...
    def GetPropertyKeys(self) -> 'vtkInformation': ...
    def GetRedrawMTime(self) -> int: ...
    def GetRenderTimeMultiplier(self) -> float: ...
    def GetShaderProperty(self) -> 'vtkShaderProperty': ...
    def GetSupportsSelection(self) -> bool: ...
    def GetUseBounds(self) -> bool: ...
    def GetVisibility(self) -> int: ...
    def GetVolumes(self, __a:'vtkPropCollection') -> None: ...
    def HasKeys(self, requiredKeys:'vtkInformation') -> bool: ...
    def HasOpaqueGeometry(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsConsumer(self, c:'vtkObject') -> int: ...
    def IsRenderingTranslucentPolygonalGeometry(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProp': ...
    def Pick(self) -> None: ...
    def PickableOff(self) -> None: ...
    def PickableOn(self) -> None: ...
    def PokeMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    def ProcessSelectorPixelBuffers(self, __a:'vtkHardwareSelector', __b:MutableSequence[int]) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveConsumer(self, c:'vtkObject') -> None: ...
    def RenderFilteredOpaqueGeometry(self, v:'vtkViewport', requiredKeys:'vtkInformation') -> bool: ...
    def RenderFilteredOverlay(self, v:'vtkViewport', requiredKeys:'vtkInformation') -> bool: ...
    def RenderFilteredTranslucentPolygonalGeometry(self, v:'vtkViewport', requiredKeys:'vtkInformation') -> bool: ...
    def RenderFilteredVolumetricGeometry(self, v:'vtkViewport', requiredKeys:'vtkInformation') -> bool: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderVolumetricGeometry(self, __a:'vtkViewport') -> int: ...
    def RestoreEstimatedRenderTime(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProp': ...
    def SetAllocatedRenderTime(self, t:float, v:'vtkViewport') -> None: ...
    def SetDragable(self, _arg:int) -> None: ...
    def SetEstimatedRenderTime(self, t:float) -> None: ...
    def SetPickable(self, _arg:int) -> None: ...
    def SetPropertyKeys(self, keys:'vtkInformation') -> None: ...
    def SetRenderTimeMultiplier(self, t:float) -> None: ...
    def SetShaderProperty(self, property:'vtkShaderProperty') -> None: ...
    def SetUseBounds(self, _arg:bool) -> None: ...
    def SetVisibility(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def UseBoundsOff(self) -> None: ...
    def UseBoundsOn(self) -> None: ...
    def VisibilityOff(self) -> None: ...
    def VisibilityOn(self) -> None: ...

class vtkProp3D(vtkProp):
    class CoordinateSystems(int): ...
    DEVICE:'CoordinateSystems'
    PHYSICAL:'CoordinateSystems'
    WORLD:'CoordinateSystems'
    bounds:'getset_descriptor'
    center:'getset_descriptor'
    coordinate_system:'getset_descriptor'
    coordinate_system_device:'getset_descriptor'
    coordinate_system_renderer:'getset_descriptor'
    is_identity:'getset_descriptor'
    length:'getset_descriptor'
    m_time:'getset_descriptor'
    matrix:'getset_descriptor'
    orientation:'getset_descriptor'
    orientation_wxyz:'getset_descriptor'
    origin:'getset_descriptor'
    position:'getset_descriptor'
    properties_from_model_to_world_matrix:'getset_descriptor'
    scale:'getset_descriptor'
    user_matrix:'getset_descriptor'
    user_transform:'getset_descriptor'
    user_transform_matrix_m_time:'getset_descriptor'
    x_range:'getset_descriptor'
    y_range:'getset_descriptor'
    z_range:'getset_descriptor'
    @overload
    def AddOrientation(self, x:float, y:float, z:float) -> None: ...
    @overload
    def AddOrientation(self, orentation:MutableSequence[float]) -> None: ...
    @overload
    def AddPosition(self, deltaPosition:MutableSequence[float]) -> None: ...
    @overload
    def AddPosition(self, deltaX:float, deltaY:float, deltaZ:float) -> None: ...
    def ComputeMatrix(self) -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCenter(self) -> Tuple[float, float, float]: ...
    def GetCoordinateSystem(self) -> 'CoordinateSystems': ...
    def GetCoordinateSystemAsString(self) -> str: ...
    def GetCoordinateSystemDevice(self) -> int: ...
    def GetCoordinateSystemRenderer(self) -> 'vtkRenderer': ...
    def GetIsIdentity(self) -> int: ...
    def GetLength(self) -> float: ...
    def GetMTime(self) -> int: ...
    @overload
    def GetMatrix(self, result:'vtkMatrix4x4') -> None: ...
    @overload
    def GetMatrix(self, result:MutableSequence[float]) -> None: ...
    @overload
    def GetMatrix(self) -> 'vtkMatrix4x4': ...
    def GetModelToWorldMatrix(self, result:'vtkMatrix4x4') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetOrientation(self) -> Tuple[float, float, float]: ...
    @overload
    def GetOrientation(self, orentation:MutableSequence[float]) -> None: ...
    def GetOrientationWXYZ(self) -> Tuple[float, float, float, float]: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetPosition(self) -> Tuple[float, float, float]: ...
    def GetScale(self) -> Tuple[float, float, float]: ...
    def GetUserMatrix(self) -> 'vtkMatrix4x4': ...
    def GetUserTransform(self) -> 'vtkLinearTransform': ...
    def GetUserTransformMatrixMTime(self) -> int: ...
    def GetXRange(self) -> Tuple[float, float]: ...
    def GetYRange(self) -> Tuple[float, float]: ...
    def GetZRange(self) -> Tuple[float, float]: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProp3D': ...
    def PokeMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    def RotateWXYZ(self, w:float, x:float, y:float, z:float) -> None: ...
    def RotateX(self, __a:float) -> None: ...
    def RotateY(self, __a:float) -> None: ...
    def RotateZ(self, __a:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProp3D': ...
    def SetCoordinateSystem(self, val:'CoordinateSystems') -> None: ...
    def SetCoordinateSystemDevice(self, _arg:int) -> None: ...
    def SetCoordinateSystemRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetCoordinateSystemToDevice(self) -> None: ...
    def SetCoordinateSystemToPhysical(self) -> None: ...
    def SetCoordinateSystemToWorld(self) -> None: ...
    @overload
    def SetOrientation(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrientation(self, orientation:MutableSequence[float]) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetOrigin(self, pos:Sequence[float]) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPosition(self, pos:MutableSequence[float]) -> None: ...
    def SetPropertiesFromModelToWorldMatrix(self, modelToWorld:'vtkMatrix4x4') -> None: ...
    @overload
    def SetScale(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetScale(self, scale:MutableSequence[float]) -> None: ...
    @overload
    def SetScale(self, s:float) -> None: ...
    def SetUserMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    def SetUserTransform(self, transform:'vtkLinearTransform') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkActor(vtkProp3D):
    backface_property:'getset_descriptor'
    bounds:'getset_descriptor'
    force_opaque:'getset_descriptor'
    force_translucent:'getset_descriptor'
    is_rendering_translucent_polygonal_geometry:'getset_descriptor'
    m_time:'getset_descriptor'
    mapper:'getset_descriptor'
    property:'getset_descriptor'
    redraw_m_time:'getset_descriptor'
    supports_selection:'getset_descriptor'
    texture:'getset_descriptor'
    def ApplyProperties(self) -> None: ...
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetBackfaceProperty(self) -> 'vtkProperty': ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetForceOpaque(self) -> bool: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetMTime(self) -> int: ...
    def GetMapper(self) -> 'vtkMapper': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetRedrawMTime(self) -> int: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetTexture(self) -> 'vtkTexture': ...
    def HasOpaqueGeometry(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsRenderingTranslucentPolygonalGeometry(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeProperty(self) -> 'vtkProperty': ...
    def NewInstance(self) -> 'vtkActor': ...
    def ProcessSelectorPixelBuffers(self, sel:'vtkHardwareSelector', pixeloffsets:MutableSequence[int]) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkMapper') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkActor': ...
    def SetBackfaceProperty(self, lut:'vtkProperty') -> None: ...
    def SetForceOpaque(self, _arg:bool) -> None: ...
    def SetForceTranslucent(self, _arg:bool) -> None: ...
    def SetIsRenderingTranslucentPolygonalGeometry(self, val:bool) -> None: ...
    def SetMapper(self, __a:'vtkMapper') -> None: ...
    def SetProperty(self, lut:'vtkProperty') -> None: ...
    def SetTexture(self, __a:'vtkTexture') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkActor2D(vtkProp):
    actual_position2_coordinate:'getset_descriptor'
    actual_position_coordinate:'getset_descriptor'
    display_position:'getset_descriptor'
    height:'getset_descriptor'
    layer_number:'getset_descriptor'
    m_time:'getset_descriptor'
    mapper:'getset_descriptor'
    position:'getset_descriptor'
    position2:'getset_descriptor'
    position2_coordinate:'getset_descriptor'
    position_coordinate:'getset_descriptor'
    property:'getset_descriptor'
    width:'getset_descriptor'
    def GetActors2D(self, pc:'vtkPropCollection') -> None: ...
    def GetActualPosition2Coordinate(self) -> 'vtkCoordinate': ...
    def GetActualPositionCoordinate(self) -> 'vtkCoordinate': ...
    def GetHeight(self) -> float: ...
    def GetLayerNumber(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMapper(self) -> 'vtkMapper2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> Tuple[float, float]: ...
    def GetPosition2(self) -> Tuple[float, float]: ...
    def GetPosition2Coordinate(self) -> 'vtkCoordinate': ...
    def GetPositionCoordinate(self) -> 'vtkCoordinate': ...
    def GetProperty(self) -> 'vtkProperty2D': ...
    def GetWidth(self) -> float: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkActor2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkActor2D': ...
    def SetDisplayPosition(self, __a:int, __b:int) -> None: ...
    def SetHeight(self, h:float) -> None: ...
    def SetLayerNumber(self, _arg:int) -> None: ...
    def SetMapper(self, mapper:'vtkMapper2D') -> None: ...
    @overload
    def SetPosition(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float) -> None: ...
    @overload
    def SetPosition2(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPosition2(self, x:float, y:float) -> None: ...
    def SetProperty(self, __a:'vtkProperty2D') -> None: ...
    def SetWidth(self, w:float) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkPropCollection(vtkmodules.vtkCommonCore.vtkCollection):
    last_prop:'getset_descriptor'
    next_prop:'getset_descriptor'
    number_of_paths:'getset_descriptor'
    def AddItem(self, a:'vtkProp') -> None: ...
    def GetLastProp(self) -> 'vtkProp': ...
    def GetNextProp(self) -> 'vtkProp': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPaths(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPropCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPropCollection': ...

class vtkActor2DCollection(vtkPropCollection):
    last_actor2d:'getset_descriptor'
    last_item:'getset_descriptor'
    next_actor2d:'getset_descriptor'
    next_item:'getset_descriptor'
    def AddItem(self, a:'vtkActor2D') -> None: ...
    def GetLastActor2D(self) -> 'vtkActor2D': ...
    def GetLastItem(self) -> 'vtkActor2D': ...
    def GetNextActor2D(self) -> 'vtkActor2D': ...
    def GetNextItem(self) -> 'vtkActor2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IndexOfFirstOccurence(self, a:'vtkActor2D') -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsItemPresent(self, a:'vtkActor2D') -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkActor2DCollection': ...
    def RenderOverlay(self, viewport:'vtkViewport') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkActor2DCollection': ...
    def Sort(self) -> None: ...

class vtkActorCollection(vtkPropCollection):
    last_actor:'getset_descriptor'
    last_item:'getset_descriptor'
    next_actor:'getset_descriptor'
    next_item:'getset_descriptor'
    def AddItem(self, a:'vtkActor') -> None: ...
    def ApplyProperties(self, p:'vtkProperty') -> None: ...
    def GetLastActor(self) -> 'vtkActor': ...
    def GetLastItem(self) -> 'vtkActor': ...
    def GetNextActor(self) -> 'vtkActor': ...
    def GetNextItem(self) -> 'vtkActor': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkActorCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkActorCollection': ...

class vtkAreaPicker(vtkAbstractPropPicker):
    clip_points:'getset_descriptor'
    data_object:'getset_descriptor'
    data_set:'getset_descriptor'
    frustum:'getset_descriptor'
    mapper:'getset_descriptor'
    pick_coords:'getset_descriptor'
    prop3_ds:'getset_descriptor'
    renderer:'getset_descriptor'
    def AreaPick(self, x0:float, y0:float, x1:float, y1:float, renderer:'vtkRenderer'=...) -> int: ...
    def GetClipPoints(self) -> 'vtkPoints': ...
    def GetDataObject(self) -> 'vtkDataObject': ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetFrustum(self) -> 'vtkPlanes': ...
    def GetMapper(self) -> 'vtkAbstractMapper3D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProp3Ds(self) -> 'vtkProp3DCollection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAreaPicker': ...
    @overload
    def Pick(self) -> int: ...
    @overload
    def Pick(self, x0:float, y0:float, z0:float, renderer:'vtkRenderer'=...) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAreaPicker': ...
    def SetPickCoords(self, x0:float, y0:float, x1:float, y1:float) -> None: ...
    def SetRenderer(self, __a:'vtkRenderer') -> None: ...

class vtkAssembly(vtkProp3D):
    bounds:'getset_descriptor'
    m_time:'getset_descriptor'
    next_path:'getset_descriptor'
    number_of_paths:'getset_descriptor'
    parts:'getset_descriptor'
    def AddPart(self, __a:'vtkProp3D') -> None: ...
    def BuildPaths(self, paths:'vtkAssemblyPaths', path:'vtkAssemblyPath') -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetMTime(self) -> int: ...
    def GetNextPath(self) -> 'vtkAssemblyPath': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPaths(self) -> int: ...
    def GetParts(self) -> 'vtkProp3DCollection': ...
    def GetVolumes(self, __a:'vtkPropCollection') -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAssembly': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemovePart(self, __a:'vtkProp3D') -> None: ...
    def RenderOpaqueGeometry(self, ren:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, ren:'vtkViewport') -> int: ...
    def RenderVolumetricGeometry(self, ren:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAssembly': ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkAssemblyNode(vtkmodules.vtkCommonCore.vtkObject):
    m_time:'getset_descriptor'
    matrix:'getset_descriptor'
    view_prop:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetMatrix(self) -> 'vtkMatrix4x4': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetViewProp(self) -> 'vtkProp': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAssemblyNode': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAssemblyNode': ...
    def SetMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    def SetViewProp(self, prop:'vtkProp') -> None: ...

class vtkAssemblyPath(vtkmodules.vtkCommonCore.vtkCollection):
    first_node:'getset_descriptor'
    last_node:'getset_descriptor'
    m_time:'getset_descriptor'
    next_node:'getset_descriptor'
    def AddNode(self, p:'vtkProp', m:'vtkMatrix4x4') -> None: ...
    def DeleteLastNode(self) -> None: ...
    def GetFirstNode(self) -> 'vtkAssemblyNode': ...
    def GetLastNode(self) -> 'vtkAssemblyNode': ...
    def GetMTime(self) -> int: ...
    def GetNextNode(self) -> 'vtkAssemblyNode': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAssemblyPath': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAssemblyPath': ...
    def ShallowCopy(self, path:'vtkAssemblyPath') -> None: ...

class vtkAssemblyPaths(vtkmodules.vtkCommonCore.vtkCollection):
    m_time:'getset_descriptor'
    next_item:'getset_descriptor'
    def AddItem(self, p:'vtkAssemblyPath') -> None: ...
    def GetMTime(self) -> int: ...
    def GetNextItem(self) -> 'vtkAssemblyPath': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsItemPresent(self, p:'vtkAssemblyPath') -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAssemblyPaths': ...
    def RemoveItem(self, p:'vtkAssemblyPath') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAssemblyPaths': ...

class vtkAvatar(vtkActor):
    head_orientation:'getset_descriptor'
    head_position:'getset_descriptor'
    left_hand_orientation:'getset_descriptor'
    left_hand_position:'getset_descriptor'
    right_hand_orientation:'getset_descriptor'
    right_hand_position:'getset_descriptor'
    show_hands_only:'getset_descriptor'
    up_vector:'getset_descriptor'
    use_left_hand:'getset_descriptor'
    use_right_hand:'getset_descriptor'
    def GetHeadOrientation(self) -> Tuple[float, float, float]: ...
    def GetHeadPosition(self) -> Tuple[float, float, float]: ...
    def GetLeftHandOrientation(self) -> Tuple[float, float, float]: ...
    def GetLeftHandPosition(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRightHandOrientation(self) -> Tuple[float, float, float]: ...
    def GetRightHandPosition(self) -> Tuple[float, float, float]: ...
    def GetShowHandsOnly(self) -> bool: ...
    def GetUpVector(self) -> Tuple[float, float, float]: ...
    def GetUseLeftHand(self) -> bool: ...
    def GetUseRightHand(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAvatar': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAvatar': ...
    @overload
    def SetHeadOrientation(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetHeadOrientation(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetHeadPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetHeadPosition(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetLeftHandOrientation(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLeftHandOrientation(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetLeftHandPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLeftHandPosition(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetRightHandOrientation(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetRightHandOrientation(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetRightHandPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetRightHandPosition(self, _arg:Sequence[float]) -> None: ...
    def SetShowHandsOnly(self, _arg:bool) -> None: ...
    @overload
    def SetUpVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetUpVector(self, _arg:Sequence[float]) -> None: ...
    def SetUseLeftHand(self, _arg:bool) -> None: ...
    def SetUseRightHand(self, _arg:bool) -> None: ...
    def ShowHandsOnlyOff(self) -> None: ...
    def ShowHandsOnlyOn(self) -> None: ...
    def UseLeftHandOff(self) -> None: ...
    def UseLeftHandOn(self) -> None: ...
    def UseRightHandOff(self) -> None: ...
    def UseRightHandOn(self) -> None: ...

class vtkBackgroundColorMonitor(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBackgroundColorMonitor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBackgroundColorMonitor': ...
    def StateChanged(self, ren:'vtkRenderer') -> bool: ...
    def Update(self, ren:'vtkRenderer') -> None: ...

class vtkBillboardTextActor3D(vtkProp3D):
    anchor_dc:'getset_descriptor'
    bounds:'getset_descriptor'
    display_offset:'getset_descriptor'
    force_opaque:'getset_descriptor'
    force_translucent:'getset_descriptor'
    input:'getset_descriptor'
    text_property:'getset_descriptor'
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetAnchorDC(self) -> Tuple[float, float, float]: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetDisplayOffset(self) -> Tuple[int, int]: ...
    def GetForceOpaque(self) -> bool: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetInput(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBillboardTextActor3D': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, vp:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, vp:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBillboardTextActor3D': ...
    @overload
    def SetDisplayOffset(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetDisplayOffset(self, _arg:Sequence[int]) -> None: ...
    def SetForceOpaque(self, opaque:bool) -> None: ...
    def SetForceTranslucent(self, trans:bool) -> None: ...
    def SetInput(self, in_:str) -> None: ...
    def SetTextProperty(self, tprop:'vtkTextProperty') -> None: ...
    def UpdateGeometry(self, vp:'vtkViewport') -> None: ...

class vtkCamera(vtkmodules.vtkCommonCore.vtkObject):
    camera_light_transform_matrix:'getset_descriptor'
    clipping_range:'getset_descriptor'
    direction_of_projection:'getset_descriptor'
    distance:'getset_descriptor'
    explicit_aspect_ratio:'getset_descriptor'
    explicit_projection_transform_matrix:'getset_descriptor'
    eye_angle:'getset_descriptor'
    eye_position:'getset_descriptor'
    eye_separation:'getset_descriptor'
    eye_transform_matrix:'getset_descriptor'
    focal_disk:'getset_descriptor'
    focal_distance:'getset_descriptor'
    focal_point:'getset_descriptor'
    focal_point_scale:'getset_descriptor'
    focal_point_shift:'getset_descriptor'
    freeze_focal_point:'getset_descriptor'
    information:'getset_descriptor'
    left_eye:'getset_descriptor'
    model_transform_matrix:'getset_descriptor'
    model_view_transform_matrix:'getset_descriptor'
    model_view_transform_object:'getset_descriptor'
    near_plane_scale:'getset_descriptor'
    near_plane_shift:'getset_descriptor'
    oblique_angles:'getset_descriptor'
    off_axis_clipping_adjustment:'getset_descriptor'
    orientation:'getset_descriptor'
    orientation_wxyz:'getset_descriptor'
    parallel_projection:'getset_descriptor'
    parallel_scale:'getset_descriptor'
    position:'getset_descriptor'
    roll:'getset_descriptor'
    scissor_rect:'getset_descriptor'
    screen_bottom_left:'getset_descriptor'
    screen_bottom_right:'getset_descriptor'
    screen_top_right:'getset_descriptor'
    shift_scale_threshold:'getset_descriptor'
    stereo:'getset_descriptor'
    thickness:'getset_descriptor'
    use_explicit_aspect_ratio:'getset_descriptor'
    use_explicit_projection_transform_matrix:'getset_descriptor'
    use_horizontal_view_angle:'getset_descriptor'
    use_off_axis_projection:'getset_descriptor'
    use_scissor:'getset_descriptor'
    user_transform:'getset_descriptor'
    user_view_transform:'getset_descriptor'
    view_angle:'getset_descriptor'
    view_plane_normal:'getset_descriptor'
    view_shear:'getset_descriptor'
    view_transform_matrix:'getset_descriptor'
    view_transform_object:'getset_descriptor'
    view_up:'getset_descriptor'
    viewing_rays_m_time:'getset_descriptor'
    window_center:'getset_descriptor'
    def ApplyTransform(self, t:'vtkTransform') -> None: ...
    def Azimuth(self, angle:float) -> None: ...
    def ComputeViewPlaneNormal(self) -> None: ...
    def DeepCopy(self, source:'vtkCamera') -> None: ...
    def Dolly(self, value:float) -> None: ...
    def Elevation(self, angle:float) -> None: ...
    def GetCameraLightTransformMatrix(self) -> 'vtkMatrix4x4': ...
    def GetClippingRange(self) -> Tuple[float, float]: ...
    def GetCompositeProjectionTransformMatrix(self, aspect:float, nearz:float, farz:float) -> 'vtkMatrix4x4': ...
    def GetDirectionOfProjection(self) -> Tuple[float, float, float]: ...
    def GetDistance(self) -> float: ...
    def GetExplicitAspectRatio(self) -> float: ...
    def GetExplicitProjectionTransformMatrix(self) -> 'vtkMatrix4x4': ...
    def GetEyeAngle(self) -> float: ...
    def GetEyePlaneNormal(self, normal:MutableSequence[float]) -> None: ...
    def GetEyePosition(self, eyePosition:MutableSequence[float]) -> None: ...
    def GetEyeSeparation(self) -> float: ...
    def GetEyeTransformMatrix(self) -> 'vtkMatrix4x4': ...
    def GetFocalDisk(self) -> float: ...
    def GetFocalDistance(self) -> float: ...
    def GetFocalPoint(self) -> Tuple[float, float, float]: ...
    def GetFocalPointScale(self) -> float: ...
    def GetFocalPointShift(self) -> Tuple[float, float, float]: ...
    def GetFreezeFocalPoint(self) -> bool: ...
    def GetFrustumPlanes(self, aspect:float, planes:MutableSequence[float]) -> None: ...
    def GetInformation(self) -> 'vtkInformation': ...
    def GetLeftEye(self) -> int: ...
    def GetModelTransformMatrix(self) -> 'vtkMatrix4x4': ...
    def GetModelViewTransformMatrix(self) -> 'vtkMatrix4x4': ...
    def GetModelViewTransformObject(self) -> 'vtkTransform': ...
    def GetNearPlaneScale(self) -> float: ...
    def GetNearPlaneShift(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffAxisClippingAdjustment(self) -> float: ...
    def GetOrientation(self) -> Tuple[float, float, float]: ...
    def GetOrientationWXYZ(self) -> Tuple[float, float, float, float]: ...
    def GetParallelProjection(self) -> int: ...
    def GetParallelScale(self) -> float: ...
    def GetPosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetProjectionTransformMatrix(self, aspect:float, nearz:float, farz:float) -> 'vtkMatrix4x4': ...
    @overload
    def GetProjectionTransformMatrix(self, ren:'vtkRenderer') -> 'vtkMatrix4x4': ...
    def GetProjectionTransformObject(self, aspect:float, nearz:float, farz:float) -> 'vtkPerspectiveTransform': ...
    def GetRoll(self) -> float: ...
    def GetScissorRect(self, scissorRect:'vtkRecti') -> None: ...
    def GetScreenBottomLeft(self) -> Tuple[float, float, float]: ...
    def GetScreenBottomRight(self) -> Tuple[float, float, float]: ...
    def GetScreenTopRight(self) -> Tuple[float, float, float]: ...
    def GetShiftScaleThreshold(self) -> float: ...
    def GetStereo(self) -> int: ...
    def GetStereoEyePosition(self, eyePosition:MutableSequence[float]) -> None: ...
    def GetThickness(self) -> float: ...
    def GetUseExplicitAspectRatio(self) -> bool: ...
    def GetUseExplicitProjectionTransformMatrix(self) -> bool: ...
    def GetUseHorizontalViewAngle(self) -> int: ...
    def GetUseOffAxisProjection(self) -> int: ...
    def GetUseScissor(self) -> bool: ...
    def GetUserTransform(self) -> 'vtkHomogeneousTransform': ...
    def GetUserViewTransform(self) -> 'vtkHomogeneousTransform': ...
    def GetViewAngle(self) -> float: ...
    def GetViewPlaneNormal(self) -> Tuple[float, float, float]: ...
    def GetViewShear(self) -> Tuple[float, float, float]: ...
    def GetViewTransformMatrix(self) -> 'vtkMatrix4x4': ...
    def GetViewTransformObject(self) -> 'vtkTransform': ...
    def GetViewUp(self) -> Tuple[float, float, float]: ...
    def GetViewingRaysMTime(self) -> int: ...
    def GetWindowCenter(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCamera': ...
    def OrthogonalizeViewUp(self) -> None: ...
    def ParallelProjectionOff(self) -> None: ...
    def ParallelProjectionOn(self) -> None: ...
    def Pitch(self, angle:float) -> None: ...
    def Render(self, __a:'vtkRenderer') -> None: ...
    def Roll(self, angle:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCamera': ...
    @overload
    def SetClippingRange(self, dNear:float, dFar:float) -> None: ...
    @overload
    def SetClippingRange(self, a:Sequence[float]) -> None: ...
    def SetDistance(self, __a:float) -> None: ...
    def SetExplicitAspectRatio(self, _arg:float) -> None: ...
    def SetExplicitProjectionTransformMatrix(self, __a:'vtkMatrix4x4') -> None: ...
    def SetEyeAngle(self, _arg:float) -> None: ...
    def SetEyePosition(self, eyePosition:MutableSequence[float]) -> None: ...
    def SetEyeSeparation(self, _arg:float) -> None: ...
    @overload
    def SetEyeTransformMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    @overload
    def SetEyeTransformMatrix(self, elements:Sequence[float]) -> None: ...
    def SetFocalDisk(self, _arg:float) -> None: ...
    def SetFocalDistance(self, _arg:float) -> None: ...
    @overload
    def SetFocalPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetFocalPoint(self, a:Sequence[float]) -> None: ...
    def SetFreezeFocalPoint(self, _arg:bool) -> None: ...
    def SetInformation(self, __a:'vtkInformation') -> None: ...
    def SetLeftEye(self, _arg:int) -> None: ...
    @overload
    def SetModelTransformMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    @overload
    def SetModelTransformMatrix(self, elements:Sequence[float]) -> None: ...
    def SetObliqueAngles(self, alpha:float, beta:float) -> None: ...
    def SetParallelProjection(self, flag:int) -> None: ...
    def SetParallelScale(self, scale:float) -> None: ...
    @overload
    def SetPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPosition(self, a:Sequence[float]) -> None: ...
    def SetRoll(self, angle:float) -> None: ...
    def SetScissorRect(self, scissorRect:'vtkRecti') -> None: ...
    @overload
    def SetScreenBottomLeft(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetScreenBottomLeft(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetScreenBottomRight(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetScreenBottomRight(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetScreenTopRight(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetScreenTopRight(self, _arg:Sequence[float]) -> None: ...
    def SetShiftScaleThreshold(self, _arg:float) -> None: ...
    def SetThickness(self, __a:float) -> None: ...
    def SetUseExplicitAspectRatio(self, _arg:bool) -> None: ...
    def SetUseExplicitProjectionTransformMatrix(self, _arg:bool) -> None: ...
    def SetUseHorizontalViewAngle(self, flag:int) -> None: ...
    def SetUseOffAxisProjection(self, _arg:int) -> None: ...
    def SetUseScissor(self, _arg:bool) -> None: ...
    def SetUserTransform(self, transform:'vtkHomogeneousTransform') -> None: ...
    def SetUserViewTransform(self, transform:'vtkHomogeneousTransform') -> None: ...
    def SetViewAngle(self, angle:float) -> None: ...
    @overload
    def SetViewShear(self, dxdz:float, dydz:float, center:float) -> None: ...
    @overload
    def SetViewShear(self, d:MutableSequence[float]) -> None: ...
    @overload
    def SetViewUp(self, vx:float, vy:float, vz:float) -> None: ...
    @overload
    def SetViewUp(self, a:Sequence[float]) -> None: ...
    def SetWindowCenter(self, x:float, y:float) -> None: ...
    def ShallowCopy(self, source:'vtkCamera') -> None: ...
    def UpdateIdealShiftScale(self, aspect:float) -> None: ...
    def UpdateViewport(self, ren:'vtkRenderer') -> None: ...
    def UseExplicitAspectRatioOff(self) -> None: ...
    def UseExplicitAspectRatioOn(self) -> None: ...
    def UseExplicitProjectionTransformMatrixOff(self) -> None: ...
    def UseExplicitProjectionTransformMatrixOn(self) -> None: ...
    def UseHorizontalViewAngleOff(self) -> None: ...
    def UseHorizontalViewAngleOn(self) -> None: ...
    def UseOffAxisProjectionOff(self) -> None: ...
    def UseOffAxisProjectionOn(self) -> None: ...
    def ViewingRaysModified(self) -> None: ...
    def Yaw(self, angle:float) -> None: ...
    def Zoom(self, factor:float) -> None: ...

class vtkCameraActor(vtkProp3D):
    bounds:'getset_descriptor'
    camera:'getset_descriptor'
    m_time:'getset_descriptor'
    property:'getset_descriptor'
    width_by_height_ratio:'getset_descriptor'
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkProperty': ...
    def GetWidthByHeightRatio(self) -> float: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraActor': ...
    def SetCamera(self, camera:'vtkCamera') -> None: ...
    def SetProperty(self, p:'vtkProperty') -> None: ...
    def SetWidthByHeightRatio(self, _arg:float) -> None: ...

class vtkCameraInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    INTERPOLATION_TYPE_LINEAR:int
    INTERPOLATION_TYPE_MANUAL:int
    INTERPOLATION_TYPE_SPLINE:int
    clipping_range_interpolator:'getset_descriptor'
    focal_point_interpolator:'getset_descriptor'
    interpolation_type:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_t:'getset_descriptor'
    minimum_t:'getset_descriptor'
    number_of_cameras:'getset_descriptor'
    parallel_scale_interpolator:'getset_descriptor'
    position_interpolator:'getset_descriptor'
    view_angle_interpolator:'getset_descriptor'
    view_up_interpolator:'getset_descriptor'
    def AddCamera(self, t:float, camera:'vtkCamera') -> None: ...
    def GetClippingRangeInterpolator(self) -> 'vtkTupleInterpolator': ...
    def GetFocalPointInterpolator(self) -> 'vtkTupleInterpolator': ...
    def GetInterpolationType(self) -> int: ...
    def GetInterpolationTypeMaxValue(self) -> int: ...
    def GetInterpolationTypeMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMaximumT(self) -> float: ...
    def GetMinimumT(self) -> float: ...
    def GetNumberOfCameras(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetParallelScaleInterpolator(self) -> 'vtkTupleInterpolator': ...
    def GetPositionInterpolator(self) -> 'vtkTupleInterpolator': ...
    def GetViewAngleInterpolator(self) -> 'vtkTupleInterpolator': ...
    def GetViewUpInterpolator(self) -> 'vtkTupleInterpolator': ...
    def Initialize(self) -> None: ...
    def InterpolateCamera(self, t:float, camera:'vtkCamera') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCameraInterpolator': ...
    def RemoveCamera(self, t:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCameraInterpolator': ...
    def SetClippingRangeInterpolator(self, __a:'vtkTupleInterpolator') -> None: ...
    def SetFocalPointInterpolator(self, __a:'vtkTupleInterpolator') -> None: ...
    def SetInterpolationType(self, _arg:int) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToManual(self) -> None: ...
    def SetInterpolationTypeToSpline(self) -> None: ...
    def SetParallelScaleInterpolator(self, __a:'vtkTupleInterpolator') -> None: ...
    def SetPositionInterpolator(self, __a:'vtkTupleInterpolator') -> None: ...
    def SetViewAngleInterpolator(self, __a:'vtkTupleInterpolator') -> None: ...
    def SetViewUpInterpolator(self, __a:'vtkTupleInterpolator') -> None: ...

class vtkVisibilitySort(vtkmodules.vtkCommonCore.vtkObject):
    BACK_TO_FRONT:int
    FRONT_TO_BACK:int
    camera:'getset_descriptor'
    direction:'getset_descriptor'
    input:'getset_descriptor'
    inverse_model_transform:'getset_descriptor'
    max_cells_returned:'getset_descriptor'
    model_transform:'getset_descriptor'
    next_cells:'getset_descriptor'
    def GetCamera(self) -> 'vtkCamera': ...
    def GetDirection(self) -> int: ...
    def GetInput(self) -> 'vtkDataSet': ...
    def GetInverseModelTransform(self) -> 'vtkMatrix4x4': ...
    def GetMaxCellsReturned(self) -> int: ...
    def GetMaxCellsReturnedMaxValue(self) -> int: ...
    def GetMaxCellsReturnedMinValue(self) -> int: ...
    def GetModelTransform(self) -> 'vtkMatrix4x4': ...
    def GetNextCells(self) -> 'vtkIdTypeArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVisibilitySort': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVisibilitySort': ...
    def SetCamera(self, camera:'vtkCamera') -> None: ...
    def SetDirection(self, _arg:int) -> None: ...
    def SetDirectionToBackToFront(self) -> None: ...
    def SetDirectionToFrontToBack(self) -> None: ...
    def SetInput(self, data:'vtkDataSet') -> None: ...
    def SetMaxCellsReturned(self, _arg:int) -> None: ...
    def SetModelTransform(self, mat:'vtkMatrix4x4') -> None: ...
    def UsesGarbageCollector(self) -> bool: ...

class vtkCellCenterDepthSort(vtkVisibilitySort):
    next_cells:'getset_descriptor'
    def GetNextCells(self) -> 'vtkIdTypeArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def InitTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellCenterDepthSort': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellCenterDepthSort': ...

class vtkCellGraphicsPrimitiveMap(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...

class vtkMapper(vtkAbstractMapper3D):
    array_access_mode:'getset_descriptor'
    array_component:'getset_descriptor'
    array_id:'getset_descriptor'
    array_name:'getset_descriptor'
    bounds:'getset_descriptor'
    color_coordinates:'getset_descriptor'
    color_map_colors:'getset_descriptor'
    color_mode:'getset_descriptor'
    color_texture_map:'getset_descriptor'
    field_data_tuple_id:'getset_descriptor'
    input:'getset_descriptor'
    input_as_data_set:'getset_descriptor'
    interpolate_scalars_before_mapping:'getset_descriptor'
    lookup_table:'getset_descriptor'
    m_time:'getset_descriptor'
    relative_coincident_topology_line_offset_parameters:'getset_descriptor'
    relative_coincident_topology_point_offset_parameter:'getset_descriptor'
    relative_coincident_topology_polygon_offset_parameters:'getset_descriptor'
    render_time:'getset_descriptor'
    resolve_coincident_topology:'getset_descriptor'
    resolve_coincident_topology_line_offset_parameters:'getset_descriptor'
    resolve_coincident_topology_point_offset_parameter:'getset_descriptor'
    resolve_coincident_topology_polygon_offset_faces:'getset_descriptor'
    resolve_coincident_topology_polygon_offset_parameters:'getset_descriptor'
    resolve_coincident_topology_z_shift:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    scalar_range:'getset_descriptor'
    scalar_visibility:'getset_descriptor'
    selection:'getset_descriptor'
    static:'getset_descriptor'
    supports_selection:'getset_descriptor'
    use_lookup_table_scalar_range:'getset_descriptor'
    @staticmethod
    def BuildColorTextureImage(lkup:'vtkScalarsToColors', colorMode:int) -> 'vtkImageData': ...
    def CanUseTextureMapForColoring(self, input:'vtkDataObject') -> int: ...
    def ClearColorArrays(self) -> None: ...
    @overload
    def ColorByArrayComponent(self, arrayNum:int, component:int) -> None: ...
    @overload
    def ColorByArrayComponent(self, arrayName:str, component:int) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def GetArrayAccessMode(self) -> int: ...
    def GetArrayComponent(self) -> int: ...
    def GetArrayId(self) -> int: ...
    def GetArrayName(self) -> str: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCoincidentTopologyLineOffsetParameters(self, factor:float, units:float) -> None: ...
    def GetCoincidentTopologyPointOffsetParameter(self, units:float) -> None: ...
    def GetCoincidentTopologyPolygonOffsetParameters(self, factor:float, units:float) -> None: ...
    def GetColorCoordinates(self) -> 'vtkFloatArray': ...
    def GetColorMapColors(self) -> 'vtkUnsignedCharArray': ...
    def GetColorMode(self) -> int: ...
    def GetColorModeAsString(self) -> str: ...
    def GetColorTextureMap(self) -> 'vtkImageData': ...
    def GetFieldDataTupleId(self) -> int: ...
    def GetInput(self) -> 'vtkDataSet': ...
    def GetInputAsDataSet(self) -> 'vtkDataSet': ...
    def GetInterpolateScalarsBeforeMapping(self) -> int: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRelativeCoincidentTopologyLineOffsetParameters(self, factor:float, units:float) -> None: ...
    def GetRelativeCoincidentTopologyPointOffsetParameter(self, units:float) -> None: ...
    def GetRelativeCoincidentTopologyPolygonOffsetParameters(self, factor:float, units:float) -> None: ...
    def GetRenderTime(self) -> float: ...
    @staticmethod
    def GetResolveCoincidentTopology() -> int: ...
    @staticmethod
    def GetResolveCoincidentTopologyLineOffsetParameters(factor:float, units:float) -> None: ...
    @staticmethod
    def GetResolveCoincidentTopologyPointOffsetParameter(units:float) -> None: ...
    @staticmethod
    def GetResolveCoincidentTopologyPolygonOffsetFaces() -> int: ...
    @staticmethod
    def GetResolveCoincidentTopologyPolygonOffsetParameters(factor:float, units:float) -> None: ...
    @staticmethod
    def GetResolveCoincidentTopologyZShift() -> float: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarModeAsString(self) -> str: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def GetScalarVisibility(self) -> int: ...
    def GetSelection(self) -> 'vtkSelection': ...
    def GetStatic(self) -> int: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetUseLookupTableScalarRange(self) -> int: ...
    def HasOpaqueGeometry(self) -> bool: ...
    def HasTranslucentPolygonalGeometry(self) -> bool: ...
    def InterpolateScalarsBeforeMappingOff(self) -> None: ...
    def InterpolateScalarsBeforeMappingOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    @overload
    def MapScalars(self, alpha:float) -> 'vtkUnsignedCharArray': ...
    @overload
    def MapScalars(self, alpha:float, cellFlag:int) -> 'vtkUnsignedCharArray': ...
    @overload
    def MapScalars(self, input:'vtkDataSet', alpha:float) -> 'vtkUnsignedCharArray': ...
    @overload
    def MapScalars(self, input:'vtkDataSet', alpha:float, cellFlag:int) -> 'vtkUnsignedCharArray': ...
    def NewInstance(self) -> 'vtkMapper': ...
    def ProcessSelectorPixelBuffers(self, __a:'vtkHardwareSelector', __b:MutableSequence[int], __c:'vtkProp') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', a:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMapper': ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    @overload
    def SelectColorArray(self, arrayNum:int) -> None: ...
    @overload
    def SelectColorArray(self, arrayName:str) -> None: ...
    def SetArrayAccessMode(self, _arg:int) -> None: ...
    def SetArrayComponent(self, _arg:int) -> None: ...
    def SetArrayId(self, _arg:int) -> None: ...
    def SetArrayName(self, _arg:str) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToDefault(self) -> None: ...
    def SetColorModeToDirectScalars(self) -> None: ...
    def SetColorModeToMapScalars(self) -> None: ...
    def SetFieldDataTupleId(self, _arg:int) -> None: ...
    def SetInterpolateScalarsBeforeMapping(self, _arg:int) -> None: ...
    def SetLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetRelativeCoincidentTopologyLineOffsetParameters(self, factor:float, units:float) -> None: ...
    def SetRelativeCoincidentTopologyPointOffsetParameter(self, units:float) -> None: ...
    def SetRelativeCoincidentTopologyPolygonOffsetParameters(self, factor:float, units:float) -> None: ...
    def SetRenderTime(self, time:float) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopology(val:int) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyLineOffsetParameters(factor:float, units:float) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyPointOffsetParameter(units:float) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyPolygonOffsetFaces(faces:int) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyPolygonOffsetParameters(factor:float, units:float) -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyToDefault() -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyToOff() -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyToPolygonOffset() -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyToShiftZBuffer() -> None: ...
    @staticmethod
    def SetResolveCoincidentTopologyZShift(val:float) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToDefault(self) -> None: ...
    def SetScalarModeToUseCellData(self) -> None: ...
    def SetScalarModeToUseCellFieldData(self) -> None: ...
    def SetScalarModeToUseFieldData(self) -> None: ...
    def SetScalarModeToUsePointData(self) -> None: ...
    def SetScalarModeToUsePointFieldData(self) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...
    def SetScalarVisibility(self, _arg:int) -> None: ...
    def SetSelection(self, __a:'vtkSelection') -> None: ...
    def SetStatic(self, _arg:int) -> None: ...
    def SetUseLookupTableScalarRange(self, _arg:int) -> None: ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...
    def StaticOff(self) -> None: ...
    def StaticOn(self) -> None: ...
    def UseLookupTableScalarRangeOff(self) -> None: ...
    def UseLookupTableScalarRangeOn(self) -> None: ...

class vtkCellGridMapper(vtkMapper):
    bounds:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    visualize_basis_function:'getset_descriptor'
    visualize_p_coords:'getset_descriptor'
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetInput(self) -> 'vtkCellGrid': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetVisualizeBasisFunction(self) -> int: ...
    def GetVisualizePCoords(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridMapper': ...
    def PrepareColormap(self, cmap:'vtkScalarsToColors'=...) -> None: ...
    def Render(self, __a:'vtkRenderer', __b:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridMapper': ...
    def SetInputData(self, in_:'vtkCellGrid') -> None: ...
    def SetVisualizeBasisFunction(self, _arg:int) -> None: ...
    def SetVisualizePCoords(self, _arg:int) -> None: ...
    @overload
    def Update(self, port:int) -> None: ...
    @overload
    def Update(self) -> None: ...
    @overload
    def Update(self, port:int, requests:'vtkInformationVector') -> int: ...
    @overload
    def Update(self, requests:'vtkInformation') -> int: ...

class vtkCellGridRenderRequest(vtkmodules.vtkCommonDataModel.vtkCellGridQuery):
    class RenderableGeometry(int): ...
    ALL:'RenderableGeometry'
    EDGES:'RenderableGeometry'
    FACES:'RenderableGeometry'
    SURFACE_WITH_EDGES:'RenderableGeometry'
    VERTICES:'RenderableGeometry'
    VOLUMES:'RenderableGeometry'
    actor:'getset_descriptor'
    is_releasing_resources:'getset_descriptor'
    mapper:'getset_descriptor'
    renderer:'getset_descriptor'
    shapes_to_draw:'getset_descriptor'
    window:'getset_descriptor'
    def Finalize(self) -> bool: ...
    def GetActor(self) -> 'vtkActor': ...
    def GetIsReleasingResources(self) -> bool: ...
    def GetMapper(self) -> 'vtkCellGridMapper': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetShapesToDraw(self) -> str: ...
    def GetShapesToDrawMaxValue(self) -> str: ...
    def GetShapesToDrawMinValue(self) -> str: ...
    def GetWindow(self) -> 'vtkWindow': ...
    def Initialize(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridRenderRequest': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridRenderRequest': ...
    def SetActor(self, actor:'vtkActor') -> None: ...
    def SetIsReleasingResources(self, _arg:bool) -> None: ...
    def SetMapper(self, mapper:'vtkCellGridMapper') -> None: ...
    def SetRenderer(self, renderer:'vtkRenderer') -> None: ...
    def SetShapesToDraw(self, _arg:str) -> None: ...
    def SetWindow(self, window:'vtkWindow') -> None: ...

class vtkPicker(vtkAbstractPropPicker):
    actors:'getset_descriptor'
    composite_data_set:'getset_descriptor'
    data_set:'getset_descriptor'
    flat_block_index:'getset_descriptor'
    mapper:'getset_descriptor'
    mapper_position:'getset_descriptor'
    picked_positions:'getset_descriptor'
    prop3_ds:'getset_descriptor'
    tolerance:'getset_descriptor'
    def GetActors(self) -> 'vtkActorCollection': ...
    def GetCompositeDataSet(self) -> 'vtkCompositeDataSet': ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetFlatBlockIndex(self) -> int: ...
    def GetMapper(self) -> 'vtkAbstractMapper3D': ...
    def GetMapperPosition(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickedPositions(self) -> 'vtkPoints': ...
    def GetProp3Ds(self) -> 'vtkProp3DCollection': ...
    def GetTolerance(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPicker': ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:'vtkRenderer') -> int: ...
    @overload
    def Pick(self, selectionPt:MutableSequence[float], ren:'vtkRenderer') -> int: ...
    @overload
    def Pick3DPoint(self, selectionPt:MutableSequence[float], ren:'vtkRenderer') -> int: ...
    @overload
    def Pick3DPoint(self, p1World:MutableSequence[float], p2World:MutableSequence[float], ren:'vtkRenderer') -> int: ...
    def Pick3DRay(self, selectionPt:MutableSequence[float], orient:MutableSequence[float], ren:'vtkRenderer') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPicker': ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkCellPicker(vtkPicker):
    cell_id:'getset_descriptor'
    cell_ijk:'getset_descriptor'
    clipping_plane_id:'getset_descriptor'
    mapper_normal:'getset_descriptor'
    p_coords:'getset_descriptor'
    pick_clipping_planes:'getset_descriptor'
    pick_normal:'getset_descriptor'
    pick_texture_data:'getset_descriptor'
    point_id:'getset_descriptor'
    point_ijk:'getset_descriptor'
    sub_id:'getset_descriptor'
    texture:'getset_descriptor'
    use_volume_gradient_opacity:'getset_descriptor'
    volume_opacity_isovalue:'getset_descriptor'
    def AddLocator(self, locator:'vtkAbstractCellLocator') -> None: ...
    def GetCellIJK(self) -> Tuple[int, int, int]: ...
    def GetCellId(self) -> int: ...
    def GetClippingPlaneId(self) -> int: ...
    def GetMapperNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPCoords(self) -> Tuple[float, float, float]: ...
    def GetPickClippingPlanes(self) -> int: ...
    def GetPickNormal(self) -> Tuple[float, float, float]: ...
    def GetPickTextureData(self) -> int: ...
    def GetPointIJK(self) -> Tuple[int, int, int]: ...
    def GetPointId(self) -> int: ...
    def GetSubId(self) -> int: ...
    def GetTexture(self) -> 'vtkTexture': ...
    def GetUseVolumeGradientOpacity(self) -> int: ...
    def GetVolumeOpacityIsovalue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellPicker': ...
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:'vtkRenderer') -> int: ...
    def Pick3DRay(self, selectionPt:MutableSequence[float], orient:MutableSequence[float], ren:'vtkRenderer') -> int: ...
    def PickClippingPlanesOff(self) -> None: ...
    def PickClippingPlanesOn(self) -> None: ...
    def PickTextureDataOff(self) -> None: ...
    def PickTextureDataOn(self) -> None: ...
    def RemoveAllLocators(self) -> None: ...
    def RemoveLocator(self, locator:'vtkAbstractCellLocator') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellPicker': ...
    def SetPickClippingPlanes(self, _arg:int) -> None: ...
    def SetPickTextureData(self, _arg:int) -> None: ...
    def SetUseVolumeGradientOpacity(self, _arg:int) -> None: ...
    def SetVolumeOpacityIsovalue(self, _arg:float) -> None: ...
    def UseVolumeGradientOpacityOff(self) -> None: ...
    def UseVolumeGradientOpacityOn(self) -> None: ...

class vtkColorTransferFunction(vtkmodules.vtkCommonCore.vtkScalarsToColors):
    above_range_color:'getset_descriptor'
    allow_duplicate_scalars:'getset_descriptor'
    below_range_color:'getset_descriptor'
    clamping:'getset_descriptor'
    color_space:'getset_descriptor'
    data_pointer:'getset_descriptor'
    hsv_wrap:'getset_descriptor'
    nan_color:'getset_descriptor'
    nan_color_rgba:'getset_descriptor'
    nan_opacity:'getset_descriptor'
    number_of_available_colors:'getset_descriptor'
    range:'getset_descriptor'
    scale:'getset_descriptor'
    size:'getset_descriptor'
    use_above_range_color:'getset_descriptor'
    use_below_range_color:'getset_descriptor'
    @overload
    def AddHSVPoint(self, x:float, h:float, s:float, v:float) -> int: ...
    @overload
    def AddHSVPoint(self, x:float, h:float, s:float, v:float, midpoint:float, sharpness:float) -> int: ...
    def AddHSVSegment(self, x1:float, h1:float, s1:float, v1:float, x2:float, h2:float, s2:float, v2:float) -> None: ...
    @overload
    def AddRGBPoint(self, x:float, r:float, g:float, b:float) -> int: ...
    @overload
    def AddRGBPoint(self, x:float, r:float, g:float, b:float, midpoint:float, sharpness:float) -> int: ...
    @overload
    def AddRGBPoints(self, x:'vtkDoubleArray', rgbColors:'vtkDoubleArray') -> int: ...
    @overload
    def AddRGBPoints(self, x:'vtkDoubleArray', rgbColors:'vtkDoubleArray', midpoint:float, sharpness:float) -> int: ...
    def AddRGBSegment(self, x1:float, r1:float, g1:float, b1:float, x2:float, r2:float, g2:float, b2:float) -> None: ...
    def AdjustRange(self, range:MutableSequence[float]) -> int: ...
    def AllowDuplicateScalarsOff(self) -> None: ...
    def AllowDuplicateScalarsOn(self) -> None: ...
    def BuildFunctionFromTable(self, x1:float, x2:float, size:int, table:MutableSequence[float]) -> None: ...
    def ClampingOff(self) -> None: ...
    def ClampingOn(self) -> None: ...
    def DeepCopy(self, f:'vtkScalarsToColors') -> None: ...
    def EstimateMinNumberOfSamples(self, x1:float, x2:float) -> int: ...
    def FillFromDataPointer(self, n:int, ptr:MutableSequence[float]) -> None: ...
    def GetAboveRangeColor(self) -> Tuple[float, float, float]: ...
    def GetAllowDuplicateScalars(self) -> int: ...
    def GetBelowRangeColor(self) -> Tuple[float, float, float]: ...
    def GetBlueValue(self, x:float) -> float: ...
    def GetClamping(self) -> int: ...
    def GetClampingMaxValue(self) -> int: ...
    def GetClampingMinValue(self) -> int: ...
    @overload
    def GetColor(self, x:float) -> Tuple[float, float, float]: ...
    @overload
    def GetColor(self, x:float, rgb:MutableSequence[float]) -> None: ...
    def GetColorSpace(self) -> int: ...
    def GetColorSpaceMaxValue(self) -> int: ...
    def GetColorSpaceMinValue(self) -> int: ...
    def GetDataPointer(self) -> Pointer: ...
    def GetGreenValue(self, x:float) -> float: ...
    def GetHSVWrap(self) -> int: ...
    def GetIndexedColor(self, idx:int, rgba:MutableSequence[float]) -> None: ...
    def GetNanColor(self) -> Tuple[float, float, float]: ...
    def GetNanOpacity(self) -> float: ...
    def GetNodeValue(self, index:int, val:MutableSequence[float]) -> int: ...
    def GetNumberOfAvailableColors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetRange(self) -> Tuple[float, float]: ...
    @overload
    def GetRange(self, arg1:float, arg2:float) -> None: ...
    @overload
    def GetRange(self, _arg:MutableSequence[float]) -> None: ...
    def GetRedValue(self, x:float) -> float: ...
    def GetScale(self) -> int: ...
    def GetSize(self) -> int: ...
    @overload
    def GetTable(self, x1:float, x2:float, n:int, table:MutableSequence[float]) -> None: ...
    @overload
    def GetTable(self, x1:float, x2:float, n:int) -> Pointer: ...
    def GetUseAboveRangeColor(self) -> int: ...
    def GetUseBelowRangeColor(self) -> int: ...
    def HSVWrapOff(self) -> None: ...
    def HSVWrapOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsThroughTable2(self, input:Pointer, output:MutableSequence[int], inputDataType:int, numberOfValues:int, inputIncrement:int, outputIncrement:int) -> None: ...
    def MapValue(self, v:float) -> Pointer: ...
    def NewInstance(self) -> 'vtkColorTransferFunction': ...
    def RemoveAllPoints(self) -> None: ...
    def RemovePoint(self, x:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkColorTransferFunction': ...
    @overload
    def SetAboveRangeColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAboveRangeColor(self, _arg:Sequence[float]) -> None: ...
    def SetAllowDuplicateScalars(self, _arg:int) -> None: ...
    @overload
    def SetBelowRangeColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBelowRangeColor(self, _arg:Sequence[float]) -> None: ...
    def SetClamping(self, _arg:int) -> None: ...
    def SetColorSpace(self, _arg:int) -> None: ...
    def SetColorSpaceToDiverging(self) -> None: ...
    def SetColorSpaceToHSV(self) -> None: ...
    def SetColorSpaceToLab(self) -> None: ...
    def SetColorSpaceToLabCIEDE2000(self) -> None: ...
    def SetColorSpaceToRGB(self) -> None: ...
    def SetColorSpaceToStep(self) -> None: ...
    def SetHSVWrap(self, _arg:int) -> None: ...
    @overload
    def SetNanColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNanColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetNanColorRGBA(self, r:float, g:float, b:float, a:float) -> None: ...
    @overload
    def SetNanColorRGBA(self, rgba:MutableSequence[float]) -> None: ...
    def SetNanOpacity(self, _arg:float) -> None: ...
    def SetNodeValue(self, index:int, val:MutableSequence[float]) -> int: ...
    def SetScale(self, _arg:int) -> None: ...
    def SetScaleToLinear(self) -> None: ...
    def SetScaleToLog10(self) -> None: ...
    def SetUseAboveRangeColor(self, _arg:int) -> None: ...
    def SetUseBelowRangeColor(self, _arg:int) -> None: ...
    def ShallowCopy(self, f:'vtkColorTransferFunction') -> None: ...
    def UseAboveRangeColorOff(self) -> None: ...
    def UseAboveRangeColorOn(self) -> None: ...
    def UseBelowRangeColorOff(self) -> None: ...
    def UseBelowRangeColorOn(self) -> None: ...

class vtkCompositeCellGridMapper(vtkMapper):
    bounds:'getset_descriptor'
    cell_id_array_name:'getset_descriptor'
    cell_id_attribute_name:'getset_descriptor'
    composite_data_display_attributes:'getset_descriptor'
    composite_id_array_name:'getset_descriptor'
    composite_id_attribute_name:'getset_descriptor'
    m_time:'getset_descriptor'
    point_id_array_name:'getset_descriptor'
    point_id_attribute_name:'getset_descriptor'
    process_id_array_name:'getset_descriptor'
    process_id_attribute_name:'getset_descriptor'
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCellIdAttributeName(self) -> 'vtkStringToken': ...
    def GetCompositeDataDisplayAttributes(self) -> 'vtkCompositeDataDisplayAttributes': ...
    def GetCompositeIdAttributeName(self) -> 'vtkStringToken': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointIdAttributeName(self) -> 'vtkStringToken': ...
    def GetProcessIdAttributeName(self) -> 'vtkStringToken': ...
    def HasOpaqueGeometry(self) -> bool: ...
    def HasTranslucentPolygonalGeometry(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeCellGridMapper': ...
    def RecursiveHasTranslucentGeometry(self, dobj:'vtkDataObject', flat_index:int) -> bool: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', a:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeCellGridMapper': ...
    def SetCellIdArrayName(self, __a:str) -> None: ...
    def SetCellIdAttributeName(self, _arg:'vtkStringToken') -> None: ...
    def SetCompositeDataDisplayAttributes(self, __a:'vtkCompositeDataDisplayAttributes') -> None: ...
    def SetCompositeIdArrayName(self, __a:str) -> None: ...
    def SetCompositeIdAttributeName(self, _arg:'vtkStringToken') -> None: ...
    def SetPointIdArrayName(self, __a:str) -> None: ...
    def SetPointIdAttributeName(self, _arg:'vtkStringToken') -> None: ...
    def SetProcessIdArrayName(self, __a:str) -> None: ...
    def SetProcessIdAttributeName(self, _arg:'vtkStringToken') -> None: ...

class vtkCompositeDataDisplayAttributes(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def ComputeVisibleBounds(cda:'vtkCompositeDataDisplayAttributes', dobj:'vtkDataObject', bounds:MutableSequence[float]) -> None: ...
    @staticmethod
    def DataObjectFromIndex(flat_index:int, parent_obj:'vtkDataObject', current_flat_index:int=0) -> 'vtkDataObject': ...
    def GetBlockArrayAccessMode(self, data_object:'vtkDataObject') -> int: ...
    def GetBlockArrayComponent(self, data_object:'vtkDataObject') -> int: ...
    def GetBlockArrayId(self, data_object:'vtkDataObject') -> int: ...
    def GetBlockArrayName(self, data_object:'vtkDataObject') -> str: ...
    @overload
    def GetBlockColor(self, data_object:'vtkDataObject', color:MutableSequence[float]) -> None: ...
    @overload
    def GetBlockColor(self, data_object:'vtkDataObject') -> 'vtkColor3d': ...
    def GetBlockColorMode(self, data_object:'vtkDataObject') -> int: ...
    def GetBlockFieldDataTupleId(self, data_object:'vtkDataObject') -> int: ...
    def GetBlockInterpolateScalarsBeforeMapping(self, data_object:'vtkDataObject') -> bool: ...
    def GetBlockLookupTable(self, data_object:'vtkDataObject') -> 'vtkScalarsToColors': ...
    def GetBlockMaterial(self, data_object:'vtkDataObject') -> str: ...
    def GetBlockOpacity(self, data_object:'vtkDataObject') -> float: ...
    def GetBlockPickability(self, data_object:'vtkDataObject') -> bool: ...
    def GetBlockScalarMode(self, data_object:'vtkDataObject') -> int: ...
    def GetBlockScalarRange(self, data_object:'vtkDataObject') -> 'vtkVector2d': ...
    def GetBlockScalarVisibility(self, data_object:'vtkDataObject') -> bool: ...
    def GetBlockUseLookupTableScalarRange(self, data_object:'vtkDataObject') -> bool: ...
    def GetBlockVisibility(self, data_object:'vtkDataObject') -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasBlockArrayAccessMode(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockArrayAccessModes(self) -> bool: ...
    def HasBlockArrayComponent(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockArrayComponents(self) -> bool: ...
    def HasBlockArrayId(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockArrayIds(self) -> bool: ...
    def HasBlockArrayName(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockArrayNames(self) -> bool: ...
    def HasBlockColor(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockColorMode(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockColorModes(self) -> bool: ...
    def HasBlockColors(self) -> bool: ...
    def HasBlockFieldDataTupleId(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockFieldDataTupleIds(self) -> bool: ...
    def HasBlockInterpolateScalarsBeforeMapping(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockInterpolateScalarsBeforeMappings(self) -> bool: ...
    def HasBlockLookupTable(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockLookupTables(self) -> bool: ...
    def HasBlockMaterial(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockMaterials(self) -> bool: ...
    def HasBlockOpacities(self) -> bool: ...
    def HasBlockOpacity(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockPickabilities(self) -> bool: ...
    def HasBlockPickability(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockScalarMode(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockScalarModes(self) -> bool: ...
    def HasBlockScalarRange(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockScalarRanges(self) -> bool: ...
    def HasBlockScalarVisibilities(self) -> bool: ...
    def HasBlockScalarVisibility(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockUseLookupTableScalarRange(self, data_object:'vtkDataObject') -> bool: ...
    def HasBlockUseLookupTableScalarRanges(self) -> bool: ...
    def HasBlockVisibilities(self) -> bool: ...
    def HasBlockVisibility(self, data_object:'vtkDataObject') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataDisplayAttributes': ...
    def RemoveBlockArrayAccessMode(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockArrayAccessModes(self) -> None: ...
    def RemoveBlockArrayComponent(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockArrayComponents(self) -> None: ...
    def RemoveBlockArrayId(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockArrayIds(self) -> None: ...
    def RemoveBlockArrayName(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockArrayNames(self) -> None: ...
    def RemoveBlockColor(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockColorMode(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockColorModes(self) -> None: ...
    def RemoveBlockColors(self) -> None: ...
    def RemoveBlockFieldDataTupleId(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockFieldDataTupleIds(self) -> None: ...
    def RemoveBlockInterpolateScalarsBeforeMapping(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockInterpolateScalarsBeforeMappings(self) -> None: ...
    def RemoveBlockLookupTable(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockLookupTables(self) -> None: ...
    def RemoveBlockMaterial(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockMaterials(self) -> None: ...
    def RemoveBlockOpacities(self) -> None: ...
    def RemoveBlockOpacity(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockPickabilities(self) -> None: ...
    def RemoveBlockPickability(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockScalarMode(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockScalarModes(self) -> None: ...
    def RemoveBlockScalarRange(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockScalarRanges(self) -> None: ...
    def RemoveBlockScalarVisibilities(self) -> None: ...
    def RemoveBlockScalarVisibility(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockUseLookupTableScalarRange(self, data_object:'vtkDataObject') -> None: ...
    def RemoveBlockUseLookupTableScalarRanges(self) -> None: ...
    def RemoveBlockVisibilities(self) -> None: ...
    def RemoveBlockVisibility(self, data_object:'vtkDataObject') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataDisplayAttributes': ...
    def SetBlockArrayAccessMode(self, data_object:'vtkDataObject', value:int) -> None: ...
    def SetBlockArrayComponent(self, data_object:'vtkDataObject', value:int) -> None: ...
    def SetBlockArrayId(self, data_object:'vtkDataObject', value:int) -> None: ...
    def SetBlockArrayName(self, data_object:'vtkDataObject', value:str) -> None: ...
    def SetBlockColor(self, data_object:'vtkDataObject', color:Sequence[float]) -> None: ...
    def SetBlockColorMode(self, data_object:'vtkDataObject', value:int) -> None: ...
    def SetBlockFieldDataTupleId(self, data_object:'vtkDataObject', value:int) -> None: ...
    def SetBlockInterpolateScalarsBeforeMapping(self, data_object:'vtkDataObject', value:bool) -> None: ...
    def SetBlockLookupTable(self, data_object:'vtkDataObject', lut:'vtkScalarsToColors') -> None: ...
    def SetBlockMaterial(self, data_object:'vtkDataObject', material:str) -> None: ...
    def SetBlockOpacity(self, data_object:'vtkDataObject', opacity:float) -> None: ...
    def SetBlockPickability(self, data_object:'vtkDataObject', visible:bool) -> None: ...
    def SetBlockScalarMode(self, data_object:'vtkDataObject', value:int) -> None: ...
    def SetBlockScalarRange(self, data_object:'vtkDataObject', value:'vtkVector2d') -> None: ...
    def SetBlockScalarVisibility(self, data_object:'vtkDataObject', value:bool) -> None: ...
    def SetBlockUseLookupTableScalarRange(self, data_object:'vtkDataObject', value:bool) -> None: ...
    def SetBlockVisibility(self, data_object:'vtkDataObject', visible:bool) -> None: ...

class vtkCompositeDataDisplayAttributesLegacy(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def ComputeVisibleBounds(cda:'vtkCompositeDataDisplayAttributesLegacy', dobj:'vtkDataObject', bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBlockColor(self, flat_index:int, color:MutableSequence[float]) -> None: ...
    @overload
    def GetBlockColor(self, flat_index:int) -> 'vtkColor3d': ...
    def GetBlockOpacity(self, flat_index:int) -> float: ...
    def GetBlockPickability(self, flat_index:int) -> bool: ...
    def GetBlockVisibility(self, flat_index:int) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasBlockColor(self, flat_index:int) -> bool: ...
    def HasBlockColors(self) -> bool: ...
    def HasBlockOpacities(self) -> bool: ...
    def HasBlockOpacity(self, flat_index:int) -> bool: ...
    def HasBlockPickabilities(self) -> bool: ...
    def HasBlockPickability(self, flat_index:int) -> bool: ...
    def HasBlockVisibilities(self) -> bool: ...
    def HasBlockVisibility(self, flat_index:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeDataDisplayAttributesLegacy': ...
    def RemoveBlockColor(self, flat_index:int) -> None: ...
    def RemoveBlockColors(self) -> None: ...
    def RemoveBlockOpacities(self) -> None: ...
    def RemoveBlockOpacity(self, flat_index:int) -> None: ...
    def RemoveBlockPickabilities(self) -> None: ...
    def RemoveBlockPickability(self, flat_index:int) -> None: ...
    def RemoveBlockVisibilities(self) -> None: ...
    def RemoveBlockVisibility(self, flat_index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeDataDisplayAttributesLegacy': ...
    def SetBlockColor(self, flat_index:int, color:Sequence[float]) -> None: ...
    def SetBlockOpacity(self, flat_index:int, opacity:float) -> None: ...
    def SetBlockPickability(self, flat_index:int, visible:bool) -> None: ...
    def SetBlockVisibility(self, flat_index:int, visible:bool) -> None: ...

class vtkPolyDataMapper(vtkMapper):
    class ShiftScaleMethodType(int): ...
    ALWAYS_AUTO_SHIFT_SCALE:'ShiftScaleMethodType'
    AUTO_SHIFT:'ShiftScaleMethodType'
    AUTO_SHIFT_SCALE:'ShiftScaleMethodType'
    DISABLE_SHIFT_SCALE:'ShiftScaleMethodType'
    FOCAL_POINT_SHIFT_SCALE:'ShiftScaleMethodType'
    MANUAL_SHIFT_SCALE:'ShiftScaleMethodType'
    NEAR_PLANE_SHIFT_SCALE:'ShiftScaleMethodType'
    bounds:'getset_descriptor'
    ghost_level:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    number_of_sub_pieces:'getset_descriptor'
    pause_shift_scale:'getset_descriptor'
    piece:'getset_descriptor'
    seamless_u:'getset_descriptor'
    seamless_v:'getset_descriptor'
    vbo_shift_scale_method:'getset_descriptor'
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetGhostLevel(self) -> int: ...
    def GetInput(self) -> 'vtkPolyData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPieces(self) -> int: ...
    def GetNumberOfSubPieces(self) -> int: ...
    def GetPauseShiftScale(self) -> bool: ...
    def GetPiece(self) -> int: ...
    def GetSeamlessU(self) -> bool: ...
    def GetSeamlessV(self) -> bool: ...
    def GetVBOShiftScaleMethod(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapDataArrayToMultiTextureAttribute(self, textureName:str, dataArrayName:str, fieldAssociation:int, componentno:int=-1) -> None: ...
    def MapDataArrayToVertexAttribute(self, vertexAttributeName:str, dataArrayName:str, fieldAssociation:int, componentno:int=-1) -> None: ...
    def NewInstance(self) -> 'vtkPolyDataMapper': ...
    def PauseShiftScaleOff(self) -> None: ...
    def PauseShiftScaleOn(self) -> None: ...
    def RemoveAllVertexAttributeMappings(self) -> None: ...
    def RemoveVertexAttributeMapping(self, vertexAttributeName:str) -> None: ...
    def Render(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    def RenderPiece(self, __a:'vtkRenderer', __b:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataMapper': ...
    def SeamlessUOff(self) -> None: ...
    def SeamlessUOn(self) -> None: ...
    def SeamlessVOff(self) -> None: ...
    def SeamlessVOn(self) -> None: ...
    def SetGhostLevel(self, _arg:int) -> None: ...
    def SetInputData(self, in_:'vtkPolyData') -> None: ...
    def SetNumberOfPieces(self, _arg:int) -> None: ...
    def SetNumberOfSubPieces(self, _arg:int) -> None: ...
    def SetPauseShiftScale(self, pauseShiftScale:bool) -> None: ...
    def SetPiece(self, _arg:int) -> None: ...
    def SetSeamlessU(self, _arg:bool) -> None: ...
    def SetSeamlessV(self, _arg:bool) -> None: ...
    def SetVBOShiftScaleMethod(self, __a:int) -> None: ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...
    @overload
    def Update(self, port:int) -> None: ...
    @overload
    def Update(self) -> None: ...
    @overload
    def Update(self, port:int, requests:'vtkInformationVector') -> int: ...
    @overload
    def Update(self, requests:'vtkInformation') -> int: ...

class vtkCompositePolyDataMapper(vtkPolyDataMapper):
    bounds:'getset_descriptor'
    cell_id_array_name:'getset_descriptor'
    color_missing_arrays_with_nan_color:'getset_descriptor'
    composite_data_display_attributes:'getset_descriptor'
    composite_id_array_name:'getset_descriptor'
    input_array_to_process:'getset_descriptor'
    m_time:'getset_descriptor'
    pause_shift_scale:'getset_descriptor'
    point_id_array_name:'getset_descriptor'
    process_id_array_name:'getset_descriptor'
    vbo_shift_scale_method:'getset_descriptor'
    def ColorMissingArraysWithNanColorOff(self) -> None: ...
    def ColorMissingArraysWithNanColorOn(self) -> None: ...
    def GetBlockArrayAccessMode(self, index:int) -> int: ...
    def GetBlockArrayComponent(self, index:int) -> int: ...
    def GetBlockArrayId(self, index:int) -> int: ...
    def GetBlockArrayName(self, index:int) -> str: ...
    @overload
    def GetBlockColor(self, index:int) -> Pointer: ...
    @overload
    def GetBlockColor(self, index:int, color:MutableSequence[float]) -> None: ...
    def GetBlockFieldDataTupleId(self, index:int) -> int: ...
    def GetBlockOpacity(self, index:int) -> float: ...
    def GetBlockScalarMode(self, index:int) -> int: ...
    def GetBlockVisibility(self, index:int) -> bool: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCellIdArrayName(self) -> str: ...
    def GetColorMissingArraysWithNanColor(self) -> bool: ...
    def GetCompositeDataDisplayAttributes(self) -> 'vtkCompositeDataDisplayAttributes': ...
    def GetCompositeIdArrayName(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointIdArrayName(self) -> str: ...
    def GetProcessIdArrayName(self) -> str: ...
    def HasOpaqueGeometry(self) -> bool: ...
    def HasTranslucentPolygonalGeometry(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositePolyDataMapper': ...
    def ProcessSelectorPixelBuffers(self, sel:'vtkHardwareSelector', pixeloffsets:MutableSequence[int], prop:'vtkProp') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveBlockArrayAccessMode(self, index:int) -> None: ...
    def RemoveBlockArrayAccessModes(self) -> None: ...
    def RemoveBlockArrayComponent(self, index:int) -> None: ...
    def RemoveBlockArrayComponents(self) -> None: ...
    def RemoveBlockArrayId(self, index:int) -> None: ...
    def RemoveBlockArrayIds(self) -> None: ...
    def RemoveBlockArrayName(self, index:int) -> None: ...
    def RemoveBlockArrayNames(self) -> None: ...
    def RemoveBlockColor(self, index:int) -> None: ...
    def RemoveBlockColors(self) -> None: ...
    def RemoveBlockFieldDataTupleId(self, index:int) -> None: ...
    def RemoveBlockFieldDataTupleIds(self) -> None: ...
    def RemoveBlockOpacities(self) -> None: ...
    def RemoveBlockOpacity(self, index:int) -> None: ...
    def RemoveBlockScalarMode(self, index:int) -> None: ...
    def RemoveBlockScalarModes(self) -> None: ...
    def RemoveBlockVisibilities(self) -> None: ...
    def RemoveBlockVisibility(self, index:int) -> None: ...
    def Render(self, renderer:'vtkRenderer', actor:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositePolyDataMapper': ...
    def SetBlockArrayAccessMode(self, index:int, value:int) -> None: ...
    def SetBlockArrayComponent(self, index:int, value:int) -> None: ...
    def SetBlockArrayId(self, index:int, value:int) -> None: ...
    def SetBlockArrayName(self, index:int, value:str) -> None: ...
    @overload
    def SetBlockColor(self, index:int, color:Sequence[float]) -> None: ...
    @overload
    def SetBlockColor(self, index:int, r:float, g:float, b:float) -> None: ...
    def SetBlockFieldDataTupleId(self, index:int, value:int) -> None: ...
    def SetBlockOpacity(self, index:int, opacity:float) -> None: ...
    def SetBlockScalarMode(self, index:int, value:int) -> None: ...
    def SetBlockVisibility(self, index:int, visible:bool) -> None: ...
    def SetCellIdArrayName(self, _arg:str) -> None: ...
    def SetColorMissingArraysWithNanColor(self, _arg:bool) -> None: ...
    def SetCompositeDataDisplayAttributes(self, attributes:'vtkCompositeDataDisplayAttributes') -> None: ...
    def SetCompositeIdArrayName(self, _arg:str) -> None: ...
    @overload
    def SetInputArrayToProcess(self, idx:int, port:int, connection:int, fieldAssociation:int, name:str) -> None: ...
    @overload
    def SetInputArrayToProcess(self, idx:int, port:int, connection:int, fieldAssociation:int, fieldAttributeType:int) -> None: ...
    @overload
    def SetInputArrayToProcess(self, idx:int, info:'vtkInformation') -> None: ...
    @overload
    def SetInputArrayToProcess(self, idx:int, port:int, connection:int, fieldAssociation:str, attributeTypeorName:str) -> None: ...
    def SetPauseShiftScale(self, pauseShiftScale:bool) -> None: ...
    def SetPointIdArrayName(self, _arg:str) -> None: ...
    def SetProcessIdArrayName(self, _arg:str) -> None: ...
    def SetVBOShiftScaleMethod(self, method:int) -> None: ...
    def ShallowCopy(self, mapper:'vtkAbstractMapper') -> None: ...

class vtkCompositePolyDataMapperDelegator(vtkmodules.vtkCommonCore.vtkObject):
    delegate:'getset_descriptor'
    marked:'getset_descriptor'
    parent:'getset_descriptor'
    def Clear(self) -> None: ...
    def ClearUnmarkedBatchElements(self) -> None: ...
    def GetDelegate(self) -> 'vtkPolyDataMapper': ...
    def GetMarked(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Mark(self) -> None: ...
    def NewInstance(self) -> 'vtkCompositePolyDataMapperDelegator': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositePolyDataMapperDelegator': ...
    def SetParent(self, mapper:'vtkCompositePolyDataMapper') -> None: ...
    def ShallowCopy(self, polydataMapper:'vtkCompositePolyDataMapper') -> None: ...
    def Unmark(self) -> None: ...
    def UnmarkBatchElements(self) -> None: ...

class vtkCoordinate(vtkmodules.vtkCommonCore.vtkObject):
    coordinate_system:'getset_descriptor'
    reference_coordinate:'getset_descriptor'
    value:'getset_descriptor'
    viewport:'getset_descriptor'
    def GetComputedDisplayValue(self, __a:'vtkViewport') -> Tuple[int, int]: ...
    def GetComputedDoubleDisplayValue(self, __a:'vtkViewport') -> Tuple[float, float]: ...
    def GetComputedDoubleViewportValue(self, __a:'vtkViewport') -> Tuple[float, float]: ...
    def GetComputedLocalDisplayValue(self, __a:'vtkViewport') -> Tuple[int, int]: ...
    def GetComputedUserDefinedValue(self, __a:'vtkViewport') -> Tuple[float, float, float]: ...
    def GetComputedValue(self, __a:'vtkViewport') -> Tuple[float, float, float]: ...
    def GetComputedViewportValue(self, __a:'vtkViewport') -> Tuple[int, int]: ...
    def GetComputedWorldValue(self, __a:'vtkViewport') -> Tuple[float, float, float]: ...
    def GetCoordinateSystem(self) -> int: ...
    def GetCoordinateSystemAsString(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReferenceCoordinate(self) -> 'vtkCoordinate': ...
    def GetValue(self) -> Tuple[float, float, float]: ...
    def GetViewport(self) -> 'vtkViewport': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCoordinate': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCoordinate': ...
    def SetCoordinateSystem(self, _arg:int) -> None: ...
    def SetCoordinateSystemToDisplay(self) -> None: ...
    def SetCoordinateSystemToNormalizedDisplay(self) -> None: ...
    def SetCoordinateSystemToNormalizedViewport(self) -> None: ...
    def SetCoordinateSystemToPose(self) -> None: ...
    def SetCoordinateSystemToView(self) -> None: ...
    def SetCoordinateSystemToViewport(self) -> None: ...
    def SetCoordinateSystemToWorld(self) -> None: ...
    def SetReferenceCoordinate(self, __a:'vtkCoordinate') -> None: ...
    @overload
    def SetValue(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetValue(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetValue(self, a:float, b:float) -> None: ...
    def SetViewport(self, viewport:'vtkViewport') -> None: ...

class vtkCuller(vtkmodules.vtkCommonCore.vtkObject):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCuller': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCuller': ...

class vtkCullerCollection(vtkmodules.vtkCommonCore.vtkCollection):
    last_item:'getset_descriptor'
    next_item:'getset_descriptor'
    def AddItem(self, a:'vtkCuller') -> None: ...
    def GetLastItem(self) -> 'vtkCuller': ...
    def GetNextItem(self) -> 'vtkCuller': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCullerCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCullerCollection': ...

class vtkDataSetMapper(vtkMapper):
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    m_time:'getset_descriptor'
    poly_data_mapper:'getset_descriptor'
    def GetInput(self) -> 'vtkDataSet': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyDataMapper(self) -> 'vtkPolyDataMapper': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataSetMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataSetMapper': ...
    def SetInputData(self, input:'vtkDataSet') -> None: ...

class vtkDiscretizableColorTransferFunction(vtkColorTransferFunction):
    alpha:'getset_descriptor'
    discretize:'getset_descriptor'
    enable_opacity_mapping:'getset_descriptor'
    m_time:'getset_descriptor'
    nan_color:'getset_descriptor'
    nan_opacity:'getset_descriptor'
    number_of_available_colors:'getset_descriptor'
    number_of_indexed_colors:'getset_descriptor'
    number_of_values:'getset_descriptor'
    scalar_opacity_function:'getset_descriptor'
    use_log_scale:'getset_descriptor'
    def Build(self) -> None: ...
    def DiscretizeOff(self) -> None: ...
    def DiscretizeOn(self) -> None: ...
    def EnableOpacityMappingOff(self) -> None: ...
    def EnableOpacityMappingOn(self) -> None: ...
    def GetColor(self, v:float, rgb:MutableSequence[float]) -> None: ...
    def GetDiscretize(self) -> int: ...
    def GetEnableOpacityMapping(self) -> bool: ...
    def GetIndexedColor(self, i:int, rgba:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfAvailableColors(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfIndexedColors(self) -> int: ...
    def GetNumberOfValues(self) -> int: ...
    def GetOpacity(self, v:float) -> float: ...
    def GetScalarOpacityFunction(self) -> 'vtkPiecewiseFunction': ...
    def GetUseLogScale(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @overload
    def IsOpaque(self) -> int: ...
    @overload
    def IsOpaque(self, scalars:'vtkAbstractArray', colorMode:int, component:int) -> int: ...
    @overload
    def IsOpaque(self, scalars:'vtkAbstractArray', colorMode:int, component:int, ghosts:'vtkUnsignedCharArray', ghostsToSkip:int=0xff) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsThroughTable2(self, input:Pointer, output:MutableSequence[int], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int) -> None: ...
    def MapValue(self, v:float) -> Pointer: ...
    def NewInstance(self) -> 'vtkDiscretizableColorTransferFunction': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDiscretizableColorTransferFunction': ...
    def SetAlpha(self, alpha:float) -> None: ...
    def SetDiscretize(self, _arg:int) -> None: ...
    def SetEnableOpacityMapping(self, _arg:bool) -> None: ...
    def SetIndexedColor(self, index:int, r:float, g:float, b:float, a:float=1.0) -> None: ...
    def SetIndexedColorRGB(self, index:int, rgb:Sequence[float]) -> None: ...
    def SetIndexedColorRGBA(self, index:int, rgba:Sequence[float]) -> None: ...
    @overload
    def SetNanColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetNanColor(self, rgb:Sequence[float]) -> None: ...
    def SetNanOpacity(self, a:float) -> None: ...
    def SetNumberOfIndexedColors(self, count:int) -> None: ...
    def SetNumberOfValues(self, _arg:int) -> None: ...
    def SetScalarOpacityFunction(self, function:'vtkPiecewiseFunction') -> None: ...
    def SetUseLogScale(self, useLogScale:int) -> None: ...
    def UsingLogScale(self) -> int: ...

class vtkDistanceToCamera(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    distance_array_name:'getset_descriptor'
    m_time:'getset_descriptor'
    renderer:'getset_descriptor'
    scaling:'getset_descriptor'
    screen_size:'getset_descriptor'
    def GetDistanceArrayName(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetScaling(self) -> bool: ...
    def GetScreenSize(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDistanceToCamera': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDistanceToCamera': ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetDistanceArrayName(self, _arg:str) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetScaling(self, _arg:bool) -> None: ...
    def SetScreenSize(self, _arg:float) -> None: ...

class vtkFXAAOptions(vtkmodules.vtkCommonCore.vtkObject):
    class DebugOption(int): ...
    FXAA_DEBUG_EDGE_DIRECTION:'DebugOption'
    FXAA_DEBUG_EDGE_DISTANCE:'DebugOption'
    FXAA_DEBUG_EDGE_NUM_STEPS:'DebugOption'
    FXAA_DEBUG_EDGE_SAMPLE_OFFSET:'DebugOption'
    FXAA_DEBUG_ONLY_EDGE_AA:'DebugOption'
    FXAA_DEBUG_ONLY_SUBPIX_AA:'DebugOption'
    FXAA_DEBUG_SUBPIXEL_ALIASING:'DebugOption'
    FXAA_NO_DEBUG:'DebugOption'
    debug_option_value:'getset_descriptor'
    endpoint_search_iterations:'getset_descriptor'
    hard_contrast_threshold:'getset_descriptor'
    relative_contrast_threshold:'getset_descriptor'
    subpixel_blend_limit:'getset_descriptor'
    subpixel_contrast_threshold:'getset_descriptor'
    use_high_quality_endpoints:'getset_descriptor'
    def GetDebugOptionValue(self) -> 'DebugOption': ...
    def GetEndpointSearchIterations(self) -> int: ...
    def GetEndpointSearchIterationsMaxValue(self) -> int: ...
    def GetEndpointSearchIterationsMinValue(self) -> int: ...
    def GetHardContrastThreshold(self) -> float: ...
    def GetHardContrastThresholdMaxValue(self) -> float: ...
    def GetHardContrastThresholdMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRelativeContrastThreshold(self) -> float: ...
    def GetRelativeContrastThresholdMaxValue(self) -> float: ...
    def GetRelativeContrastThresholdMinValue(self) -> float: ...
    def GetSubpixelBlendLimit(self) -> float: ...
    def GetSubpixelBlendLimitMaxValue(self) -> float: ...
    def GetSubpixelBlendLimitMinValue(self) -> float: ...
    def GetSubpixelContrastThreshold(self) -> float: ...
    def GetSubpixelContrastThresholdMaxValue(self) -> float: ...
    def GetSubpixelContrastThresholdMinValue(self) -> float: ...
    def GetUseHighQualityEndpoints(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFXAAOptions': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFXAAOptions': ...
    def SetDebugOptionValue(self, _arg:'DebugOption') -> None: ...
    def SetEndpointSearchIterations(self, _arg:int) -> None: ...
    def SetHardContrastThreshold(self, _arg:float) -> None: ...
    def SetRelativeContrastThreshold(self, _arg:float) -> None: ...
    def SetSubpixelBlendLimit(self, _arg:float) -> None: ...
    def SetSubpixelContrastThreshold(self, _arg:float) -> None: ...
    def SetUseHighQualityEndpoints(self, _arg:bool) -> None: ...
    def UseHighQualityEndpointsOff(self) -> None: ...
    def UseHighQualityEndpointsOn(self) -> None: ...

class vtkFlagpoleLabel(vtkActor):
    base_position:'getset_descriptor'
    bounds:'getset_descriptor'
    flag_size:'getset_descriptor'
    force_opaque:'getset_descriptor'
    force_translucent:'getset_descriptor'
    input:'getset_descriptor'
    text_property:'getset_descriptor'
    top_position:'getset_descriptor'
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    def GetBasePosition(self) -> Tuple[float, float, float]: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetFlagSize(self) -> float: ...
    def GetForceOpaque(self) -> bool: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetInput(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def GetTopPosition(self) -> Tuple[float, float, float]: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFlagpoleLabel': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, vp:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, vp:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFlagpoleLabel': ...
    def SetBasePosition(self, x:float, y:float, z:float) -> None: ...
    def SetFlagSize(self, _arg:float) -> None: ...
    def SetForceOpaque(self, opaque:bool) -> None: ...
    def SetForceTranslucent(self, trans:bool) -> None: ...
    def SetInput(self, in_:str) -> None: ...
    def SetTextProperty(self, tprop:'vtkTextProperty') -> None: ...
    def SetTopPosition(self, x:float, y:float, z:float) -> None: ...

class vtkFollower(vtkActor):
    camera:'getset_descriptor'
    def ComputeMatrix(self) -> None: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFollower': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFollower': ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkFrameBufferObjectBase(vtkmodules.vtkCommonCore.vtkObject):
    @overload
    def GetLastSize(self) -> Pointer: ...
    @overload
    def GetLastSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def GetLastSize(self, _arg:MutableSequence[int]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFrameBufferObjectBase': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFrameBufferObjectBase': ...

class vtkFrustumCoverageCuller(vtkCuller):
    maximum_coverage:'getset_descriptor'
    minimum_coverage:'getset_descriptor'
    sorting_style:'getset_descriptor'
    def GetMaximumCoverage(self) -> float: ...
    def GetMinimumCoverage(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSortingStyle(self) -> int: ...
    def GetSortingStyleAsString(self) -> str: ...
    def GetSortingStyleMaxValue(self) -> int: ...
    def GetSortingStyleMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFrustumCoverageCuller': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFrustumCoverageCuller': ...
    def SetMaximumCoverage(self, _arg:float) -> None: ...
    def SetMinimumCoverage(self, _arg:float) -> None: ...
    def SetSortingStyle(self, _arg:int) -> None: ...
    def SetSortingStyleToBackToFront(self) -> None: ...
    def SetSortingStyleToFrontToBack(self) -> None: ...
    def SetSortingStyleToNone(self) -> None: ...

class vtkGPUInfo(vtkmodules.vtkCommonCore.vtkObject):
    dedicated_system_memory:'getset_descriptor'
    dedicated_video_memory:'getset_descriptor'
    shared_system_memory:'getset_descriptor'
    def GetDedicatedSystemMemory(self) -> int: ...
    def GetDedicatedVideoMemory(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSharedSystemMemory(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGPUInfo': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGPUInfo': ...
    def SetDedicatedSystemMemory(self, _arg:int) -> None: ...
    def SetDedicatedVideoMemory(self, _arg:int) -> None: ...
    def SetSharedSystemMemory(self, _arg:int) -> None: ...

class vtkGPUInfoList(vtkmodules.vtkCommonCore.vtkObject):
    number_of_gp_us:'getset_descriptor'
    def GetGPUInfo(self, i:int) -> 'vtkGPUInfo': ...
    def GetNumberOfGPUs(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsProbed(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGPUInfoList': ...
    def Probe(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGPUInfoList': ...

class vtkGPUInfoListArray(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkGPUInfoListArray') -> None: ...

class vtkGenericVertexAttributeMapping(vtkmodules.vtkCommonCore.vtkObject):
    number_of_mappings:'getset_descriptor'
    @overload
    def AddMapping(self, attributeName:str, arrayName:str, fieldAssociation:int, component:int) -> None: ...
    @overload
    def AddMapping(self, unit:int, arrayName:str, fieldAssociation:int, component:int) -> None: ...
    def GetArrayName(self, index:int) -> str: ...
    def GetAttributeName(self, index:int) -> str: ...
    def GetComponent(self, index:int) -> int: ...
    def GetFieldAssociation(self, index:int) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfMappings(self) -> int: ...
    def GetTextureUnit(self, index:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGenericVertexAttributeMapping': ...
    def RemoveAllMappings(self) -> None: ...
    def RemoveMapping(self, attributeName:str) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGenericVertexAttributeMapping': ...

class vtkGlyph3DMapper(vtkMapper):
    class ArrayIndexes(int): ...
    class OrientationModes(int): ...
    class ScaleModes(int): ...
    DIRECTION:'OrientationModes'
    MASK:'ArrayIndexes'
    NO_DATA_SCALING:'ScaleModes'
    ORIENTATION:'ArrayIndexes'
    QUATERNION:'OrientationModes'
    ROTATION:'OrientationModes'
    SCALE:'ArrayIndexes'
    SCALE_BY_COMPONENTS:'ScaleModes'
    SCALE_BY_MAGNITUDE:'ScaleModes'
    SELECTIONID:'ArrayIndexes'
    SOURCE_INDEX:'ArrayIndexes'
    block_attributes:'getset_descriptor'
    bounds:'getset_descriptor'
    clamping:'getset_descriptor'
    culling_and_lod:'getset_descriptor'
    input_data:'getset_descriptor'
    lod_coloring:'getset_descriptor'
    mask_array:'getset_descriptor'
    masking:'getset_descriptor'
    max_number_of_lod:'getset_descriptor'
    number_of_lod:'getset_descriptor'
    orient:'getset_descriptor'
    orientation_array:'getset_descriptor'
    orientation_mode:'getset_descriptor'
    range:'getset_descriptor'
    scale_array:'getset_descriptor'
    scale_factor:'getset_descriptor'
    scale_mode:'getset_descriptor'
    scaling:'getset_descriptor'
    selection_color_id:'getset_descriptor'
    selection_id_array:'getset_descriptor'
    source_connection:'getset_descriptor'
    source_data:'getset_descriptor'
    source_index_array:'getset_descriptor'
    source_indexing:'getset_descriptor'
    source_table_tree:'getset_descriptor'
    supports_selection:'getset_descriptor'
    use_selection_ids:'getset_descriptor'
    use_source_table_tree:'getset_descriptor'
    def ClampingOff(self) -> None: ...
    def ClampingOn(self) -> None: ...
    def GetBlockAttributes(self) -> 'vtkCompositeDataDisplayAttributes': ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetClamping(self) -> bool: ...
    def GetCullingAndLOD(self) -> bool: ...
    def GetLODColoring(self) -> bool: ...
    def GetMasking(self) -> bool: ...
    def GetMaxNumberOfLOD(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrient(self) -> bool: ...
    def GetOrientationMode(self) -> int: ...
    def GetOrientationModeAsString(self) -> str: ...
    def GetOrientationModeMaxValue(self) -> int: ...
    def GetOrientationModeMinValue(self) -> int: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetScaleFactor(self) -> float: ...
    def GetScaleMode(self) -> int: ...
    def GetScaleModeAsString(self) -> str: ...
    def GetScaling(self) -> bool: ...
    def GetSelectionColorId(self) -> int: ...
    def GetSource(self, idx:int=0) -> 'vtkPolyData': ...
    def GetSourceIndexing(self) -> bool: ...
    def GetSourceTableTree(self) -> 'vtkDataObjectTree': ...
    def GetSupportsSelection(self) -> bool: ...
    def GetUseSelectionIds(self) -> bool: ...
    def GetUseSourceTableTree(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MaskingOff(self) -> None: ...
    def MaskingOn(self) -> None: ...
    def NewInstance(self) -> 'vtkGlyph3DMapper': ...
    def OrientOff(self) -> None: ...
    def OrientOn(self) -> None: ...
    def Render(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGlyph3DMapper': ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetBlockAttributes(self, attr:'vtkCompositeDataDisplayAttributes') -> None: ...
    def SetClamping(self, _arg:bool) -> None: ...
    def SetCullingAndLOD(self, _arg:bool) -> None: ...
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    def SetLODColoring(self, _arg:bool) -> None: ...
    def SetLODDistanceAndTargetReduction(self, index:int, distance:float, targetReduction:float) -> None: ...
    @overload
    def SetMaskArray(self, maskarrayname:str) -> None: ...
    @overload
    def SetMaskArray(self, fieldAttributeType:int) -> None: ...
    def SetMasking(self, _arg:bool) -> None: ...
    def SetNumberOfLOD(self, nb:int) -> None: ...
    def SetOrient(self, _arg:bool) -> None: ...
    @overload
    def SetOrientationArray(self, orientationarrayname:str) -> None: ...
    @overload
    def SetOrientationArray(self, fieldAttributeType:int) -> None: ...
    def SetOrientationMode(self, _arg:int) -> None: ...
    def SetOrientationModeToDirection(self) -> None: ...
    def SetOrientationModeToQuaternion(self) -> None: ...
    def SetOrientationModeToRotation(self) -> None: ...
    @overload
    def SetRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetRange(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetScaleArray(self, scalarsarrayname:str) -> None: ...
    @overload
    def SetScaleArray(self, fieldAttributeType:int) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetScaleMode(self, _arg:int) -> None: ...
    def SetScaleModeToNoDataScaling(self) -> None: ...
    def SetScaleModeToScaleByMagnitude(self) -> None: ...
    def SetScaleModeToScaleByVectorComponents(self) -> None: ...
    def SetScaling(self, _arg:bool) -> None: ...
    def SetSelectionColorId(self, _arg:int) -> None: ...
    @overload
    def SetSelectionIdArray(self, selectionIdArrayName:str) -> None: ...
    @overload
    def SetSelectionIdArray(self, fieldAttributeType:int) -> None: ...
    @overload
    def SetSourceConnection(self, idx:int, algOutput:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetSourceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    @overload
    def SetSourceData(self, idx:int, pd:'vtkPolyData') -> None: ...
    @overload
    def SetSourceData(self, pd:'vtkPolyData') -> None: ...
    @overload
    def SetSourceIndexArray(self, arrayname:str) -> None: ...
    @overload
    def SetSourceIndexArray(self, fieldAttributeType:int) -> None: ...
    def SetSourceIndexing(self, _arg:bool) -> None: ...
    def SetSourceTableTree(self, tree:'vtkDataObjectTree') -> None: ...
    def SetUseSelectionIds(self, _arg:bool) -> None: ...
    def SetUseSourceTableTree(self, _arg:bool) -> None: ...
    def SourceIndexingOff(self) -> None: ...
    def SourceIndexingOn(self) -> None: ...
    def UseSelectionIdsOff(self) -> None: ...
    def UseSelectionIdsOn(self) -> None: ...
    def UseSourceTableTreeOff(self) -> None: ...
    def UseSourceTableTreeOn(self) -> None: ...

class vtkGraphMapper(vtkMapper):
    bounds:'getset_descriptor'
    color_edges:'getset_descriptor'
    color_vertices:'getset_descriptor'
    edge_color_array_name:'getset_descriptor'
    edge_line_width:'getset_descriptor'
    edge_lookup_table:'getset_descriptor'
    edge_visibility:'getset_descriptor'
    enable_edges_by_array:'getset_descriptor'
    enable_vertices_by_array:'getset_descriptor'
    enabled_edges_array_name:'getset_descriptor'
    enabled_vertices_array_name:'getset_descriptor'
    icon_alignment:'getset_descriptor'
    icon_array_name:'getset_descriptor'
    icon_size:'getset_descriptor'
    icon_texture:'getset_descriptor'
    icon_visibility:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    m_time:'getset_descriptor'
    scaled_glyphs:'getset_descriptor'
    scaling_array_name:'getset_descriptor'
    vertex_color_array_name:'getset_descriptor'
    vertex_lookup_table:'getset_descriptor'
    vertex_point_size:'getset_descriptor'
    def AddIconType(self, type:str, index:int) -> None: ...
    def ClearIconTypes(self) -> None: ...
    def ColorEdgesOff(self) -> None: ...
    def ColorEdgesOn(self) -> None: ...
    def ColorVerticesOff(self) -> None: ...
    def ColorVerticesOn(self) -> None: ...
    def EdgeVisibilityOff(self) -> None: ...
    def EdgeVisibilityOn(self) -> None: ...
    def EnableEdgesByArrayOff(self) -> None: ...
    def EnableEdgesByArrayOn(self) -> None: ...
    def EnableVerticesByArrayOff(self) -> None: ...
    def EnableVerticesByArrayOn(self) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetColorEdges(self) -> bool: ...
    def GetColorVertices(self) -> bool: ...
    def GetEdgeColorArrayName(self) -> str: ...
    def GetEdgeLineWidth(self) -> float: ...
    def GetEdgeLookupTable(self) -> 'vtkLookupTable': ...
    def GetEdgeVisibility(self) -> bool: ...
    def GetEnableEdgesByArray(self) -> int: ...
    def GetEnableVerticesByArray(self) -> int: ...
    def GetEnabledEdgesArrayName(self) -> str: ...
    def GetEnabledVerticesArrayName(self) -> str: ...
    def GetIconArrayName(self) -> str: ...
    def GetIconSize(self) -> Pointer: ...
    def GetIconTexture(self) -> 'vtkTexture': ...
    def GetIconVisibility(self) -> bool: ...
    def GetInput(self) -> 'vtkGraph': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaledGlyphs(self) -> bool: ...
    def GetScalingArrayName(self) -> str: ...
    def GetVertexColorArrayName(self) -> str: ...
    def GetVertexLookupTable(self) -> 'vtkLookupTable': ...
    def GetVertexPointSize(self) -> float: ...
    def IconVisibilityOff(self) -> None: ...
    def IconVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphMapper': ...
    def ScaledGlyphsOff(self) -> None: ...
    def ScaledGlyphsOn(self) -> None: ...
    def SetColorEdges(self, vis:bool) -> None: ...
    def SetColorVertices(self, vis:bool) -> None: ...
    def SetEdgeColorArrayName(self, name:str) -> None: ...
    def SetEdgeLineWidth(self, width:float) -> None: ...
    def SetEdgeVisibility(self, vis:bool) -> None: ...
    def SetEnableEdgesByArray(self, _arg:int) -> None: ...
    def SetEnableVerticesByArray(self, _arg:int) -> None: ...
    def SetEnabledEdgesArrayName(self, _arg:str) -> None: ...
    def SetEnabledVerticesArrayName(self, _arg:str) -> None: ...
    def SetIconAlignment(self, alignment:int) -> None: ...
    def SetIconArrayName(self, name:str) -> None: ...
    def SetIconSize(self, size:MutableSequence[int]) -> None: ...
    def SetIconTexture(self, texture:'vtkTexture') -> None: ...
    def SetIconVisibility(self, vis:bool) -> None: ...
    def SetInputData(self, input:'vtkGraph') -> None: ...
    def SetScaledGlyphs(self, arg:bool) -> None: ...
    def SetScalingArrayName(self, _arg:str) -> None: ...
    def SetVertexColorArrayName(self, name:str) -> None: ...
    def SetVertexPointSize(self, size:float) -> None: ...

class vtkGraphToGlyphs(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    CIRCLE:int
    CROSS:int
    DASH:int
    DIAMOND:int
    SPHERE:int
    SQUARE:int
    THICKCROSS:int
    TRIANGLE:int
    VERTEX:int
    filled:'getset_descriptor'
    glyph_type:'getset_descriptor'
    m_time:'getset_descriptor'
    renderer:'getset_descriptor'
    scaling:'getset_descriptor'
    screen_size:'getset_descriptor'
    def FilledOff(self) -> None: ...
    def FilledOn(self) -> None: ...
    def GetFilled(self) -> bool: ...
    def GetGlyphType(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetScaling(self) -> bool: ...
    def GetScreenSize(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphToGlyphs': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphToGlyphs': ...
    def SetFilled(self, _arg:bool) -> None: ...
    def SetGlyphType(self, _arg:int) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetScaling(self, b:bool) -> None: ...
    def SetScreenSize(self, _arg:float) -> None: ...

class vtkGraphicsFactory(vtkmodules.vtkCommonCore.vtkObject):
    off_screen_only_mode:'getset_descriptor'
    render_library:'getset_descriptor'
    use_mesa_classes:'getset_descriptor'
    @staticmethod
    def CreateInstance(vtkclassname:str) -> 'vtkObject': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetOffScreenOnlyMode() -> int: ...
    @staticmethod
    def GetRenderLibrary() -> str: ...
    @staticmethod
    def GetUseMesaClasses() -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphicsFactory': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphicsFactory': ...
    @staticmethod
    def SetOffScreenOnlyMode(use:int) -> None: ...
    @staticmethod
    def SetUseMesaClasses(use:int) -> None: ...

class vtkHardwarePicker(vtkAbstractPropPicker):
    cell_grid_cell_type_id:'getset_descriptor'
    cell_grid_source_spec_id:'getset_descriptor'
    cell_grid_tuple_id:'getset_descriptor'
    cell_id:'getset_descriptor'
    composite_data_set:'getset_descriptor'
    data_object:'getset_descriptor'
    data_set:'getset_descriptor'
    flat_block_index:'getset_descriptor'
    mapper:'getset_descriptor'
    normal_flipped:'getset_descriptor'
    p_coords:'getset_descriptor'
    pick_normal:'getset_descriptor'
    pixel_tolerance:'getset_descriptor'
    point_id:'getset_descriptor'
    snap_to_mesh_point:'getset_descriptor'
    sub_id:'getset_descriptor'
    def GetCellGridCellTypeId(self) -> int: ...
    def GetCellGridSourceSpecId(self) -> int: ...
    def GetCellGridTupleId(self) -> int: ...
    def GetCellId(self) -> int: ...
    def GetCompositeDataSet(self) -> 'vtkCompositeDataSet': ...
    def GetDataObject(self) -> 'vtkDataObject': ...
    def GetDataSet(self) -> 'vtkDataSet': ...
    def GetFlatBlockIndex(self) -> int: ...
    def GetMapper(self) -> 'vtkAbstractMapper3D': ...
    def GetNormalFlipped(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPCoords(self) -> Tuple[float, float, float]: ...
    def GetPickNormal(self) -> Tuple[float, float, float]: ...
    def GetPixelTolerance(self) -> int: ...
    def GetPointId(self) -> int: ...
    def GetSnapToMeshPoint(self) -> bool: ...
    def GetSubId(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHardwarePicker': ...
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:'vtkRenderer') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHardwarePicker': ...
    def SetPixelTolerance(self, _arg:int) -> None: ...
    def SetSnapToMeshPoint(self, _arg:bool) -> None: ...
    def SnapToMeshPointOff(self) -> None: ...
    def SnapToMeshPointOn(self) -> None: ...

class vtkHardwareSelector(vtkmodules.vtkCommonCore.vtkObject):
    class PassTypes(int): ...
    ACTOR_PASS:'PassTypes'
    CELLGRID_CELL_TYPE_INDEX_PASS:'PassTypes'
    CELLGRID_SOURCE_INDEX_PASS:'PassTypes'
    CELLGRID_TUPLE_ID_HIGH24:'PassTypes'
    CELLGRID_TUPLE_ID_LOW24:'PassTypes'
    CELL_ID_HIGH24:'PassTypes'
    CELL_ID_LOW24:'PassTypes'
    COMPOSITE_INDEX_PASS:'PassTypes'
    MAX_KNOWN_PASS:'PassTypes'
    MIN_KNOWN_PASS:'PassTypes'
    POINT_ID_HIGH24:'PassTypes'
    POINT_ID_LOW24:'PassTypes'
    PROCESS_PASS:'PassTypes'
    actor_pass_only:'getset_descriptor'
    area:'getset_descriptor'
    capture_z_values:'getset_descriptor'
    current_pass:'getset_descriptor'
    field_association:'getset_descriptor'
    process_id:'getset_descriptor'
    prop_color_value:'getset_descriptor'
    renderer:'getset_descriptor'
    use_process_id_from_data:'getset_descriptor'
    def BeginRenderProp(self) -> None: ...
    def CaptureBuffers(self) -> bool: ...
    def ClearBuffers(self) -> None: ...
    @staticmethod
    def Convert(id:int, tcoord:MutableSequence[float]) -> None: ...
    def EndRenderProp(self) -> None: ...
    def GeneratePolygonSelection(self, polygonPoints:MutableSequence[int], count:int) -> 'vtkSelection': ...
    @overload
    def GenerateSelection(self) -> 'vtkSelection': ...
    @overload
    def GenerateSelection(self, r:MutableSequence[int]) -> 'vtkSelection': ...
    @overload
    def GenerateSelection(self, x1:int, y1:int, x2:int, y2:int) -> 'vtkSelection': ...
    def GetActorPassOnly(self) -> bool: ...
    def GetArea(self) -> Tuple[int, int, int, int]: ...
    def GetCaptureZValues(self) -> bool: ...
    def GetCurrentPass(self) -> int: ...
    def GetFieldAssociation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixelBuffer(self, passNo:int) -> Pointer: ...
    def GetProcessID(self) -> int: ...
    def GetPropColorValue(self) -> Tuple[float, float, float]: ...
    def GetPropFromID(self, id:int) -> 'vtkProp': ...
    def GetRawPixelBuffer(self, passNo:int) -> Pointer: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetUseProcessIdFromData(self) -> bool: ...
    def HasHighCellGridTupleIds(self) -> bool: ...
    def HasHighCellIds(self) -> bool: ...
    def HasHighPointIds(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHardwareSelector': ...
    def PassTypeToString(self, type:'PassTypes') -> str: ...
    def RenderCompositeIndex(self, index:int) -> None: ...
    def RenderProcessId(self, processid:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHardwareSelector': ...
    def SavePixelBuffer(self, passNo:int) -> None: ...
    def Select(self) -> 'vtkSelection': ...
    def SetActorPassOnly(self, _arg:bool) -> None: ...
    @overload
    def SetArea(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int) -> None: ...
    @overload
    def SetArea(self, _arg:Sequence[int]) -> None: ...
    def SetCaptureZValues(self, _arg:bool) -> None: ...
    def SetFieldAssociation(self, _arg:int) -> None: ...
    def SetProcessID(self, _arg:int) -> None: ...
    @overload
    def SetPropColorValue(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPropColorValue(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPropColorValue(self, val:int) -> None: ...
    def SetRenderer(self, __a:'vtkRenderer') -> None: ...
    def SetUseProcessIdFromData(self, _arg:bool) -> None: ...
    def UpdateMaximumCellGridTupleId(self, attribid:int) -> None: ...
    def UpdateMaximumCellId(self, attribid:int) -> None: ...
    def UpdateMaximumPointId(self, attribid:int) -> None: ...

class vtkHardwareWindow(vtkmodules.vtkCommonCore.vtkWindow):
    def Create(self) -> None: ...
    def Destroy(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHardwareWindow': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHardwareWindow': ...

class vtkHierarchicalPolyDataMapper(vtkCompositePolyDataMapper):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHierarchicalPolyDataMapper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHierarchicalPolyDataMapper': ...

class vtkImageSlice(vtkProp3D):
    bounds:'getset_descriptor'
    force_translucent:'getset_descriptor'
    m_time:'getset_descriptor'
    mapper:'getset_descriptor'
    max_x_bound:'getset_descriptor'
    max_y_bound:'getset_descriptor'
    max_z_bound:'getset_descriptor'
    min_x_bound:'getset_descriptor'
    min_y_bound:'getset_descriptor'
    min_z_bound:'getset_descriptor'
    property:'getset_descriptor'
    redraw_m_time:'getset_descriptor'
    stacked_image_pass:'getset_descriptor'
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetImages(self, __a:'vtkPropCollection') -> None: ...
    def GetMTime(self) -> int: ...
    def GetMapper(self) -> 'vtkImageMapper3D': ...
    def GetMaxXBound(self) -> float: ...
    def GetMaxYBound(self) -> float: ...
    def GetMaxZBound(self) -> float: ...
    def GetMinXBound(self) -> float: ...
    def GetMinYBound(self) -> float: ...
    def GetMinZBound(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkImageProperty': ...
    def GetRedrawMTime(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageSlice': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def Render(self, __a:'vtkRenderer') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageSlice': ...
    def SetForceTranslucent(self, _arg:bool) -> None: ...
    def SetMapper(self, mapper:'vtkImageMapper3D') -> None: ...
    def SetProperty(self, property:'vtkImageProperty') -> None: ...
    def SetStackedImagePass(self, pass_:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def Update(self) -> None: ...

class vtkImageActor(vtkImageSlice):
    bounds:'getset_descriptor'
    display_bounds:'getset_descriptor'
    display_extent:'getset_descriptor'
    force_opaque:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    interpolate:'getset_descriptor'
    opacity:'getset_descriptor'
    slice_number:'getset_descriptor'
    slice_number_max:'getset_descriptor'
    slice_number_min:'getset_descriptor'
    whole_z_max:'getset_descriptor'
    whole_z_min:'getset_descriptor'
    z_slice:'getset_descriptor'
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetDisplayBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetDisplayBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetDisplayExtent(self, extent:MutableSequence[int]) -> None: ...
    @overload
    def GetDisplayExtent(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetForceOpaque(self) -> bool: ...
    def GetInput(self) -> 'vtkImageData': ...
    def GetInterpolate(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetSliceNumber(self) -> int: ...
    def GetSliceNumberMax(self) -> int: ...
    def GetSliceNumberMin(self) -> int: ...
    def GetWholeZMax(self) -> int: ...
    def GetWholeZMin(self) -> int: ...
    def GetZSlice(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InterpolateOff(self) -> None: ...
    def InterpolateOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageActor': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageActor': ...
    @overload
    def SetDisplayExtent(self, extent:Sequence[int]) -> None: ...
    @overload
    def SetDisplayExtent(self, minX:int, maxX:int, minY:int, maxY:int, minZ:int, maxZ:int) -> None: ...
    def SetForceOpaque(self, _arg:bool) -> None: ...
    def SetInputData(self, __a:'vtkImageData') -> None: ...
    def SetInterpolate(self, __a:int) -> None: ...
    def SetOpacity(self, __a:float) -> None: ...
    def SetZSlice(self, z:int) -> None: ...

class vtkMapper2D(vtkAbstractMapper):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMapper2D': ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport', __b:'vtkActor2D') -> None: ...
    def RenderOverlay(self, __a:'vtkViewport', __b:'vtkActor2D') -> None: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport', __b:'vtkActor2D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMapper2D': ...

class vtkImageMapper(vtkMapper2D):
    color_level:'getset_descriptor'
    color_scale:'getset_descriptor'
    color_shift:'getset_descriptor'
    color_window:'getset_descriptor'
    custom_display_extents:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    m_time:'getset_descriptor'
    render_to_rectangle:'getset_descriptor'
    use_custom_extents:'getset_descriptor'
    whole_z_max:'getset_descriptor'
    whole_z_min:'getset_descriptor'
    z_slice:'getset_descriptor'
    def GetColorLevel(self) -> float: ...
    def GetColorScale(self) -> float: ...
    def GetColorShift(self) -> float: ...
    def GetColorWindow(self) -> float: ...
    def GetCustomDisplayExtents(self) -> Tuple[int, int, int, int]: ...
    def GetInput(self) -> 'vtkImageData': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderToRectangle(self) -> int: ...
    def GetUseCustomExtents(self) -> int: ...
    def GetWholeZMax(self) -> int: ...
    def GetWholeZMin(self) -> int: ...
    def GetZSlice(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMapper': ...
    def RenderData(self, __a:'vtkViewport', __b:'vtkImageData', __c:'vtkActor2D') -> None: ...
    def RenderStart(self, viewport:'vtkViewport', actor:'vtkActor2D') -> None: ...
    def RenderToRectangleOff(self) -> None: ...
    def RenderToRectangleOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMapper': ...
    def SetColorLevel(self, _arg:float) -> None: ...
    def SetColorWindow(self, _arg:float) -> None: ...
    def SetCustomDisplayExtents(self, data:Sequence[int]) -> None: ...
    def SetInputData(self, input:'vtkImageData') -> None: ...
    def SetRenderToRectangle(self, _arg:int) -> None: ...
    def SetUseCustomExtents(self, _arg:int) -> None: ...
    def SetZSlice(self, _arg:int) -> None: ...
    def UseCustomExtentsOff(self) -> None: ...
    def UseCustomExtentsOn(self) -> None: ...

class vtkImageMapper3D(vtkAbstractMapper3D):
    background:'getset_descriptor'
    border:'getset_descriptor'
    data_object_input:'getset_descriptor'
    data_set_input:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    number_of_threads:'getset_descriptor'
    number_of_threads_max_value:'getset_descriptor'
    number_of_threads_min_value:'getset_descriptor'
    slice_at_focal_point:'getset_descriptor'
    slice_faces_camera:'getset_descriptor'
    slice_plane:'getset_descriptor'
    streaming:'getset_descriptor'
    def BackgroundOff(self) -> None: ...
    def BackgroundOn(self) -> None: ...
    def BorderOff(self) -> None: ...
    def BorderOn(self) -> None: ...
    def GetBackground(self) -> int: ...
    def GetBorder(self) -> int: ...
    def GetDataObjectInput(self) -> 'vtkDataObject': ...
    def GetDataSetInput(self) -> 'vtkDataSet': ...
    def GetIndexBounds(self, extent:MutableSequence[float]) -> None: ...
    def GetInput(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfThreads(self) -> int: ...
    def GetNumberOfThreadsMaxValue(self) -> int: ...
    def GetNumberOfThreadsMinValue(self) -> int: ...
    def GetSliceAtFocalPoint(self) -> int: ...
    def GetSliceFacesCamera(self) -> int: ...
    def GetSlicePlane(self) -> 'vtkPlane': ...
    def GetSlicePlaneInDataCoords(self, propMatrix:'vtkMatrix4x4', plane:MutableSequence[float]) -> None: ...
    def GetStreaming(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageMapper3D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, renderer:'vtkRenderer', prop:'vtkImageSlice') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageMapper3D': ...
    def SetBackground(self, _arg:int) -> None: ...
    def SetBorder(self, _arg:int) -> None: ...
    def SetInputData(self, input:'vtkImageData') -> None: ...
    def SetNumberOfThreads(self, _arg:int) -> None: ...
    def SetSliceAtFocalPoint(self, _arg:int) -> None: ...
    def SetSliceFacesCamera(self, _arg:int) -> None: ...
    def SetStreaming(self, _arg:int) -> None: ...
    def SliceAtFocalPointOff(self) -> None: ...
    def SliceAtFocalPointOn(self) -> None: ...
    def SliceFacesCameraOff(self) -> None: ...
    def SliceFacesCameraOn(self) -> None: ...
    def StreamingOff(self) -> None: ...
    def StreamingOn(self) -> None: ...

class vtkImageProperty(vtkmodules.vtkCommonCore.vtkObject):
    ambient:'getset_descriptor'
    backing:'getset_descriptor'
    backing_color:'getset_descriptor'
    checkerboard:'getset_descriptor'
    checkerboard_offset:'getset_descriptor'
    checkerboard_spacing:'getset_descriptor'
    color_level:'getset_descriptor'
    color_window:'getset_descriptor'
    diffuse:'getset_descriptor'
    interpolation_type:'getset_descriptor'
    layer_number:'getset_descriptor'
    lookup_table:'getset_descriptor'
    m_time:'getset_descriptor'
    opacity:'getset_descriptor'
    use_lookup_table_scalar_range:'getset_descriptor'
    def BackingOff(self) -> None: ...
    def BackingOn(self) -> None: ...
    def CheckerboardOff(self) -> None: ...
    def CheckerboardOn(self) -> None: ...
    def DeepCopy(self, p:'vtkImageProperty') -> None: ...
    def GetAmbient(self) -> float: ...
    def GetAmbientMaxValue(self) -> float: ...
    def GetAmbientMinValue(self) -> float: ...
    def GetBacking(self) -> int: ...
    def GetBackingColor(self) -> Tuple[float, float, float]: ...
    def GetCheckerboard(self) -> int: ...
    def GetCheckerboardOffset(self) -> Tuple[float, float]: ...
    def GetCheckerboardSpacing(self) -> Tuple[float, float]: ...
    def GetColorLevel(self) -> float: ...
    def GetColorWindow(self) -> float: ...
    def GetDiffuse(self) -> float: ...
    def GetDiffuseMaxValue(self) -> float: ...
    def GetDiffuseMinValue(self) -> float: ...
    def GetInterpolationType(self) -> int: ...
    def GetInterpolationTypeAsString(self) -> str: ...
    def GetInterpolationTypeMaxValue(self) -> int: ...
    def GetInterpolationTypeMinValue(self) -> int: ...
    def GetLayerNumber(self) -> int: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetUseLookupTableScalarRange(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageProperty': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageProperty': ...
    def SetAmbient(self, _arg:float) -> None: ...
    def SetBacking(self, _arg:int) -> None: ...
    @overload
    def SetBackingColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackingColor(self, _arg:Sequence[float]) -> None: ...
    def SetCheckerboard(self, _arg:int) -> None: ...
    @overload
    def SetCheckerboardOffset(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetCheckerboardOffset(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetCheckerboardSpacing(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetCheckerboardSpacing(self, _arg:Sequence[float]) -> None: ...
    def SetColorLevel(self, _arg:float) -> None: ...
    def SetColorWindow(self, _arg:float) -> None: ...
    def SetDiffuse(self, _arg:float) -> None: ...
    def SetInterpolationType(self, _arg:int) -> None: ...
    def SetInterpolationTypeToCubic(self) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToNearest(self) -> None: ...
    def SetLayerNumber(self, _arg:int) -> None: ...
    def SetLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetUseLookupTableScalarRange(self, _arg:int) -> None: ...
    def UseLookupTableScalarRangeOff(self) -> None: ...
    def UseLookupTableScalarRangeOn(self) -> None: ...

class vtkImageSliceMapper(vtkImageMapper3D):
    bounds:'getset_descriptor'
    cropping:'getset_descriptor'
    cropping_region:'getset_descriptor'
    display_extent:'getset_descriptor'
    m_time:'getset_descriptor'
    orientation:'getset_descriptor'
    slice_number:'getset_descriptor'
    def CroppingOff(self) -> None: ...
    def CroppingOn(self) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCropping(self) -> int: ...
    def GetCroppingRegion(self) -> Tuple[int, int, int, int, int, int]: ...
    def GetIndexBounds(self, extent:MutableSequence[float]) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> int: ...
    def GetOrientationMaxValue(self) -> int: ...
    def GetOrientationMinValue(self) -> int: ...
    def GetSliceNumber(self) -> int: ...
    def GetSliceNumberMaxValue(self) -> int: ...
    def GetSliceNumberMinValue(self) -> int: ...
    def GetSlicePlaneInDataCoords(self, propMatrix:'vtkMatrix4x4', plane:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageSliceMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, renderer:'vtkRenderer', prop:'vtkImageSlice') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageSliceMapper': ...
    def SetCropping(self, _arg:int) -> None: ...
    @overload
    def SetCroppingRegion(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int, _arg5:int, _arg6:int) -> None: ...
    @overload
    def SetCroppingRegion(self, _arg:Sequence[int]) -> None: ...
    def SetDisplayExtent(self, extent:Sequence[int]) -> None: ...
    def SetOrientation(self, _arg:int) -> None: ...
    def SetOrientationToI(self) -> None: ...
    def SetOrientationToJ(self) -> None: ...
    def SetOrientationToK(self) -> None: ...
    def SetOrientationToX(self) -> None: ...
    def SetOrientationToY(self) -> None: ...
    def SetOrientationToZ(self) -> None: ...
    def SetSliceNumber(self, slice:int) -> None: ...

class vtkInteractorObserver(vtkmodules.vtkCommonCore.vtkObject):
    current_renderer:'getset_descriptor'
    default_renderer:'getset_descriptor'
    enabled:'getset_descriptor'
    interactor:'getset_descriptor'
    key_press_activation:'getset_descriptor'
    key_press_activation_value:'getset_descriptor'
    picking_managed:'getset_descriptor'
    priority:'getset_descriptor'
    @staticmethod
    def ComputeDisplayToWorld(ren:'vtkRenderer', x:float, y:float, z:float, worldPt:MutableSequence[float]) -> None: ...
    @staticmethod
    def ComputeWorldToDisplay(ren:'vtkRenderer', x:float, y:float, z:float, displayPt:MutableSequence[float]) -> None: ...
    def EnabledOff(self) -> None: ...
    def EnabledOn(self) -> None: ...
    def GetCurrentRenderer(self) -> 'vtkRenderer': ...
    def GetDefaultRenderer(self) -> 'vtkRenderer': ...
    def GetEnabled(self) -> int: ...
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetKeyPressActivation(self) -> int: ...
    def GetKeyPressActivationValue(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickingManaged(self) -> bool: ...
    def GetPriority(self) -> float: ...
    def GetPriorityMaxValue(self) -> float: ...
    def GetPriorityMinValue(self) -> float: ...
    def GrabFocus(self, mouseEvents:'vtkCommand', keypressEvents:'vtkCommand'=...) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeyPressActivationOff(self) -> None: ...
    def KeyPressActivationOn(self) -> None: ...
    def NewInstance(self) -> 'vtkInteractorObserver': ...
    def Off(self) -> None: ...
    def On(self) -> None: ...
    def OnChar(self) -> None: ...
    def PickingManagedOff(self) -> None: ...
    def PickingManagedOn(self) -> None: ...
    def ReleaseFocus(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInteractorObserver': ...
    def SetCurrentRenderer(self, __a:'vtkRenderer') -> None: ...
    def SetDefaultRenderer(self, __a:'vtkRenderer') -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetInteractor(self, iren:'vtkRenderWindowInteractor') -> None: ...
    def SetKeyPressActivation(self, _arg:int) -> None: ...
    def SetKeyPressActivationValue(self, _arg:str) -> None: ...
    def SetPickingManaged(self, managed:bool) -> None: ...
    def SetPriority(self, _arg:float) -> None: ...

class vtkInteractorEventRecorder(vtkInteractorObserver):
    class vtkEventDataType(int):
        None_:'vtkEventDataType'
        StringArray:'vtkEventDataType'
    enabled:'getset_descriptor'
    file_name:'getset_descriptor'
    input_string:'getset_descriptor'
    interactor:'getset_descriptor'
    read_from_input_string:'getset_descriptor'
    def Clear(self) -> None: ...
    def GetFileName(self) -> str: ...
    def GetInputString(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetReadFromInputString(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInteractorEventRecorder': ...
    def Play(self) -> None: ...
    def ReadFromInputStringOff(self) -> None: ...
    def ReadFromInputStringOn(self) -> None: ...
    def Record(self) -> None: ...
    def Rewind(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInteractorEventRecorder': ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetInputString(self, _arg:str) -> None: ...
    def SetInteractor(self, iren:'vtkRenderWindowInteractor') -> None: ...
    def SetReadFromInputString(self, _arg:int) -> None: ...
    def Stop(self) -> None: ...

class vtkInteractorStyle(vtkInteractorObserver):
    auto_adjust_camera_clipping_range:'getset_descriptor'
    enabled:'getset_descriptor'
    handle_observers:'getset_descriptor'
    interactor:'getset_descriptor'
    mouse_wheel_motion_factor:'getset_descriptor'
    pick_color:'getset_descriptor'
    state:'getset_descriptor'
    t_dx_style:'getset_descriptor'
    timer_duration:'getset_descriptor'
    use_timers:'getset_descriptor'
    def AutoAdjustCameraClippingRangeOff(self) -> None: ...
    def AutoAdjustCameraClippingRangeOn(self) -> None: ...
    def DelegateTDxEvent(self, event:int, calldata:Pointer) -> None: ...
    def Dolly(self) -> None: ...
    def EndDolly(self) -> None: ...
    def EndEnvRotate(self) -> None: ...
    def EndGesture(self) -> None: ...
    def EndPan(self) -> None: ...
    def EndRotate(self) -> None: ...
    def EndSpin(self) -> None: ...
    def EndTimer(self) -> None: ...
    def EndTwoPointer(self) -> None: ...
    def EndUniformScale(self) -> None: ...
    def EndZoom(self) -> None: ...
    def EnvironmentRotate(self) -> None: ...
    def FindPokedRenderer(self, __a:int, __b:int) -> None: ...
    def GetAutoAdjustCameraClippingRange(self) -> int: ...
    def GetAutoAdjustCameraClippingRangeMaxValue(self) -> int: ...
    def GetAutoAdjustCameraClippingRangeMinValue(self) -> int: ...
    def GetHandleObservers(self) -> int: ...
    def GetMouseWheelMotionFactor(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickColor(self) -> Tuple[float, float, float]: ...
    def GetState(self) -> int: ...
    def GetTDxStyle(self) -> 'vtkTDxInteractorStyle': ...
    def GetTimerDuration(self) -> int: ...
    def GetTimerDurationMaxValue(self) -> int: ...
    def GetTimerDurationMinValue(self) -> int: ...
    def GetUseTimers(self) -> int: ...
    def HandleObserversOff(self) -> None: ...
    def HandleObserversOn(self) -> None: ...
    def HighlightActor2D(self, actor2D:'vtkActor2D') -> None: ...
    def HighlightProp(self, prop:'vtkProp') -> None: ...
    def HighlightProp3D(self, prop3D:'vtkProp3D') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInteractorStyle': ...
    def OnButton3D(self, __a:'vtkEventData') -> None: ...
    def OnChar(self) -> None: ...
    def OnClip3D(self, __a:'vtkEventData') -> None: ...
    def OnConfigure(self) -> None: ...
    def OnDropFiles(self, filePaths:'vtkStringArray') -> None: ...
    def OnDropLocation(self, position:MutableSequence[float]) -> None: ...
    def OnElevation3D(self, __a:'vtkEventData') -> None: ...
    def OnEndPan(self) -> None: ...
    def OnEndPinch(self) -> None: ...
    def OnEndRotate(self) -> None: ...
    def OnEndSwipe(self) -> None: ...
    def OnEnter(self) -> None: ...
    def OnExpose(self) -> None: ...
    def OnFifthButtonDown(self) -> None: ...
    def OnFifthButtonUp(self) -> None: ...
    def OnFourthButtonDown(self) -> None: ...
    def OnFourthButtonUp(self) -> None: ...
    def OnKeyDown(self) -> None: ...
    def OnKeyPress(self) -> None: ...
    def OnKeyRelease(self) -> None: ...
    def OnKeyUp(self) -> None: ...
    def OnLeave(self) -> None: ...
    def OnLeftButtonDoubleClick(self) -> None: ...
    def OnLeftButtonDown(self) -> None: ...
    def OnLeftButtonUp(self) -> None: ...
    def OnLongTap(self) -> None: ...
    def OnMenu3D(self, __a:'vtkEventData') -> None: ...
    def OnMiddleButtonDoubleClick(self) -> None: ...
    def OnMiddleButtonDown(self) -> None: ...
    def OnMiddleButtonUp(self) -> None: ...
    def OnMouseMove(self) -> None: ...
    def OnMouseWheelBackward(self) -> None: ...
    def OnMouseWheelForward(self) -> None: ...
    def OnMouseWheelLeft(self) -> None: ...
    def OnMouseWheelRight(self) -> None: ...
    def OnMove3D(self, __a:'vtkEventData') -> None: ...
    def OnNextPose3D(self, __a:'vtkEventData') -> None: ...
    def OnPan(self) -> None: ...
    def OnPick3D(self, __a:'vtkEventData') -> None: ...
    def OnPinch(self) -> None: ...
    def OnPositionProp3D(self, __a:'vtkEventData') -> None: ...
    def OnRightButtonDoubleClick(self) -> None: ...
    def OnRightButtonDown(self) -> None: ...
    def OnRightButtonUp(self) -> None: ...
    def OnRotate(self) -> None: ...
    def OnSelect3D(self, __a:'vtkEventData') -> None: ...
    def OnStartPan(self) -> None: ...
    def OnStartPinch(self) -> None: ...
    def OnStartRotate(self) -> None: ...
    def OnStartSwipe(self) -> None: ...
    def OnSwipe(self) -> None: ...
    def OnTap(self) -> None: ...
    def OnTimer(self) -> None: ...
    def OnViewerMovement3D(self, __a:'vtkEventData') -> None: ...
    def Pan(self) -> None: ...
    def Rotate(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInteractorStyle': ...
    def SetAutoAdjustCameraClippingRange(self, _arg:int) -> None: ...
    def SetEnabled(self, __a:int) -> None: ...
    def SetHandleObservers(self, _arg:int) -> None: ...
    def SetInteractor(self, interactor:'vtkRenderWindowInteractor') -> None: ...
    def SetMouseWheelMotionFactor(self, _arg:float) -> None: ...
    @overload
    def SetPickColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPickColor(self, _arg:Sequence[float]) -> None: ...
    def SetTDxStyle(self, tdxStyle:'vtkTDxInteractorStyle') -> None: ...
    def SetTimerDuration(self, _arg:int) -> None: ...
    def SetUseTimers(self, _arg:int) -> None: ...
    def Spin(self) -> None: ...
    def StartAnimate(self) -> None: ...
    def StartDolly(self) -> None: ...
    def StartEnvRotate(self) -> None: ...
    def StartGesture(self) -> None: ...
    def StartPan(self) -> None: ...
    def StartRotate(self) -> None: ...
    def StartSpin(self) -> None: ...
    def StartState(self, newstate:int) -> None: ...
    def StartTimer(self) -> None: ...
    def StartTwoPointer(self) -> None: ...
    def StartUniformScale(self) -> None: ...
    def StartZoom(self) -> None: ...
    def StopAnimate(self) -> None: ...
    def StopState(self) -> None: ...
    def UniformScale(self) -> None: ...
    def UseTimersOff(self) -> None: ...
    def UseTimersOn(self) -> None: ...
    def Zoom(self) -> None: ...

class vtkInteractorStyle3D(vtkInteractorStyle):
    dolly_physical_speed:'getset_descriptor'
    interaction_picker:'getset_descriptor'
    def Dolly3D(self, __a:'vtkEventData') -> None: ...
    def GetDollyPhysicalSpeed(self) -> float: ...
    def GetInteractionPicker(self) -> 'vtkAbstractPropPicker': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInteractorStyle3D': ...
    def PositionProp(self, __a:'vtkEventData', lwpos:MutableSequence[float]=..., lwori:MutableSequence[float]=...) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInteractorStyle3D': ...
    def SetDollyPhysicalSpeed(self, _arg:float) -> None: ...
    def SetInteractionPicker(self, prop:'vtkAbstractPropPicker') -> None: ...
    def SetScale(self, cam:'vtkCamera', newScale:float) -> None: ...

class vtkInteractorStyleSwitchBase(vtkInteractorStyle):
    interactor:'getset_descriptor'
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkInteractorStyleSwitchBase': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkInteractorStyleSwitchBase': ...

class vtkLODProp3D(vtkProp3D):
    automatic_lod_selection:'getset_descriptor'
    automatic_pick_lod_selection:'getset_descriptor'
    bounds:'getset_descriptor'
    current_index:'getset_descriptor'
    last_rendered_lodid:'getset_descriptor'
    number_of_lo_ds:'getset_descriptor'
    pick_lodid:'getset_descriptor'
    selected_lodid:'getset_descriptor'
    selected_pick_lodid:'getset_descriptor'
    def AddEstimatedRenderTime(self, t:float, vp:'vtkViewport') -> None: ...
    @overload
    def AddLOD(self, m:'vtkMapper', p:'vtkProperty', back:'vtkProperty', t:'vtkTexture', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkMapper', p:'vtkProperty', t:'vtkTexture', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkMapper', p:'vtkProperty', back:'vtkProperty', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkMapper', p:'vtkProperty', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkMapper', t:'vtkTexture', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkMapper', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkAbstractVolumeMapper', p:'vtkVolumeProperty', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkAbstractVolumeMapper', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkImageMapper3D', p:'vtkImageProperty', time:float) -> int: ...
    @overload
    def AddLOD(self, m:'vtkImageMapper3D', time:float) -> int: ...
    def AutomaticLODSelectionOff(self) -> None: ...
    def AutomaticLODSelectionOn(self) -> None: ...
    def AutomaticPickLODSelectionOff(self) -> None: ...
    def AutomaticPickLODSelectionOn(self) -> None: ...
    def DisableLOD(self, id:int) -> None: ...
    def EnableLOD(self, id:int) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetAutomaticLODSelection(self) -> int: ...
    def GetAutomaticLODSelectionMaxValue(self) -> int: ...
    def GetAutomaticLODSelectionMinValue(self) -> int: ...
    def GetAutomaticPickLODSelection(self) -> int: ...
    def GetAutomaticPickLODSelectionMaxValue(self) -> int: ...
    def GetAutomaticPickLODSelectionMinValue(self) -> int: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCurrentIndex(self) -> int: ...
    def GetLODEstimatedRenderTime(self, id:int) -> float: ...
    def GetLODIndexEstimatedRenderTime(self, index:int) -> float: ...
    def GetLODIndexLevel(self, index:int) -> float: ...
    def GetLODLevel(self, id:int) -> float: ...
    def GetLODMapper(self, id:int) -> 'vtkAbstractMapper3D': ...
    def GetLastRenderedLODID(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLODs(self) -> int: ...
    def GetPickLODID(self) -> int: ...
    def GetSelectedLODID(self) -> int: ...
    def GetSelectedPickLODID(self) -> int: ...
    def GetVolumes(self, __a:'vtkPropCollection') -> None: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsLODEnabled(self, id:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLODProp3D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveLOD(self, id:int) -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderVolumetricGeometry(self, viewport:'vtkViewport') -> int: ...
    def RestoreEstimatedRenderTime(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLODProp3D': ...
    def SetAllocatedRenderTime(self, t:float, vp:'vtkViewport') -> None: ...
    def SetAutomaticLODSelection(self, _arg:int) -> None: ...
    def SetAutomaticPickLODSelection(self, _arg:int) -> None: ...
    def SetLODBackfaceProperty(self, id:int, t:'vtkProperty') -> None: ...
    def SetLODLevel(self, id:int, level:float) -> None: ...
    @overload
    def SetLODMapper(self, id:int, m:'vtkMapper') -> None: ...
    @overload
    def SetLODMapper(self, id:int, m:'vtkAbstractVolumeMapper') -> None: ...
    @overload
    def SetLODMapper(self, id:int, m:'vtkImageMapper3D') -> None: ...
    @overload
    def SetLODProperty(self, id:int, p:'vtkProperty') -> None: ...
    @overload
    def SetLODProperty(self, id:int, p:'vtkVolumeProperty') -> None: ...
    @overload
    def SetLODProperty(self, id:int, p:'vtkImageProperty') -> None: ...
    def SetLODTexture(self, id:int, t:'vtkTexture') -> None: ...
    def SetSelectedLODID(self, _arg:int) -> None: ...
    def SetSelectedPickLODID(self, id:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkLODProp3DEntry_t(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkLODProp3DEntry_t') -> None: ...

class vtkLabeledContourMapper(vtkMapper):
    bounds:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    label_visibility:'getset_descriptor'
    poly_data_mapper:'getset_descriptor'
    skip_distance:'getset_descriptor'
    text_properties:'getset_descriptor'
    text_property:'getset_descriptor'
    text_property_mapping:'getset_descriptor'
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetInput(self) -> 'vtkPolyData': ...
    def GetLabelVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyDataMapper(self) -> 'vtkPolyDataMapper': ...
    def GetSkipDistance(self) -> float: ...
    def GetTextProperties(self) -> 'vtkTextPropertyCollection': ...
    def GetTextPropertyMapping(self) -> 'vtkDoubleArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkLabeledContourMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer', act:'vtkActor') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLabeledContourMapper': ...
    def SetInputData(self, in_:'vtkPolyData') -> None: ...
    def SetLabelVisibility(self, _arg:bool) -> None: ...
    def SetSkipDistance(self, _arg:float) -> None: ...
    def SetTextProperties(self, coll:'vtkTextPropertyCollection') -> None: ...
    def SetTextProperty(self, tprop:'vtkTextProperty') -> None: ...
    def SetTextPropertyMapping(self, mapping:'vtkDoubleArray') -> None: ...

class vtkLight(vtkmodules.vtkCommonCore.vtkObject):
    ambient_color:'getset_descriptor'
    attenuation_values:'getset_descriptor'
    color:'getset_descriptor'
    cone_angle:'getset_descriptor'
    diffuse_color:'getset_descriptor'
    direction_angle:'getset_descriptor'
    exponent:'getset_descriptor'
    focal_point:'getset_descriptor'
    information:'getset_descriptor'
    intensity:'getset_descriptor'
    light_type:'getset_descriptor'
    position:'getset_descriptor'
    positional:'getset_descriptor'
    shadow_attenuation:'getset_descriptor'
    specular_color:'getset_descriptor'
    switch:'getset_descriptor'
    transform_matrix:'getset_descriptor'
    transformed_focal_point:'getset_descriptor'
    transformed_position:'getset_descriptor'
    def DeepCopy(self, light:'vtkLight') -> None: ...
    def GetAmbientColor(self) -> Tuple[float, float, float]: ...
    def GetAttenuationValues(self) -> Tuple[float, float, float]: ...
    def GetConeAngle(self) -> float: ...
    def GetDiffuseColor(self) -> Tuple[float, float, float]: ...
    def GetExponent(self) -> float: ...
    def GetExponentMaxValue(self) -> float: ...
    def GetExponentMinValue(self) -> float: ...
    def GetFocalPoint(self) -> Tuple[float, float, float]: ...
    def GetInformation(self) -> 'vtkInformation': ...
    def GetIntensity(self) -> float: ...
    def GetLightType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> Tuple[float, float, float]: ...
    def GetPositional(self) -> int: ...
    def GetShadowAttenuation(self) -> float: ...
    def GetSpecularColor(self) -> Tuple[float, float, float]: ...
    def GetSwitch(self) -> int: ...
    def GetTransformMatrix(self) -> 'vtkMatrix4x4': ...
    @overload
    def GetTransformedFocalPoint(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetTransformedFocalPoint(self, a:MutableSequence[float]) -> None: ...
    @overload
    def GetTransformedFocalPoint(self) -> Tuple[float, float, float]: ...
    @overload
    def GetTransformedPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def GetTransformedPosition(self, a:MutableSequence[float]) -> None: ...
    @overload
    def GetTransformedPosition(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LightTypeIsCameraLight(self) -> int: ...
    def LightTypeIsHeadlight(self) -> int: ...
    def LightTypeIsSceneLight(self) -> int: ...
    def NewInstance(self) -> 'vtkLight': ...
    def PositionalOff(self) -> None: ...
    def PositionalOn(self) -> None: ...
    def Render(self, __a:'vtkRenderer', __b:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLight': ...
    @overload
    def SetAmbientColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAmbientColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAttenuationValues(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAttenuationValues(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetColor(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetColor(self, a:Sequence[float]) -> None: ...
    def SetConeAngle(self, _arg:float) -> None: ...
    @overload
    def SetDiffuseColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDiffuseColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetDirectionAngle(self, elevation:float, azimuth:float) -> None: ...
    @overload
    def SetDirectionAngle(self, ang:Sequence[float]) -> None: ...
    def SetExponent(self, _arg:float) -> None: ...
    @overload
    def SetFocalPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetFocalPoint(self, _arg:Sequence[float]) -> None: ...
    def SetInformation(self, __a:'vtkInformation') -> None: ...
    def SetIntensity(self, _arg:float) -> None: ...
    def SetLightType(self, __a:int) -> None: ...
    def SetLightTypeToCameraLight(self) -> None: ...
    def SetLightTypeToHeadlight(self) -> None: ...
    def SetLightTypeToSceneLight(self) -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPosition(self, _arg:Sequence[float]) -> None: ...
    def SetPositional(self, _arg:int) -> None: ...
    def SetShadowAttenuation(self, _arg:float) -> None: ...
    @overload
    def SetSpecularColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpecularColor(self, _arg:Sequence[float]) -> None: ...
    def SetSwitch(self, _arg:int) -> None: ...
    def SetTransformMatrix(self, __a:'vtkMatrix4x4') -> None: ...
    def ShallowClone(self) -> 'vtkLight': ...
    def SwitchOff(self) -> None: ...
    def SwitchOn(self) -> None: ...
    def TransformPoint(self, a:MutableSequence[float], b:MutableSequence[float]) -> None: ...
    def TransformVector(self, a:MutableSequence[float], b:MutableSequence[float]) -> None: ...

class vtkLightActor(vtkProp3D):
    bounds:'getset_descriptor'
    clipping_range:'getset_descriptor'
    cone_property:'getset_descriptor'
    frustum_property:'getset_descriptor'
    light:'getset_descriptor'
    m_time:'getset_descriptor'
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetClippingRange(self) -> Tuple[float, float]: ...
    def GetConeProperty(self) -> 'vtkProperty': ...
    def GetFrustumProperty(self) -> 'vtkProperty': ...
    def GetLight(self) -> 'vtkLight': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLightActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLightActor': ...
    @overload
    def SetClippingRange(self, dNear:float, dFar:float) -> None: ...
    @overload
    def SetClippingRange(self, a:Sequence[float]) -> None: ...
    def SetLight(self, light:'vtkLight') -> None: ...

class vtkLightCollection(vtkmodules.vtkCommonCore.vtkCollection):
    next_item:'getset_descriptor'
    def AddItem(self, a:'vtkLight') -> None: ...
    def GetNextItem(self) -> 'vtkLight': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLightCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLightCollection': ...

class vtkLightKit(vtkmodules.vtkCommonCore.vtkObject):
    class LightKitSubType(int): ...
    class LightKitType(int): ...
    Azimuth:'LightKitSubType'
    Elevation:'LightKitSubType'
    Intensity:'LightKitSubType'
    KBRatio:'LightKitSubType'
    KFRatio:'LightKitSubType'
    KHRatio:'LightKitSubType'
    TBackLight:'LightKitType'
    TFillLight:'LightKitType'
    THeadLight:'LightKitType'
    TKeyLight:'LightKitType'
    Warmth:'LightKitSubType'
    back_light_angle:'getset_descriptor'
    back_light_azimuth:'getset_descriptor'
    back_light_color:'getset_descriptor'
    back_light_elevation:'getset_descriptor'
    back_light_warmth:'getset_descriptor'
    fill_light_angle:'getset_descriptor'
    fill_light_azimuth:'getset_descriptor'
    fill_light_color:'getset_descriptor'
    fill_light_elevation:'getset_descriptor'
    fill_light_warmth:'getset_descriptor'
    head_light_color:'getset_descriptor'
    head_light_warmth:'getset_descriptor'
    key_light_angle:'getset_descriptor'
    key_light_azimuth:'getset_descriptor'
    key_light_color:'getset_descriptor'
    key_light_elevation:'getset_descriptor'
    key_light_intensity:'getset_descriptor'
    key_light_warmth:'getset_descriptor'
    key_to_back_ratio:'getset_descriptor'
    key_to_fill_ratio:'getset_descriptor'
    key_to_head_ratio:'getset_descriptor'
    maintain_luminance:'getset_descriptor'
    def AddLightsToRenderer(self, renderer:'vtkRenderer') -> None: ...
    def DeepCopy(self, kit:'vtkLightKit') -> None: ...
    def GetBackLightAngle(self) -> Tuple[float, float]: ...
    def GetBackLightAzimuth(self) -> float: ...
    def GetBackLightColor(self) -> Tuple[float, float, float]: ...
    def GetBackLightElevation(self) -> float: ...
    def GetBackLightWarmth(self) -> float: ...
    def GetFillLightAngle(self) -> Tuple[float, float]: ...
    def GetFillLightAzimuth(self) -> float: ...
    def GetFillLightColor(self) -> Tuple[float, float, float]: ...
    def GetFillLightElevation(self) -> float: ...
    def GetFillLightWarmth(self) -> float: ...
    def GetHeadLightColor(self) -> Tuple[float, float, float]: ...
    def GetHeadLightWarmth(self) -> float: ...
    def GetKeyLightAngle(self) -> Tuple[float, float]: ...
    def GetKeyLightAzimuth(self) -> float: ...
    def GetKeyLightColor(self) -> Tuple[float, float, float]: ...
    def GetKeyLightElevation(self) -> float: ...
    def GetKeyLightIntensity(self) -> float: ...
    def GetKeyLightWarmth(self) -> float: ...
    def GetKeyToBackRatio(self) -> float: ...
    def GetKeyToBackRatioMaxValue(self) -> float: ...
    def GetKeyToBackRatioMinValue(self) -> float: ...
    def GetKeyToFillRatio(self) -> float: ...
    def GetKeyToFillRatioMaxValue(self) -> float: ...
    def GetKeyToFillRatioMinValue(self) -> float: ...
    def GetKeyToHeadRatio(self) -> float: ...
    def GetKeyToHeadRatioMaxValue(self) -> float: ...
    def GetKeyToHeadRatioMinValue(self) -> float: ...
    def GetMaintainLuminance(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetShortStringFromSubType(subtype:int) -> str: ...
    @staticmethod
    def GetStringFromSubType(type:int) -> str: ...
    @staticmethod
    def GetStringFromType(type:int) -> str: ...
    @staticmethod
    def GetSubType(type:'LightKitType', i:int) -> 'LightKitSubType': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MaintainLuminanceOff(self) -> None: ...
    def MaintainLuminanceOn(self) -> None: ...
    def Modified(self) -> None: ...
    def NewInstance(self) -> 'vtkLightKit': ...
    def RemoveLightsFromRenderer(self, renderer:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLightKit': ...
    @overload
    def SetBackLightAngle(self, elevation:float, azimuth:float) -> None: ...
    @overload
    def SetBackLightAngle(self, angle:MutableSequence[float]) -> None: ...
    def SetBackLightAzimuth(self, x:float) -> None: ...
    def SetBackLightElevation(self, x:float) -> None: ...
    def SetBackLightWarmth(self, _arg:float) -> None: ...
    @overload
    def SetFillLightAngle(self, elevation:float, azimuth:float) -> None: ...
    @overload
    def SetFillLightAngle(self, angle:MutableSequence[float]) -> None: ...
    def SetFillLightAzimuth(self, x:float) -> None: ...
    def SetFillLightElevation(self, x:float) -> None: ...
    def SetFillLightWarmth(self, _arg:float) -> None: ...
    def SetHeadLightWarmth(self, _arg:float) -> None: ...
    @overload
    def SetKeyLightAngle(self, elevation:float, azimuth:float) -> None: ...
    @overload
    def SetKeyLightAngle(self, angle:MutableSequence[float]) -> None: ...
    def SetKeyLightAzimuth(self, x:float) -> None: ...
    def SetKeyLightElevation(self, x:float) -> None: ...
    def SetKeyLightIntensity(self, _arg:float) -> None: ...
    def SetKeyLightWarmth(self, _arg:float) -> None: ...
    def SetKeyToBackRatio(self, _arg:float) -> None: ...
    def SetKeyToFillRatio(self, _arg:float) -> None: ...
    def SetKeyToHeadRatio(self, _arg:float) -> None: ...
    def SetMaintainLuminance(self, _arg:int) -> None: ...
    def Update(self) -> None: ...

class vtkLogLookupTable(vtkmodules.vtkCommonCore.vtkLookupTable):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLogLookupTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLogLookupTable': ...

class vtkLookupTableWithEnabling(vtkmodules.vtkCommonCore.vtkLookupTable):
    enabled_array:'getset_descriptor'
    def DisableColor(self, r:int, g:int, b:int, rd:MutableSequence[int], gd:MutableSequence[int], bd:MutableSequence[int]) -> None: ...
    def GetEnabledArray(self) -> 'vtkDataArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalarsThroughTable2(self, input:Pointer, output:MutableSequence[int], inputDataType:int, numberOfValues:int, inputIncrement:int, outputFormat:int) -> None: ...
    def NewInstance(self) -> 'vtkLookupTableWithEnabling': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLookupTableWithEnabling': ...
    def SetEnabledArray(self, enabledArray:'vtkDataArray') -> None: ...

class vtkMapArrayValues(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    class FieldType(int): ...
    CELL_DATA:'FieldType'
    EDGE_DATA:'FieldType'
    NUM_ATTRIBUTE_LOCS:'FieldType'
    POINT_DATA:'FieldType'
    ROW_DATA:'FieldType'
    VERTEX_DATA:'FieldType'
    field_type:'getset_descriptor'
    fill_value:'getset_descriptor'
    input_array_name:'getset_descriptor'
    map_size:'getset_descriptor'
    output_array_name:'getset_descriptor'
    output_array_type:'getset_descriptor'
    pass_array:'getset_descriptor'
    @overload
    def AddToMap(self, from_:'vtkVariant', to:'vtkVariant') -> None: ...
    @overload
    def AddToMap(self, from_:int, to:int) -> None: ...
    @overload
    def AddToMap(self, from_:int, to:str) -> None: ...
    @overload
    def AddToMap(self, from_:str, to:int) -> None: ...
    @overload
    def AddToMap(self, from_:str, to:str) -> None: ...
    def ClearMap(self) -> None: ...
    def GetFieldType(self) -> int: ...
    def GetFillValue(self) -> float: ...
    def GetInputArrayName(self) -> str: ...
    def GetMapSize(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputArrayName(self) -> str: ...
    def GetOutputArrayType(self) -> int: ...
    def GetPassArray(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMapArrayValues': ...
    def PassArrayOff(self) -> None: ...
    def PassArrayOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMapArrayValues': ...
    def SetFieldType(self, _arg:int) -> None: ...
    def SetFillValue(self, _arg:float) -> None: ...
    def SetInputArrayName(self, _arg:str) -> None: ...
    def SetOutputArrayName(self, _arg:str) -> None: ...
    def SetOutputArrayType(self, _arg:int) -> None: ...
    def SetPassArray(self, _arg:int) -> None: ...

class vtkMapperCollection(vtkmodules.vtkCommonCore.vtkCollection):
    last_item:'getset_descriptor'
    next_item:'getset_descriptor'
    def AddItem(self, a:'vtkMapper') -> None: ...
    def GetLastItem(self) -> 'vtkMapper': ...
    def GetNextItem(self) -> 'vtkMapper': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMapperCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMapperCollection': ...

class vtkObserverMediator(vtkmodules.vtkCommonCore.vtkObject):
    interactor:'getset_descriptor'
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkObserverMediator': ...
    def RemoveAllCursorShapeRequests(self, __a:'vtkInteractorObserver') -> None: ...
    def RequestCursorShape(self, __a:'vtkInteractorObserver', requestedShape:int) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkObserverMediator': ...
    def SetInteractor(self, iren:'vtkRenderWindowInteractor') -> None: ...

class vtkPickingManager(vtkmodules.vtkCommonCore.vtkObject):
    enabled:'getset_descriptor'
    interactor:'getset_descriptor'
    number_of_pickers:'getset_descriptor'
    optimize_on_interactor_events:'getset_descriptor'
    def AddPicker(self, picker:'vtkAbstractPicker', object:'vtkObject'=...) -> None: ...
    def EnabledOff(self) -> None: ...
    def EnabledOn(self) -> None: ...
    def GetAssemblyPath(self, X:float, Y:float, Z:float, picker:'vtkAbstractPropPicker', renderer:'vtkRenderer', obj:'vtkObject') -> 'vtkAssemblyPath': ...
    def GetEnabled(self) -> bool: ...
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfObjectsLinked(self, picker:'vtkAbstractPicker') -> int: ...
    def GetNumberOfPickers(self) -> int: ...
    def GetOptimizeOnInteractorEvents(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPickingManager': ...
    @overload
    def Pick(self, picker:'vtkAbstractPicker', object:'vtkObject') -> bool: ...
    @overload
    def Pick(self, object:'vtkObject') -> bool: ...
    @overload
    def Pick(self, picker:'vtkAbstractPicker') -> bool: ...
    def RemoveObject(self, object:'vtkObject') -> None: ...
    def RemovePicker(self, picker:'vtkAbstractPicker', object:'vtkObject'=...) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPickingManager': ...
    def SetEnabled(self, _arg:bool) -> None: ...
    def SetInteractor(self, iren:'vtkRenderWindowInteractor') -> None: ...
    def SetOptimizeOnInteractorEvents(self, optimize:bool) -> None: ...

class vtkPointGaussianMapper(vtkPolyDataMapper):
    anisotropic:'getset_descriptor'
    bound_scale:'getset_descriptor'
    emissive:'getset_descriptor'
    lowpass_matrix:'getset_descriptor'
    opacity_array:'getset_descriptor'
    opacity_array_component:'getset_descriptor'
    opacity_table_size:'getset_descriptor'
    rotation_array:'getset_descriptor'
    scalar_opacity_function:'getset_descriptor'
    scale_array:'getset_descriptor'
    scale_array_component:'getset_descriptor'
    scale_factor:'getset_descriptor'
    scale_function:'getset_descriptor'
    scale_table_size:'getset_descriptor'
    splat_shader_code:'getset_descriptor'
    supports_selection:'getset_descriptor'
    triangle_scale:'getset_descriptor'
    def AnisotropicOff(self) -> None: ...
    def AnisotropicOn(self) -> None: ...
    def EmissiveOff(self) -> None: ...
    def EmissiveOn(self) -> None: ...
    def GetAnisotropic(self) -> bool: ...
    def GetBoundScale(self) -> float: ...
    def GetEmissive(self) -> int: ...
    def GetLowpassMatrix(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacityArray(self) -> str: ...
    def GetOpacityArrayComponent(self) -> int: ...
    def GetOpacityTableSize(self) -> int: ...
    def GetRotationArray(self) -> str: ...
    def GetScalarOpacityFunction(self) -> 'vtkPiecewiseFunction': ...
    def GetScaleArray(self) -> str: ...
    def GetScaleArrayComponent(self) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetScaleFunction(self) -> 'vtkPiecewiseFunction': ...
    def GetScaleTableSize(self) -> int: ...
    def GetSplatShaderCode(self) -> str: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetTriangleScale(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointGaussianMapper': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointGaussianMapper': ...
    def SetAnisotropic(self, _arg:bool) -> None: ...
    def SetBoundScale(self, _arg:float) -> None: ...
    def SetEmissive(self, _arg:int) -> None: ...
    @overload
    def SetLowpassMatrix(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetLowpassMatrix(self, _arg:Sequence[float]) -> None: ...
    def SetOpacityArray(self, _arg:str) -> None: ...
    def SetOpacityArrayComponent(self, _arg:int) -> None: ...
    def SetOpacityTableSize(self, _arg:int) -> None: ...
    def SetRotationArray(self, _arg:str) -> None: ...
    def SetScalarOpacityFunction(self, __a:'vtkPiecewiseFunction') -> None: ...
    def SetScaleArray(self, _arg:str) -> None: ...
    def SetScaleArrayComponent(self, _arg:int) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetScaleFunction(self, __a:'vtkPiecewiseFunction') -> None: ...
    def SetScaleTableSize(self, _arg:int) -> None: ...
    def SetSplatShaderCode(self, _arg:str) -> None: ...
    def SetTriangleScale(self, value:float) -> None: ...

class vtkPointPicker(vtkPicker):
    point_id:'getset_descriptor'
    use_cells:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointId(self) -> int: ...
    def GetUseCells(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPointPicker': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPointPicker': ...
    def SetUseCells(self, _arg:int) -> None: ...
    def UseCellsOff(self) -> None: ...
    def UseCellsOn(self) -> None: ...

class vtkPolyDataMapper2D(vtkMapper2D):
    array_access_mode:'getset_descriptor'
    array_component:'getset_descriptor'
    array_id:'getset_descriptor'
    array_name:'getset_descriptor'
    color_mode:'getset_descriptor'
    input:'getset_descriptor'
    input_data:'getset_descriptor'
    lookup_table:'getset_descriptor'
    m_time:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    scalar_range:'getset_descriptor'
    scalar_visibility:'getset_descriptor'
    transform_coordinate:'getset_descriptor'
    transform_coordinate_use_double:'getset_descriptor'
    use_lookup_table_scalar_range:'getset_descriptor'
    @overload
    def ColorByArrayComponent(self, arrayNum:int, component:int) -> None: ...
    @overload
    def ColorByArrayComponent(self, arrayName:str, component:int) -> None: ...
    def CreateDefaultLookupTable(self) -> None: ...
    def GetArrayAccessMode(self) -> int: ...
    def GetArrayComponent(self) -> int: ...
    def GetArrayId(self) -> int: ...
    def GetArrayName(self) -> str: ...
    def GetColorMode(self) -> int: ...
    def GetColorModeAsString(self) -> str: ...
    def GetInput(self) -> 'vtkPolyData': ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def GetScalarVisibility(self) -> int: ...
    def GetTransformCoordinate(self) -> 'vtkCoordinate': ...
    def GetTransformCoordinateUseDouble(self) -> bool: ...
    def GetUseLookupTableScalarRange(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapScalars(self, alpha:float) -> 'vtkUnsignedCharArray': ...
    def NewInstance(self) -> 'vtkPolyDataMapper2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataMapper2D': ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToDefault(self) -> None: ...
    def SetColorModeToDirectScalars(self) -> None: ...
    def SetColorModeToMapScalars(self) -> None: ...
    def SetInputData(self, in_:'vtkPolyData') -> None: ...
    def SetLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToDefault(self) -> None: ...
    def SetScalarModeToUseCellData(self) -> None: ...
    def SetScalarModeToUseCellFieldData(self) -> None: ...
    def SetScalarModeToUsePointData(self) -> None: ...
    def SetScalarModeToUsePointFieldData(self) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...
    def SetScalarVisibility(self, _arg:int) -> None: ...
    def SetTransformCoordinate(self, __a:'vtkCoordinate') -> None: ...
    def SetTransformCoordinateUseDouble(self, _arg:bool) -> None: ...
    def SetUseLookupTableScalarRange(self, _arg:int) -> None: ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...
    def TransformCoordinateUseDoubleOff(self) -> None: ...
    def TransformCoordinateUseDoubleOn(self) -> None: ...
    def UseLookupTableScalarRangeOff(self) -> None: ...
    def UseLookupTableScalarRangeOn(self) -> None: ...

class vtkProp3DCollection(vtkPropCollection):
    last_prop3d:'getset_descriptor'
    next_prop3d:'getset_descriptor'
    def AddItem(self, p:'vtkProp3D') -> None: ...
    def GetLastProp3D(self) -> 'vtkProp3D': ...
    def GetNextProp3D(self) -> 'vtkProp3D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProp3DCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProp3DCollection': ...

class vtkProp3DFollower(vtkProp3D):
    bounds:'getset_descriptor'
    camera:'getset_descriptor'
    next_path:'getset_descriptor'
    prop3d:'getset_descriptor'
    def ComputeMatrix(self) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetNextPath(self) -> 'vtkAssemblyPath': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProp3D(self) -> 'vtkProp3D': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProp3DFollower': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderVolumetricGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProp3DFollower': ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def SetProp3D(self, prop:'vtkProp3D') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkPropAssembly(vtkProp):
    bounds:'getset_descriptor'
    m_time:'getset_descriptor'
    next_path:'getset_descriptor'
    number_of_paths:'getset_descriptor'
    parts:'getset_descriptor'
    def AddPart(self, __a:'vtkProp') -> None: ...
    def BuildPaths(self, paths:'vtkAssemblyPaths', path:'vtkAssemblyPath') -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetMTime(self) -> int: ...
    def GetNextPath(self) -> 'vtkAssemblyPath': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPaths(self) -> int: ...
    def GetParts(self) -> 'vtkPropCollection': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def InitPathTraversal(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPropAssembly': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemovePart(self, __a:'vtkProp') -> None: ...
    def RenderOpaqueGeometry(self, ren:'vtkViewport') -> int: ...
    def RenderOverlay(self, ren:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, ren:'vtkViewport') -> int: ...
    def RenderVolumetricGeometry(self, ren:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPropAssembly': ...
    def ShallowCopy(self, Prop:'vtkProp') -> None: ...

class vtkPropPicker(vtkAbstractPropPicker):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPropPicker': ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:'vtkRenderer') -> int: ...
    @overload
    def Pick(self, selectionPt:MutableSequence[float], renderer:'vtkRenderer') -> int: ...
    def Pick3DPoint(self, selectionPt:MutableSequence[float], ren:'vtkRenderer') -> int: ...
    def Pick3DRay(self, selectionPt:MutableSequence[float], orient:MutableSequence[float], ren:'vtkRenderer') -> int: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float, renderer:'vtkRenderer') -> int: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float, renderer:'vtkRenderer', pickfrom:'vtkPropCollection') -> int: ...
    @overload
    def PickProp3DPoint(self, pos:MutableSequence[float], renderer:'vtkRenderer') -> int: ...
    @overload
    def PickProp3DPoint(self, pos:MutableSequence[float], renderer:'vtkRenderer', pickfrom:'vtkPropCollection') -> int: ...
    def PickProp3DRay(self, selectionPt:MutableSequence[float], eventWorldOrientation:MutableSequence[float], renderer:'vtkRenderer', pickfrom:'vtkPropCollection') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPropPicker': ...

class vtkProperty(vtkmodules.vtkCommonCore.vtkObject):
    ambient:'getset_descriptor'
    ambient_color:'getset_descriptor'
    anisotropy:'getset_descriptor'
    anisotropy_rotation:'getset_descriptor'
    anisotropy_texture:'getset_descriptor'
    backface_culling:'getset_descriptor'
    base_color_texture:'getset_descriptor'
    base_ior:'getset_descriptor'
    coat_color:'getset_descriptor'
    coat_ior:'getset_descriptor'
    coat_normal_scale:'getset_descriptor'
    coat_normal_texture:'getset_descriptor'
    coat_roughness:'getset_descriptor'
    coat_strength:'getset_descriptor'
    color:'getset_descriptor'
    diffuse:'getset_descriptor'
    diffuse_color:'getset_descriptor'
    edge_color:'getset_descriptor'
    edge_opacity:'getset_descriptor'
    edge_tint:'getset_descriptor'
    edge_visibility:'getset_descriptor'
    emissive_factor:'getset_descriptor'
    emissive_texture:'getset_descriptor'
    frontface_culling:'getset_descriptor'
    information:'getset_descriptor'
    interpolation:'getset_descriptor'
    lighting:'getset_descriptor'
    line_stipple_pattern:'getset_descriptor'
    line_stipple_repeat_factor:'getset_descriptor'
    line_width:'getset_descriptor'
    material_name:'getset_descriptor'
    metallic:'getset_descriptor'
    normal_scale:'getset_descriptor'
    normal_texture:'getset_descriptor'
    number_of_textures:'getset_descriptor'
    occlusion_strength:'getset_descriptor'
    opacity:'getset_descriptor'
    orm_texture:'getset_descriptor'
    point_size:'getset_descriptor'
    render_lines_as_tubes:'getset_descriptor'
    render_points_as_spheres:'getset_descriptor'
    representation:'getset_descriptor'
    roughness:'getset_descriptor'
    selection_color:'getset_descriptor'
    selection_line_width:'getset_descriptor'
    selection_point_size:'getset_descriptor'
    shading:'getset_descriptor'
    show_textures_on_backface:'getset_descriptor'
    specular:'getset_descriptor'
    specular_color:'getset_descriptor'
    specular_power:'getset_descriptor'
    vertex_color:'getset_descriptor'
    vertex_visibility:'getset_descriptor'
    @overload
    def AddShaderVariable(self, __a:str, __b:int, __c:MutableSequence[int]) -> None: ...
    @overload
    def AddShaderVariable(self, __a:str, __b:int, __c:MutableSequence[float]) -> None: ...
    @overload
    def AddShaderVariable(self, __a:str, __b:int) -> None: ...
    @overload
    def AddShaderVariable(self, __a:str, __b:float) -> None: ...
    @overload
    def AddShaderVariable(self, __a:str, __b:int, __c:int) -> None: ...
    @overload
    def AddShaderVariable(self, __a:str, __b:float, __c:float) -> None: ...
    @overload
    def AddShaderVariable(self, __a:str, __b:int, __c:int, __d:int) -> None: ...
    @overload
    def AddShaderVariable(self, __a:str, __b:float, __c:float, __d:float) -> None: ...
    def BackfaceCullingOff(self) -> None: ...
    def BackfaceCullingOn(self) -> None: ...
    def BackfaceRender(self, __a:'vtkActor', __b:'vtkRenderer') -> None: ...
    @staticmethod
    def ComputeIORFromReflectance(reflectance:float, ior:float) -> float: ...
    @staticmethod
    def ComputeReflectanceFromIOR(IORTo:float, IORFrom:float) -> float: ...
    def ComputeReflectanceOfBaseLayer(self) -> float: ...
    def DeepCopy(self, p:'vtkProperty') -> None: ...
    def EdgeVisibilityOff(self) -> None: ...
    def EdgeVisibilityOn(self) -> None: ...
    def FrontfaceCullingOff(self) -> None: ...
    def FrontfaceCullingOn(self) -> None: ...
    def GetAmbient(self) -> float: ...
    def GetAmbientColor(self) -> Tuple[float, float, float]: ...
    def GetAmbientMaxValue(self) -> float: ...
    def GetAmbientMinValue(self) -> float: ...
    def GetAnisotropy(self) -> float: ...
    def GetAnisotropyMaxValue(self) -> float: ...
    def GetAnisotropyMinValue(self) -> float: ...
    def GetAnisotropyRotation(self) -> float: ...
    def GetAnisotropyRotationMaxValue(self) -> float: ...
    def GetAnisotropyRotationMinValue(self) -> float: ...
    def GetBackfaceCulling(self) -> int: ...
    def GetBaseIOR(self) -> float: ...
    def GetBaseIORMaxValue(self) -> float: ...
    def GetBaseIORMinValue(self) -> float: ...
    def GetCoatColor(self) -> Tuple[float, float, float]: ...
    def GetCoatIOR(self) -> float: ...
    def GetCoatIORMaxValue(self) -> float: ...
    def GetCoatIORMinValue(self) -> float: ...
    def GetCoatNormalScale(self) -> float: ...
    def GetCoatNormalScaleMaxValue(self) -> float: ...
    def GetCoatNormalScaleMinValue(self) -> float: ...
    def GetCoatRoughness(self) -> float: ...
    def GetCoatRoughnessMaxValue(self) -> float: ...
    def GetCoatRoughnessMinValue(self) -> float: ...
    def GetCoatStrength(self) -> float: ...
    def GetCoatStrengthMaxValue(self) -> float: ...
    def GetCoatStrengthMinValue(self) -> float: ...
    @overload
    def GetColor(self) -> Tuple[float, float, float]: ...
    @overload
    def GetColor(self, rgb:MutableSequence[float]) -> None: ...
    @overload
    def GetColor(self, r:float, g:float, b:float) -> None: ...
    def GetDiffuse(self) -> float: ...
    def GetDiffuseColor(self) -> Tuple[float, float, float]: ...
    def GetDiffuseMaxValue(self) -> float: ...
    def GetDiffuseMinValue(self) -> float: ...
    def GetEdgeColor(self) -> Tuple[float, float, float]: ...
    def GetEdgeOpacity(self) -> float: ...
    def GetEdgeOpacityMaxValue(self) -> float: ...
    def GetEdgeOpacityMinValue(self) -> float: ...
    def GetEdgeTint(self) -> Tuple[float, float, float]: ...
    def GetEdgeVisibility(self) -> int: ...
    def GetEmissiveFactor(self) -> Tuple[float, float, float]: ...
    def GetFrontfaceCulling(self) -> int: ...
    def GetInformation(self) -> 'vtkInformation': ...
    def GetInterpolation(self) -> int: ...
    def GetInterpolationAsString(self) -> str: ...
    def GetInterpolationMaxValue(self) -> int: ...
    def GetInterpolationMinValue(self) -> int: ...
    def GetLighting(self) -> bool: ...
    def GetLineStipplePattern(self) -> int: ...
    def GetLineStippleRepeatFactor(self) -> int: ...
    def GetLineStippleRepeatFactorMaxValue(self) -> int: ...
    def GetLineStippleRepeatFactorMinValue(self) -> int: ...
    def GetLineWidth(self) -> float: ...
    def GetLineWidthMaxValue(self) -> float: ...
    def GetLineWidthMinValue(self) -> float: ...
    def GetMaterialName(self) -> str: ...
    def GetMetallic(self) -> float: ...
    def GetMetallicMaxValue(self) -> float: ...
    def GetMetallicMinValue(self) -> float: ...
    def GetNormalScale(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTextures(self) -> int: ...
    def GetOcclusionStrength(self) -> float: ...
    def GetOcclusionStrengthMaxValue(self) -> float: ...
    def GetOcclusionStrengthMinValue(self) -> float: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetPointSize(self) -> float: ...
    def GetPointSizeMaxValue(self) -> float: ...
    def GetPointSizeMinValue(self) -> float: ...
    def GetRenderLinesAsTubes(self) -> bool: ...
    def GetRenderPointsAsSpheres(self) -> bool: ...
    def GetRepresentation(self) -> int: ...
    def GetRepresentationAsString(self) -> str: ...
    def GetRepresentationMaxValue(self) -> int: ...
    def GetRepresentationMinValue(self) -> int: ...
    def GetRoughness(self) -> float: ...
    def GetRoughnessMaxValue(self) -> float: ...
    def GetRoughnessMinValue(self) -> float: ...
    def GetSelectionColor(self) -> Tuple[float, float, float, float]: ...
    def GetSelectionLineWidth(self) -> float: ...
    def GetSelectionPointSize(self) -> float: ...
    def GetShading(self) -> int: ...
    def GetShowTexturesOnBackface(self) -> bool: ...
    def GetSpecular(self) -> float: ...
    def GetSpecularColor(self) -> Tuple[float, float, float]: ...
    def GetSpecularMaxValue(self) -> float: ...
    def GetSpecularMinValue(self) -> float: ...
    def GetSpecularPower(self) -> float: ...
    def GetSpecularPowerMaxValue(self) -> float: ...
    def GetSpecularPowerMinValue(self) -> float: ...
    def GetTexture(self, name:str) -> 'vtkTexture': ...
    def GetVertexColor(self) -> Tuple[float, float, float]: ...
    def GetVertexVisibility(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LightingOff(self) -> None: ...
    def LightingOn(self) -> None: ...
    def NewInstance(self) -> 'vtkProperty': ...
    def PostRender(self, __a:'vtkActor', __b:'vtkRenderer') -> None: ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def RemoveAllTextures(self) -> None: ...
    def RemoveTexture(self, name:str) -> None: ...
    def Render(self, __a:'vtkActor', __b:'vtkRenderer') -> None: ...
    def RenderLinesAsTubesOff(self) -> None: ...
    def RenderLinesAsTubesOn(self) -> None: ...
    def RenderPointsAsSpheresOff(self) -> None: ...
    def RenderPointsAsSpheresOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProperty': ...
    def SetAmbient(self, _arg:float) -> None: ...
    @overload
    def SetAmbientColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAmbientColor(self, _arg:Sequence[float]) -> None: ...
    def SetAnisotropy(self, _arg:float) -> None: ...
    def SetAnisotropyRotation(self, _arg:float) -> None: ...
    def SetAnisotropyTexture(self, texture:'vtkTexture') -> None: ...
    def SetBackfaceCulling(self, _arg:int) -> None: ...
    def SetBaseColorTexture(self, texture:'vtkTexture') -> None: ...
    def SetBaseIOR(self, _arg:float) -> None: ...
    @overload
    def SetCoatColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCoatColor(self, _arg:Sequence[float]) -> None: ...
    def SetCoatIOR(self, _arg:float) -> None: ...
    def SetCoatNormalScale(self, _arg:float) -> None: ...
    def SetCoatNormalTexture(self, texture:'vtkTexture') -> None: ...
    def SetCoatRoughness(self, _arg:float) -> None: ...
    def SetCoatStrength(self, _arg:float) -> None: ...
    @overload
    def SetColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetColor(self, a:MutableSequence[float]) -> None: ...
    def SetDiffuse(self, _arg:float) -> None: ...
    @overload
    def SetDiffuseColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDiffuseColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetEdgeColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEdgeColor(self, _arg:Sequence[float]) -> None: ...
    def SetEdgeOpacity(self, _arg:float) -> None: ...
    @overload
    def SetEdgeTint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEdgeTint(self, _arg:Sequence[float]) -> None: ...
    def SetEdgeVisibility(self, _arg:int) -> None: ...
    @overload
    def SetEmissiveFactor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEmissiveFactor(self, _arg:Sequence[float]) -> None: ...
    def SetEmissiveTexture(self, texture:'vtkTexture') -> None: ...
    def SetFrontfaceCulling(self, _arg:int) -> None: ...
    def SetInformation(self, __a:'vtkInformation') -> None: ...
    def SetInterpolation(self, _arg:int) -> None: ...
    def SetInterpolationToFlat(self) -> None: ...
    def SetInterpolationToGouraud(self) -> None: ...
    def SetInterpolationToPBR(self) -> None: ...
    def SetInterpolationToPhong(self) -> None: ...
    def SetLighting(self, _arg:bool) -> None: ...
    def SetLineStipplePattern(self, _arg:int) -> None: ...
    def SetLineStippleRepeatFactor(self, _arg:int) -> None: ...
    def SetLineWidth(self, _arg:float) -> None: ...
    def SetMaterialName(self, _arg:str) -> None: ...
    def SetMetallic(self, _arg:float) -> None: ...
    def SetNormalScale(self, _arg:float) -> None: ...
    def SetNormalTexture(self, texture:'vtkTexture') -> None: ...
    def SetORMTexture(self, texture:'vtkTexture') -> None: ...
    def SetOcclusionStrength(self, _arg:float) -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetPointSize(self, _arg:float) -> None: ...
    def SetRenderLinesAsTubes(self, _arg:bool) -> None: ...
    def SetRenderPointsAsSpheres(self, _arg:bool) -> None: ...
    def SetRepresentation(self, _arg:int) -> None: ...
    def SetRepresentationToPoints(self) -> None: ...
    def SetRepresentationToSurface(self) -> None: ...
    def SetRepresentationToWireframe(self) -> None: ...
    def SetRoughness(self, _arg:float) -> None: ...
    @overload
    def SetSelectionColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetSelectionColor(self, _arg:Sequence[float]) -> None: ...
    def SetSelectionLineWidth(self, _arg:float) -> None: ...
    def SetSelectionPointSize(self, _arg:float) -> None: ...
    def SetShading(self, _arg:int) -> None: ...
    def SetShowTexturesOnBackface(self, _arg:bool) -> None: ...
    def SetSpecular(self, _arg:float) -> None: ...
    @overload
    def SetSpecularColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSpecularColor(self, _arg:Sequence[float]) -> None: ...
    def SetSpecularPower(self, _arg:float) -> None: ...
    def SetTexture(self, name:str, texture:'vtkTexture') -> None: ...
    @overload
    def SetVertexColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetVertexColor(self, _arg:Sequence[float]) -> None: ...
    def SetVertexVisibility(self, _arg:int) -> None: ...
    def ShadingOff(self) -> None: ...
    def ShadingOn(self) -> None: ...
    def ShowTexturesOnBackfaceOff(self) -> None: ...
    def ShowTexturesOnBackfaceOn(self) -> None: ...
    def VertexVisibilityOff(self) -> None: ...
    def VertexVisibilityOn(self) -> None: ...

class vtkProperty2D(vtkmodules.vtkCommonCore.vtkObject):
    color:'getset_descriptor'
    display_location:'getset_descriptor'
    line_stipple_pattern:'getset_descriptor'
    line_stipple_repeat_factor:'getset_descriptor'
    line_width:'getset_descriptor'
    opacity:'getset_descriptor'
    point_size:'getset_descriptor'
    def DeepCopy(self, p:'vtkProperty2D') -> None: ...
    def GetColor(self) -> Tuple[float, float, float]: ...
    def GetDisplayLocation(self) -> int: ...
    def GetDisplayLocationMaxValue(self) -> int: ...
    def GetDisplayLocationMinValue(self) -> int: ...
    def GetLineStipplePattern(self) -> int: ...
    def GetLineStippleRepeatFactor(self) -> int: ...
    def GetLineStippleRepeatFactorMaxValue(self) -> int: ...
    def GetLineStippleRepeatFactorMinValue(self) -> int: ...
    def GetLineWidth(self) -> float: ...
    def GetLineWidthMaxValue(self) -> float: ...
    def GetLineWidthMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetPointSize(self) -> float: ...
    def GetPointSizeMaxValue(self) -> float: ...
    def GetPointSizeMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProperty2D': ...
    def Render(self, viewport:'vtkViewport') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProperty2D': ...
    @overload
    def SetColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetColor(self, _arg:Sequence[float]) -> None: ...
    def SetDisplayLocation(self, _arg:int) -> None: ...
    def SetDisplayLocationToBackground(self) -> None: ...
    def SetDisplayLocationToForeground(self) -> None: ...
    def SetLineStipplePattern(self, _arg:int) -> None: ...
    def SetLineStippleRepeatFactor(self, _arg:int) -> None: ...
    def SetLineWidth(self, _arg:float) -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetPointSize(self, _arg:float) -> None: ...

class vtkRayCastRayInfo_t(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkRayCastRayInfo_t') -> None: ...

class vtkRenderPass(vtkmodules.vtkCommonCore.vtkObject):
    number_of_rendered_props:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRenderedProps(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderPass': ...
    def ReleaseGraphicsResources(self, w:'vtkWindow') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderPass': ...

class vtkRenderState(object):
    frame_buffer:'getset_descriptor'
    prop_array_count:'getset_descriptor'
    renderer:'getset_descriptor'
    required_keys:'getset_descriptor'
    def __init__(self, renderer:'vtkRenderer') -> None: ...
    def GetFrameBuffer(self) -> 'vtkFrameBufferObjectBase': ...
    def GetPropArrayCount(self) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetRequiredKeys(self) -> 'vtkInformation': ...
    def GetWindowSize(self, size:MutableSequence[int]) -> None: ...
    def IsValid(self) -> bool: ...
    def SetFrameBuffer(self, fbo:'vtkFrameBufferObjectBase') -> None: ...
    def SetRequiredKeys(self, keys:'vtkInformation') -> None: ...

class vtkRenderTimerLog(vtkmodules.vtkCommonCore.vtkObject):
    frame_limit:'getset_descriptor'
    logging_enabled:'getset_descriptor'
    def FrameReady(self) -> bool: ...
    def GetFrameLimit(self) -> int: ...
    def GetLoggingEnabled(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsSupported(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoggingEnabledOff(self) -> None: ...
    def LoggingEnabledOn(self) -> None: ...
    def MarkEndEvent(self) -> None: ...
    def MarkFrame(self) -> None: ...
    def MarkStartEvent(self, name:str) -> None: ...
    def NewInstance(self) -> 'vtkRenderTimerLog': ...
    def ReleaseGraphicsResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderTimerLog': ...
    def SetFrameLimit(self, _arg:int) -> None: ...
    def SetLoggingEnabled(self, _arg:bool) -> None: ...

class vtkRenderWidget(vtkmodules.vtkCommonCore.vtkObject):
    name:'getset_descriptor'
    position:'getset_descriptor'
    size:'getset_descriptor'
    def GetName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> 'vtkVector2i': ...
    def GetSize(self) -> 'vtkVector2i': ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def NewInstance(self) -> 'vtkRenderWidget': ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderWidget': ...
    def SetName(self, name:str) -> None: ...
    def SetPosition(self, pos:'vtkVector2i') -> None: ...
    def SetSize(self, size:'vtkVector2i') -> None: ...
    def Start(self) -> None: ...

class vtkRenderWindow(vtkmodules.vtkCommonCore.vtkWindow):
    PhysicalToWorldMatrixModified:int
    abort_render:'getset_descriptor'
    alpha_bit_planes:'getset_descriptor'
    anaglyph_color_mask:'getset_descriptor'
    anaglyph_color_saturation:'getset_descriptor'
    borders:'getset_descriptor'
    capturing_gl2ps_special_props:'getset_descriptor'
    current_cursor:'getset_descriptor'
    cursor_file_name:'getset_descriptor'
    cursor_position:'getset_descriptor'
    depth_buffer_size:'getset_descriptor'
    desired_update_rate:'getset_descriptor'
    device_index:'getset_descriptor'
    display_id:'getset_descriptor'
    enable_translucent_surface:'getset_descriptor'
    event_pending:'getset_descriptor'
    full_screen:'getset_descriptor'
    generic_context:'getset_descriptor'
    generic_display_id:'getset_descriptor'
    generic_drawable:'getset_descriptor'
    generic_parent_id:'getset_descriptor'
    generic_window_id:'getset_descriptor'
    in_abort_check:'getset_descriptor'
    initialized:'getset_descriptor'
    interactor:'getset_descriptor'
    line_smoothing:'getset_descriptor'
    multi_samples:'getset_descriptor'
    never_rendered:'getset_descriptor'
    next_window_id:'getset_descriptor'
    next_window_info:'getset_descriptor'
    number_of_devices:'getset_descriptor'
    number_of_layers:'getset_descriptor'
    number_of_layers_max_value:'getset_descriptor'
    number_of_layers_min_value:'getset_descriptor'
    parent_id:'getset_descriptor'
    parent_info:'getset_descriptor'
    physical_scale:'getset_descriptor'
    physical_to_world_matrix:'getset_descriptor'
    physical_translation:'getset_descriptor'
    physical_view_direction:'getset_descriptor'
    physical_view_up:'getset_descriptor'
    platform_supports_render_window_sharing:'getset_descriptor'
    point_smoothing:'getset_descriptor'
    polygon_smoothing:'getset_descriptor'
    render_library:'getset_descriptor'
    render_timer:'getset_descriptor'
    renderers:'getset_descriptor'
    rendering_backend:'getset_descriptor'
    shared_render_window:'getset_descriptor'
    stencil_capable:'getset_descriptor'
    stereo_capable_window:'getset_descriptor'
    stereo_render:'getset_descriptor'
    stereo_type:'getset_descriptor'
    swap_buffers:'getset_descriptor'
    use_srgb_color_space:'getset_descriptor'
    window_id:'getset_descriptor'
    window_info:'getset_descriptor'
    def AddRenderer(self, __a:'vtkRenderer') -> None: ...
    def AlphaBitPlanesOff(self) -> None: ...
    def AlphaBitPlanesOn(self) -> None: ...
    def BordersOff(self) -> None: ...
    def BordersOn(self) -> None: ...
    def CaptureGL2PSSpecialProps(self, specialProps:'vtkCollection') -> None: ...
    def CheckAbortStatus(self) -> int: ...
    def CheckInRenderStatus(self) -> int: ...
    def ClearInRenderStatus(self) -> None: ...
    def CopyResultFrame(self) -> None: ...
    def EnableTranslucentSurfaceOff(self) -> None: ...
    def EnableTranslucentSurfaceOn(self) -> None: ...
    def End(self) -> None: ...
    def Finalize(self) -> None: ...
    def Frame(self) -> None: ...
    def FullScreenOff(self) -> None: ...
    def FullScreenOn(self) -> None: ...
    def GetAbortRender(self) -> int: ...
    def GetAlphaBitPlanes(self) -> int: ...
    def GetAnaglyphColorMask(self) -> Tuple[int, int]: ...
    def GetAnaglyphColorSaturation(self) -> float: ...
    def GetAnaglyphColorSaturationMaxValue(self) -> float: ...
    def GetAnaglyphColorSaturationMinValue(self) -> float: ...
    def GetBorders(self) -> int: ...
    def GetCapturingGL2PSSpecialProps(self) -> int: ...
    def GetColorBufferSizes(self, __a:MutableSequence[int]) -> int: ...
    def GetCurrentCursor(self) -> int: ...
    def GetCursorFileName(self) -> str: ...
    def GetDepthBufferSize(self) -> int: ...
    def GetDesiredUpdateRate(self) -> float: ...
    def GetDeviceIndex(self) -> int: ...
    def GetDeviceToWorldMatrixForDevice(self, device:'vtkEventDataDevice', deviceToWorldMatrix:'vtkMatrix4x4') -> bool: ...
    def GetEnableTranslucentSurface(self) -> bool: ...
    def GetEventPending(self) -> int: ...
    def GetFullScreen(self) -> int: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetInAbortCheck(self) -> int: ...
    def GetInitialized(self) -> bool: ...
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetLineSmoothing(self) -> int: ...
    def GetMultiSamples(self) -> int: ...
    def GetNeverRendered(self) -> int: ...
    def GetNumberOfDevices(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLayers(self) -> int: ...
    def GetNumberOfLayersMaxValue(self) -> int: ...
    def GetNumberOfLayersMinValue(self) -> int: ...
    def GetPhysicalScale(self) -> float: ...
    def GetPhysicalToWorldMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    def GetPhysicalTranslation(self) -> Tuple[float, float, float]: ...
    def GetPhysicalViewDirection(self) -> Tuple[float, float, float]: ...
    def GetPhysicalViewUp(self) -> Tuple[float, float, float]: ...
    def GetPlatformSupportsRenderWindowSharing(self) -> bool: ...
    def GetPointSmoothing(self) -> int: ...
    def GetPolygonSmoothing(self) -> int: ...
    @overload
    def GetRGBACharPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:int) -> Pointer: ...
    @overload
    def GetRGBACharPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:'vtkUnsignedCharArray', __g:int) -> int: ...
    @overload
    def GetRGBAPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:int) -> Pointer: ...
    @overload
    def GetRGBAPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:int, __f:'vtkFloatArray', __g:int) -> int: ...
    @staticmethod
    def GetRenderLibrary() -> str: ...
    def GetRenderTimer(self) -> 'vtkRenderTimerLog': ...
    def GetRenderers(self) -> 'vtkRendererCollection': ...
    def GetRenderingBackend(self) -> str: ...
    def GetSharedRenderWindow(self) -> 'vtkRenderWindow': ...
    def GetStencilCapable(self) -> int: ...
    def GetStereoCapableWindow(self) -> int: ...
    def GetStereoRender(self) -> int: ...
    def GetStereoType(self) -> int: ...
    @overload
    def GetStereoTypeAsString(self) -> str: ...
    @overload
    @staticmethod
    def GetStereoTypeAsString(type:int) -> str: ...
    def GetSwapBuffers(self) -> int: ...
    def GetUseSRGBColorSpace(self) -> bool: ...
    @overload
    def GetZbufferData(self, __a:int, __b:int, __c:int, __d:int) -> Pointer: ...
    @overload
    def GetZbufferData(self, __a:int, __b:int, __c:int, __d:int, __e:MutableSequence[float]) -> int: ...
    @overload
    def GetZbufferData(self, __a:int, __b:int, __c:int, __d:int, __e:'vtkFloatArray') -> int: ...
    def GetZbufferDataAtPoint(self, x:int, y:int) -> float: ...
    def HasRenderer(self, __a:'vtkRenderer') -> int: ...
    def HideCursor(self) -> None: ...
    def Initialize(self) -> None: ...
    def InitializeFromCurrentContext(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    def IsCurrent(self) -> bool: ...
    def IsDirect(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LineSmoothingOff(self) -> None: ...
    def LineSmoothingOn(self) -> None: ...
    def MakeRenderWindowInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def NewInstance(self) -> 'vtkRenderWindow': ...
    def PointSmoothingOff(self) -> None: ...
    def PointSmoothingOn(self) -> None: ...
    def PolygonSmoothingOff(self) -> None: ...
    def PolygonSmoothingOn(self) -> None: ...
    def ReleaseRGBAPixelData(self, __a:MutableSequence[float]) -> None: ...
    def RemoveRenderer(self, __a:'vtkRenderer') -> None: ...
    def Render(self) -> None: ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderWindow': ...
    def SetAbortRender(self, _arg:int) -> None: ...
    def SetAlphaBitPlanes(self, _arg:int) -> None: ...
    @overload
    def SetAnaglyphColorMask(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetAnaglyphColorMask(self, _arg:Sequence[int]) -> None: ...
    def SetAnaglyphColorSaturation(self, _arg:float) -> None: ...
    def SetBorders(self, _arg:int) -> None: ...
    def SetCurrentCursor(self, _arg:int) -> None: ...
    def SetCursorFileName(self, _arg:str) -> None: ...
    def SetCursorPosition(self, __a:int, __b:int) -> None: ...
    def SetDesiredUpdateRate(self, __a:float) -> None: ...
    def SetDeviceIndex(self, _arg:int) -> None: ...
    def SetDisplayId(self, __a:Pointer) -> None: ...
    def SetEnableTranslucentSurface(self, _arg:bool) -> None: ...
    def SetForceMakeCurrent(self) -> None: ...
    def SetFullScreen(self, __a:int) -> None: ...
    def SetInAbortCheck(self, _arg:int) -> None: ...
    def SetInteractor(self, __a:'vtkRenderWindowInteractor') -> None: ...
    def SetLineSmoothing(self, _arg:int) -> None: ...
    def SetMultiSamples(self, __a:int) -> None: ...
    def SetNextWindowId(self, __a:Pointer) -> None: ...
    def SetNextWindowInfo(self, __a:str) -> None: ...
    def SetNumberOfLayers(self, _arg:int) -> None: ...
    def SetParentId(self, __a:Pointer) -> None: ...
    def SetParentInfo(self, __a:str) -> None: ...
    def SetPhysicalScale(self, __a:float) -> None: ...
    def SetPhysicalToWorldMatrix(self, matrix:'vtkMatrix4x4') -> None: ...
    @overload
    def SetPhysicalTranslation(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetPhysicalTranslation(self, __a:MutableSequence[float]) -> None: ...
    @overload
    def SetPhysicalViewDirection(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetPhysicalViewDirection(self, __a:MutableSequence[float]) -> None: ...
    @overload
    def SetPhysicalViewUp(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetPhysicalViewUp(self, __a:MutableSequence[float]) -> None: ...
    @overload
    def SetPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:MutableSequence[int], __f:int, __g:int) -> int: ...
    @overload
    def SetPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:'vtkUnsignedCharArray', __f:int, __g:int) -> int: ...
    def SetPointSmoothing(self, _arg:int) -> None: ...
    def SetPolygonSmoothing(self, _arg:int) -> None: ...
    @overload
    def SetRGBACharPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:MutableSequence[int], __f:int, __g:int, __h:int) -> int: ...
    @overload
    def SetRGBACharPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:'vtkUnsignedCharArray', __f:int, __g:int, __h:int) -> int: ...
    @overload
    def SetRGBAPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:MutableSequence[float], __f:int, __g:int, __h:int) -> int: ...
    @overload
    def SetRGBAPixelData(self, __a:int, __b:int, __c:int, __d:int, __e:'vtkFloatArray', __f:int, __g:int, __h:int) -> int: ...
    def SetSharedRenderWindow(self, __a:'vtkRenderWindow') -> None: ...
    def SetStencilCapable(self, _arg:int) -> None: ...
    def SetStereoCapableWindow(self, capable:int) -> None: ...
    def SetStereoRender(self, stereo:int) -> None: ...
    def SetStereoType(self, __a:int) -> None: ...
    def SetStereoTypeToAnaglyph(self) -> None: ...
    def SetStereoTypeToCheckerboard(self) -> None: ...
    def SetStereoTypeToCrystalEyes(self) -> None: ...
    def SetStereoTypeToDresden(self) -> None: ...
    def SetStereoTypeToEmulate(self) -> None: ...
    def SetStereoTypeToFake(self) -> None: ...
    def SetStereoTypeToInterlaced(self) -> None: ...
    def SetStereoTypeToLeft(self) -> None: ...
    def SetStereoTypeToRedBlue(self) -> None: ...
    def SetStereoTypeToRight(self) -> None: ...
    def SetStereoTypeToSplitViewportHorizontal(self) -> None: ...
    def SetSwapBuffers(self, _arg:int) -> None: ...
    def SetUseSRGBColorSpace(self, _arg:bool) -> None: ...
    def SetWindowId(self, __a:Pointer) -> None: ...
    def SetWindowInfo(self, __a:str) -> None: ...
    @overload
    def SetZbufferData(self, __a:int, __b:int, __c:int, __d:int, __e:MutableSequence[float]) -> int: ...
    @overload
    def SetZbufferData(self, __a:int, __b:int, __c:int, __d:int, __e:'vtkFloatArray') -> int: ...
    def ShowCursor(self) -> None: ...
    def Start(self) -> None: ...
    def StencilCapableOff(self) -> None: ...
    def StencilCapableOn(self) -> None: ...
    def StereoCapableWindowOff(self) -> None: ...
    def StereoCapableWindowOn(self) -> None: ...
    def StereoMidpoint(self) -> None: ...
    def StereoRenderComplete(self) -> None: ...
    def StereoRenderOff(self) -> None: ...
    def StereoRenderOn(self) -> None: ...
    def StereoUpdate(self) -> None: ...
    def SupportsOpenGL(self) -> int: ...
    def SwapBuffersOff(self) -> None: ...
    def SwapBuffersOn(self) -> None: ...
    def UseSRGBColorSpaceOff(self) -> None: ...
    def UseSRGBColorSpaceOn(self) -> None: ...
    def WaitForCompletion(self) -> None: ...
    def WindowRemap(self) -> None: ...

class vtkRenderWindowCollection(vtkmodules.vtkCommonCore.vtkCollection):
    next_item:'getset_descriptor'
    def AddItem(self, a:'vtkRenderWindow') -> None: ...
    def GetNextItem(self) -> 'vtkRenderWindow': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderWindowCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderWindowCollection': ...

class vtkRenderWindowInteractor(vtkmodules.vtkCommonCore.vtkObject):
    OneShotTimer:int
    RepeatingTimer:int
    alt_key:'getset_descriptor'
    control_key:'getset_descriptor'
    current_gesture:'getset_descriptor'
    desired_update_rate:'getset_descriptor'
    dolly:'getset_descriptor'
    done:'getset_descriptor'
    enable_render:'getset_descriptor'
    enabled:'getset_descriptor'
    event_position:'getset_descriptor'
    event_position_flip_y:'getset_descriptor'
    event_size:'getset_descriptor'
    hardware_window:'getset_descriptor'
    initialized:'getset_descriptor'
    interactor_style:'getset_descriptor'
    key_code:'getset_descriptor'
    key_sym:'getset_descriptor'
    last_event_position:'getset_descriptor'
    last_rotation:'getset_descriptor'
    last_scale:'getset_descriptor'
    last_translation:'getset_descriptor'
    light_follow_camera:'getset_descriptor'
    number_of_fly_frames:'getset_descriptor'
    number_of_fly_frames_max_value:'getset_descriptor'
    number_of_fly_frames_min_value:'getset_descriptor'
    observer_mediator:'getset_descriptor'
    picker:'getset_descriptor'
    picking_manager:'getset_descriptor'
    pointer_index:'getset_descriptor'
    pointers_down_count:'getset_descriptor'
    recognize_gestures:'getset_descriptor'
    render_window:'getset_descriptor'
    repeat_count:'getset_descriptor'
    rotation:'getset_descriptor'
    scale:'getset_descriptor'
    shift_key:'getset_descriptor'
    size:'getset_descriptor'
    still_update_rate:'getset_descriptor'
    timer_duration:'getset_descriptor'
    timer_event_duration:'getset_descriptor'
    timer_event_id:'getset_descriptor'
    timer_event_platform_id:'getset_descriptor'
    timer_event_type:'getset_descriptor'
    translation:'getset_descriptor'
    use_t_dx:'getset_descriptor'
    def CharEvent(self) -> None: ...
    def ClearContact(self, contactID:int) -> None: ...
    def ClearPointerIndex(self, i:int) -> None: ...
    def ConfigureEvent(self) -> None: ...
    def CreateDefaultPicker(self) -> 'vtkAbstractPropPicker': ...
    def CreateOneShotTimer(self, duration:int) -> int: ...
    def CreateRepeatingTimer(self, duration:int) -> int: ...
    def CreateTimer(self, timerType:int) -> int: ...
    @overload
    def DestroyTimer(self) -> int: ...
    @overload
    def DestroyTimer(self, timerId:int) -> int: ...
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    def EnableRenderOff(self) -> None: ...
    def EnableRenderOn(self) -> None: ...
    def EndPanEvent(self) -> None: ...
    def EndPickCallback(self) -> None: ...
    def EndPinchEvent(self) -> None: ...
    def EndRotateEvent(self) -> None: ...
    def EnterEvent(self) -> None: ...
    def ExitCallback(self) -> None: ...
    def ExitEvent(self) -> None: ...
    def ExposeEvent(self) -> None: ...
    def FifthButtonPressEvent(self) -> None: ...
    def FifthButtonReleaseEvent(self) -> None: ...
    def FindPokedRenderer(self, __a:int, __b:int) -> 'vtkRenderer': ...
    @overload
    def FlyTo(self, ren:'vtkRenderer', x:float, y:float, z:float) -> None: ...
    @overload
    def FlyTo(self, ren:'vtkRenderer', x:MutableSequence[float]) -> None: ...
    @overload
    def FlyToImage(self, ren:'vtkRenderer', x:float, y:float) -> None: ...
    @overload
    def FlyToImage(self, ren:'vtkRenderer', x:MutableSequence[float]) -> None: ...
    def FourthButtonPressEvent(self) -> None: ...
    def FourthButtonReleaseEvent(self) -> None: ...
    def GetAltKey(self) -> int: ...
    def GetControlKey(self) -> int: ...
    def GetCurrentGesture(self) -> vtkCommand.EventIds: ...
    def GetDesiredUpdateRate(self) -> float: ...
    def GetDesiredUpdateRateMaxValue(self) -> float: ...
    def GetDesiredUpdateRateMinValue(self) -> float: ...
    def GetDolly(self) -> float: ...
    def GetDone(self) -> bool: ...
    def GetEnableRender(self) -> bool: ...
    def GetEnabled(self) -> int: ...
    def GetEventPosition(self) -> Tuple[int, int]: ...
    def GetEventPositions(self, pointerIndex:int) -> Pointer: ...
    def GetEventSize(self) -> Tuple[int, int]: ...
    def GetHardwareWindow(self) -> 'vtkHardwareWindow': ...
    def GetInitialized(self) -> int: ...
    def GetInteractorStyle(self) -> 'vtkInteractorObserver': ...
    def GetKeyCode(self) -> str: ...
    def GetKeySym(self) -> str: ...
    def GetLastEventPosition(self) -> Tuple[int, int]: ...
    def GetLastEventPositions(self, pointerIndex:int) -> Pointer: ...
    def GetLastRotation(self) -> float: ...
    def GetLastScale(self) -> float: ...
    def GetLastTranslation(self) -> Tuple[float, float]: ...
    def GetLightFollowCamera(self) -> int: ...
    def GetMousePosition(self, x:MutableSequence[int], y:MutableSequence[int]) -> None: ...
    def GetNumberOfFlyFrames(self) -> int: ...
    def GetNumberOfFlyFramesMaxValue(self) -> int: ...
    def GetNumberOfFlyFramesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetObserverMediator(self) -> 'vtkObserverMediator': ...
    def GetPicker(self) -> 'vtkAbstractPicker': ...
    def GetPickingManager(self) -> 'vtkPickingManager': ...
    def GetPointerIndex(self) -> int: ...
    def GetPointerIndexForContact(self, contactID:int) -> int: ...
    def GetPointerIndexForExistingContact(self, contactID:int) -> int: ...
    def GetPointersDownCount(self) -> int: ...
    def GetRecognizeGestures(self) -> bool: ...
    def GetRenderWindow(self) -> 'vtkRenderWindow': ...
    def GetRepeatCount(self) -> int: ...
    def GetRotation(self) -> float: ...
    def GetScale(self) -> float: ...
    def GetShiftKey(self) -> int: ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetStillUpdateRate(self) -> float: ...
    def GetStillUpdateRateMaxValue(self) -> float: ...
    def GetStillUpdateRateMinValue(self) -> float: ...
    @overload
    def GetTimerDuration(self, timerId:int) -> int: ...
    @overload
    def GetTimerDuration(self) -> int: ...
    def GetTimerDurationMaxValue(self) -> int: ...
    def GetTimerDurationMinValue(self) -> int: ...
    def GetTimerEventDuration(self) -> int: ...
    def GetTimerEventId(self) -> int: ...
    def GetTimerEventPlatformId(self) -> int: ...
    def GetTimerEventType(self) -> int: ...
    def GetTranslation(self) -> Tuple[float, float]: ...
    def GetUseTDx(self) -> bool: ...
    def GetVTKTimerId(self, platformTimerId:int) -> int: ...
    def HideCursor(self) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsOneShotTimer(self, timerId:int) -> int: ...
    def IsPointerIndexSet(self, i:int) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeyPressEvent(self) -> None: ...
    def KeyReleaseEvent(self) -> None: ...
    def LeaveEvent(self) -> None: ...
    def LeftButtonPressEvent(self) -> None: ...
    def LeftButtonReleaseEvent(self) -> None: ...
    def LightFollowCameraOff(self) -> None: ...
    def LightFollowCameraOn(self) -> None: ...
    def LongTapEvent(self) -> None: ...
    def MiddleButtonPressEvent(self) -> None: ...
    def MiddleButtonReleaseEvent(self) -> None: ...
    def MouseMoveEvent(self) -> None: ...
    def MouseWheelBackwardEvent(self) -> None: ...
    def MouseWheelForwardEvent(self) -> None: ...
    def MouseWheelLeftEvent(self) -> None: ...
    def MouseWheelRightEvent(self) -> None: ...
    def NewInstance(self) -> 'vtkRenderWindowInteractor': ...
    def PanEvent(self) -> None: ...
    def PinchEvent(self) -> None: ...
    def ProcessEvents(self) -> None: ...
    def ReInitialize(self) -> None: ...
    def Render(self) -> None: ...
    def ResetTimer(self, timerId:int) -> int: ...
    def RightButtonPressEvent(self) -> None: ...
    def RightButtonReleaseEvent(self) -> None: ...
    def RotateEvent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderWindowInteractor': ...
    def SetAltKey(self, _arg:int) -> None: ...
    def SetControlKey(self, _arg:int) -> None: ...
    def SetCurrentGesture(self, eid:vtkCommand.EventIds) -> None: ...
    def SetDesiredUpdateRate(self, _arg:float) -> None: ...
    def SetDolly(self, _arg:float) -> None: ...
    def SetDone(self, _arg:bool) -> None: ...
    def SetEnableRender(self, _arg:bool) -> None: ...
    @overload
    def SetEventInformation(self, x:int, y:int, ctrl:int, shift:int, keycode:str, repeatcount:int, keysym:str, pointerIndex:int) -> None: ...
    @overload
    def SetEventInformation(self, x:int, y:int, ctrl:int=0, shift:int=0, keycode:str=..., repeatcount:int=0, keysym:str=...) -> None: ...
    @overload
    def SetEventInformationFlipY(self, x:int, y:int, ctrl:int, shift:int, keycode:str, repeatcount:int, keysym:str, pointerIndex:int) -> None: ...
    @overload
    def SetEventInformationFlipY(self, x:int, y:int, ctrl:int=0, shift:int=0, keycode:str=..., repeatcount:int=0, keysym:str=...) -> None: ...
    @overload
    def SetEventPosition(self, x:int, y:int) -> None: ...
    @overload
    def SetEventPosition(self, pos:MutableSequence[int]) -> None: ...
    @overload
    def SetEventPosition(self, x:int, y:int, pointerIndex:int) -> None: ...
    @overload
    def SetEventPosition(self, pos:MutableSequence[int], pointerIndex:int) -> None: ...
    @overload
    def SetEventPositionFlipY(self, x:int, y:int) -> None: ...
    @overload
    def SetEventPositionFlipY(self, pos:MutableSequence[int]) -> None: ...
    @overload
    def SetEventPositionFlipY(self, x:int, y:int, pointerIndex:int) -> None: ...
    @overload
    def SetEventPositionFlipY(self, pos:MutableSequence[int], pointerIndex:int) -> None: ...
    @overload
    def SetEventSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetEventSize(self, _arg:Sequence[int]) -> None: ...
    def SetHardwareWindow(self, aren:'vtkHardwareWindow') -> None: ...
    def SetInteractorStyle(self, __a:'vtkInteractorObserver') -> None: ...
    def SetKeyCode(self, _arg:str) -> None: ...
    def SetKeyEventInformation(self, ctrl:int=0, shift:int=0, keycode:str=..., repeatcount:int=0, keysym:str=...) -> None: ...
    def SetKeySym(self, _arg:str) -> None: ...
    @overload
    def SetLastEventPosition(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetLastEventPosition(self, _arg:Sequence[int]) -> None: ...
    def SetLightFollowCamera(self, _arg:int) -> None: ...
    def SetNumberOfFlyFrames(self, _arg:int) -> None: ...
    def SetPicker(self, __a:'vtkAbstractPicker') -> None: ...
    def SetPickingManager(self, __a:'vtkPickingManager') -> None: ...
    def SetPointerIndex(self, _arg:int) -> None: ...
    def SetRecognizeGestures(self, _arg:bool) -> None: ...
    def SetRenderWindow(self, aren:'vtkRenderWindow') -> None: ...
    def SetRepeatCount(self, _arg:int) -> None: ...
    def SetRotation(self, rotation:float) -> None: ...
    def SetScale(self, scale:float) -> None: ...
    def SetShiftKey(self, _arg:int) -> None: ...
    @overload
    def SetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetSize(self, _arg:Sequence[int]) -> None: ...
    def SetStillUpdateRate(self, _arg:float) -> None: ...
    def SetTimerDuration(self, _arg:int) -> None: ...
    def SetTimerEventDuration(self, _arg:int) -> None: ...
    def SetTimerEventId(self, _arg:int) -> None: ...
    def SetTimerEventPlatformId(self, _arg:int) -> None: ...
    def SetTimerEventType(self, _arg:int) -> None: ...
    def SetTranslation(self, val:MutableSequence[float]) -> None: ...
    def SetUseTDx(self, _arg:bool) -> None: ...
    def ShowCursor(self) -> None: ...
    def Start(self) -> None: ...
    def StartPanEvent(self) -> None: ...
    def StartPickCallback(self) -> None: ...
    def StartPinchEvent(self) -> None: ...
    def StartRotateEvent(self) -> None: ...
    def SwipeEvent(self) -> None: ...
    def TapEvent(self) -> None: ...
    def TerminateApp(self) -> None: ...
    def UpdateSize(self, x:int, y:int) -> None: ...
    def UserCallback(self) -> None: ...

class vtkRenderWindowInteractor3D(vtkRenderWindowInteractor):
    last_translation3d:'getset_descriptor'
    physical_scale:'getset_descriptor'
    physical_view_direction:'getset_descriptor'
    physical_view_up:'getset_descriptor'
    starting_physical_to_world_matrix:'getset_descriptor'
    translation3d:'getset_descriptor'
    def Disable(self) -> None: ...
    def Enable(self) -> None: ...
    def GetLastPhysicalEventPose(self, poseMatrix:'vtkMatrix4x4', pointerIndex:int) -> None: ...
    def GetLastTranslation3D(self) -> Tuple[float, float, float]: ...
    def GetLastWorldEventOrientation(self, pointerIndex:int) -> Pointer: ...
    def GetLastWorldEventPose(self, poseMatrix:'vtkMatrix4x4', pointerIndex:int) -> None: ...
    def GetLastWorldEventPosition(self, pointerIndex:int) -> Pointer: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhysicalEventPose(self, poseMatrix:'vtkMatrix4x4', pointerIndex:int) -> None: ...
    def GetPhysicalScale(self) -> float: ...
    def GetPhysicalTranslation(self, __a:'vtkCamera') -> Pointer: ...
    def GetPhysicalViewDirection(self) -> Pointer: ...
    def GetPhysicalViewUp(self) -> Pointer: ...
    def GetStartingPhysicalEventPose(self, poseMatrix:'vtkMatrix4x4', pointerIndex:int) -> None: ...
    def GetStartingPhysicalToWorldMatrix(self, startingPhysicalToWorldMatrix:'vtkMatrix4x4') -> None: ...
    def GetTouchPadPosition(self, __a:'vtkEventDataDevice', __b:'vtkEventDataDeviceInput', __c:MutableSequence[float]) -> None: ...
    def GetTranslation3D(self) -> Tuple[float, float, float]: ...
    def GetWorldEventOrientation(self, pointerIndex:int) -> Pointer: ...
    def GetWorldEventPose(self, poseMatrix:'vtkMatrix4x4', pointerIndex:int) -> None: ...
    def GetWorldEventPosition(self, pointerIndex:int) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MiddleButtonPressEvent(self) -> None: ...
    def MiddleButtonReleaseEvent(self) -> None: ...
    def NewInstance(self) -> 'vtkRenderWindowInteractor3D': ...
    def RightButtonPressEvent(self) -> None: ...
    def RightButtonReleaseEvent(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderWindowInteractor3D': ...
    def SetPhysicalEventPose(self, poseMatrix:'vtkMatrix4x4', pointerIndex:int) -> None: ...
    def SetPhysicalEventPosition(self, x:float, y:float, z:float, pointerIndex:int) -> None: ...
    def SetPhysicalScale(self, __a:float) -> None: ...
    def SetPhysicalTranslation(self, __a:'vtkCamera', __b:float, __c:float, __d:float) -> None: ...
    def SetPhysicalViewDirection(self, __a:float, __b:float, __c:float) -> None: ...
    def SetPhysicalViewUp(self, __a:float, __b:float, __c:float) -> None: ...
    def SetStartingPhysicalEventPose(self, poseMatrix:'vtkMatrix4x4', device:'vtkEventDataDevice') -> None: ...
    def SetStartingPhysicalToWorldMatrix(self, startingPhysicalToWorldMatrix:'vtkMatrix4x4') -> None: ...
    def SetTranslation3D(self, val:MutableSequence[float]) -> None: ...
    def SetWorldEventOrientation(self, w:float, x:float, y:float, z:float, pointerIndex:int) -> None: ...
    def SetWorldEventPose(self, poseMatrix:'vtkMatrix4x4', pointerIndex:int) -> None: ...
    def SetWorldEventPosition(self, x:float, y:float, z:float, pointerIndex:int) -> None: ...

class vtkRenderedAreaPicker(vtkAreaPicker):
    def AreaPick(self, x0:float, y0:float, x1:float, y1:float, __e:'vtkRenderer') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderedAreaPicker': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderedAreaPicker': ...

class vtkViewport(vtkmodules.vtkCommonCore.vtkObject):
    class GradientModes(int):
        VTK_GRADIENT_HORIZONTAL:'GradientModes'
        VTK_GRADIENT_RADIAL_VIEWPORT_FARTHEST_CORNER:'GradientModes'
        VTK_GRADIENT_RADIAL_VIEWPORT_FARTHEST_SIDE:'GradientModes'
        VTK_GRADIENT_VERTICAL:'GradientModes'
    actors2d:'getset_descriptor'
    aspect:'getset_descriptor'
    background:'getset_descriptor'
    background2:'getset_descriptor'
    background_alpha:'getset_descriptor'
    center:'getset_descriptor'
    display_point:'getset_descriptor'
    dither_gradient:'getset_descriptor'
    environmental_bg:'getset_descriptor'
    environmental_bg2:'getset_descriptor'
    gradient_background:'getset_descriptor'
    gradient_environmental_bg:'getset_descriptor'
    gradient_mode:'getset_descriptor'
    origin:'getset_descriptor'
    pick_height:'getset_descriptor'
    pick_result_props:'getset_descriptor'
    pick_width:'getset_descriptor'
    pick_x:'getset_descriptor'
    pick_x1:'getset_descriptor'
    pick_x2:'getset_descriptor'
    pick_y:'getset_descriptor'
    pick_y1:'getset_descriptor'
    pick_y2:'getset_descriptor'
    picked_z:'getset_descriptor'
    pixel_aspect:'getset_descriptor'
    size:'getset_descriptor'
    view_point:'getset_descriptor'
    view_props:'getset_descriptor'
    viewport:'getset_descriptor'
    vtk_window:'getset_descriptor'
    world_point:'getset_descriptor'
    def AddActor2D(self, p:'vtkProp') -> None: ...
    def AddViewProp(self, __a:'vtkProp') -> None: ...
    def ComputeAspect(self) -> None: ...
    def DisplayToLocalDisplay(self, x:float, y:float) -> None: ...
    def DisplayToNormalizedDisplay(self, u:float, v:float) -> None: ...
    def DisplayToView(self) -> None: ...
    def DisplayToWorld(self) -> None: ...
    def DitherGradientOff(self) -> None: ...
    def DitherGradientOn(self) -> None: ...
    def GetActors2D(self) -> 'vtkActor2DCollection': ...
    def GetAspect(self) -> Tuple[float, float]: ...
    def GetBackground(self) -> Tuple[float, float, float]: ...
    def GetBackground2(self) -> Tuple[float, float, float]: ...
    def GetBackgroundAlpha(self) -> float: ...
    def GetBackgroundAlphaMaxValue(self) -> float: ...
    def GetBackgroundAlphaMinValue(self) -> float: ...
    def GetCenter(self) -> Tuple[float, float]: ...
    def GetDisplayPoint(self) -> Tuple[float, float, float]: ...
    def GetDitherGradient(self) -> bool: ...
    def GetEnvironmentalBG(self) -> Tuple[float, float, float]: ...
    def GetEnvironmentalBG2(self) -> Tuple[float, float, float]: ...
    def GetGradientBackground(self) -> bool: ...
    def GetGradientEnvironmentalBG(self) -> bool: ...
    def GetGradientMode(self) -> 'GradientModes': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self) -> Tuple[int, int]: ...
    def GetPickHeight(self) -> float: ...
    def GetPickResultProps(self) -> 'vtkPropCollection': ...
    def GetPickWidth(self) -> float: ...
    def GetPickX(self) -> float: ...
    def GetPickX1(self) -> float: ...
    def GetPickX2(self) -> float: ...
    def GetPickY(self) -> float: ...
    def GetPickY1(self) -> float: ...
    def GetPickY2(self) -> float: ...
    def GetPickedZ(self) -> float: ...
    def GetPixelAspect(self) -> Tuple[float, float]: ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetTiledSize(self, width:MutableSequence[int], height:MutableSequence[int]) -> None: ...
    def GetTiledSizeAndOrigin(self, width:MutableSequence[int], height:MutableSequence[int], lowerLeftX:MutableSequence[int], lowerLeftY:MutableSequence[int]) -> None: ...
    def GetVTKWindow(self) -> 'vtkWindow': ...
    def GetViewPoint(self) -> Tuple[float, float, float]: ...
    def GetViewProps(self) -> 'vtkPropCollection': ...
    def GetViewport(self) -> Tuple[float, float, float, float]: ...
    def GetWorldPoint(self) -> Tuple[float, float, float, float]: ...
    def GradientBackgroundOff(self) -> None: ...
    def GradientBackgroundOn(self) -> None: ...
    def GradientEnvironmentalBGOff(self) -> None: ...
    def GradientEnvironmentalBGOn(self) -> None: ...
    def HasViewProp(self, __a:'vtkProp') -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInViewport(self, x:int, y:int) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LocalDisplayToDisplay(self, x:float, y:float) -> None: ...
    def NewInstance(self) -> 'vtkViewport': ...
    def NormalizedDisplayToDisplay(self, u:float, v:float) -> None: ...
    def NormalizedDisplayToViewport(self, x:float, y:float) -> None: ...
    def NormalizedViewportToView(self, x:float, y:float, z:float) -> None: ...
    def NormalizedViewportToViewport(self, u:float, v:float) -> None: ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float) -> 'vtkAssemblyPath': ...
    @overload
    def PickProp(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float) -> 'vtkAssemblyPath': ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float, fieldAssociation:int, selection:'vtkSelection') -> 'vtkAssemblyPath': ...
    @overload
    def PickProp(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float, fieldAssociation:int, selection:'vtkSelection') -> 'vtkAssemblyPath': ...
    @overload
    def PickPropFrom(self, selectionX:float, selectionY:float, __c:'vtkPropCollection') -> 'vtkAssemblyPath': ...
    @overload
    def PickPropFrom(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float, __e:'vtkPropCollection') -> 'vtkAssemblyPath': ...
    @overload
    def PickPropFrom(self, selectionX:float, selectionY:float, __c:'vtkPropCollection', fieldAssociation:int, selection:'vtkSelection') -> 'vtkAssemblyPath': ...
    @overload
    def PickPropFrom(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float, __e:'vtkPropCollection', fieldAssociation:int, selection:'vtkSelection') -> 'vtkAssemblyPath': ...
    def PoseToView(self, __a:float, __b:float, __c:float) -> None: ...
    def PoseToWorld(self, __a:float, __b:float, __c:float) -> None: ...
    def RemoveActor2D(self, p:'vtkProp') -> None: ...
    def RemoveAllViewProps(self) -> None: ...
    def RemoveViewProp(self, __a:'vtkProp') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkViewport': ...
    @overload
    def SetAspect(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetAspect(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetBackground(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackground(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetBackground2(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackground2(self, _arg:Sequence[float]) -> None: ...
    def SetBackgroundAlpha(self, _arg:float) -> None: ...
    @overload
    def SetDisplayPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDisplayPoint(self, _arg:Sequence[float]) -> None: ...
    def SetDitherGradient(self, _arg:bool) -> None: ...
    @overload
    def SetEnvironmentalBG(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEnvironmentalBG(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetEnvironmentalBG2(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEnvironmentalBG2(self, _arg:Sequence[float]) -> None: ...
    def SetGradientBackground(self, _arg:bool) -> None: ...
    def SetGradientEnvironmentalBG(self, _arg:bool) -> None: ...
    def SetGradientMode(self, _arg:'GradientModes') -> None: ...
    @overload
    def SetPixelAspect(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPixelAspect(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetViewPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetViewPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetViewport(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetViewport(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetWorldPoint(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetWorldPoint(self, _arg:Sequence[float]) -> None: ...
    @overload
    def ViewToDisplay(self) -> None: ...
    @overload
    def ViewToDisplay(self, x:float, y:float, z:float) -> None: ...
    def ViewToNormalizedViewport(self, x:float, y:float, z:float) -> None: ...
    def ViewToPose(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def ViewToWorld(self) -> None: ...
    @overload
    def ViewToWorld(self, __a:float, __b:float, __c:float) -> None: ...
    def ViewportToNormalizedDisplay(self, x:float, y:float) -> None: ...
    def ViewportToNormalizedViewport(self, u:float, v:float) -> None: ...
    @overload
    def WorldToDisplay(self) -> None: ...
    @overload
    def WorldToDisplay(self, x:float, y:float, z:float) -> None: ...
    def WorldToPose(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def WorldToView(self) -> None: ...
    @overload
    def WorldToView(self, __a:float, __b:float, __c:float) -> None: ...

class vtkRenderer(vtkViewport):
    active_camera:'getset_descriptor'
    actors:'getset_descriptor'
    allocated_render_time:'getset_descriptor'
    ambient:'getset_descriptor'
    automatic_light_creation:'getset_descriptor'
    background_texture:'getset_descriptor'
    backing_store:'getset_descriptor'
    clipping_range_expansion:'getset_descriptor'
    cullers:'getset_descriptor'
    delegate:'getset_descriptor'
    draw:'getset_descriptor'
    environment_right:'getset_descriptor'
    environment_texture:'getset_descriptor'
    environment_texture_property:'getset_descriptor'
    environment_up:'getset_descriptor'
    erase:'getset_descriptor'
    fxaa_options:'getset_descriptor'
    gl2ps_special_prop_collection:'getset_descriptor'
    information:'getset_descriptor'
    interactive:'getset_descriptor'
    last_render_time_in_seconds:'getset_descriptor'
    last_rendering_used_depth_peeling:'getset_descriptor'
    layer:'getset_descriptor'
    left_background_texture:'getset_descriptor'
    light_collection:'getset_descriptor'
    light_follow_camera:'getset_descriptor'
    lights:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_number_of_peels:'getset_descriptor'
    near_clipping_plane_tolerance:'getset_descriptor'
    number_of_props_rendered:'getset_descriptor'
    occlusion_ratio:'getset_descriptor'
    preserve_color_buffer:'getset_descriptor'
    preserve_depth_buffer:'getset_descriptor'
    render_window:'getset_descriptor'
    right_background_texture:'getset_descriptor'
    safe_get_z:'getset_descriptor'
    selector:'getset_descriptor'
    ssao_bias:'getset_descriptor'
    ssao_blur:'getset_descriptor'
    ssao_kernel_size:'getset_descriptor'
    ssao_radius:'getset_descriptor'
    textured_background:'getset_descriptor'
    tiled_aspect_ratio:'getset_descriptor'
    time_factor:'getset_descriptor'
    two_sided_lighting:'getset_descriptor'
    use_depth_peeling:'getset_descriptor'
    use_depth_peeling_for_volumes:'getset_descriptor'
    use_fxaa:'getset_descriptor'
    use_hidden_line_removal:'getset_descriptor'
    use_image_based_lighting:'getset_descriptor'
    use_shadows:'getset_descriptor'
    use_ssao:'getset_descriptor'
    volumes:'getset_descriptor'
    vtk_window:'getset_descriptor'
    def AddActor(self, p:'vtkProp') -> None: ...
    def AddCuller(self, __a:'vtkCuller') -> None: ...
    def AddLight(self, __a:'vtkLight') -> None: ...
    def AddVolume(self, p:'vtkProp') -> None: ...
    def AutomaticLightCreationOff(self) -> None: ...
    def AutomaticLightCreationOn(self) -> None: ...
    def BackingStoreOff(self) -> None: ...
    def BackingStoreOn(self) -> None: ...
    def CaptureGL2PSSpecialProp(self, __a:'vtkProp') -> int: ...
    def Clear(self) -> None: ...
    def ClearLights(self) -> None: ...
    @overload
    def ComputeVisiblePropBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def ComputeVisiblePropBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def CreateLight(self) -> None: ...
    def DeviceRender(self) -> None: ...
    def DeviceRenderOpaqueGeometry(self, fbo:'vtkFrameBufferObjectBase'=...) -> None: ...
    def DeviceRenderTranslucentPolygonalGeometry(self, fbo:'vtkFrameBufferObjectBase'=...) -> None: ...
    @overload
    def DisplayToWorld(self, display:'vtkVector3d') -> 'vtkVector3d': ...
    @overload
    def DisplayToWorld(self) -> None: ...
    def DrawOff(self) -> None: ...
    def DrawOn(self) -> None: ...
    def EraseOff(self) -> None: ...
    def EraseOn(self) -> None: ...
    def GetActiveCamera(self) -> 'vtkCamera': ...
    def GetActors(self) -> 'vtkActorCollection': ...
    def GetAllocatedRenderTime(self) -> float: ...
    def GetAmbient(self) -> Tuple[float, float, float]: ...
    def GetAutomaticLightCreation(self) -> int: ...
    def GetBackgroundTexture(self) -> 'vtkTexture': ...
    def GetBackingStore(self) -> int: ...
    def GetClippingRangeExpansion(self) -> float: ...
    def GetClippingRangeExpansionMaxValue(self) -> float: ...
    def GetClippingRangeExpansionMinValue(self) -> float: ...
    def GetCullers(self) -> 'vtkCullerCollection': ...
    def GetDelegate(self) -> 'vtkRendererDelegate': ...
    def GetDraw(self) -> int: ...
    def GetEnvironmentRight(self) -> Tuple[float, float, float]: ...
    def GetEnvironmentTexture(self) -> 'vtkTexture': ...
    def GetEnvironmentUp(self) -> Tuple[float, float, float]: ...
    def GetErase(self) -> int: ...
    def GetFXAAOptions(self) -> 'vtkFXAAOptions': ...
    def GetInformation(self) -> 'vtkInformation': ...
    def GetInteractive(self) -> int: ...
    def GetLastRenderTimeInSeconds(self) -> float: ...
    def GetLastRenderingUsedDepthPeeling(self) -> int: ...
    def GetLayer(self) -> int: ...
    def GetLeftBackgroundTexture(self) -> 'vtkTexture': ...
    def GetLightFollowCamera(self) -> int: ...
    def GetLights(self) -> 'vtkLightCollection': ...
    def GetMTime(self) -> int: ...
    def GetMaximumNumberOfPeels(self) -> int: ...
    def GetNearClippingPlaneTolerance(self) -> float: ...
    def GetNearClippingPlaneToleranceMaxValue(self) -> float: ...
    def GetNearClippingPlaneToleranceMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPropsRendered(self) -> int: ...
    def GetOcclusionRatio(self) -> float: ...
    def GetOcclusionRatioMaxValue(self) -> float: ...
    def GetOcclusionRatioMinValue(self) -> float: ...
    def GetPass(self) -> 'vtkRenderPass': ...
    def GetPreserveColorBuffer(self) -> int: ...
    def GetPreserveDepthBuffer(self) -> int: ...
    def GetRenderWindow(self) -> 'vtkRenderWindow': ...
    def GetRightBackgroundTexture(self) -> 'vtkTexture': ...
    def GetSSAOBias(self) -> float: ...
    def GetSSAOBlur(self) -> bool: ...
    def GetSSAOKernelSize(self) -> int: ...
    def GetSSAORadius(self) -> float: ...
    def GetSafeGetZ(self) -> bool: ...
    def GetSelector(self) -> 'vtkHardwareSelector': ...
    def GetTexturedBackground(self) -> bool: ...
    def GetTiledAspectRatio(self) -> float: ...
    def GetTimeFactor(self) -> float: ...
    def GetTwoSidedLighting(self) -> int: ...
    def GetUseDepthPeeling(self) -> int: ...
    def GetUseDepthPeelingForVolumes(self) -> bool: ...
    def GetUseFXAA(self) -> bool: ...
    def GetUseHiddenLineRemoval(self) -> int: ...
    def GetUseImageBasedLighting(self) -> bool: ...
    def GetUseSSAO(self) -> bool: ...
    def GetUseShadows(self) -> int: ...
    def GetVTKWindow(self) -> 'vtkWindow': ...
    def GetVolumes(self) -> 'vtkVolumeCollection': ...
    def GetZ(self, x:int, y:int) -> float: ...
    def InteractiveOff(self) -> None: ...
    def InteractiveOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsActiveCameraCreated(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LightFollowCameraOff(self) -> None: ...
    def LightFollowCameraOn(self) -> None: ...
    def MakeCamera(self) -> 'vtkCamera': ...
    def MakeLight(self) -> 'vtkLight': ...
    def NewInstance(self) -> 'vtkRenderer': ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float) -> 'vtkAssemblyPath': ...
    @overload
    def PickProp(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float) -> 'vtkAssemblyPath': ...
    @overload
    def PickProp(self, selectionX:float, selectionY:float, fieldAssociation:int, selection:'vtkSelection') -> 'vtkAssemblyPath': ...
    @overload
    def PickProp(self, selectionX1:float, selectionY1:float, selectionX2:float, selectionY2:float, fieldAssociation:int, selection:'vtkSelection') -> 'vtkAssemblyPath': ...
    def PoseToView(self, wx:float, wy:float, wz:float) -> None: ...
    def PoseToWorld(self, wx:float, wy:float, wz:float) -> None: ...
    def PreserveColorBufferOff(self) -> None: ...
    def PreserveColorBufferOn(self) -> None: ...
    def PreserveDepthBufferOff(self) -> None: ...
    def PreserveDepthBufferOn(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveActor(self, p:'vtkProp') -> None: ...
    def RemoveAllLights(self) -> None: ...
    def RemoveCuller(self, __a:'vtkCuller') -> None: ...
    def RemoveLight(self, __a:'vtkLight') -> None: ...
    def RemoveVolume(self, p:'vtkProp') -> None: ...
    def Render(self) -> None: ...
    @overload
    def ResetCamera(self) -> None: ...
    @overload
    def ResetCamera(self, bounds:Sequence[float]) -> None: ...
    @overload
    def ResetCamera(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def ResetCameraClippingRange(self) -> None: ...
    @overload
    def ResetCameraClippingRange(self, bounds:Sequence[float]) -> None: ...
    @overload
    def ResetCameraClippingRange(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def ResetCameraScreenSpace(self, offsetRatio:float=0.9) -> None: ...
    @overload
    def ResetCameraScreenSpace(self, bounds:Sequence[float], offsetRatio:float=0.9) -> None: ...
    @overload
    def ResetCameraScreenSpace(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float, offsetRatio:float=0.9) -> None: ...
    def SSAOBlurOff(self) -> None: ...
    def SSAOBlurOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderer': ...
    def SafeGetZOff(self) -> None: ...
    def SafeGetZOn(self) -> None: ...
    def SetActiveCamera(self, __a:'vtkCamera') -> None: ...
    def SetAllocatedRenderTime(self, _arg:float) -> None: ...
    @overload
    def SetAmbient(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAmbient(self, _arg:Sequence[float]) -> None: ...
    def SetAutomaticLightCreation(self, _arg:int) -> None: ...
    def SetBackgroundTexture(self, __a:'vtkTexture') -> None: ...
    def SetBackingStore(self, _arg:int) -> None: ...
    def SetClippingRangeExpansion(self, _arg:float) -> None: ...
    def SetDelegate(self, d:'vtkRendererDelegate') -> None: ...
    def SetDraw(self, _arg:int) -> None: ...
    @overload
    def SetEnvironmentRight(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEnvironmentRight(self, _arg:Sequence[float]) -> None: ...
    def SetEnvironmentTexture(self, texture:'vtkTexture', isSRGB:bool=False) -> None: ...
    def SetEnvironmentTextureProperty(self, texture:'vtkTexture') -> None: ...
    @overload
    def SetEnvironmentUp(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetEnvironmentUp(self, _arg:Sequence[float]) -> None: ...
    def SetErase(self, _arg:int) -> None: ...
    def SetFXAAOptions(self, __a:'vtkFXAAOptions') -> None: ...
    def SetGL2PSSpecialPropCollection(self, __a:'vtkPropCollection') -> None: ...
    def SetInformation(self, __a:'vtkInformation') -> None: ...
    def SetInteractive(self, _arg:int) -> None: ...
    def SetLayer(self, layer:int) -> None: ...
    def SetLeftBackgroundTexture(self, __a:'vtkTexture') -> None: ...
    def SetLightCollection(self, lights:'vtkLightCollection') -> None: ...
    def SetLightFollowCamera(self, _arg:int) -> None: ...
    def SetMaximumNumberOfPeels(self, _arg:int) -> None: ...
    def SetNearClippingPlaneTolerance(self, _arg:float) -> None: ...
    def SetOcclusionRatio(self, _arg:float) -> None: ...
    def SetPass(self, p:'vtkRenderPass') -> None: ...
    def SetPreserveColorBuffer(self, _arg:int) -> None: ...
    def SetPreserveDepthBuffer(self, _arg:int) -> None: ...
    def SetRenderWindow(self, __a:'vtkRenderWindow') -> None: ...
    def SetRightBackgroundTexture(self, __a:'vtkTexture') -> None: ...
    def SetSSAOBias(self, _arg:float) -> None: ...
    def SetSSAOBlur(self, _arg:bool) -> None: ...
    def SetSSAOKernelSize(self, _arg:int) -> None: ...
    def SetSSAORadius(self, _arg:float) -> None: ...
    def SetSafeGetZ(self, _arg:bool) -> None: ...
    def SetTexturedBackground(self, _arg:bool) -> None: ...
    def SetTwoSidedLighting(self, _arg:int) -> None: ...
    def SetUseDepthPeeling(self, _arg:int) -> None: ...
    def SetUseDepthPeelingForVolumes(self, _arg:bool) -> None: ...
    def SetUseFXAA(self, _arg:bool) -> None: ...
    def SetUseHiddenLineRemoval(self, _arg:int) -> None: ...
    def SetUseImageBasedLighting(self, _arg:bool) -> None: ...
    def SetUseSSAO(self, _arg:bool) -> None: ...
    def SetUseShadows(self, _arg:int) -> None: ...
    def StereoMidpoint(self) -> None: ...
    def TexturedBackgroundOff(self) -> None: ...
    def TexturedBackgroundOn(self) -> None: ...
    def Transparent(self) -> int: ...
    def TwoSidedLightingOff(self) -> None: ...
    def TwoSidedLightingOn(self) -> None: ...
    def UpdateLightsGeometryToFollowCamera(self) -> int: ...
    def UseDepthPeelingForVolumesOff(self) -> None: ...
    def UseDepthPeelingForVolumesOn(self) -> None: ...
    def UseDepthPeelingOff(self) -> None: ...
    def UseDepthPeelingOn(self) -> None: ...
    def UseFXAAOff(self) -> None: ...
    def UseFXAAOn(self) -> None: ...
    def UseHiddenLineRemovalOff(self) -> None: ...
    def UseHiddenLineRemovalOn(self) -> None: ...
    def UseImageBasedLightingOff(self) -> None: ...
    def UseImageBasedLightingOn(self) -> None: ...
    def UseSSAOOff(self) -> None: ...
    def UseSSAOOn(self) -> None: ...
    def UseShadowsOff(self) -> None: ...
    def UseShadowsOn(self) -> None: ...
    def ViewToPose(self, wx:float, wy:float, wz:float) -> None: ...
    @overload
    def ViewToWorld(self) -> None: ...
    @overload
    def ViewToWorld(self, wx:float, wy:float, wz:float) -> None: ...
    def VisibleActorCount(self) -> int: ...
    def VisibleVolumeCount(self) -> int: ...
    def WorldToPose(self, wx:float, wy:float, wz:float) -> None: ...
    @overload
    def WorldToView(self) -> None: ...
    @overload
    def WorldToView(self, wx:float, wy:float, wz:float) -> None: ...
    def ZoomToBoxUsingViewAngle(self, box:'vtkRecti', offsetRatio:float=1.0) -> None: ...

class vtkRendererCollection(vtkmodules.vtkCommonCore.vtkCollection):
    first_renderer:'getset_descriptor'
    next_item:'getset_descriptor'
    def AddItem(self, a:'vtkRenderer') -> None: ...
    def GetFirstRenderer(self) -> 'vtkRenderer': ...
    def GetNextItem(self) -> 'vtkRenderer': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRendererCollection': ...
    def Render(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRendererCollection': ...

class vtkRendererDelegate(vtkmodules.vtkCommonCore.vtkObject):
    used:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUsed(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRendererDelegate': ...
    def Render(self, r:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRendererDelegate': ...
    def SetUsed(self, _arg:bool) -> None: ...
    def UsedOff(self) -> None: ...
    def UsedOn(self) -> None: ...

class vtkRendererSource(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    depth_values:'getset_descriptor'
    depth_values_in_scalars:'getset_descriptor'
    input:'getset_descriptor'
    m_time:'getset_descriptor'
    output:'getset_descriptor'
    render_flag:'getset_descriptor'
    whole_window:'getset_descriptor'
    def DepthValuesInScalarsOff(self) -> None: ...
    def DepthValuesInScalarsOn(self) -> None: ...
    def DepthValuesOff(self) -> None: ...
    def DepthValuesOn(self) -> None: ...
    def DepthValuesOnlyOff(self) -> None: ...
    def DepthValuesOnlyOn(self) -> None: ...
    def GetDepthValues(self) -> int: ...
    def GetDepthValuesInScalars(self) -> int: ...
    def GetDepthValuesOnly(self) -> int: ...
    def GetInput(self) -> 'vtkRenderer': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkImageData': ...
    def GetRenderFlag(self) -> int: ...
    def GetWholeWindow(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRendererSource': ...
    def RenderFlagOff(self) -> None: ...
    def RenderFlagOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRendererSource': ...
    def SetDepthValues(self, _arg:int) -> None: ...
    def SetDepthValuesInScalars(self, _arg:int) -> None: ...
    def SetDepthValuesOnly(self, _arg:int) -> None: ...
    def SetInput(self, __a:'vtkRenderer') -> None: ...
    def SetRenderFlag(self, _arg:int) -> None: ...
    def SetWholeWindow(self, _arg:int) -> None: ...
    def WholeWindowOff(self) -> None: ...
    def WholeWindowOn(self) -> None: ...

class vtkResizingWindowToImageFilter(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    input:'getset_descriptor'
    input_buffer_type:'getset_descriptor'
    output:'getset_descriptor'
    size:'getset_descriptor'
    size_limit:'getset_descriptor'
    def GetInput(self) -> 'vtkWindow': ...
    def GetInputBufferType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkImageData': ...
    def GetSize(self) -> Tuple[int, int]: ...
    def GetSizeLimit(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkResizingWindowToImageFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkResizingWindowToImageFilter': ...
    def SetInput(self, input:'vtkWindow') -> None: ...
    def SetInputBufferType(self, _arg:int) -> None: ...
    def SetInputBufferTypeToRGB(self) -> None: ...
    def SetInputBufferTypeToRGBA(self) -> None: ...
    def SetInputBufferTypeToZBuffer(self) -> None: ...
    @overload
    def SetSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetSize(self, _arg:Sequence[int]) -> None: ...
    def SetSizeLimit(self, _arg:int) -> None: ...

class vtkScenePicker(vtkmodules.vtkCommonCore.vtkObject):
    enable_vertex_picking:'getset_descriptor'
    renderer:'getset_descriptor'
    def EnableVertexPickingOff(self) -> None: ...
    def EnableVertexPickingOn(self) -> None: ...
    def GetCellId(self, displayPos:MutableSequence[int]) -> int: ...
    def GetEnableVertexPicking(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetVertexId(self, displayPos:MutableSequence[int]) -> int: ...
    def GetViewProp(self, displayPos:MutableSequence[int]) -> 'vtkProp': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkScenePicker': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScenePicker': ...
    def SetEnableVertexPicking(self, _arg:int) -> None: ...
    def SetRenderer(self, __a:'vtkRenderer') -> None: ...

class vtkSelectVisiblePoints(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    m_time:'getset_descriptor'
    renderer:'getset_descriptor'
    select_invisible:'getset_descriptor'
    selection:'getset_descriptor'
    selection_window:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_world:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetSelectInvisible(self) -> int: ...
    def GetSelection(self) -> Tuple[int, int, int, int]: ...
    def GetSelectionWindow(self) -> int: ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def GetToleranceWorld(self) -> float: ...
    def GetToleranceWorldMaxValue(self) -> float: ...
    def GetToleranceWorldMinValue(self) -> float: ...
    def Initialize(self, getZbuff:bool) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    def IsPointOccluded(self, x:Sequence[float], zPtr:Sequence[float]) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSelectVisiblePoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSelectVisiblePoints': ...
    def SelectInvisibleOff(self) -> None: ...
    def SelectInvisibleOn(self) -> None: ...
    def SelectionWindowOff(self) -> None: ...
    def SelectionWindowOn(self) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetSelectInvisible(self, _arg:int) -> None: ...
    @overload
    def SetSelection(self, _arg1:int, _arg2:int, _arg3:int, _arg4:int) -> None: ...
    @overload
    def SetSelection(self, _arg:Sequence[int]) -> None: ...
    def SetSelectionWindow(self, _arg:int) -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceWorld(self, _arg:float) -> None: ...

class vtkShaderProperty(vtkmodules.vtkCommonCore.vtkObject):
    fragment_custom_uniforms:'getset_descriptor'
    fragment_shader_code:'getset_descriptor'
    geometry_custom_uniforms:'getset_descriptor'
    geometry_shader_code:'getset_descriptor'
    number_of_shader_replacements:'getset_descriptor'
    shader_m_time:'getset_descriptor'
    tess_control_custom_uniforms:'getset_descriptor'
    tess_control_shader_code:'getset_descriptor'
    tess_evaluation_custom_uniforms:'getset_descriptor'
    tess_evaluation_shader_code:'getset_descriptor'
    vertex_custom_uniforms:'getset_descriptor'
    vertex_shader_code:'getset_descriptor'
    def AddFragmentShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddGeometryShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddTessControlShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddTessEvaluationShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def AddVertexShaderReplacement(self, originalValue:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def ClearAllFragmentShaderReplacements(self) -> None: ...
    def ClearAllGeometryShaderReplacements(self) -> None: ...
    def ClearAllShaderReplacements(self) -> None: ...
    def ClearAllTessControlShaderReplacements(self) -> None: ...
    def ClearAllTessEvalShaderReplacements(self) -> None: ...
    def ClearAllVertexShaderReplacements(self) -> None: ...
    def ClearFragmentShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearGeometryShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearTessControlShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearTessEvaluationShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def ClearVertexShaderReplacement(self, originalValue:str, replaceFirst:bool) -> None: ...
    def DeepCopy(self, p:'vtkShaderProperty') -> None: ...
    def GetFragmentCustomUniforms(self) -> 'vtkUniforms': ...
    def GetFragmentShaderCode(self) -> str: ...
    def GetGeometryCustomUniforms(self) -> 'vtkUniforms': ...
    def GetGeometryShaderCode(self) -> str: ...
    def GetNthShaderReplacement(self, index:int, name:str, replaceFirst:bool, replacementValue:str, replaceAll:bool) -> None: ...
    def GetNthShaderReplacementTypeAsString(self, index:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfShaderReplacements(self) -> int: ...
    def GetShaderMTime(self) -> int: ...
    def GetTessControlCustomUniforms(self) -> 'vtkUniforms': ...
    def GetTessControlShaderCode(self) -> str: ...
    def GetTessEvaluationCustomUniforms(self) -> 'vtkUniforms': ...
    def GetTessEvaluationShaderCode(self) -> str: ...
    def GetVertexCustomUniforms(self) -> 'vtkUniforms': ...
    def GetVertexShaderCode(self) -> str: ...
    def HasFragmentShaderCode(self) -> bool: ...
    def HasGeometryShaderCode(self) -> bool: ...
    def HasTessControlShaderCode(self) -> bool: ...
    def HasTessEvalShaderCode(self) -> bool: ...
    def HasVertexShaderCode(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkShaderProperty': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkShaderProperty': ...
    def SetFragmentShaderCode(self, _arg:str) -> None: ...
    def SetGeometryShaderCode(self, _arg:str) -> None: ...
    def SetTessControlShaderCode(self, _arg:str) -> None: ...
    def SetTessEvaluationShaderCode(self, _arg:str) -> None: ...
    def SetVertexShaderCode(self, _arg:str) -> None: ...

class vtkSkybox(vtkActor):
    class Projection(int): ...
    Cube:'Projection'
    Floor:'Projection'
    Sphere:'Projection'
    StereoSphere:'Projection'
    bounds:'getset_descriptor'
    floor_plane:'getset_descriptor'
    floor_right:'getset_descriptor'
    floor_tex_coord_scale:'getset_descriptor'
    gamma_correct:'getset_descriptor'
    projection:'getset_descriptor'
    def GammaCorrectOff(self) -> None: ...
    def GammaCorrectOn(self) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetFloorPlane(self) -> Tuple[float, float, float, float]: ...
    def GetFloorRight(self) -> Tuple[float, float, float]: ...
    def GetFloorTexCoordScale(self) -> Tuple[float, float]: ...
    def GetGammaCorrect(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProjection(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSkybox': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSkybox': ...
    @overload
    def SetFloorPlane(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetFloorPlane(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetFloorRight(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetFloorRight(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetFloorTexCoordScale(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetFloorTexCoordScale(self, _arg:Sequence[float]) -> None: ...
    def SetGammaCorrect(self, _arg:bool) -> None: ...
    def SetProjection(self, _arg:int) -> None: ...
    def SetProjectionToCube(self) -> None: ...
    def SetProjectionToFloor(self) -> None: ...
    def SetProjectionToSphere(self) -> None: ...
    def SetProjectionToStereoSphere(self) -> None: ...

class vtkStateStorage(object):
    def __init__(self) -> None: ...
    def Clear(self) -> None: ...

class vtkStereoCompositor(vtkmodules.vtkCommonCore.vtkObject):
    def Anaglyph(self, rgbLeftNResult:'vtkUnsignedCharArray', rgbRight:'vtkUnsignedCharArray', colorSaturation:float, colorMask:Sequence[int]) -> bool: ...
    def Checkerboard(self, rgbLeftNResult:'vtkUnsignedCharArray', rgbRight:'vtkUnsignedCharArray', size:Sequence[int]) -> bool: ...
    def Dresden(self, rgbLeftNResult:'vtkUnsignedCharArray', rgbRight:'vtkUnsignedCharArray', size:Sequence[int]) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def Interlaced(self, rgbLeftNResult:'vtkUnsignedCharArray', rgbRight:'vtkUnsignedCharArray', size:Sequence[int]) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStereoCompositor': ...
    def RedBlue(self, rgbLeftNResult:'vtkUnsignedCharArray', rgbRight:'vtkUnsignedCharArray') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStereoCompositor': ...
    def SplitViewportHorizontal(self, rgbLeftNResult:'vtkUnsignedCharArray', rgbRight:'vtkUnsignedCharArray', size:Sequence[int]) -> bool: ...

class vtkStringToImage(vtkmodules.vtkCommonCore.vtkObject):
    scale_to_power_of_two:'getset_descriptor'
    def GetBounds(self, property:'vtkTextProperty', string:str, dpi:int) -> 'vtkVector2i': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleToPowerOfTwo(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkStringToImage': ...
    def RenderString(self, property:'vtkTextProperty', string:str, dpi:int, data:'vtkImageData', text_dims:MutableSequence[int]=...) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkStringToImage': ...
    def SetScaleToPowerOfTwo(self, scale:bool) -> None: ...

class vtkTDxInteractorStyle(vtkmodules.vtkCommonCore.vtkObject):
    settings:'getset_descriptor'
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSettings(self) -> 'vtkTDxInteractorStyleSettings': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTDxInteractorStyle': ...
    def OnButtonPressedEvent(self, button:int) -> None: ...
    def OnButtonReleasedEvent(self, button:int) -> None: ...
    def ProcessEvent(self, renderer:'vtkRenderer', event:int, calldata:Pointer) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTDxInteractorStyle': ...
    def SetSettings(self, settings:'vtkTDxInteractorStyleSettings') -> None: ...

class vtkTDxInteractorStyleCamera(vtkTDxInteractorStyle):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTDxInteractorStyleCamera': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTDxInteractorStyleCamera': ...

class vtkTDxInteractorStyleSettings(vtkmodules.vtkCommonCore.vtkObject):
    angle_sensitivity:'getset_descriptor'
    translation_x_sensitivity:'getset_descriptor'
    translation_y_sensitivity:'getset_descriptor'
    translation_z_sensitivity:'getset_descriptor'
    use_rotation_x:'getset_descriptor'
    use_rotation_y:'getset_descriptor'
    use_rotation_z:'getset_descriptor'
    def GetAngleSensitivity(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTranslationXSensitivity(self) -> float: ...
    def GetTranslationYSensitivity(self) -> float: ...
    def GetTranslationZSensitivity(self) -> float: ...
    def GetUseRotationX(self) -> bool: ...
    def GetUseRotationY(self) -> bool: ...
    def GetUseRotationZ(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTDxInteractorStyleSettings': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTDxInteractorStyleSettings': ...
    def SetAngleSensitivity(self, _arg:float) -> None: ...
    def SetTranslationXSensitivity(self, _arg:float) -> None: ...
    def SetTranslationYSensitivity(self, _arg:float) -> None: ...
    def SetTranslationZSensitivity(self, _arg:float) -> None: ...
    def SetUseRotationX(self, _arg:bool) -> None: ...
    def SetUseRotationY(self, _arg:bool) -> None: ...
    def SetUseRotationZ(self, _arg:bool) -> None: ...

class vtkTDxMotionEventInfo(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkTDxMotionEventInfo') -> None: ...

class vtkTexturedActor2D(vtkActor2D):
    m_time:'getset_descriptor'
    texture:'getset_descriptor'
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTexture(self) -> 'vtkTexture': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTexturedActor2D': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTexturedActor2D': ...
    def SetTexture(self, texture:'vtkTexture') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkTextActor(vtkTexturedActor2D):
    TEXT_SCALE_MODE_NONE:int
    TEXT_SCALE_MODE_PROP:int
    TEXT_SCALE_MODE_VIEWPORT:int
    alignment_point:'getset_descriptor'
    input:'getset_descriptor'
    maximum_line_height:'getset_descriptor'
    minimum_size:'getset_descriptor'
    orientation:'getset_descriptor'
    scaled_text_property:'getset_descriptor'
    text_property:'getset_descriptor'
    text_scale_mode:'getset_descriptor'
    use_border_align:'getset_descriptor'
    def ComputeScaledFont(self, viewport:'vtkViewport') -> None: ...
    def DisplayToSpecified(self, pos:MutableSequence[float], vport:'vtkViewport', specified:int) -> None: ...
    def GetAlignmentPoint(self) -> int: ...
    def GetBoundingBox(self, vport:'vtkViewport', bbox:MutableSequence[float]) -> None: ...
    @staticmethod
    def GetFontScale(viewport:'vtkViewport') -> float: ...
    def GetInput(self) -> str: ...
    def GetMaximumLineHeight(self) -> float: ...
    def GetMinimumSize(self) -> Tuple[int, int]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> float: ...
    def GetScaledTextProperty(self) -> 'vtkTextProperty': ...
    def GetSize(self, vport:'vtkViewport', size:MutableSequence[float]) -> None: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def GetTextScaleMode(self) -> int: ...
    def GetTextScaleModeMaxValue(self) -> int: ...
    def GetTextScaleModeMinValue(self) -> int: ...
    def GetUseBorderAlign(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextActor': ...
    def SetAlignmentPoint(self, point:int) -> None: ...
    @overload
    def SetConstrainedFontSize(self, __a:'vtkViewport', targetWidth:int, targetHeight:int) -> int: ...
    @overload
    @staticmethod
    def SetConstrainedFontSize(__a:'vtkTextActor', __b:'vtkViewport', targetWidth:int, targetHeight:int) -> int: ...
    def SetInput(self, inputString:str) -> None: ...
    def SetMaximumLineHeight(self, _arg:float) -> None: ...
    @overload
    def SetMinimumSize(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetMinimumSize(self, _arg:Sequence[int]) -> None: ...
    def SetNonLinearFontScale(self, exponent:float, target:int) -> None: ...
    def SetOrientation(self, orientation:float) -> None: ...
    def SetTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetTextScaleMode(self, _arg:int) -> None: ...
    def SetTextScaleModeToNone(self) -> None: ...
    def SetTextScaleModeToProp(self) -> None: ...
    def SetTextScaleModeToViewport(self) -> None: ...
    def SetUseBorderAlign(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def SpecifiedToDisplay(self, pos:MutableSequence[float], vport:'vtkViewport', specified:int) -> None: ...
    def UseBorderAlignOff(self) -> None: ...
    def UseBorderAlignOn(self) -> None: ...

class vtkTextActor3D(vtkProp3D):
    bounds:'getset_descriptor'
    force_opaque:'getset_descriptor'
    force_translucent:'getset_descriptor'
    input:'getset_descriptor'
    rendered_dpi:'getset_descriptor'
    text_property:'getset_descriptor'
    def ForceOpaqueOff(self) -> None: ...
    def ForceOpaqueOn(self) -> None: ...
    def ForceTranslucentOff(self) -> None: ...
    def ForceTranslucentOn(self) -> None: ...
    def GetBoundingBox(self, bbox:MutableSequence[int]) -> int: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetForceOpaque(self) -> bool: ...
    def GetForceTranslucent(self) -> bool: ...
    def GetInput(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @staticmethod
    def GetRenderedDPI() -> int: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextActor3D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextActor3D': ...
    def SetForceOpaque(self, opaque:bool) -> None: ...
    def SetForceTranslucent(self, trans:bool) -> None: ...
    def SetInput(self, _arg:str) -> None: ...
    def SetTextProperty(self, p:'vtkTextProperty') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkTextMapper(vtkMapper2D):
    input:'getset_descriptor'
    m_time:'getset_descriptor'
    text_property:'getset_descriptor'
    def GetHeight(self, v:'vtkViewport') -> int: ...
    def GetInput(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSize(self, __a:'vtkViewport', size:MutableSequence[int]) -> None: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def GetWidth(self, v:'vtkViewport') -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextMapper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOverlay(self, __a:'vtkViewport', __b:'vtkActor2D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextMapper': ...
    @overload
    def SetConstrainedFontSize(self, __a:'vtkViewport', targetWidth:int, targetHeight:int) -> int: ...
    @overload
    @staticmethod
    def SetConstrainedFontSize(__a:'vtkTextMapper', __b:'vtkViewport', targetWidth:int, targetHeight:int) -> int: ...
    def SetInput(self, _arg:str) -> None: ...
    @staticmethod
    def SetRelativeFontSize(__a:'vtkTextMapper', __b:'vtkViewport', winSize:Sequence[int], stringSize:MutableSequence[int], sizeFactor:float=0.0) -> int: ...
    def SetTextProperty(self, p:'vtkTextProperty') -> None: ...
    def ShallowCopy(self, m:'vtkAbstractMapper') -> None: ...

class vtkTextProperty(vtkmodules.vtkCommonCore.vtkObject):
    background_color:'getset_descriptor'
    background_opacity:'getset_descriptor'
    background_rgba:'getset_descriptor'
    bold:'getset_descriptor'
    cell_offset:'getset_descriptor'
    color:'getset_descriptor'
    font_family:'getset_descriptor'
    font_family_as_string:'getset_descriptor'
    font_file:'getset_descriptor'
    font_size:'getset_descriptor'
    frame:'getset_descriptor'
    frame_color:'getset_descriptor'
    frame_width:'getset_descriptor'
    interior_lines_color:'getset_descriptor'
    interior_lines_visibility:'getset_descriptor'
    interior_lines_width:'getset_descriptor'
    italic:'getset_descriptor'
    justification:'getset_descriptor'
    line_offset:'getset_descriptor'
    line_spacing:'getset_descriptor'
    opacity:'getset_descriptor'
    orientation:'getset_descriptor'
    shadow:'getset_descriptor'
    shadow_offset:'getset_descriptor'
    use_tight_bounding_box:'getset_descriptor'
    vertical_justification:'getset_descriptor'
    def BoldOff(self) -> None: ...
    def BoldOn(self) -> None: ...
    def FrameOff(self) -> None: ...
    def FrameOn(self) -> None: ...
    def GetBackgroundColor(self) -> Tuple[float, float, float]: ...
    def GetBackgroundOpacity(self) -> float: ...
    def GetBackgroundOpacityMaxValue(self) -> float: ...
    def GetBackgroundOpacityMinValue(self) -> float: ...
    @overload
    def GetBackgroundRGBA(self, rgba:MutableSequence[float]) -> None: ...
    @overload
    def GetBackgroundRGBA(self, r:float, g:float, b:float, a:float) -> None: ...
    def GetBold(self) -> int: ...
    def GetCellOffset(self) -> float: ...
    def GetColor(self) -> Tuple[float, float, float]: ...
    def GetFontFamily(self) -> int: ...
    @overload
    def GetFontFamilyAsString(self) -> str: ...
    @overload
    @staticmethod
    def GetFontFamilyAsString(f:int) -> str: ...
    @staticmethod
    def GetFontFamilyFromString(f:str) -> int: ...
    def GetFontFamilyMinValue(self) -> int: ...
    def GetFontFile(self) -> str: ...
    def GetFontSize(self) -> int: ...
    def GetFontSizeMaxValue(self) -> int: ...
    def GetFontSizeMinValue(self) -> int: ...
    def GetFrame(self) -> int: ...
    def GetFrameColor(self) -> Tuple[float, float, float]: ...
    def GetFrameWidth(self) -> int: ...
    def GetFrameWidthMaxValue(self) -> int: ...
    def GetFrameWidthMinValue(self) -> int: ...
    def GetInteriorLinesColor(self) -> Tuple[float, float, float]: ...
    def GetInteriorLinesVisibility(self) -> bool: ...
    def GetInteriorLinesWidth(self) -> int: ...
    def GetItalic(self) -> int: ...
    def GetJustification(self) -> int: ...
    def GetJustificationAsString(self) -> str: ...
    def GetJustificationMaxValue(self) -> int: ...
    def GetJustificationMinValue(self) -> int: ...
    def GetLineOffset(self) -> float: ...
    def GetLineSpacing(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetOrientation(self) -> float: ...
    def GetShadow(self) -> int: ...
    def GetShadowColor(self, color:MutableSequence[float]) -> None: ...
    def GetShadowOffset(self) -> Tuple[int, int]: ...
    def GetUseTightBoundingBox(self) -> int: ...
    def GetVerticalJustification(self) -> int: ...
    def GetVerticalJustificationAsString(self) -> str: ...
    def GetVerticalJustificationMaxValue(self) -> int: ...
    def GetVerticalJustificationMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def ItalicOff(self) -> None: ...
    def ItalicOn(self) -> None: ...
    def NewInstance(self) -> 'vtkTextProperty': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextProperty': ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:Sequence[float]) -> None: ...
    def SetBackgroundOpacity(self, _arg:float) -> None: ...
    @overload
    def SetBackgroundRGBA(self, rgba:MutableSequence[float]) -> None: ...
    @overload
    def SetBackgroundRGBA(self, r:float, g:float, b:float, a:float) -> None: ...
    def SetBold(self, _arg:int) -> None: ...
    def SetCellOffset(self, _arg:float) -> None: ...
    @overload
    def SetColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetColor(self, _arg:Sequence[float]) -> None: ...
    def SetFontFamily(self, t:int) -> None: ...
    def SetFontFamilyAsString(self, _arg:str) -> None: ...
    def SetFontFamilyToArial(self) -> None: ...
    def SetFontFamilyToCourier(self) -> None: ...
    def SetFontFamilyToTimes(self) -> None: ...
    def SetFontFile(self, _arg:str) -> None: ...
    def SetFontSize(self, _arg:int) -> None: ...
    def SetFrame(self, _arg:int) -> None: ...
    @overload
    def SetFrameColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetFrameColor(self, _arg:Sequence[float]) -> None: ...
    def SetFrameWidth(self, _arg:int) -> None: ...
    @overload
    def SetInteriorLinesColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetInteriorLinesColor(self, _arg:Sequence[float]) -> None: ...
    def SetInteriorLinesVisibility(self, _arg:bool) -> None: ...
    def SetInteriorLinesWidth(self, _arg:int) -> None: ...
    def SetItalic(self, _arg:int) -> None: ...
    def SetJustification(self, _arg:int) -> None: ...
    def SetJustificationToCentered(self) -> None: ...
    def SetJustificationToLeft(self) -> None: ...
    def SetJustificationToRight(self) -> None: ...
    def SetLineOffset(self, _arg:float) -> None: ...
    def SetLineSpacing(self, _arg:float) -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetOrientation(self, _arg:float) -> None: ...
    def SetShadow(self, _arg:int) -> None: ...
    @overload
    def SetShadowOffset(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetShadowOffset(self, _arg:Sequence[int]) -> None: ...
    def SetUseTightBoundingBox(self, _arg:int) -> None: ...
    def SetVerticalJustification(self, _arg:int) -> None: ...
    def SetVerticalJustificationToBottom(self) -> None: ...
    def SetVerticalJustificationToCentered(self) -> None: ...
    def SetVerticalJustificationToTop(self) -> None: ...
    def ShadowOff(self) -> None: ...
    def ShadowOn(self) -> None: ...
    def ShallowCopy(self, tprop:'vtkTextProperty') -> None: ...
    def UseTightBoundingBoxOff(self) -> None: ...
    def UseTightBoundingBoxOn(self) -> None: ...

class vtkTextPropertyCollection(vtkmodules.vtkCommonCore.vtkCollection):
    last_item:'getset_descriptor'
    next_item:'getset_descriptor'
    def AddItem(self, a:'vtkTextProperty') -> None: ...
    def GetItem(self, idx:int) -> 'vtkTextProperty': ...
    def GetLastItem(self) -> 'vtkTextProperty': ...
    def GetNextItem(self) -> 'vtkTextProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTextPropertyCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextPropertyCollection': ...

class vtkTextRenderer(vtkmodules.vtkCommonCore.vtkObject):
    class Backend(int): ...
    Default:'Backend'
    Detect:'Backend'
    FreeType:'Backend'
    MathText:'Backend'
    UserBackend:'Backend'
    default_backend:'getset_descriptor'
    instance:'getset_descriptor'
    scale_to_power_of_two:'getset_descriptor'
    def DetectBackend(self, str:str) -> int: ...
    def FreeTypeIsSupported(self) -> bool: ...
    def GetBoundingBox(self, tprop:'vtkTextProperty', str:str, bbox:MutableSequence[int], dpi:int, backend:int=...) -> bool: ...
    def GetConstrainedFontSize(self, str:str, tprop:'vtkTextProperty', targetWidth:int, targetHeight:int, dpi:int, backend:int=...) -> int: ...
    def GetDefaultBackend(self) -> int: ...
    @staticmethod
    def GetInstance() -> 'vtkTextRenderer': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MathTextIsSupported(self) -> bool: ...
    def NewInstance(self) -> 'vtkTextRenderer': ...
    def RenderString(self, tprop:'vtkTextProperty', str:str, data:'vtkImageData', textDims:MutableSequence[int], dpi:int, backend:int=...) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTextRenderer': ...
    def SetDefaultBackend(self, _arg:int) -> None: ...
    def SetScaleToPowerOfTwo(self, scale:bool) -> None: ...
    def StringToPath(self, tprop:'vtkTextProperty', str:str, path:'vtkPath', dpi:int, backend:int=...) -> bool: ...

class vtkTextRendererCleanup(object):
    def __init__(self) -> None: ...

class vtkTexture(vtkmodules.vtkCommonExecutionModel.vtkImageAlgorithm):
    class VTKTextureBlendingMode(int): ...
    ClampToBorder:int
    ClampToEdge:int
    MirroredRepeat:int
    NumberOfWrapModes:int
    Repeat:int
    VTK_TEXTURE_BLENDING_MODE_ADD:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_ADD_SIGNED:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_INTERPOLATE:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_MODULATE:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_NONE:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_REPLACE:'VTKTextureBlendingMode'
    VTK_TEXTURE_BLENDING_MODE_SUBTRACT:'VTKTextureBlendingMode'
    blending_mode:'getset_descriptor'
    border_color:'getset_descriptor'
    color_mode:'getset_descriptor'
    cube_map:'getset_descriptor'
    edge_clamp:'getset_descriptor'
    input:'getset_descriptor'
    interpolate:'getset_descriptor'
    lookup_table:'getset_descriptor'
    mapped_scalars:'getset_descriptor'
    maximum_anisotropic_filtering:'getset_descriptor'
    mipmap:'getset_descriptor'
    premultiplied_alpha:'getset_descriptor'
    quality:'getset_descriptor'
    repeat:'getset_descriptor'
    restrict_power_of2_image_smaller:'getset_descriptor'
    texture_unit:'getset_descriptor'
    transform:'getset_descriptor'
    use_srgb_color_space:'getset_descriptor'
    wrap:'getset_descriptor'
    def CubeMapOff(self) -> None: ...
    def CubeMapOn(self) -> None: ...
    def EdgeClampOff(self) -> None: ...
    def EdgeClampOn(self) -> None: ...
    def GetBlendingMode(self) -> int: ...
    def GetBorderColor(self) -> Tuple[float, float, float, float]: ...
    def GetColorMode(self) -> int: ...
    def GetCubeMap(self) -> bool: ...
    def GetEdgeClamp(self) -> int: ...
    def GetInput(self) -> 'vtkImageData': ...
    def GetInterpolate(self) -> int: ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMappedScalars(self) -> 'vtkUnsignedCharArray': ...
    def GetMaximumAnisotropicFiltering(self) -> float: ...
    def GetMipmap(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPremultipliedAlpha(self) -> bool: ...
    def GetQuality(self) -> int: ...
    def GetRepeat(self) -> int: ...
    def GetRestrictPowerOf2ImageSmaller(self) -> int: ...
    def GetTextureUnit(self) -> int: ...
    def GetTransform(self) -> 'vtkTransform': ...
    def GetUseSRGBColorSpace(self) -> bool: ...
    def GetWrap(self) -> int: ...
    def GetWrapMaxValue(self) -> int: ...
    def GetWrapMinValue(self) -> int: ...
    def InterpolateOff(self) -> None: ...
    def InterpolateOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsTranslucent(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def Load(self, __a:'vtkRenderer') -> None: ...
    def MapScalarsToColors(self, scalars:'vtkDataArray') -> Pointer: ...
    def MipmapOff(self) -> None: ...
    def MipmapOn(self) -> None: ...
    def NewInstance(self) -> 'vtkTexture': ...
    def PostRender(self, __a:'vtkRenderer') -> None: ...
    def PremultipliedAlphaOff(self) -> None: ...
    def PremultipliedAlphaOn(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    def RepeatOff(self) -> None: ...
    def RepeatOn(self) -> None: ...
    def RestrictPowerOf2ImageSmallerOff(self) -> None: ...
    def RestrictPowerOf2ImageSmallerOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTexture': ...
    def SetBlendingMode(self, _arg:int) -> None: ...
    @overload
    def SetBorderColor(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetBorderColor(self, _arg:Sequence[float]) -> None: ...
    def SetColorMode(self, _arg:int) -> None: ...
    def SetColorModeToDefault(self) -> None: ...
    def SetColorModeToDirectScalars(self) -> None: ...
    def SetColorModeToMapScalars(self) -> None: ...
    def SetCubeMap(self, val:bool) -> None: ...
    def SetEdgeClamp(self, __a:int) -> None: ...
    def SetInterpolate(self, _arg:int) -> None: ...
    def SetLookupTable(self, __a:'vtkScalarsToColors') -> None: ...
    def SetMaximumAnisotropicFiltering(self, _arg:float) -> None: ...
    def SetMipmap(self, _arg:bool) -> None: ...
    def SetPremultipliedAlpha(self, _arg:bool) -> None: ...
    def SetQuality(self, _arg:int) -> None: ...
    def SetQualityTo16Bit(self) -> None: ...
    def SetQualityTo32Bit(self) -> None: ...
    def SetQualityToDefault(self) -> None: ...
    def SetRepeat(self, r:int) -> None: ...
    def SetRestrictPowerOf2ImageSmaller(self, _arg:int) -> None: ...
    def SetTransform(self, transform:'vtkTransform') -> None: ...
    def SetUseSRGBColorSpace(self, _arg:bool) -> None: ...
    def SetWrap(self, _arg:int) -> None: ...
    def UseSRGBColorSpaceOff(self) -> None: ...
    def UseSRGBColorSpaceOn(self) -> None: ...

class vtkTransformCoordinateSystems(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    input_coordinate_system:'getset_descriptor'
    m_time:'getset_descriptor'
    output_coordinate_system:'getset_descriptor'
    viewport:'getset_descriptor'
    def GetInputCoordinateSystem(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputCoordinateSystem(self) -> int: ...
    def GetViewport(self) -> 'vtkViewport': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransformCoordinateSystems': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransformCoordinateSystems': ...
    def SetInputCoordinateSystem(self, _arg:int) -> None: ...
    def SetInputCoordinateSystemToDisplay(self) -> None: ...
    def SetInputCoordinateSystemToViewport(self) -> None: ...
    def SetInputCoordinateSystemToWorld(self) -> None: ...
    def SetOutputCoordinateSystem(self, _arg:int) -> None: ...
    def SetOutputCoordinateSystemToDisplay(self) -> None: ...
    def SetOutputCoordinateSystemToViewport(self) -> None: ...
    def SetOutputCoordinateSystemToWorld(self) -> None: ...
    def SetViewport(self, viewport:'vtkViewport') -> None: ...

class vtkTransformInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    INTERPOLATION_TYPE_LINEAR:int
    INTERPOLATION_TYPE_MANUAL:int
    INTERPOLATION_TYPE_SPLINE:int
    interpolation_type:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_t:'getset_descriptor'
    minimum_t:'getset_descriptor'
    number_of_transforms:'getset_descriptor'
    position_interpolator:'getset_descriptor'
    rotation_interpolator:'getset_descriptor'
    scale_interpolator:'getset_descriptor'
    @overload
    def AddTransform(self, t:float, xform:'vtkTransform') -> None: ...
    @overload
    def AddTransform(self, t:float, matrix:'vtkMatrix4x4') -> None: ...
    @overload
    def AddTransform(self, t:float, prop3D:'vtkProp3D') -> None: ...
    def GetInterpolationType(self) -> int: ...
    def GetInterpolationTypeMaxValue(self) -> int: ...
    def GetInterpolationTypeMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMaximumT(self) -> float: ...
    def GetMinimumT(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTransforms(self) -> int: ...
    def GetPositionInterpolator(self) -> 'vtkTupleInterpolator': ...
    def GetRotationInterpolator(self) -> 'vtkQuaternionInterpolator': ...
    def GetScaleInterpolator(self) -> 'vtkTupleInterpolator': ...
    def Initialize(self) -> None: ...
    def InterpolateTransform(self, t:float, xform:'vtkTransform') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTransformInterpolator': ...
    def RemoveTransform(self, t:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTransformInterpolator': ...
    def SetInterpolationType(self, _arg:int) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToManual(self) -> None: ...
    def SetInterpolationTypeToSpline(self) -> None: ...
    def SetPositionInterpolator(self, __a:'vtkTupleInterpolator') -> None: ...
    def SetRotationInterpolator(self, __a:'vtkQuaternionInterpolator') -> None: ...
    def SetScaleInterpolator(self, __a:'vtkTupleInterpolator') -> None: ...

class vtkTupleInterpolator(vtkmodules.vtkCommonCore.vtkObject):
    INTERPOLATION_TYPE_LINEAR:int
    INTERPOLATION_TYPE_SPLINE:int
    interpolating_spline:'getset_descriptor'
    interpolation_type:'getset_descriptor'
    maximum_t:'getset_descriptor'
    minimum_t:'getset_descriptor'
    number_of_components:'getset_descriptor'
    number_of_tuples:'getset_descriptor'
    def AddTuple(self, t:float, tuple:MutableSequence[float]) -> None: ...
    def GetInterpolatingSpline(self) -> 'vtkSpline': ...
    def GetInterpolationType(self) -> int: ...
    def GetMaximumT(self) -> float: ...
    def GetMinimumT(self) -> float: ...
    def GetNumberOfComponents(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTuples(self) -> int: ...
    def Initialize(self) -> None: ...
    def InterpolateTuple(self, t:float, tuple:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTupleInterpolator': ...
    def RemoveTuple(self, t:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTupleInterpolator': ...
    def SetInterpolatingSpline(self, __a:'vtkSpline') -> None: ...
    def SetInterpolationType(self, type:int) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToSpline(self) -> None: ...
    def SetNumberOfComponents(self, numComp:int) -> None: ...

class vtkUniforms(vtkmodules.vtkCommonCore.vtkObject):
    class TupleType(int): ...
    NumberOfTupleTypes:'TupleType'
    TupleTypeInvalid:'TupleType'
    TupleTypeMatrix:'TupleType'
    TupleTypeScalar:'TupleType'
    TupleTypeVector:'TupleType'
    number_of_uniforms:'getset_descriptor'
    uniform_list_m_time:'getset_descriptor'
    def GetNthUniformName(self, uniformIndex:int) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfUniforms(self) -> int: ...
    @overload
    def GetUniform(self, name:str, value:MutableSequence[int]) -> bool: ...
    @overload
    def GetUniform(self, name:str, value:MutableSequence[float]) -> bool: ...
    def GetUniform1fv(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniform1iv(self, name:str, f:MutableSequence[int]) -> bool: ...
    def GetUniform2f(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniform2fv(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniform2i(self, name:str, v:MutableSequence[int]) -> bool: ...
    def GetUniform3f(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniform3fv(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniform3uc(self, name:str, v:MutableSequence[int]) -> bool: ...
    def GetUniform4f(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniform4fv(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniform4uc(self, name:str, v:MutableSequence[int]) -> bool: ...
    def GetUniformListMTime(self) -> int: ...
    @overload
    def GetUniformMatrix(self, name:str, v:'vtkMatrix3x3') -> bool: ...
    @overload
    def GetUniformMatrix(self, name:str, v:'vtkMatrix4x4') -> bool: ...
    def GetUniformMatrix3x3(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniformMatrix4x4(self, name:str, v:MutableSequence[float]) -> bool: ...
    def GetUniformMatrix4x4v(self, name:str, f:MutableSequence[float]) -> bool: ...
    def GetUniformNumberOfComponents(self, name:str) -> int: ...
    def GetUniformNumberOfTuples(self, name:str) -> int: ...
    def GetUniformScalarType(self, name:str) -> int: ...
    def GetUniformTupleType(self, name:str) -> 'TupleType': ...
    def GetUniformf(self, name:str, v:float) -> bool: ...
    def GetUniformi(self, name:str, v:int) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkUniforms': ...
    def RemoveAllUniforms(self) -> None: ...
    def RemoveUniform(self, name:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkUniforms': ...
    @staticmethod
    def ScalarTypeToString(scalarType:int) -> str: ...
    @overload
    def SetUniform(self, name:str, tt:vtkUniforms.TupleType, nbComponents:int, value:Sequence[int]) -> None: ...
    @overload
    def SetUniform(self, name:str, tt:vtkUniforms.TupleType, nbComponents:int, value:Sequence[float]) -> None: ...
    def SetUniform1fv(self, name:str, count:int, f:Sequence[float]) -> None: ...
    def SetUniform1iv(self, name:str, count:int, f:Sequence[int]) -> None: ...
    def SetUniform2f(self, name:str, v:Sequence[float]) -> None: ...
    def SetUniform2i(self, name:str, v:Sequence[int]) -> None: ...
    def SetUniform3f(self, name:str, v:Sequence[float]) -> None: ...
    def SetUniform3uc(self, name:str, v:Sequence[int]) -> None: ...
    def SetUniform4f(self, name:str, v:Sequence[float]) -> None: ...
    def SetUniform4uc(self, name:str, v:Sequence[int]) -> None: ...
    @overload
    def SetUniformMatrix(self, name:str, v:'vtkMatrix3x3') -> None: ...
    @overload
    def SetUniformMatrix(self, name:str, v:'vtkMatrix4x4') -> None: ...
    def SetUniformMatrix3x3(self, name:str, v:MutableSequence[float]) -> None: ...
    def SetUniformMatrix4x4(self, name:str, v:MutableSequence[float]) -> None: ...
    def SetUniformMatrix4x4v(self, name:str, count:int, v:MutableSequence[float]) -> None: ...
    def SetUniformf(self, name:str, v:float) -> None: ...
    def SetUniformi(self, name:str, v:int) -> None: ...
    @staticmethod
    def StringToScalarType(s:str) -> int: ...
    @staticmethod
    def StringToTupleType(s:str) -> 'TupleType': ...
    @staticmethod
    def TupleTypeToString(tt:'TupleType') -> str: ...

class vtkViewDependentErrorMetric(vtkmodules.vtkCommonDataModel.vtkGenericSubdivisionErrorMetric):
    pixel_tolerance:'getset_descriptor'
    viewport:'getset_descriptor'
    def GetError(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPixelTolerance(self) -> float: ...
    def GetViewport(self) -> 'vtkViewport': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkViewDependentErrorMetric': ...
    def RequiresEdgeSubdivision(self, leftPoint:MutableSequence[float], midPoint:MutableSequence[float], rightPoint:MutableSequence[float], alpha:float) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkViewDependentErrorMetric': ...
    def SetPixelTolerance(self, value:float) -> None: ...
    def SetViewport(self, viewport:'vtkViewport') -> None: ...

class vtkVolume(vtkProp3D):
    array_size:'getset_descriptor'
    bounds:'getset_descriptor'
    corrected_scalar_opacity_array:'getset_descriptor'
    gradient_opacity_array:'getset_descriptor'
    gradient_opacity_constant:'getset_descriptor'
    gray_array:'getset_descriptor'
    m_time:'getset_descriptor'
    mapper:'getset_descriptor'
    max_x_bound:'getset_descriptor'
    max_y_bound:'getset_descriptor'
    max_z_bound:'getset_descriptor'
    min_x_bound:'getset_descriptor'
    min_y_bound:'getset_descriptor'
    min_z_bound:'getset_descriptor'
    property:'getset_descriptor'
    redraw_m_time:'getset_descriptor'
    rgb_array:'getset_descriptor'
    scalar_opacity_array:'getset_descriptor'
    supports_selection:'getset_descriptor'
    def GetArraySize(self) -> float: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetCorrectedScalarOpacityArray(self, __a:int) -> Pointer: ...
    @overload
    def GetCorrectedScalarOpacityArray(self) -> Pointer: ...
    @overload
    def GetGradientOpacityArray(self, __a:int) -> Pointer: ...
    @overload
    def GetGradientOpacityArray(self) -> Pointer: ...
    @overload
    def GetGradientOpacityConstant(self, __a:int) -> float: ...
    @overload
    def GetGradientOpacityConstant(self) -> float: ...
    @overload
    def GetGrayArray(self, __a:int) -> Pointer: ...
    @overload
    def GetGrayArray(self) -> Pointer: ...
    def GetMTime(self) -> int: ...
    def GetMapper(self) -> 'vtkAbstractVolumeMapper': ...
    def GetMaxXBound(self) -> float: ...
    def GetMaxYBound(self) -> float: ...
    def GetMaxZBound(self) -> float: ...
    def GetMinXBound(self) -> float: ...
    def GetMinYBound(self) -> float: ...
    def GetMinZBound(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetProperty(self) -> 'vtkVolumeProperty': ...
    @overload
    def GetRGBArray(self, __a:int) -> Pointer: ...
    @overload
    def GetRGBArray(self) -> Pointer: ...
    def GetRedrawMTime(self) -> int: ...
    @overload
    def GetScalarOpacityArray(self, __a:int) -> Pointer: ...
    @overload
    def GetScalarOpacityArray(self) -> Pointer: ...
    def GetSupportsSelection(self) -> bool: ...
    def GetVolumes(self, vc:'vtkPropCollection') -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolume': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderVolumetricGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolume': ...
    def SetMapper(self, mapper:'vtkAbstractVolumeMapper') -> None: ...
    def SetProperty(self, property:'vtkVolumeProperty') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def Update(self) -> None: ...
    def UpdateScalarOpacityforSampleSize(self, ren:'vtkRenderer', sample_distance:float) -> None: ...
    def UpdateTransferFunctions(self, ren:'vtkRenderer') -> None: ...

class vtkVolumeCollection(vtkPropCollection):
    next_item:'getset_descriptor'
    next_volume:'getset_descriptor'
    def AddItem(self, a:'vtkVolume') -> None: ...
    def GetNextItem(self) -> 'vtkVolume': ...
    def GetNextVolume(self) -> 'vtkVolume': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeCollection': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeCollection': ...

class vtkVolumeProperty(vtkmodules.vtkCommonCore.vtkObject):
    class TransferMode(int): ...
    TF_1D:'TransferMode'
    TF_2D:'TransferMode'
    ambient:'getset_descriptor'
    clipped_voxel_intensity:'getset_descriptor'
    color:'getset_descriptor'
    color_channels:'getset_descriptor'
    diffuse:'getset_descriptor'
    disable_gradient_opacity:'getset_descriptor'
    gradient_opacity:'getset_descriptor'
    gradient_opacity_m_time:'getset_descriptor'
    gray_transfer_function:'getset_descriptor'
    gray_transfer_function_m_time:'getset_descriptor'
    independent_components:'getset_descriptor'
    interpolation_type:'getset_descriptor'
    iso_surface_values:'getset_descriptor'
    label_color_m_time:'getset_descriptor'
    label_gradient_opacity_m_time:'getset_descriptor'
    label_scalar_opacity_m_time:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    rgb_transfer_function:'getset_descriptor'
    rgb_transfer_function_m_time:'getset_descriptor'
    scalar_opacity:'getset_descriptor'
    scalar_opacity_m_time:'getset_descriptor'
    scalar_opacity_unit_distance:'getset_descriptor'
    scattering_anisotropy:'getset_descriptor'
    shade:'getset_descriptor'
    slice_function:'getset_descriptor'
    specular:'getset_descriptor'
    specular_power:'getset_descriptor'
    stored_gradient_opacity:'getset_descriptor'
    transfer_function2d:'getset_descriptor'
    transfer_function_mode:'getset_descriptor'
    use_clipped_voxel_intensity:'getset_descriptor'
    def DeepCopy(self, p:'vtkVolumeProperty') -> None: ...
    @overload
    def DisableGradientOpacityOff(self, index:int) -> None: ...
    @overload
    def DisableGradientOpacityOff(self) -> None: ...
    @overload
    def DisableGradientOpacityOn(self, index:int) -> None: ...
    @overload
    def DisableGradientOpacityOn(self) -> None: ...
    @overload
    def GetAmbient(self, index:int) -> float: ...
    @overload
    def GetAmbient(self) -> float: ...
    def GetClippedVoxelIntensity(self) -> float: ...
    @overload
    def GetColorChannels(self, index:int) -> int: ...
    @overload
    def GetColorChannels(self) -> int: ...
    def GetComponentWeight(self, index:int) -> float: ...
    @overload
    def GetDiffuse(self, index:int) -> float: ...
    @overload
    def GetDiffuse(self) -> float: ...
    @overload
    def GetDisableGradientOpacity(self, index:int) -> int: ...
    @overload
    def GetDisableGradientOpacity(self) -> int: ...
    @overload
    def GetGradientOpacity(self, index:int) -> 'vtkPiecewiseFunction': ...
    @overload
    def GetGradientOpacity(self) -> 'vtkPiecewiseFunction': ...
    @overload
    def GetGradientOpacityMTime(self, index:int) -> 'vtkTimeStamp': ...
    @overload
    def GetGradientOpacityMTime(self) -> 'vtkTimeStamp': ...
    @overload
    def GetGrayTransferFunction(self, index:int) -> 'vtkPiecewiseFunction': ...
    @overload
    def GetGrayTransferFunction(self) -> 'vtkPiecewiseFunction': ...
    @overload
    def GetGrayTransferFunctionMTime(self, index:int) -> 'vtkTimeStamp': ...
    @overload
    def GetGrayTransferFunctionMTime(self) -> 'vtkTimeStamp': ...
    def GetIndependentComponents(self) -> int: ...
    def GetIndependentComponentsMaxValue(self) -> int: ...
    def GetIndependentComponentsMinValue(self) -> int: ...
    def GetInterpolationType(self) -> int: ...
    def GetInterpolationTypeAsString(self) -> str: ...
    def GetInterpolationTypeMaxValue(self) -> int: ...
    def GetInterpolationTypeMinValue(self) -> int: ...
    def GetIsoSurfaceValues(self) -> 'vtkContourValues': ...
    def GetLabelColor(self, label:int) -> 'vtkColorTransferFunction': ...
    def GetLabelColorMTime(self) -> 'vtkTimeStamp': ...
    def GetLabelGradientOpacity(self, label:int) -> 'vtkPiecewiseFunction': ...
    def GetLabelGradientOpacityMTime(self) -> 'vtkTimeStamp': ...
    def GetLabelScalarOpacity(self, label:int) -> 'vtkPiecewiseFunction': ...
    def GetLabelScalarOpacityMTime(self) -> 'vtkTimeStamp': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    @overload
    def GetRGBTransferFunction(self, index:int) -> 'vtkColorTransferFunction': ...
    @overload
    def GetRGBTransferFunction(self) -> 'vtkColorTransferFunction': ...
    @overload
    def GetRGBTransferFunctionMTime(self, index:int) -> 'vtkTimeStamp': ...
    @overload
    def GetRGBTransferFunctionMTime(self) -> 'vtkTimeStamp': ...
    @overload
    def GetScalarOpacity(self, index:int) -> 'vtkPiecewiseFunction': ...
    @overload
    def GetScalarOpacity(self) -> 'vtkPiecewiseFunction': ...
    @overload
    def GetScalarOpacityMTime(self, index:int) -> 'vtkTimeStamp': ...
    @overload
    def GetScalarOpacityMTime(self) -> 'vtkTimeStamp': ...
    @overload
    def GetScalarOpacityUnitDistance(self, index:int) -> float: ...
    @overload
    def GetScalarOpacityUnitDistance(self) -> float: ...
    def GetScatteringAnisotropy(self) -> float: ...
    def GetScatteringAnisotropyMaxValue(self) -> float: ...
    def GetScatteringAnisotropyMinValue(self) -> float: ...
    @overload
    def GetShade(self, index:int) -> int: ...
    @overload
    def GetShade(self) -> int: ...
    def GetSliceFunction(self) -> 'vtkImplicitFunction': ...
    @overload
    def GetSpecular(self, index:int) -> float: ...
    @overload
    def GetSpecular(self) -> float: ...
    @overload
    def GetSpecularPower(self, index:int) -> float: ...
    @overload
    def GetSpecularPower(self) -> float: ...
    @overload
    def GetStoredGradientOpacity(self, index:int) -> 'vtkPiecewiseFunction': ...
    @overload
    def GetStoredGradientOpacity(self) -> 'vtkPiecewiseFunction': ...
    @overload
    def GetTransferFunction2D(self, index:int) -> 'vtkImageData': ...
    @overload
    def GetTransferFunction2D(self) -> 'vtkImageData': ...
    def GetTransferFunctionMode(self) -> int: ...
    def GetTransferFunctionModeMaxValue(self) -> int: ...
    def GetTransferFunctionModeMinValue(self) -> int: ...
    def GetUseClippedVoxelIntensity(self) -> int: ...
    def HasGradientOpacity(self, index:int=0) -> bool: ...
    def HasLabelGradientOpacity(self) -> bool: ...
    def IndependentComponentsOff(self) -> None: ...
    def IndependentComponentsOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeProperty': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeProperty': ...
    @overload
    def SetAmbient(self, index:int, value:float) -> None: ...
    @overload
    def SetAmbient(self, value:float) -> None: ...
    def SetClippedVoxelIntensity(self, _arg:float) -> None: ...
    @overload
    def SetColor(self, index:int, function:'vtkPiecewiseFunction') -> None: ...
    @overload
    def SetColor(self, function:'vtkPiecewiseFunction') -> None: ...
    @overload
    def SetColor(self, index:int, function:'vtkColorTransferFunction') -> None: ...
    @overload
    def SetColor(self, function:'vtkColorTransferFunction') -> None: ...
    def SetComponentWeight(self, index:int, value:float) -> None: ...
    @overload
    def SetDiffuse(self, index:int, value:float) -> None: ...
    @overload
    def SetDiffuse(self, value:float) -> None: ...
    @overload
    def SetDisableGradientOpacity(self, index:int, value:int) -> None: ...
    @overload
    def SetDisableGradientOpacity(self, value:int) -> None: ...
    @overload
    def SetGradientOpacity(self, index:int, function:'vtkPiecewiseFunction') -> None: ...
    @overload
    def SetGradientOpacity(self, function:'vtkPiecewiseFunction') -> None: ...
    def SetIndependentComponents(self, _arg:int) -> None: ...
    def SetInterpolationType(self, _arg:int) -> None: ...
    def SetInterpolationTypeToLinear(self) -> None: ...
    def SetInterpolationTypeToNearest(self) -> None: ...
    def SetLabelColor(self, label:int, function:'vtkColorTransferFunction') -> None: ...
    def SetLabelGradientOpacity(self, label:int, function:'vtkPiecewiseFunction') -> None: ...
    def SetLabelScalarOpacity(self, label:int, function:'vtkPiecewiseFunction') -> None: ...
    @overload
    def SetScalarOpacity(self, index:int, function:'vtkPiecewiseFunction') -> None: ...
    @overload
    def SetScalarOpacity(self, function:'vtkPiecewiseFunction') -> None: ...
    @overload
    def SetScalarOpacityUnitDistance(self, index:int, distance:float) -> None: ...
    @overload
    def SetScalarOpacityUnitDistance(self, distance:float) -> None: ...
    def SetScatteringAnisotropy(self, _arg:float) -> None: ...
    @overload
    def SetShade(self, index:int, value:int) -> None: ...
    @overload
    def SetShade(self, value:int) -> None: ...
    def SetSliceFunction(self, _arg:'vtkImplicitFunction') -> None: ...
    @overload
    def SetSpecular(self, index:int, value:float) -> None: ...
    @overload
    def SetSpecular(self, value:float) -> None: ...
    @overload
    def SetSpecularPower(self, index:int, value:float) -> None: ...
    @overload
    def SetSpecularPower(self, value:float) -> None: ...
    @overload
    def SetTransferFunction2D(self, index:int, function:'vtkImageData') -> None: ...
    @overload
    def SetTransferFunction2D(self, function:'vtkImageData') -> None: ...
    def SetTransferFunctionMode(self, _arg:int) -> None: ...
    def SetTransferFunctionModeTo1D(self) -> None: ...
    def SetTransferFunctionModeTo2D(self) -> None: ...
    def SetUseClippedVoxelIntensity(self, _arg:int) -> None: ...
    @overload
    def ShadeOff(self, index:int) -> None: ...
    @overload
    def ShadeOff(self) -> None: ...
    @overload
    def ShadeOn(self, index:int) -> None: ...
    @overload
    def ShadeOn(self) -> None: ...
    def UpdateMTimes(self) -> None: ...
    def UseClippedVoxelIntensityOff(self) -> None: ...
    def UseClippedVoxelIntensityOn(self) -> None: ...

class vtkWindowLevelLookupTable(vtkmodules.vtkCommonCore.vtkLookupTable):
    inverse_video:'getset_descriptor'
    level:'getset_descriptor'
    maximum_table_value:'getset_descriptor'
    minimum_table_value:'getset_descriptor'
    window:'getset_descriptor'
    def ForceBuild(self) -> None: ...
    def GetInverseVideo(self) -> int: ...
    def GetLevel(self) -> float: ...
    def GetMaximumTableValue(self) -> Tuple[float, float, float, float]: ...
    def GetMinimumTableValue(self) -> Tuple[float, float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWindow(self) -> float: ...
    def InverseVideoOff(self) -> None: ...
    def InverseVideoOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWindowLevelLookupTable': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWindowLevelLookupTable': ...
    def SetInverseVideo(self, iv:int) -> None: ...
    def SetLevel(self, level:float) -> None: ...
    @overload
    def SetMaximumTableValue(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetMaximumTableValue(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetMinimumTableValue(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetMinimumTableValue(self, _arg:Sequence[float]) -> None: ...
    def SetWindow(self, window:float) -> None: ...

class vtkWindowToImageFilter(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    fix_boundary:'getset_descriptor'
    input:'getset_descriptor'
    input_buffer_type:'getset_descriptor'
    output:'getset_descriptor'
    read_front_buffer:'getset_descriptor'
    scale:'getset_descriptor'
    should_rerender:'getset_descriptor'
    viewport:'getset_descriptor'
    def FixBoundaryOff(self) -> None: ...
    def FixBoundaryOn(self) -> None: ...
    def GetFixBoundary(self) -> bool: ...
    def GetInput(self) -> 'vtkWindow': ...
    def GetInputBufferType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutput(self) -> 'vtkImageData': ...
    def GetReadFrontBuffer(self) -> int: ...
    def GetScale(self) -> Tuple[int, int]: ...
    def GetShouldRerender(self) -> int: ...
    def GetViewport(self) -> Tuple[float, float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWindowToImageFilter': ...
    def ReadFrontBufferOff(self) -> None: ...
    def ReadFrontBufferOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWindowToImageFilter': ...
    def SetFixBoundary(self, _arg:bool) -> None: ...
    def SetInput(self, input:'vtkWindow') -> None: ...
    def SetInputBufferType(self, _arg:int) -> None: ...
    def SetInputBufferTypeToRGB(self) -> None: ...
    def SetInputBufferTypeToRGBA(self) -> None: ...
    def SetInputBufferTypeToZBuffer(self) -> None: ...
    def SetReadFrontBuffer(self, _arg:int) -> None: ...
    @overload
    def SetScale(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetScale(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetScale(self, scale:int) -> None: ...
    def SetShouldRerender(self, _arg:int) -> None: ...
    @overload
    def SetViewport(self, __a:float, __b:float, __c:float, __d:float) -> None: ...
    @overload
    def SetViewport(self, __a:MutableSequence[float]) -> None: ...
    def ShouldRerenderOff(self) -> None: ...
    def ShouldRerenderOn(self) -> None: ...

class vtkWorldPointPicker(vtkAbstractPicker):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkWorldPointPicker': ...
    @overload
    def Pick(self, selectionX:float, selectionY:float, selectionZ:float, renderer:'vtkRenderer') -> int: ...
    @overload
    def Pick(self, selectionPt:MutableSequence[float], renderer:'vtkRenderer') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkWorldPointPicker': ...

