'''In this file the classs used for logging messages is defined
'''

import logging
from pathlib import Path

# create auxiliary variables
loggerName = Path(__file__).stem

# create logging formatter
logFormatter = logging.Formatter(fmt=' %(levelname)s :: %(message)s')

# create logger
logger = logging.getLogger(loggerName)
logger.setLevel(logging.INFO)

# create console handler
consoleHandler = logging.StreamHandler()
consoleHandler.setLevel(logging.INFO)
consoleHandler.setFormatter(logFormatter)

# Add console handler to logger
logger.addHandler(consoleHandler)
