# Optimality Module 

The **Optimality** module is an integral component of the **abopt** framework and is used by both the *evol* and *local* submodules. It provides a suite of tools for post-optimization analysis, including feasibility assessments, sensitivity analysis, and diagnostic plotting. The module is designed to help users evaluate the quality of the optimization results and ensure that the solutions meet the necessary constraints.

---

## Features

- **LaTeX Table Generation:**  
  Automatically creates LaTeX-formatted tables summarizing key optimization metrics (e.g., residuals, sensitivity).  
  *Function:* `generate_latex_table(summary_dict, table_caption, table)`

- **Feasibility Reporting:**  
  Logs detailed information on the primal feasibility of the optimization results, including constraint violation details for both α (alpha) and β (beta) parameters.  
  *Functions:* `print_primal_feasibility_results(primal_summary, alpha_violations, beta_violations, logger_obj)` and `print_sensitivity_and_active_constraints(sensitivity_summary, active_constraints_summary, logger_obj)`

- **Diagnostic Plotting:**  
  Generates plots that visually represent constraint violations and sensitivity analysis across proteins:
  - **Constraint Violations:** Bar plots that display the total violations per protein, with prominent highlighting of the worst offenders.  
    *Function:* `plot_constraint_violations(alpha_violations, beta_violations, out_dir)`
  - **Sensitivity Analysis:** Horizontal bar plots showing the sensitivity statistics (minimum, mean, maximum) for each protein.  
    *Function:* `plot_sensitivity_analysis(sensitivity_analysis, out_dir)`

- **Data Processing:**  
  Processes Excel files with optimization results (e.g., alpha and beta values, estimated and observed data) to validate normalization constraints, compute residuals, and calculate gradients.  
  *Function:* `process_excel_results(file_path)`

- **Comprehensive Post-Processing:**  
  Orchestrates the full analysis workflow, including LaTeX table generation, plotting, and logging of feasibility and sensitivity summaries.  
  *Function:* `post_optimization_results()`

---

## How It Works

1. **Data Ingestion:**  
   The module loads optimization results from an Excel file (typically generated by the *evol* or *local* modules). It extracts sheets for alpha values, beta values, observed data, and estimated data.

2. **Validation & Metrics:**  
   It validates normalization constraints by ensuring that the sum of α values for each gene–psite and the sum of β values for each kinase equal 1. It then computes residuals between the observed and estimated data along with the corresponding gradients.

3. **Sensitivity Analysis:**  
   The module calculates sensitivity metrics (min, max, and mean) for each protein and identifies proteins with high sensitivity levels.

4. **Reporting & Plotting:**  
   - **LaTeX Reports:** Generates tables summarizing residuals and sensitivity metrics for inclusion in technical reports.
   - **Plots:** Creates figures for constraint violations and sensitivity analysis, saving them to the output directory.
   - **Logging:** Uses a custom logging configuration to output summaries and detailed reports to both the console and log files.

5. **Integration:**  
   The `post_optimization_results()` function is typically called at the end of an optimization run within the *evol* or *local* modules, ensuring that the post-optimization analysis is automatically executed.

---

## Dependencies

- **Python Packages:**  
  - numpy
  - pandas
  - matplotlib
  - pathlib
- **Logging:**  
  Utilizes the logging configuration provided by the framework (configured via `logconf.py` in *evol* or *local*).

---

## Usage

The Optimality module is automatically integrated within the *abopt* framework. After an optimization run, the module’s main function, `post_optimization_results()`, is invoked to:
- Process the Excel results.
- Generate diagnostic LaTeX tables and plots.
- Log comprehensive feasibility and sensitivity summaries.

For standalone usage or custom analysis, import the module and call the relevant functions directly. For example:

```python
from kinopt.optimality.KKT import post_optimization_results

results = post_optimization_results()
```

---

## Directory Structure (within abopt)

```
abopt/
└── optimality/
    └── KKT.py             # Contains all functions for optimality analysis (LaTeX generation, plotting, logging, etc.). citeturn2file0
```

---