# coding: utf-8

"""
    Gate API v4

    APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.  # noqa: E501

    Contact: support@mail.gate.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class BatchOrder(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'text': 'str',
        'succeeded': 'bool',
        'label': 'str',
        'message': 'str',
        'id': 'str',
        'create_time': 'str',
        'update_time': 'str',
        'status': 'str',
        'currency_pair': 'str',
        'type': 'str',
        'account': 'str',
        'side': 'str',
        'amount': 'str',
        'price': 'str',
        'time_in_force': 'str',
        'auto_borrow': 'bool',
        'left': 'str',
        'fill_price': 'str',
        'filled_total': 'str',
        'fee': 'str',
        'fee_currency': 'str',
        'point_fee': 'str',
        'gt_fee': 'str',
        'gt_discount': 'bool',
        'rebated_fee': 'str',
        'rebated_fee_currency': 'str',
    }

    attribute_map = {
        'text': 'text',
        'succeeded': 'succeeded',
        'label': 'label',
        'message': 'message',
        'id': 'id',
        'create_time': 'create_time',
        'update_time': 'update_time',
        'status': 'status',
        'currency_pair': 'currency_pair',
        'type': 'type',
        'account': 'account',
        'side': 'side',
        'amount': 'amount',
        'price': 'price',
        'time_in_force': 'time_in_force',
        'auto_borrow': 'auto_borrow',
        'left': 'left',
        'fill_price': 'fill_price',
        'filled_total': 'filled_total',
        'fee': 'fee',
        'fee_currency': 'fee_currency',
        'point_fee': 'point_fee',
        'gt_fee': 'gt_fee',
        'gt_discount': 'gt_discount',
        'rebated_fee': 'rebated_fee',
        'rebated_fee_currency': 'rebated_fee_currency',
    }

    def __init__(
        self,
        text=None,
        succeeded=None,
        label=None,
        message=None,
        id=None,
        create_time=None,
        update_time=None,
        status=None,
        currency_pair=None,
        type='limit',
        account='spot',
        side=None,
        amount=None,
        price=None,
        time_in_force='gtc',
        auto_borrow=None,
        left=None,
        fill_price=None,
        filled_total=None,
        fee=None,
        fee_currency=None,
        point_fee=None,
        gt_fee=None,
        gt_discount=None,
        rebated_fee=None,
        rebated_fee_currency=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        # type: (str, bool, str, str, str, str, str, str, str, str, str, str, str, str, str, bool, str, str, str, str, str, str, str, bool, str, str, Configuration) -> None
        """BatchOrder - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._text = None
        self._succeeded = None
        self._label = None
        self._message = None
        self._id = None
        self._create_time = None
        self._update_time = None
        self._status = None
        self._currency_pair = None
        self._type = None
        self._account = None
        self._side = None
        self._amount = None
        self._price = None
        self._time_in_force = None
        self._auto_borrow = None
        self._left = None
        self._fill_price = None
        self._filled_total = None
        self._fee = None
        self._fee_currency = None
        self._point_fee = None
        self._gt_fee = None
        self._gt_discount = None
        self._rebated_fee = None
        self._rebated_fee_currency = None
        self.discriminator = None

        if text is not None:
            self.text = text
        if succeeded is not None:
            self.succeeded = succeeded
        if label is not None:
            self.label = label
        if message is not None:
            self.message = message
        if id is not None:
            self.id = id
        if create_time is not None:
            self.create_time = create_time
        if update_time is not None:
            self.update_time = update_time
        if status is not None:
            self.status = status
        if currency_pair is not None:
            self.currency_pair = currency_pair
        if type is not None:
            self.type = type
        if account is not None:
            self.account = account
        if side is not None:
            self.side = side
        if amount is not None:
            self.amount = amount
        if price is not None:
            self.price = price
        if time_in_force is not None:
            self.time_in_force = time_in_force
        if auto_borrow is not None:
            self.auto_borrow = auto_borrow
        if left is not None:
            self.left = left
        if fill_price is not None:
            self.fill_price = fill_price
        if filled_total is not None:
            self.filled_total = filled_total
        if fee is not None:
            self.fee = fee
        if fee_currency is not None:
            self.fee_currency = fee_currency
        if point_fee is not None:
            self.point_fee = point_fee
        if gt_fee is not None:
            self.gt_fee = gt_fee
        if gt_discount is not None:
            self.gt_discount = gt_discount
        if rebated_fee is not None:
            self.rebated_fee = rebated_fee
        if rebated_fee_currency is not None:
            self.rebated_fee_currency = rebated_fee_currency

    @property
    def text(self):
        """Gets the text of this BatchOrder.  # noqa: E501

        User defined information. If not empty, must follow the rules below:  1. prefixed with `t-` 2. no longer than 28 bytes without `t-` prefix 3. can only include 0-9, A-Z, a-z, underscore(_), hyphen(-) or dot(.)   # noqa: E501

        :return: The text of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this BatchOrder.

        User defined information. If not empty, must follow the rules below:  1. prefixed with `t-` 2. no longer than 28 bytes without `t-` prefix 3. can only include 0-9, A-Z, a-z, underscore(_), hyphen(-) or dot(.)   # noqa: E501

        :param text: The text of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def succeeded(self):
        """Gets the succeeded of this BatchOrder.  # noqa: E501

        Whether order succeeds  # noqa: E501

        :return: The succeeded of this BatchOrder.  # noqa: E501
        :rtype: bool
        """
        return self._succeeded

    @succeeded.setter
    def succeeded(self, succeeded):
        """Sets the succeeded of this BatchOrder.

        Whether order succeeds  # noqa: E501

        :param succeeded: The succeeded of this BatchOrder.  # noqa: E501
        :type: bool
        """

        self._succeeded = succeeded

    @property
    def label(self):
        """Gets the label of this BatchOrder.  # noqa: E501

        Error label, empty string if order succeeds  # noqa: E501

        :return: The label of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """Sets the label of this BatchOrder.

        Error label, empty string if order succeeds  # noqa: E501

        :param label: The label of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._label = label

    @property
    def message(self):
        """Gets the message of this BatchOrder.  # noqa: E501

        Detailed error message, empty string if order succeeds  # noqa: E501

        :return: The message of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this BatchOrder.

        Detailed error message, empty string if order succeeds  # noqa: E501

        :param message: The message of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def id(self):
        """Gets the id of this BatchOrder.  # noqa: E501

        Order ID  # noqa: E501

        :return: The id of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BatchOrder.

        Order ID  # noqa: E501

        :param id: The id of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def create_time(self):
        """Gets the create_time of this BatchOrder.  # noqa: E501

        Order creation time  # noqa: E501

        :return: The create_time of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this BatchOrder.

        Order creation time  # noqa: E501

        :param create_time: The create_time of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._create_time = create_time

    @property
    def update_time(self):
        """Gets the update_time of this BatchOrder.  # noqa: E501

        Order last modification time  # noqa: E501

        :return: The update_time of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._update_time

    @update_time.setter
    def update_time(self, update_time):
        """Sets the update_time of this BatchOrder.

        Order last modification time  # noqa: E501

        :param update_time: The update_time of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._update_time = update_time

    @property
    def status(self):
        """Gets the status of this BatchOrder.  # noqa: E501

        Order status  - `open`: to be filled - `closed`: filled - `cancelled`: cancelled  # noqa: E501

        :return: The status of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this BatchOrder.

        Order status  - `open`: to be filled - `closed`: filled - `cancelled`: cancelled  # noqa: E501

        :param status: The status of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["open", "closed", "cancelled"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}".format(status, allowed_values)  # noqa: E501
            )

        self._status = status

    @property
    def currency_pair(self):
        """Gets the currency_pair of this BatchOrder.  # noqa: E501

        Currency pair  # noqa: E501

        :return: The currency_pair of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._currency_pair

    @currency_pair.setter
    def currency_pair(self, currency_pair):
        """Sets the currency_pair of this BatchOrder.

        Currency pair  # noqa: E501

        :param currency_pair: The currency_pair of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._currency_pair = currency_pair

    @property
    def type(self):
        """Gets the type of this BatchOrder.  # noqa: E501

        Order type. limit - limit order  # noqa: E501

        :return: The type of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BatchOrder.

        Order type. limit - limit order  # noqa: E501

        :param type: The type of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["limit"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}".format(type, allowed_values)  # noqa: E501
            )

        self._type = type

    @property
    def account(self):
        """Gets the account of this BatchOrder.  # noqa: E501

        Account type. spot - use spot account; margin - use margin account  # noqa: E501

        :return: The account of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this BatchOrder.

        Account type. spot - use spot account; margin - use margin account  # noqa: E501

        :param account: The account of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["spot", "margin"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and account not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `account` ({0}), must be one of {1}".format(account, allowed_values)  # noqa: E501
            )

        self._account = account

    @property
    def side(self):
        """Gets the side of this BatchOrder.  # noqa: E501

        Order side  # noqa: E501

        :return: The side of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._side

    @side.setter
    def side(self, side):
        """Sets the side of this BatchOrder.

        Order side  # noqa: E501

        :param side: The side of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["buy", "sell"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and side not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `side` ({0}), must be one of {1}".format(side, allowed_values)  # noqa: E501
            )

        self._side = side

    @property
    def amount(self):
        """Gets the amount of this BatchOrder.  # noqa: E501

        Trade amount  # noqa: E501

        :return: The amount of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this BatchOrder.

        Trade amount  # noqa: E501

        :param amount: The amount of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._amount = amount

    @property
    def price(self):
        """Gets the price of this BatchOrder.  # noqa: E501

        Order price  # noqa: E501

        :return: The price of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this BatchOrder.

        Order price  # noqa: E501

        :param price: The price of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._price = price

    @property
    def time_in_force(self):
        """Gets the time_in_force of this BatchOrder.  # noqa: E501

        Time in force  - gtc: GoodTillCancelled - ioc: ImmediateOrCancelled, taker only - poc: PendingOrCancelled, makes a post-only order that always enjoys a maker fee  # noqa: E501

        :return: The time_in_force of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._time_in_force

    @time_in_force.setter
    def time_in_force(self, time_in_force):
        """Sets the time_in_force of this BatchOrder.

        Time in force  - gtc: GoodTillCancelled - ioc: ImmediateOrCancelled, taker only - poc: PendingOrCancelled, makes a post-only order that always enjoys a maker fee  # noqa: E501

        :param time_in_force: The time_in_force of this BatchOrder.  # noqa: E501
        :type: str
        """
        allowed_values = ["gtc", "ioc", "poc"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and time_in_force not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `time_in_force` ({0}), must be one of {1}".format(  # noqa: E501
                    time_in_force, allowed_values
                )
            )

        self._time_in_force = time_in_force

    @property
    def auto_borrow(self):
        """Gets the auto_borrow of this BatchOrder.  # noqa: E501

        Used in margin trading(i.e. `account` is `margin`) to allow automatic loan of insufficient part if balance is not enough.  # noqa: E501

        :return: The auto_borrow of this BatchOrder.  # noqa: E501
        :rtype: bool
        """
        return self._auto_borrow

    @auto_borrow.setter
    def auto_borrow(self, auto_borrow):
        """Sets the auto_borrow of this BatchOrder.

        Used in margin trading(i.e. `account` is `margin`) to allow automatic loan of insufficient part if balance is not enough.  # noqa: E501

        :param auto_borrow: The auto_borrow of this BatchOrder.  # noqa: E501
        :type: bool
        """

        self._auto_borrow = auto_borrow

    @property
    def left(self):
        """Gets the left of this BatchOrder.  # noqa: E501

        Amount left to fill  # noqa: E501

        :return: The left of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._left

    @left.setter
    def left(self, left):
        """Sets the left of this BatchOrder.

        Amount left to fill  # noqa: E501

        :param left: The left of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._left = left

    @property
    def fill_price(self):
        """Gets the fill_price of this BatchOrder.  # noqa: E501

        Total filled in quote currency. Deprecated in favor of `filled_total`  # noqa: E501

        :return: The fill_price of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._fill_price

    @fill_price.setter
    def fill_price(self, fill_price):
        """Sets the fill_price of this BatchOrder.

        Total filled in quote currency. Deprecated in favor of `filled_total`  # noqa: E501

        :param fill_price: The fill_price of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._fill_price = fill_price

    @property
    def filled_total(self):
        """Gets the filled_total of this BatchOrder.  # noqa: E501

        Total filled in quote currency  # noqa: E501

        :return: The filled_total of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._filled_total

    @filled_total.setter
    def filled_total(self, filled_total):
        """Sets the filled_total of this BatchOrder.

        Total filled in quote currency  # noqa: E501

        :param filled_total: The filled_total of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._filled_total = filled_total

    @property
    def fee(self):
        """Gets the fee of this BatchOrder.  # noqa: E501

        Fee deducted  # noqa: E501

        :return: The fee of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._fee

    @fee.setter
    def fee(self, fee):
        """Sets the fee of this BatchOrder.

        Fee deducted  # noqa: E501

        :param fee: The fee of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._fee = fee

    @property
    def fee_currency(self):
        """Gets the fee_currency of this BatchOrder.  # noqa: E501

        Fee currency unit  # noqa: E501

        :return: The fee_currency of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._fee_currency

    @fee_currency.setter
    def fee_currency(self, fee_currency):
        """Sets the fee_currency of this BatchOrder.

        Fee currency unit  # noqa: E501

        :param fee_currency: The fee_currency of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._fee_currency = fee_currency

    @property
    def point_fee(self):
        """Gets the point_fee of this BatchOrder.  # noqa: E501

        Point used to deduct fee  # noqa: E501

        :return: The point_fee of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._point_fee

    @point_fee.setter
    def point_fee(self, point_fee):
        """Sets the point_fee of this BatchOrder.

        Point used to deduct fee  # noqa: E501

        :param point_fee: The point_fee of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._point_fee = point_fee

    @property
    def gt_fee(self):
        """Gets the gt_fee of this BatchOrder.  # noqa: E501

        GT used to deduct fee  # noqa: E501

        :return: The gt_fee of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._gt_fee

    @gt_fee.setter
    def gt_fee(self, gt_fee):
        """Sets the gt_fee of this BatchOrder.

        GT used to deduct fee  # noqa: E501

        :param gt_fee: The gt_fee of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._gt_fee = gt_fee

    @property
    def gt_discount(self):
        """Gets the gt_discount of this BatchOrder.  # noqa: E501

        Whether GT fee discount is used  # noqa: E501

        :return: The gt_discount of this BatchOrder.  # noqa: E501
        :rtype: bool
        """
        return self._gt_discount

    @gt_discount.setter
    def gt_discount(self, gt_discount):
        """Sets the gt_discount of this BatchOrder.

        Whether GT fee discount is used  # noqa: E501

        :param gt_discount: The gt_discount of this BatchOrder.  # noqa: E501
        :type: bool
        """

        self._gt_discount = gt_discount

    @property
    def rebated_fee(self):
        """Gets the rebated_fee of this BatchOrder.  # noqa: E501

        Rebated fee  # noqa: E501

        :return: The rebated_fee of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._rebated_fee

    @rebated_fee.setter
    def rebated_fee(self, rebated_fee):
        """Sets the rebated_fee of this BatchOrder.

        Rebated fee  # noqa: E501

        :param rebated_fee: The rebated_fee of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._rebated_fee = rebated_fee

    @property
    def rebated_fee_currency(self):
        """Gets the rebated_fee_currency of this BatchOrder.  # noqa: E501

        Rebated fee currency unit  # noqa: E501

        :return: The rebated_fee_currency of this BatchOrder.  # noqa: E501
        :rtype: str
        """
        return self._rebated_fee_currency

    @rebated_fee_currency.setter
    def rebated_fee_currency(self, rebated_fee_currency):
        """Sets the rebated_fee_currency of this BatchOrder.

        Rebated fee currency unit  # noqa: E501

        :param rebated_fee_currency: The rebated_fee_currency of this BatchOrder.  # noqa: E501
        :type: str
        """

        self._rebated_fee_currency = rebated_fee_currency

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BatchOrder):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BatchOrder):
            return True

        return self.to_dict() != other.to_dict()
