# coding: utf-8

"""
    Gate API v4

    APIv4 provides spot, margin and futures trading operations. There are public APIs to retrieve the real-time market statistics, and private APIs which needs authentication to trade on user's behalf.  # noqa: E501

    Contact: support@mail.gate.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from gate_api.configuration import Configuration


class LoanRecord(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'loan_id': 'str',
        'create_time': 'str',
        'expire_time': 'str',
        'status': 'str',
        'borrow_user_id': 'str',
        'currency': 'str',
        'rate': 'str',
        'amount': 'str',
        'days': 'int',
        'auto_renew': 'bool',
        'repaid': 'str',
        'paid_interest': 'str',
        'unpaid_interest': 'str',
    }

    attribute_map = {
        'id': 'id',
        'loan_id': 'loan_id',
        'create_time': 'create_time',
        'expire_time': 'expire_time',
        'status': 'status',
        'borrow_user_id': 'borrow_user_id',
        'currency': 'currency',
        'rate': 'rate',
        'amount': 'amount',
        'days': 'days',
        'auto_renew': 'auto_renew',
        'repaid': 'repaid',
        'paid_interest': 'paid_interest',
        'unpaid_interest': 'unpaid_interest',
    }

    def __init__(
        self,
        id=None,
        loan_id=None,
        create_time=None,
        expire_time=None,
        status=None,
        borrow_user_id=None,
        currency=None,
        rate=None,
        amount=None,
        days=None,
        auto_renew=False,
        repaid=None,
        paid_interest=None,
        unpaid_interest=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        # type: (str, str, str, str, str, str, str, str, str, int, bool, str, str, str, Configuration) -> None
        """LoanRecord - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._loan_id = None
        self._create_time = None
        self._expire_time = None
        self._status = None
        self._borrow_user_id = None
        self._currency = None
        self._rate = None
        self._amount = None
        self._days = None
        self._auto_renew = None
        self._repaid = None
        self._paid_interest = None
        self._unpaid_interest = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if loan_id is not None:
            self.loan_id = loan_id
        if create_time is not None:
            self.create_time = create_time
        if expire_time is not None:
            self.expire_time = expire_time
        if status is not None:
            self.status = status
        if borrow_user_id is not None:
            self.borrow_user_id = borrow_user_id
        if currency is not None:
            self.currency = currency
        if rate is not None:
            self.rate = rate
        if amount is not None:
            self.amount = amount
        if days is not None:
            self.days = days
        if auto_renew is not None:
            self.auto_renew = auto_renew
        if repaid is not None:
            self.repaid = repaid
        if paid_interest is not None:
            self.paid_interest = paid_interest
        if unpaid_interest is not None:
            self.unpaid_interest = unpaid_interest

    @property
    def id(self):
        """Gets the id of this LoanRecord.  # noqa: E501

        Loan record ID  # noqa: E501

        :return: The id of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LoanRecord.

        Loan record ID  # noqa: E501

        :param id: The id of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def loan_id(self):
        """Gets the loan_id of this LoanRecord.  # noqa: E501

        Loan ID the record belongs to  # noqa: E501

        :return: The loan_id of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._loan_id

    @loan_id.setter
    def loan_id(self, loan_id):
        """Sets the loan_id of this LoanRecord.

        Loan ID the record belongs to  # noqa: E501

        :param loan_id: The loan_id of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._loan_id = loan_id

    @property
    def create_time(self):
        """Gets the create_time of this LoanRecord.  # noqa: E501

        Loan time  # noqa: E501

        :return: The create_time of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._create_time

    @create_time.setter
    def create_time(self, create_time):
        """Sets the create_time of this LoanRecord.

        Loan time  # noqa: E501

        :param create_time: The create_time of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._create_time = create_time

    @property
    def expire_time(self):
        """Gets the expire_time of this LoanRecord.  # noqa: E501

        Expiration time  # noqa: E501

        :return: The expire_time of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._expire_time

    @expire_time.setter
    def expire_time(self, expire_time):
        """Sets the expire_time of this LoanRecord.

        Expiration time  # noqa: E501

        :param expire_time: The expire_time of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._expire_time = expire_time

    @property
    def status(self):
        """Gets the status of this LoanRecord.  # noqa: E501

        Loan record status  # noqa: E501

        :return: The status of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this LoanRecord.

        Loan record status  # noqa: E501

        :param status: The status of this LoanRecord.  # noqa: E501
        :type: str
        """
        allowed_values = ["loaned", "finished"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}".format(status, allowed_values)  # noqa: E501
            )

        self._status = status

    @property
    def borrow_user_id(self):
        """Gets the borrow_user_id of this LoanRecord.  # noqa: E501

        Garbled user ID  # noqa: E501

        :return: The borrow_user_id of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._borrow_user_id

    @borrow_user_id.setter
    def borrow_user_id(self, borrow_user_id):
        """Sets the borrow_user_id of this LoanRecord.

        Garbled user ID  # noqa: E501

        :param borrow_user_id: The borrow_user_id of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._borrow_user_id = borrow_user_id

    @property
    def currency(self):
        """Gets the currency of this LoanRecord.  # noqa: E501

        Loan currency  # noqa: E501

        :return: The currency of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this LoanRecord.

        Loan currency  # noqa: E501

        :param currency: The currency of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._currency = currency

    @property
    def rate(self):
        """Gets the rate of this LoanRecord.  # noqa: E501

        Loan rate  # noqa: E501

        :return: The rate of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._rate

    @rate.setter
    def rate(self, rate):
        """Sets the rate of this LoanRecord.

        Loan rate  # noqa: E501

        :param rate: The rate of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._rate = rate

    @property
    def amount(self):
        """Gets the amount of this LoanRecord.  # noqa: E501

        Loan amount  # noqa: E501

        :return: The amount of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this LoanRecord.

        Loan amount  # noqa: E501

        :param amount: The amount of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._amount = amount

    @property
    def days(self):
        """Gets the days of this LoanRecord.  # noqa: E501

        Loan days  # noqa: E501

        :return: The days of this LoanRecord.  # noqa: E501
        :rtype: int
        """
        return self._days

    @days.setter
    def days(self, days):
        """Sets the days of this LoanRecord.

        Loan days  # noqa: E501

        :param days: The days of this LoanRecord.  # noqa: E501
        :type: int
        """

        self._days = days

    @property
    def auto_renew(self):
        """Gets the auto_renew of this LoanRecord.  # noqa: E501

        Whether the record will auto renew on expiration  # noqa: E501

        :return: The auto_renew of this LoanRecord.  # noqa: E501
        :rtype: bool
        """
        return self._auto_renew

    @auto_renew.setter
    def auto_renew(self, auto_renew):
        """Sets the auto_renew of this LoanRecord.

        Whether the record will auto renew on expiration  # noqa: E501

        :param auto_renew: The auto_renew of this LoanRecord.  # noqa: E501
        :type: bool
        """

        self._auto_renew = auto_renew

    @property
    def repaid(self):
        """Gets the repaid of this LoanRecord.  # noqa: E501

        Repaid amount  # noqa: E501

        :return: The repaid of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._repaid

    @repaid.setter
    def repaid(self, repaid):
        """Sets the repaid of this LoanRecord.

        Repaid amount  # noqa: E501

        :param repaid: The repaid of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._repaid = repaid

    @property
    def paid_interest(self):
        """Gets the paid_interest of this LoanRecord.  # noqa: E501

        Repaid interest  # noqa: E501

        :return: The paid_interest of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._paid_interest

    @paid_interest.setter
    def paid_interest(self, paid_interest):
        """Sets the paid_interest of this LoanRecord.

        Repaid interest  # noqa: E501

        :param paid_interest: The paid_interest of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._paid_interest = paid_interest

    @property
    def unpaid_interest(self):
        """Gets the unpaid_interest of this LoanRecord.  # noqa: E501

        Interest not repaid  # noqa: E501

        :return: The unpaid_interest of this LoanRecord.  # noqa: E501
        :rtype: str
        """
        return self._unpaid_interest

    @unpaid_interest.setter
    def unpaid_interest(self, unpaid_interest):
        """Sets the unpaid_interest of this LoanRecord.

        Interest not repaid  # noqa: E501

        :param unpaid_interest: The unpaid_interest of this LoanRecord.  # noqa: E501
        :type: str
        """

        self._unpaid_interest = unpaid_interest

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict()) if hasattr(item[1], "to_dict") else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LoanRecord):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LoanRecord):
            return True

        return self.to_dict() != other.to_dict()
