# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/dashboard/tableauConnection.json
#   timestamp: 2022-08-23T15:52:10+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class TableauType(Enum):
    Tableau = 'Tableau'


class TableauConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[TableauType] = Field(
        TableauType.Tableau, description='Service Type', title='Service Type'
    )
    hostPort: Optional[AnyUrl] = Field(
        None, description='Tableau Server.', title='Host and Port'
    )
    username: Optional[str] = Field(
        None, description='Username for Tableau.', title='Username'
    )
    password: Optional[SecretStr] = Field(
        None, description='Password for Tableau.', title='Password'
    )
    apiVersion: str = Field(
        ..., description='Tableau API version.', title='API Version'
    )
    siteName: Optional[str] = Field(
        None, description='Tableau Site Name.', title='Site Name'
    )
    siteUrl: Optional[str] = Field(
        None, description='Tableau Site Url.', title='Site Url'
    )
    personalAccessTokenName: Optional[str] = Field(
        None, description='Personal Access Token Name.', title='Personal Access Token'
    )
    personalAccessTokenSecret: Optional[SecretStr] = Field(
        None,
        description='Personal Access Token Secret.',
        title='Personal Access Token Secret',
    )
    env: str = Field(
        ..., description='Tableau Environment Name.', title='Tableau Environment'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
