# generated by datamodel-codegen:
#   filename:  schema/tests/columnTest.json
#   timestamp: 2022-08-23T15:52:10+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, Extra, Field

from ..type import basic, entityReference
from . import basic as basic_1
from .column import (
    columnValueMaxToBeBetween,
    columnValueMeanToBeBetween,
    columnValueMedianToBeBetween,
    columnValueMinToBeBetween,
    columnValuesLengthsToBeBetween,
    columnValuesMissingCountToBeEqual,
    columnValuesSumToBeBetween,
    columnValueStdDevToBeBetween,
    columnValuesToBeBetween,
    columnValuesToBeInSet,
    columnValuesToBeNotInSet,
    columnValuesToBeNotNull,
    columnValuesToBeUnique,
    columnValuesToMatchRegex,
    columnValuesToNotMatchRegex,
)


class ColumnTestType(Enum):
    columnValuesToBeUnique = 'columnValuesToBeUnique'
    columnValuesToBeNotNull = 'columnValuesToBeNotNull'
    columnValuesToMatchRegex = 'columnValuesToMatchRegex'
    columnValuesToBeNotInSet = 'columnValuesToBeNotInSet'
    columnValuesToBeInSet = 'columnValuesToBeInSet'
    columnValuesToBeBetween = 'columnValuesToBeBetween'
    columnValuesMissingCountToBeEqual = 'columnValuesMissingCountToBeEqual'
    columnValueLengthsToBeBetween = 'columnValueLengthsToBeBetween'
    columnValueMaxToBeBetween = 'columnValueMaxToBeBetween'
    columnValueMinToBeBetween = 'columnValueMinToBeBetween'
    columnValuesSumToBeBetween = 'columnValuesSumToBeBetween'
    columnValuesToNotMatchRegex = 'columnValuesToNotMatchRegex'
    columnValueStdDevToBeBetween = 'columnValueStdDevToBeBetween'
    columnValueMedianToBeBetween = 'columnValueMedianToBeBetween'
    columnValueMeanToBeBetween = 'columnValueMeanToBeBetween'


class ColumnTestCase(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[
        Union[
            columnValuesToBeUnique.ColumnValuesToBeUnique,
            columnValuesToBeNotNull.ColumnValuesToBeNotNull,
            columnValuesToMatchRegex.ColumnValuesToMatchRegex,
            columnValuesToBeNotInSet.ColumnValuesToBeNotInSet,
            columnValuesToBeInSet.ColumnValuesToBeInSet,
            columnValuesToBeBetween.ColumnValuesToBeBetween,
            columnValuesMissingCountToBeEqual.ColumnValuesMissingCount,
            columnValueMaxToBeBetween.ColumnValueMaxToBeBetween,
            columnValueMinToBeBetween.ColumnValueMinToBeBetween,
            columnValuesSumToBeBetween.ColumnValuesSumToBeBetween,
            columnValuesLengthsToBeBetween.ColumnValueLengthsToBeBetween,
            columnValuesToNotMatchRegex.ColumnValuesToNotMatchRegex,
            columnValueStdDevToBeBetween.ColumnValueStdDevToBeBetween,
            columnValueMedianToBeBetween.ColumnValueMedianToBeBetween,
            columnValueMeanToBeBetween.ColumnValueMeanToBeBetween,
        ]
    ] = None
    columnTestType: Optional[ColumnTestType] = None


class ColumnTest(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this table instance.'
    )
    name: basic.EntityName = Field(
        ...,
        description='Name that identifies this test case. Name passed by client will be  overridden by  auto generating based on table/column name and test name',
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the testcase.'
    )
    columnName: str = Field(..., description='Name of the column in a table.')
    testCase: ColumnTestCase
    executionFrequency: Optional[basic_1.TestCaseExecutionFrequency] = None
    results: Optional[List[basic_1.TestCaseResult]] = Field(
        None, description='List of results of the test case.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Pipeline.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
