"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from typing import Optional, Union
from requests import Session
from binance_common.configuration import ConfigurationRestAPI
from binance_common.errors import RequiredError
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request

from ..models import AutoCancelAllOpenOrdersResponse
from ..models import GetAutoCancelAllOpenOrdersResponse
from ..models import GetMarketMakerProtectionConfigResponse
from ..models import ResetMarketMakerProtectionConfigResponse
from ..models import SetAutoCancelAllOpenOrdersResponse
from ..models import SetMarketMakerProtectionConfigResponse


class MarketMakerEndpointsApi:
    """API Client for MarketMakerEndpointsApi endpoints."""

    def __init__(
        self,
        configuration: ConfigurationRestAPI = None,
        session: Session = None,
        signer: Signers = None,
    ) -> None:
        self._configuration = configuration
        self._session = session
        self._signer = signer

    def auto_cancel_all_open_orders(
        self,
        underlyings: Union[str, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AutoCancelAllOpenOrdersResponse]:
        """
                Auto-Cancel All Open Orders (Kill-Switch) Heartbeat (TRADE)
                POST /eapi/v1/countdownCancelAllHeartBeat
                https://developers.binance.com/docs/derivatives/option/market-maker-endpoints/Auto-Cancel-All-Open-Orders-Heartbeat

                This endpoint resets the time from which the countdown will begin to the time this messaged is received.  It should be called repeatedly as heartbeats.  Multiple heartbeats can be updated at once by specifying the underlying symbols as a list (ex. BTCUSDT,ETHUSDT) in the underlyings parameter.

        * The response will only include underlying symbols where the heartbeat has been successfully updated.

        Weight: 10

                Args:
                    underlyings (Union[str, None]): Option Underlying Symbols, e.g BTCUSDT,ETHUSDT
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[AutoCancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if underlyings is None:
            raise RequiredError(
                field="underlyings",
                error_message="Missing required parameter 'underlyings'",
            )

        payload = {"underlyings": underlyings, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/eapi/v1/countdownCancelAllHeartBeat",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=AutoCancelAllOpenOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_auto_cancel_all_open_orders(
        self,
        underlying: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetAutoCancelAllOpenOrdersResponse]:
        """
                Get Auto-Cancel All Open Orders (Kill-Switch) Config (TRADE)
                GET /eapi/v1/countdownCancelAll
                https://developers.binance.com/docs/derivatives/option/market-maker-endpoints/Get-Auto-Cancel-All-Open-Orders-Config

                This endpoint returns the auto-cancel parameters for each underlying symbol. Note only active auto-cancel parameters will be returned, if countdownTime is set to 0 (ie. countdownTime has been turned off), the underlying symbol and corresponding countdownTime parameter will not be returned in the response.

        * countdownTime = 0 means the function is disabled.

        Weight: 1

                Args:
                    underlying (Optional[str] = None): underlying, e.g BTCUSDT
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetAutoCancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"underlying": underlying, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/countdownCancelAll",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetAutoCancelAllOpenOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def get_market_maker_protection_config(
        self,
        underlying: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetMarketMakerProtectionConfigResponse]:
        """
                Get Market Maker Protection Config (TRADE)
                GET /eapi/v1/mmp
                https://developers.binance.com/docs/derivatives/option/market-maker-endpoints/Get-Market-Maker-Protection-Config

                Get config for MMP.

        Weight: 1

                Args:
                    underlying (Optional[str] = None): underlying, e.g BTCUSDT
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[GetMarketMakerProtectionConfigResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"underlying": underlying, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="GET",
            path="/eapi/v1/mmp",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=GetMarketMakerProtectionConfigResponse,
            is_signed=True,
            signer=self._signer,
        )

    def reset_market_maker_protection_config(
        self,
        underlying: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ResetMarketMakerProtectionConfigResponse]:
        """
                Reset Market Maker Protection Config (TRADE)
                POST /eapi/v1/mmpReset
                https://developers.binance.com/docs/derivatives/option/market-maker-endpoints/Reset-Market-Maker-Protection-Config

                Reset MMP, start MMP order again.

        Weight: 1

                Args:
                    underlying (Optional[str] = None): underlying, e.g BTCUSDT
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[ResetMarketMakerProtectionConfigResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {"underlying": underlying, "recv_window": recv_window}

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/eapi/v1/mmpReset",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=ResetMarketMakerProtectionConfigResponse,
            is_signed=True,
            signer=self._signer,
        )

    def set_auto_cancel_all_open_orders(
        self,
        underlying: Union[str, None],
        countdown_time: Union[int, None],
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetAutoCancelAllOpenOrdersResponse]:
        """
                Set Auto-Cancel All Open Orders (Kill-Switch) Config (TRADE)
                POST /eapi/v1/countdownCancelAll
                https://developers.binance.com/docs/derivatives/option/market-maker-endpoints/Set-Auto-Cancel-All-Open-Orders-Config

                This endpoint sets the parameters of the auto-cancel feature which cancels all open orders (both market maker protection and non market maker protection order types) of the underlying symbol at the end of the specified countdown time period if no heartbeat message is sent.  After the countdown time period, all open orders will be cancelled and new orders will be rejected with error code -2010 until either a heartbeat message is sent or the auto-cancel feature is turned off by setting countdownTime to 0.


        * This rest endpoint sets up the parameters to cancel your open orders in case of an outage or disconnection.
        * Example usage:
        Call this endpoint with a countdownTime value of 10000 (10 seconds) to turn on the auto-cancel feature. If the corresponding countdownCancelAllHeartBeat endpoint is not called within 10 seconds with the specified underlying symbol, all open orders of the specified symbol will be automatically canceled. If this endpoint is called with an countdownTime of 0, the countdown timer will be stopped.
        * The system will check all countdowns approximately every 1000 milliseconds, **please note that sufficient redundancy should be considered when using this function**. We do not recommend setting the countdown time to be too precise or too small.

        Weight: 1

                Args:
                    underlying (Union[str, None]): Option underlying, e.g BTCUSDT
                    countdown_time (Union[int, None]): Countdown time in milliseconds (ex. 1,000 for 1 second). 0 to disable the timer. Negative values (ex. -10000) are not accepted. Minimum acceptable value is 5,000
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SetAutoCancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        if underlying is None:
            raise RequiredError(
                field="underlying",
                error_message="Missing required parameter 'underlying'",
            )
        if countdown_time is None:
            raise RequiredError(
                field="countdown_time",
                error_message="Missing required parameter 'countdown_time'",
            )

        payload = {
            "underlying": underlying,
            "countdown_time": countdown_time,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/eapi/v1/countdownCancelAll",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SetAutoCancelAllOpenOrdersResponse,
            is_signed=True,
            signer=self._signer,
        )

    def set_market_maker_protection_config(
        self,
        underlying: Optional[str] = None,
        window_time_in_milliseconds: Optional[int] = None,
        frozen_time_in_milliseconds: Optional[int] = None,
        qty_limit: Optional[float] = None,
        delta_limit: Optional[float] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetMarketMakerProtectionConfigResponse]:
        """
                Set Market Maker Protection Config (TRADE)
                POST /eapi/v1/mmpSet
                https://developers.binance.com/docs/derivatives/option/market-maker-endpoints/Set-Market-Maker-Protection-Config

                Set config for MMP.
        Market Maker Protection(MMP) is a set of protection mechanism for option market maker, this mechanism is able to prevent mass trading in short period time. Once market maker's account branches the threshold, the Market Maker Protection will be triggered. When Market Maker Protection triggers, all the current MMP orders will be canceled, new MMP orders will be rejected. Market maker can use this time to reevaluate market and modify order price.

        Weight: 1

                Args:
                    underlying (Optional[str] = None): underlying, e.g BTCUSDT
                    window_time_in_milliseconds (Optional[int] = None): MMP Interval in milliseconds; Range (0,5000]
                    frozen_time_in_milliseconds (Optional[int] = None): MMP frozen time in milliseconds, if set to 0 manual reset is required
                    qty_limit (Optional[float] = None): quantity limit
                    delta_limit (Optional[float] = None): net delta limit
                    recv_window (Optional[int] = None):

                Returns:
                    ApiResponse[SetMarketMakerProtectionConfigResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        payload = {
            "underlying": underlying,
            "window_time_in_milliseconds": window_time_in_milliseconds,
            "frozen_time_in_milliseconds": frozen_time_in_milliseconds,
            "qty_limit": qty_limit,
            "delta_limit": delta_limit,
            "recv_window": recv_window,
        }

        return send_request(
            self._session,
            self._configuration,
            method="POST",
            path="/eapi/v1/mmpSet",
            payload=payload,
            time_unit=self._configuration.time_unit,
            response_model=SetMarketMakerProtectionConfigResponse,
            is_signed=True,
            signer=self._signer,
        )
