# coding: utf-8

"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_derivatives_trading_options.rest_api.models.exchange_information_response_option_assets_inner import (
    ExchangeInformationResponseOptionAssetsInner,
)
from binance_sdk_derivatives_trading_options.rest_api.models.exchange_information_response_option_contracts_inner import (
    ExchangeInformationResponseOptionContractsInner,
)
from binance_sdk_derivatives_trading_options.rest_api.models.exchange_information_response_option_symbols_inner import (
    ExchangeInformationResponseOptionSymbolsInner,
)
from binance_sdk_derivatives_trading_options.rest_api.models.exchange_information_response_rate_limits_inner import (
    ExchangeInformationResponseRateLimitsInner,
)
from typing import Set
from typing_extensions import Self


class ExchangeInformationResponse(BaseModel):
    """
    ExchangeInformationResponse
    """  # noqa: E501

    timezone: Optional[StrictStr] = None
    server_time: Optional[StrictInt] = Field(default=None, alias="serverTime")
    option_contracts: Optional[
        List[ExchangeInformationResponseOptionContractsInner]
    ] = Field(default=None, alias="optionContracts")
    option_assets: Optional[List[ExchangeInformationResponseOptionAssetsInner]] = Field(
        default=None, alias="optionAssets"
    )
    option_symbols: Optional[List[ExchangeInformationResponseOptionSymbolsInner]] = (
        Field(default=None, alias="optionSymbols")
    )
    rate_limits: Optional[List[ExchangeInformationResponseRateLimitsInner]] = Field(
        default=None, alias="rateLimits"
    )
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "timezone",
        "serverTime",
        "optionContracts",
        "optionAssets",
        "optionSymbols",
        "rateLimits",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExchangeInformationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in option_contracts (list)
        _items = []
        if self.option_contracts:
            for _item_option_contracts in self.option_contracts:
                if _item_option_contracts:
                    _items.append(_item_option_contracts.to_dict())
            _dict["optionContracts"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in option_assets (list)
        _items = []
        if self.option_assets:
            for _item_option_assets in self.option_assets:
                if _item_option_assets:
                    _items.append(_item_option_assets.to_dict())
            _dict["optionAssets"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in option_symbols (list)
        _items = []
        if self.option_symbols:
            for _item_option_symbols in self.option_symbols:
                if _item_option_symbols:
                    _items.append(_item_option_symbols.to_dict())
            _dict["optionSymbols"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in rate_limits (list)
        _items = []
        if self.rate_limits:
            for _item_rate_limits in self.rate_limits:
                if _item_rate_limits:
                    _items.append(_item_rate_limits.to_dict())
            _dict["rateLimits"] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExchangeInformationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "timezone": obj.get("timezone"),
                "serverTime": obj.get("serverTime"),
                "optionContracts": (
                    [
                        ExchangeInformationResponseOptionContractsInner.from_dict(_item)
                        for _item in obj["optionContracts"]
                    ]
                    if obj.get("optionContracts") is not None
                    else None
                ),
                "optionAssets": (
                    [
                        ExchangeInformationResponseOptionAssetsInner.from_dict(_item)
                        for _item in obj["optionAssets"]
                    ]
                    if obj.get("optionAssets") is not None
                    else None
                ),
                "optionSymbols": (
                    [
                        ExchangeInformationResponseOptionSymbolsInner.from_dict(_item)
                        for _item in obj["optionSymbols"]
                    ]
                    if obj.get("optionSymbols") is not None
                    else None
                ),
                "rateLimits": (
                    [
                        ExchangeInformationResponseRateLimitsInner.from_dict(_item)
                        for _item in obj["rateLimits"]
                    ]
                    if obj.get("rateLimits") is not None
                    else None
                ),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
