# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchDscpToCosMappingsArgs', 'SwitchDscpToCosMappings']

@pulumi.input_type
class SwitchDscpToCosMappingsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchDscpToCosMappingsMappingArgs']]]] = None):
        """
        The set of arguments for constructing a SwitchDscpToCosMappings resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['SwitchDscpToCosMappingsMappingArgs']]] mappings: An array of DSCP to CoS mappings. An empty array will reset the mappings to default.
        """
        pulumi.set(__self__, "network_id", network_id)
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchDscpToCosMappingsMappingArgs']]]]:
        """
        An array of DSCP to CoS mappings. An empty array will reset the mappings to default.
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchDscpToCosMappingsMappingArgs']]]]):
        pulumi.set(self, "mappings", value)


@pulumi.input_type
class _SwitchDscpToCosMappingsState:
    def __init__(__self__, *,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchDscpToCosMappingsMappingArgs']]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SwitchDscpToCosMappings resources.
        :param pulumi.Input[Sequence[pulumi.Input['SwitchDscpToCosMappingsMappingArgs']]] mappings: An array of DSCP to CoS mappings. An empty array will reset the mappings to default.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        if mappings is not None:
            pulumi.set(__self__, "mappings", mappings)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter
    def mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchDscpToCosMappingsMappingArgs']]]]:
        """
        An array of DSCP to CoS mappings. An empty array will reset the mappings to default.
        """
        return pulumi.get(self, "mappings")

    @mappings.setter
    def mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchDscpToCosMappingsMappingArgs']]]]):
        pulumi.set(self, "mappings", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)


class SwitchDscpToCosMappings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchDscpToCosMappingsMappingArgs', 'SwitchDscpToCosMappingsMappingArgsDict']]]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchDscpToCosMappings("example",
            mappings=[{
                "cos": 1,
                "dscp": 1,
                "title": "Video",
            }],
            network_id="string")
        pulumi.export("merakiNetworksSwitchDscpToCosMappingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchDscpToCosMappings:SwitchDscpToCosMappings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchDscpToCosMappingsMappingArgs', 'SwitchDscpToCosMappingsMappingArgsDict']]]] mappings: An array of DSCP to CoS mappings. An empty array will reset the mappings to default.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchDscpToCosMappingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchDscpToCosMappings("example",
            mappings=[{
                "cos": 1,
                "dscp": 1,
                "title": "Video",
            }],
            network_id="string")
        pulumi.export("merakiNetworksSwitchDscpToCosMappingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchDscpToCosMappings:SwitchDscpToCosMappings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchDscpToCosMappingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchDscpToCosMappingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchDscpToCosMappingsMappingArgs', 'SwitchDscpToCosMappingsMappingArgsDict']]]]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchDscpToCosMappingsArgs.__new__(SwitchDscpToCosMappingsArgs)

            __props__.__dict__["mappings"] = mappings
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
        super(SwitchDscpToCosMappings, __self__).__init__(
            'meraki:networks/switchDscpToCosMappings:SwitchDscpToCosMappings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchDscpToCosMappingsMappingArgs', 'SwitchDscpToCosMappingsMappingArgsDict']]]]] = None,
            network_id: Optional[pulumi.Input[str]] = None) -> 'SwitchDscpToCosMappings':
        """
        Get an existing SwitchDscpToCosMappings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchDscpToCosMappingsMappingArgs', 'SwitchDscpToCosMappingsMappingArgsDict']]]] mappings: An array of DSCP to CoS mappings. An empty array will reset the mappings to default.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchDscpToCosMappingsState.__new__(_SwitchDscpToCosMappingsState)

        __props__.__dict__["mappings"] = mappings
        __props__.__dict__["network_id"] = network_id
        return SwitchDscpToCosMappings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def mappings(self) -> pulumi.Output[Sequence['outputs.SwitchDscpToCosMappingsMapping']]:
        """
        An array of DSCP to CoS mappings. An empty array will reset the mappings to default.
        """
        return pulumi.get(self, "mappings")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

