#*=+--+=#=+--         SwiftCore Flight Management Software        --+=#=+--+=#*#
#               Copyright (C) 2020 Black Swift Technologies LLC.               #
#                             All Rights Reserved.                             #
#                                                                              #
#    NOTICE:  All information contained herein is, and remains the property    #
#    of Black Swift Technologies.                                              #
#                                                                              #
#    The intellectual and technical concepts contained herein are              #
#    proprietary to Black Swift Technologies LLC and may be covered by U.S.    #
#    and foreign patents, patents in process, and are protected by trade       #
#    secret or copyright law.                                                  #
#                                                                              #
#    Dissemination of this information or reproduction of this material is     #
#    strictly forbidden unless prior written permission is obtained from       #
#    Black Swift Technologies LLC.                                             #
#                                                                              #
#*=+--+=#=+--                 --+=#=+--+=#=+--                    --+=#=+--+=#*#

from enum import Enum
import struct

from comm_packets.comm_packets import *

#                      THIS FILE IS AUTOGENERATED BY                           #
#                                 msg-gen.py                                   #
#                                DO NOT EDIT                                   #

#---------[ GCS ]---------#

class GCSRTKFlags (Enum):
	SURVEY_IN_WAITING=0
	SURVEY_IN_REQUESTED=1
	SURVEY_IN_COMPLETE=2
	SENDING_RTCM3=3

class GCSStatus:
	SIZE = 27

	def __init__ (self, rssi = 0, num_drop = 0, hour = 0, minute = 0,
	seconds = 0.0, satellites = 0, pdop = 0.0, battery_v = 0.0, battery_i = 0.0,
	batt_level = 0.0, error = 0):
		self.rssi = rssi
		self.num_drop = num_drop
		self.hour = hour
		self.minute = minute
		self.seconds = seconds
		self.satellites = satellites
		self.pdop = pdop
		self.battery_v = battery_v
		self.battery_i = battery_i
		self.batt_level = batt_level
		self.error = error

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [GCSStatus]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.rssi = struct.unpack_from('<b',buf,offset)[0]
		offset = offset + struct.calcsize('<b')

		self.num_drop = struct.unpack_from('<H',buf,offset)[0]
		offset = offset + struct.calcsize('<H')

		self.hour = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.minute = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.seconds = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.satellites = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

		self.pdop = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.battery_v = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.battery_i = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.batt_level = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.error = struct.unpack_from('<B',buf,offset)[0]
		offset = offset + struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<b', self.rssi))
		buf.extend(struct.pack('<H', self.num_drop))
		buf.extend(struct.pack('<B', self.hour))
		buf.extend(struct.pack('<B', self.minute))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<f', self.pdop))
		buf.extend(struct.pack('<f', self.battery_v))
		buf.extend(struct.pack('<f', self.battery_i))
		buf.extend(struct.pack('<f', self.batt_level))
		buf.extend(struct.pack('<B', self.error))
		return bytearray(buf)

class GCSSurveyIn:
	SIZE = 17

	def __init__ (self, time_elapsed = 0, time_minimum = 0, accuracy = 0.0,
	accuracy_minimum = 0.0, flags = GCSRTKFlags(0)):
		self.time_elapsed = time_elapsed
		self.time_minimum = time_minimum
		self.accuracy = accuracy
		self.accuracy_minimum = accuracy_minimum

		self.flags = GCSRTKFlags(flags)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [GCSSurveyIn]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.time_elapsed = struct.unpack_from('<I',buf,offset)[0]
		offset = offset + struct.calcsize('<I')

		self.time_minimum = struct.unpack_from('<I',buf,offset)[0]
		offset = offset + struct.calcsize('<I')

		self.accuracy = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.accuracy_minimum = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.flags = GCSRTKFlags(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<I', self.time_elapsed))
		buf.extend(struct.pack('<I', self.time_minimum))
		buf.extend(struct.pack('<f', self.accuracy))
		buf.extend(struct.pack('<f', self.accuracy_minimum))

		buf.put(GCSRTKFlags.encode(self.flags));
		return bytearray(buf)

#---------[ Status ]---------#

class GCSErrors (Enum):
	# The further down the list, the higher the error priority

	ERROR_NO_ERROR=0
	ERROR_LOW_BATT=1
	ERROR_HIGH_BATT=2
	ERROR_NO_BATT=3
	ERROR_BAD_GPS=4
	ERROR_NO_GPS=5
	ERROR_NO_RADIO=6
	ERROR_HIGH_CURRENT=7
	ERROR_HIGH_TEMP=8

#---------[ Telemetry ]---------#

class TelemetryGCS:
	SIZE = 24

	def __init__ (self, latitude = 0.0, longitude = 0.0, altitude = 0.0,
	speed = 0.0, course = 0.0, pressure = 0.0):
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude
		self.speed = speed
		self.course = course
		self.pressure = pressure

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [TelemetryGCS]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.latitude = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.longitude = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.altitude = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.speed = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.course = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

		self.pressure = struct.unpack_from('<f',buf,offset)[0]
		offset = offset + struct.calcsize('<f')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.latitude))
		buf.extend(struct.pack('<f', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.speed))
		buf.extend(struct.pack('<f', self.course))
		buf.extend(struct.pack('<f', self.pressure))
		return bytearray(buf)
